; before running make, or tasm and tlink, don't forget
; to run 2asm! (or there will be no PICTURE.ASM to include)
;    2ASM PICTURE.PCX

cseg segment para public 'code'
assume cs:cseg, ds:cseg
org	100h

;////////////////////////////////////////////////////////////

start:
    ; set vidmode 13h
	mov	    ax, 013h
	int	    10h

    ; sets the palette
    mov     cx, 256
    mov     ax, 0
palloop:
    push    ax
    mov     bx, ax
    shr     bl, 2       ;bl=grey value
    call    pal
    pop     ax
    inc     ax
    loop    palloop


    ; move the raw data to the vga memory (0a000h)
	mov     bx, 0a000h
	mov	    es, bx
	xor	    di, di
    mov     si, offset rawfile
    mov     cx, 32000
    rep     movsw

    ; wait for key
	xor     ah, ah
	int	    16h

    ; set textmode
	mov	    ax, 03h
	int	    10h

    ; return to dos
	mov	    ax,4ch
	int	    21h

; sets the palette
pal PROC NEAR
    mov     dx, 3c8h
    mov     ah, bl      ; red
    out     dx, ax
    mov     al, bl      ; green
    inc     dx
    out     dx, al
    mov     al, bl      ; blue
    out     dx, al
	ret
pal ENDP

;////////////////////////////////////////////////////////////

; make sure that no matter what the varname
; of the rawfile in picture.asm is, we'll
; get the right offset anyway...
rawfile:

; include the file generated by 2asm
    include picture.asm

;////////////////////////////////////////////////////////////

cseg ends
end start
