#include "gamecore.h"
#include "math.h"
#include <sstream>
#include <vector>

//const int MAX_PARTICLES = 1000;

Particle dead;

fusa::cVec2f getRandomDir( )
{
	return fusa::cVec2f( random( )-0.5f, random( )-0.5f );
}

ParticleSystem::ParticleSystem( std::string tex_ ):
tex( tex_ ), spawn_rate( 16 ), spawn_timer( 0 )
{

}

void ParticleSystem::render( )
{
	spawn_timer -= 1;

	if( spawn_timer < 0 )
	{
		addParticle( );

		spawn_timer = spawn_rate;
	}

	fusa::getTexture( tex ).bindTexture( 0 );

	for( int i = 0; i < MAX_PARTICLES; ++i )
  {
		if( particles[i].pos.x == -10000 )
			continue;

		particles[i].pos += (particles[i].vel*dTime)/50;
		particles[i].a -= particles[i].fade;

		if( particles[i].a < 0.0001 )
			particles[i] = dead;

		particles[i].size += particles[i].grow;

		glColor4f( particles[i].r, particles[i].g, particles[i].b, particles[i].a );

		drawPointSprite( particles[i].pos, particles[i].size );
	}

	/*
	glDisable( GL_DEPTH_TEST );
	glEnable( GL_BLEND );
	glBlendFunc( GL_SRC_ALPHA, GL_ONE );

	float quadratic[] =  { 1.0f, 0.0f, 0.01f };
  glPointParameterfvARB( GL_POINT_DISTANCE_ATTENUATION_ARB, quadratic );

  float maxSize = 0.0f;
  glGetFloatv( GL_POINT_SIZE_MAX_ARB, &maxSize );

  if( maxSize > 100.0f )
    maxSize = 100.0f;

  glPointSize( maxSize );

	glPointParameterfARB( GL_POINT_FADE_THRESHOLD_SIZE_ARB, 60.0f );

  glPointParameterfARB( GL_POINT_SIZE_MIN_ARB, 10.0f );
  glPointParameterfARB( GL_POINT_SIZE_MAX_ARB, maxSize );

  glTexEnvf( GL_POINT_SPRITE_ARB, GL_COORD_REPLACE_ARB, GL_TRUE );

	glEnable( GL_POINT_SPRITE_ARB );

	glBegin( GL_POINTS );
  {
    for( int i = 0; i < MAX_PARTICLES; ++i )
    {
			if( particles[i].pos.x == -10000 )
				continue;

			particles[i].pos += particles[i].vel/6.0f;
			particles[i].a -= 0.001;

			if( particles[i].a < 0.1 )
				particles[i] = dead;

      glColor4f( particles[i].r,
                 particles[i].g,
                 particles[i].b, 
                 particles[i].a );

      glVertex3f( particles[i].pos.x,
                  particles[i].pos.y,
                  0.0f );
    }
  }
	glEnd( );

	glDisable( GL_POINT_SPRITE_ARB );
	*/
}

void ParticleSystem::addParticle( )
{
	for( int i = 0; i < MAX_PARTICLES; ++i )
  {
		if( particles[i].pos.x == -10000 )
		{
			particles[i] = makeParticle( );
			return;
		}
	}
}

Particle ParticleSystem::makeParticle( )
{
	Particle p;
	p.pos = pos;
	p.vel = getRandomDir( );

	return p;
}

SpawnParticleSystem::SpawnParticleSystem( ):
ParticleSystem( "AimCircle.png" )
{

}

Particle SpawnParticleSystem::makeParticle( )
{
	Particle p;
	p.pos = pos;
	p.vel = getRandomDir( )/10;
	p.r = 1.0f;
	p.g = 1.0f;
	p.b = 1.0f;
	p.a = 0.1f;
	p.size = 30.0f;
	p.grow = 0.03f;
	p.fade = 0.0001f;

	return p;
}