#include "fusa_spatialNode.h"
#include <iostream>

//this file contains code relevant to spatialNode's tree structure.
//see fusa_spatialNode to see implementations relevant to the
//data part of the nodes.

using namespace fusa;

void cSpatialNode::insertNodeAsParent(cSpatialNode* ptr_insNode)
{
    cSpatialNode* ptr_parent = this->getParent();

    //make node child of insertNode.
    ptr_insNode->addChild(this);

    //remove link to node from insertnode's parent (old parent of node)
    std::list<cSpatialNode*>::iterator it = ptr_parent->m_children.begin();
    while(it!=ptr_parent->m_children.end())
    {
        if(*it == this)
        {
            ptr_parent->m_children.erase(it);
            break;
        }
        it++;
    }
    ptr_parent->addChild(ptr_insNode);
}

std::list<cSpatialNode*>& cSpatialNode::ChildList()
{
    return m_children;
}

cSpatialNode* cSpatialNode::getParent()const
{
    return mptr_parent;
}

cSpatialNode* cSpatialNode::getNode(const std::string &name)
{
    if(this->Name()==name)
    {
        return this;
    }

    cSpatialNode *ptr_ans =0;
    std::list<cSpatialNode*>::const_iterator it = m_children.begin();
    while(it!=m_children.end())
    {
        ptr_ans = (*it)->getNode(name);
        if(ptr_ans)
        {
            break;
        }
        it++;
    }
    return ptr_ans;
}

const cSpatialNode* cSpatialNode::getNode(const std::string &name)const
{
    if(this->Name()==name)
    {
        return this;
    }

    cSpatialNode *ptr_ans =0;
    std::list<cSpatialNode*>::const_iterator it = m_children.begin();
    while(it!=m_children.end())
    {
        ptr_ans = (*it)->getNode(name);
        if(ptr_ans)
        {
            break;
        }
        it++;
    }
    return ptr_ans;
}

void cSpatialNode::getNodes(NodeType nodeType, std::vector<const cSpatialNode*> &nodes)const
{
    if(this->getNodeType() == nodeType)
    {
        nodes.push_back(this);
    }

    std::list<cSpatialNode*>::const_iterator it = m_children.begin();
    while(it!=m_children.end())
    {
        (*it)->getNodes(nodeType,nodes);
        it++;
    }
}

void cSpatialNode::getNodes(NodeType nodeType, std::vector<cSpatialNode*> &nodes)
{
    if(this->getNodeType() == nodeType)
    {
        nodes.push_back(this);
    }

    std::list<cSpatialNode*>::iterator it = m_children.begin();
    while(it!=m_children.end())
    {
        (*it)->getNodes(nodeType,nodes);
        it++;
    }
}

cSpatialNode* cSpatialNode::getNode(int id)
{
    if(this->getId() == id)
    {
        return this;
    }

    cSpatialNode *ptr_ans =0;
    std::list<cSpatialNode*>::const_iterator it = m_children.begin();
    while(it!=m_children.end())
    {
        ptr_ans = (*it)->getNode(id);
        if(ptr_ans)
        {
            break;
        }
        it++;
    }
    return ptr_ans;
}

const cSpatialNode* cSpatialNode::getNode(int id)const
{
    if(this->getId() == id)
    {
        return this;
    }

    cSpatialNode *ptr_ans =0;
    std::list<cSpatialNode*>::const_iterator it = m_children.begin();
    while(it!=m_children.end())
    {
        ptr_ans = (*it)->getNode(id);
        if(ptr_ans)
        {
            break;
        }
        it++;
    }
    return ptr_ans;
}

void cSpatialNode::addChild(cSpatialNode *ptr_child)
{
    ptr_child->mptr_parent = this;
    ptr_child->mptr_parentID = this->m_ID;
    m_children.push_back(ptr_child);
}

