#ifndef H_xxFUSA_SPATIALNODExx_H
#define H_xxFUSA_SPATIALNODExx_H
#include "../math/fusa_animatableObjects.h"
#include "../math/fusa_mathincludes.h"
#include "../renderer/fusa_material.h"

/*******************************************************

Original Author...Håvard Christensen
Purpose...........Spatial node for scenegraph

Description:
This is the base class for nodes in the scenegraph. it is called cSpatialNode as Spatial describes
what a node in the graph is. (something residing in space = spatial).

//TODO:
/*
- Clean up,
*/



namespace fusa
{

  class cScenegraph;
  class cCameraNode;
  /*!
    @class cSpatialNode
    @brief cSpatialNode is the base class for all nodes in the scene.
    @it contains spatial information (position,rotation,scaling) and
    @renderstates which tells how a node should be rendered by the renderer.
  */
  class cSpatialNode
  {
  public:
    ///Describes the nodetype supported.
    enum NodeType
      {
	ntSpatial,
	ntTestBox,
	ntGeometry,
	ntCamera,
	ntCollision,
	ntTrack,
	ntLink,
	ntParticle,
      };

    friend class cScenegraph;



    ///update the node and calculate how much it is going to move this frame.
    virtual void preUpdate(float t,cSpatialNode *ptr_parent);

    ///update the node and move it by as much as calculated in preUpdate.
    virtual void postUpdate(float t);

    ///gets the node type of the node,
    /*!i.e ntGeometry is a geometry node. you can ask for nodetype then use static cast to
      cast the node to the type it is.*/
    virtual NodeType getNodeType()const;

    ///returns referance to the node's ID
    int getId()const;

    cVec3f& Scale()
    {
      m_hasUpdatedTransformLocal = true;
      return m_scaleVec;
    }
    const cVec3f& Scale()const
    {
      return m_scaleVec;
    }

    ///returns referance to the node's Rotation (relative to parent-node)
    fusa::cQuat<float>& Rotate();

    ///returns const referance to the node's Rotation (relative to parent-node)
    const fusa::cQuat<float>& Rotate()const;

    ///sets the position (relative to parent-node)
    void setPosition(const cVec3f &pos);

    ///returns const referance to the Position (relative to parent-node)
    const fusa::cVec3f getPosition()const;
    const fusa::cVec3f getPosition(float t)const;

    ///translates the node
    void translate(const cVec3f &trans);

    ///gets the world rotation, only valid after the scenegraph has been updated
    const fusa::cQuat<float>& getWorldRotation()const;

    ///gets the world position, only valid after the scenegraph has been updated
    const fusa::cVec3f& getWorldPosition()const;

    ///gets the world scale, only valid after the scenegraph has been updated
    cVec3f getWorldScaleVec()const;

    ///both gets and sets the name (by returning reference)
    ///(not guaranteed to be unique, use number ID's for searching)
    std::string & Name();

    ///gets the node name (not guaranteed to be unique, use number ID's for searching)
    const std::string& Name()const;

    ///gets the ID of a parent.
    int getParentId()const;

    ///loads up a node given an input stream, binary settings and file format version
    virtual bool loadNode(std::ifstream &in, bool binForm,int versionForm);

    ///sets a bool that decides if the node, and children of the node, should render or not.
    void setRenderFlag(bool shouldNodeBeRendered);

    ///the passing of should-render is so that if set to false, none of the child will render.
    bool shouldRender()const;

    ///gets the world should-render, if this is false, but shoulRender returns true,
    ///it means a higher node is blocking this render.
    bool getWorldShouldRender()const;

    ///get the worldRenderState (only valid after an update).
    ///this renderstate is the one which is used for rendering to screen.
    ///this gets the first renderState. that is pass 0
    std::vector<cMaterial>* getWorldRenderState()const;


    ///gets material of given pass.
    /*!

     */
    cMaterial& Material(unsigned int pass=0);
    unsigned int getNrOfMaterialPasses()const;
    void addMaterialPass(const cMaterial& mat);

    ///if there exists a local renderstate this function returns true.
    bool hasLocalRenderState()const
    {
      if(m_renderPasses.size())
	return true;
      return false;
    }

    ///gets pointer to array of renderstates.
    cMaterial* getWorldRenderStatePass(unsigned int pass=0)const;

    ///data structure part.

    ///adds child to node.
    /*!automatically does parent-things.
    //FIX_ME should fix id things too.*/
    void addChild(cSpatialNode *ptr_child);

    ///searches subtree of the calling node
    /*!searches for a node with an id equal to the parameter id*/
    const cSpatialNode* getNode(int id)const;
    cSpatialNode* getNode(int id);

    ///searches subtree of the calling node
    /*!searches for a node with a name equal to the parameter name
      Notice!. names are NOT guaranteed to be unique, but can be usefull if you know what
      you are doing/looking for.*/
    const cSpatialNode* getNode(const std::string &name)const;
    cSpatialNode* getNode(const std::string &name);


    ///searches subtree of the calling node
    /*!searches for nodes with an nodetype equal to the parameter nodeType
      and adds them all up in an array of pointers.
      this is usefull when you find yourself wanting
      i.e, all geometry nodes that a subtree contains.
      it takes in a refrence to the array/vector that it will fill the nodes it finds into.*/
    void getNodes(NodeType nodeType, std::vector<cSpatialNode*> &nodes);
    void getNodes(NodeType nodeType, std::vector<const cSpatialNode*> &nodes)const;

    ///gets the parent node.
    cSpatialNode* getParent()const;

    ///inserts the node ptr_insNode as the parent of node the calling node.
    /*!if node this has parent, it will become the parent of ptr_insNode
      it's as if suddenly you come to realize that your father really is your grandfather :O
      , soap opera.*/
    void insertNodeAsParent(cSpatialNode* ptr_insNode);

    ///gets the list of children that this node has.
    std::list<cSpatialNode*>& ChildList();

    virtual bool pickNode()const{return false;}


    const fusa::cVec3f& getframeMovementDelta()const
    {
      return m_frameMovementDelta;
    }

    cAnimatableVec3f* getAnimatablePosition()
    {
      return &m_position;
    }

    cAnimatableVec3f* getAnimatableWorldPosition()
    {
      return 0;
    }

    cScenegraph* getSceneLink()
    {
      return mptr_scenegraphLink;
    }

    fusa::cMatrix4<float>& getWorldRotMat()
    {
      return m_worldRotationMat;
    }

    const fusa::cMatrix4<float>& getWorldRotMat()const
    {
      return m_worldRotationMat;
    }

    bool cullingSphereOutsideCamFrustrum(cCameraNode *ptr_cam);
    friend class cCameraController;
  protected:
    ///protected so that only cScenegraph can create nodes.
    cSpatialNode(cScenegraph *ptr_sceneLink);

    ///protected so that only cScenegraph can desotry nodes.
    virtual ~cSpatialNode();

    int m_ID;
    int mptr_parentID;
    std::string m_name;


    fusa::cQuat<float> m_rotation;
    fusa::cAnimatableVec3f m_position;
    cVec3f m_scaleVec;

    fusa::cQuat<float> m_worldRotation;
    fusa::cMatrix4<float> m_worldRotationMat;
    cVec3f m_worldPosition;
    cVec3f m_worldScaleVec;

    cVec3f m_pivotPos;

    fusa::cVec3f m_frameMovementDelta;
    bool m_render;
    bool m_worldRender;

    std::vector<cMaterial> m_renderPasses;
    std::vector<cMaterial> *mptr_worldRenderPasses;

    //data structure part.

    cSpatialNode* mptr_parent;
    std::list<cSpatialNode*> m_children;

    cScenegraph *mptr_scenegraphLink;

    float m_selectSphereRadius;

    float m_cullingSphereRadius;
    cVec3f m_cullingSphereOffset;

    //this is used for a bit of optimization
    //if true, this node has updated position and must update
    //itself.
    bool m_hasUpdatedTransformLocal;
    bool m_hasUpdatedTransformWorld;

  };
}
#endif
