#include "fusa_mesh.h"
#include "../renderer/fusa_hardmesh.h"
#include "../common/fusa_logging.h"
#include <map>

using namespace fusa;

void cMesh::mapSoftMeshToHardMesh(cHardMesh *hm,
				  GLint indexStorageSpec,
				  GLint vertexStorageSpec,
				  GLint defAttribStorageSpec,
				  std::map<std::string,GLint> *attribStorageSpec
				  )
{
  hm->m_indices.storeData(GL_ELEMENT_ARRAY_BUFFER,sizeof(unsigned int),
			     3,faces.size(),GL_UNSIGNED_INT,
			    &faces[0].v1,
			  indexStorageSpec);

  hm->m_vertices.storeData(GL_ARRAY_BUFFER,sizeof(float),
			      3,vertices.size(),GL_FLOAT,
			     &vertices[0].x,
			      vertexStorageSpec);
  {
  std::map<std::string,std::vector<float> >::iterator it= vec1AttributeMap.begin();
  while(it!=vec1AttributeMap.end())
    {

      GLint specify = defAttribStorageSpec;
      if(attribStorageSpec)
	{
	  if(attribStorageSpec->find(it->first)!=attribStorageSpec->end())
	    {
	      specify = (*attribStorageSpec)[it->first];
	    }
	}
      fusa::cBufferData bD;
      bD.storeData(GL_ARRAY_BUFFER,sizeof(float),
		   1,it->second.size(),GL_FLOAT,
		   &it->second[0],
		   GL_STATIC_DRAW_ARB);
      hm->m_attribBuffer[it->first] = bD;
      it++;
    }
  }
{
  std::map<std::string,std::vector<cVec2f> >::iterator it= vec2AttributeMap.begin();
  while(it!=vec2AttributeMap.end())
    {

      GLint specify = defAttribStorageSpec;
      if(attribStorageSpec)
	{
	  if(attribStorageSpec->find(it->first)!=attribStorageSpec->end())
	    {
	      specify = (*attribStorageSpec)[it->first];
	    }
	}
      fusa::cBufferData bD;
      bD.storeData(GL_ARRAY_BUFFER,sizeof(float),
		   2,it->second.size(),GL_FLOAT,
		   &it->second[0].x,
		   GL_STATIC_DRAW_ARB);
      hm->m_attribBuffer[it->first] = bD;
      it++;
    }
  }
{
  std::map<std::string,std::vector<cVec3f> >::iterator it= vec3AttributeMap.begin();
  while(it!=vec3AttributeMap.end())
    {

      GLint specify = defAttribStorageSpec;
      if(attribStorageSpec)
	{
	  if(attribStorageSpec->find(it->first)!=attribStorageSpec->end())
	    {
	      specify = (*attribStorageSpec)[it->first];
	    }
	}
      fusa::cBufferData bD;
      bD.storeData(GL_ARRAY_BUFFER,sizeof(float),
		   3,it->second.size(),GL_FLOAT,
		   &it->second[0].x,
		   GL_STATIC_DRAW_ARB);
      hm->m_attribBuffer[it->first] = bD;
      it++;
    }
  }
{
  std::map<std::string,std::vector<cVec4f> >::iterator it= vec4AttributeMap.begin();
  while(it!=vec4AttributeMap.end())
    {

      GLint specify = defAttribStorageSpec;
      if(attribStorageSpec)
	{
	  if(attribStorageSpec->find(it->first)!=attribStorageSpec->end())
	    {
	      specify = (*attribStorageSpec)[it->first];
	    }
	}
      fusa::cBufferData bD;
      bD.storeData(GL_ARRAY_BUFFER,sizeof(float),
		   4,it->second.size(),GL_FLOAT,
		   &it->second[0].x,
		   GL_STATIC_DRAW_ARB);
      hm->m_attribBuffer[it->first] = bD;
      it++;
    }
  }

{
  std::map<std::string,std::vector<cMatrix3<float> > >::iterator it= mat3x3AttributeMap.begin();
  while(it!=mat3x3AttributeMap.end())
    {

      GLint specify = defAttribStorageSpec;
      if(attribStorageSpec)
	{
	  if(attribStorageSpec->find(it->first)!=attribStorageSpec->end())
	    {
	      specify = (*attribStorageSpec)[it->first];
	    }
	}
      logger<<"fix sending of vertex attribute mat3x3"<<std::endl;
      /*
      fusa::cBufferData bD;
      bD.storeData(GL_ARRAY_BUFFER,sizeof(float),
		   1,it->second.size(),GL_FLOAT,
		   &it->second[0],
		   GL_STATIC_DRAW_ARB);*/
      it++;
    }
  }
}


struct SmgrpHelper
{
	int refToAFace;
	bool hasBeenUsedForSmgrp;
};



sIndexedMesh fusa::convertMeshTypes(sMultiIndexedMesh &inMesh)
{
	
	sIndexedMesh m;
	m.indices.resize(inMesh.vertexIndices.size());
	m.vertices.resize(inMesh.vertices.size());


	{for(std::map<std::string,std::vector<float> >::iterator it = inMesh.attributeData.begin();
	it!= inMesh.attributeData.end(); it++)
	{
		m.attributeData[it->first] = std::vector<float> ();
		m.attributeData[it->first].resize(inMesh.vertices.size());
	}}


	{for(std::map<std::string,std::vector<cVec2f> >::iterator it = inMesh.attributeDataVec2.begin();
	it!= inMesh.attributeDataVec2.end(); it++)
	{
		m.attributeDataVec2[it->first] = std::vector<cVec2f> ();
		m.attributeDataVec2[it->first].resize(inMesh.vertices.size());
	}}

	{for(std::map<std::string,std::vector<cVec3f> >::iterator it = inMesh.attributeDataVec3.begin();
	it!= inMesh.attributeDataVec3.end(); it++)
	{
		m.attributeDataVec3[it->first] = std::vector<cVec3f> ();
		m.attributeDataVec3[it->first].resize(inMesh.vertices.size());
	}}

	{for(std::map<std::string,std::vector<cVec4f> >::iterator it = inMesh.attributeDataVec4.begin();
	it!= inMesh.attributeDataVec4.end(); it++)
	{
		m.attributeDataVec4[it->first] = std::vector<cVec4f> ();
		m.attributeDataVec4[it->first].resize(inMesh.vertices.size());
	}}

	{for(std::map<std::string,std::vector<cMatrix3<float> > >::iterator it = inMesh.attributeDataMat3.begin();
	it!= inMesh.attributeDataMat3.end(); it++)
	{
		m.attributeDataMat3[it->first] = std::vector<cMatrix3<float> > ();
		m.attributeDataMat3[it->first].resize(inMesh.vertices.size());
	}}

	{for(std::map<std::string,std::vector<cMatrix4<float> > >::iterator it = inMesh.attributeDataMat4.begin();
	it!= inMesh.attributeDataMat4.end(); it++)
	{
		m.attributeDataMat4[it->first] = std::vector<cMatrix4<float> > ();
		m.attributeDataMat4[it->first].resize(inMesh.vertices.size());
	}}



	//map can help us with stuff.
	std::map<int,bool> usedRef;
	std::map<int,std::vector<SmgrpHelper> > refBackToFaces;
	std::map<int,std::vector<SmgrpHelper> > refBackToFacesV2;
	std::map<int,std::vector<SmgrpHelper> > refBackToFacesV3;
	std::map<int,std::vector<SmgrpHelper> > refBackToFacesV4;

	std::map<std::string,bool> smoothedAttribute;




	for(unsigned int i=0; i < inMesh.vertexIndices.size(); i++)
	{

		//unsigned int attIndex = attIndi[i];
		unsigned int vertIndex = inMesh.vertexIndices[i];

		if(usedRef.find(vertIndex)==usedRef.end())
		{
			//nothing special to be done.

			for(std::map<std::string,std::vector<unsigned int> >::iterator it = inMesh.indexForAttributes.begin();
				it!= inMesh.indexForAttributes.end(); it++)
			{
				if(it->second.size()!=inMesh.vertexIndices.size())
				{
					logger<<"AAAIDS in multiple indexed data convert shit"<<std::endl;
				}
				else
				{
					unsigned int attIndex = it->second[i];
					if(inMesh.attributeData.find(it->first)!=inMesh.attributeData.end())
					{
						m.attributeData[it->first][vertIndex] = inMesh.attributeData[it->first] [attIndex];
					}
					if(inMesh.attributeDataVec2.find(it->first)!=inMesh.attributeDataVec2.end())
					{
						m.attributeDataVec2[it->first][vertIndex] = inMesh.attributeDataVec2[it->first] [attIndex];
					}
					if(inMesh.attributeDataVec3.find(it->first)!=inMesh.attributeDataVec3.end())
					{
						m.attributeDataVec3[it->first][vertIndex] = inMesh.attributeDataVec3[it->first] [attIndex];
					}
					if(inMesh.attributeDataVec4.find(it->first)!=inMesh.attributeDataVec4.end())
					{
						m.attributeDataVec4[it->first][vertIndex] = inMesh.attributeDataVec4[it->first] [attIndex];
					}

					if(inMesh.attributeDataMat3.find(it->first)!=inMesh.attributeDataMat3.end())
					{
						m.attributeDataMat3[it->first][vertIndex] = inMesh.attributeDataMat3[it->first] [attIndex];
					}

					if(inMesh.attributeDataMat4.find(it->first)!=inMesh.attributeDataMat4.end())
					{
						m.attributeDataMat4[it->first][vertIndex] = inMesh.attributeDataMat4[it->first] [attIndex];
					}

				}
			}

			m.indices[i]=vertIndex;
			m.vertices[vertIndex] = inMesh.vertices[vertIndex];
			usedRef[vertIndex]=true;

			SmgrpHelper smHelper;
			smHelper.refToAFace = i;
			smHelper.hasBeenUsedForSmgrp=false;

			refBackToFaces[vertIndex].push_back(smHelper);
			refBackToFacesV2[vertIndex].push_back(smHelper);
			refBackToFacesV3[vertIndex].push_back(smHelper);
			refBackToFacesV4[vertIndex].push_back(smHelper);
		}
		else
		{
			bool duplicateIt=false;
			bool smoothingGrpReb=false;
			//it has been used before. do a checkup on weather we need to duplicate vertex.

			for(std::map<std::string,std::vector<unsigned int> >::iterator it = inMesh.indexForAttributes.begin();
				it!= inMesh.indexForAttributes.end(); it++)
			{
				unsigned int attIndex = it->second[i];
				bool dealingWithFloat = inMesh.attributeData.find(it->first)!=inMesh.attributeData.end();
				bool dealingWithVec2 = inMesh.attributeDataVec2.find(it->first)!=inMesh.attributeDataVec2.end();
				bool dealingWithVec3 = inMesh.attributeDataVec3.find(it->first)!=inMesh.attributeDataVec3.end();
				bool dealingWithVec4 = inMesh.attributeDataVec4.find(it->first)!=inMesh.attributeDataVec4.end();
				bool dealingWithMat3 = inMesh.attributeDataMat3.find(it->first)!=inMesh.attributeDataMat3.end();
				bool dealingWithMat4 = inMesh.attributeDataMat4.find(it->first)!=inMesh.attributeDataMat4.end();

				smoothedAttribute[it->first]=false;

				bool hasSmoothGroup = inMesh.smoothingGroupForAttributes.find(it->first)!=inMesh.smoothingGroupForAttributes.end();
				bool potentialSmoothing = false;
				if(dealingWithFloat)
					if (! epsCheck(m.attributeData[it->first][vertIndex],inMesh.attributeData[it->first] [attIndex]))
						potentialSmoothing = true;
				if(dealingWithVec2)
					if (! m.attributeDataVec2[it->first][vertIndex].equals(inMesh.attributeDataVec2[it->first] [attIndex]))
						potentialSmoothing = true;
				if(dealingWithVec3)
				{
				//	std::cout<<"lol:"<<m.attributeDataVec3[it->first][vertIndex]<<std::endl;
				//	std::cout<<"lol2:"<<inMesh.attributeDataVec3[it->first] [attIndex]<<std::endl;
				//	std::cout<<"==================================="<<std::endl;
					if (! m.attributeDataVec3[it->first][vertIndex].equals(inMesh.attributeDataVec3[it->first] [attIndex]))
						potentialSmoothing = true;
				}
				if(dealingWithVec4)
					if (! m.attributeDataVec4[it->first][vertIndex].equals(inMesh.attributeDataVec4[it->first] [attIndex]))
						potentialSmoothing = true;
				if(dealingWithMat3)
				{
					if( !( (m.attributeDataMat3[it->first][vertIndex].getCollumn(0).equals(inMesh.attributeDataMat3[it->first] [attIndex].getCollumn(0))) &&
						(m.attributeDataMat3[it->first][vertIndex].getCollumn(1).equals(inMesh.attributeDataMat3[it->first] [attIndex].getCollumn(1))) &&
						(m.attributeDataMat3[it->first][vertIndex].getCollumn(2).equals(inMesh.attributeDataMat3[it->first] [attIndex].getCollumn(2))))) 
						potentialSmoothing = true;
				}
				if(dealingWithMat4)
				{
					if( !((m.attributeDataMat4[it->first][vertIndex].getColumn(0).equals(inMesh.attributeDataMat4[it->first] [attIndex].getColumn(0))) &&
						(m.attributeDataMat4[it->first][vertIndex].getColumn(1).equals(inMesh.attributeDataMat4[it->first] [attIndex].getColumn(1))) &&
						(m.attributeDataMat4[it->first][vertIndex].getColumn(2).equals(inMesh.attributeDataMat4[it->first] [attIndex].getColumn(2))) &&
						(m.attributeDataMat4[it->first][vertIndex].getColumn(3).equals(inMesh.attributeDataMat4[it->first] [attIndex].getColumn(3)))))
						potentialSmoothing = true;
				}

				if(potentialSmoothing && hasSmoothGroup)
				{
					unsigned int smgrp = inMesh.smoothingGroupForAttributes[it->first][attIndex];
					int j;
					if(smgrp==0)//smoothing group 0 means no smooth.
					{
						duplicateIt = true;
					}
					else
					{
						bool noSmoothingGroupMatch=true;
						if(dealingWithFloat)
						{
							for(j=0; j < refBackToFaces[vertIndex].size(); j++)
							{
								//go through all the other faces that has used this vertex
								if((inMesh.smoothingGroupForAttributes[it->first])[refBackToFaces[vertIndex][j].refToAFace]==smgrp)
								{
									noSmoothingGroupMatch=false;
									smoothedAttribute[it->first]=true;
									if(!refBackToFaces[vertIndex][j].hasBeenUsedForSmgrp)
									{
										m.attributeData[it->first][vertIndex] = m.attributeData[it->first][vertIndex]*0.5 + 
											inMesh.attributeData[it->first] [attIndex]*0.5;											
										refBackToFaces[vertIndex][j].hasBeenUsedForSmgrp=true;
									}

								}
							}
						}
						if(dealingWithVec2)
						{
							for(j=0; j < refBackToFacesV2[vertIndex].size(); j++)
							{
								//go through all the other faces that has used this vertex
								if((inMesh.smoothingGroupForAttributes[it->first])[refBackToFacesV2[vertIndex][j].refToAFace]==smgrp)
								{
									noSmoothingGroupMatch=false;
									smoothedAttribute[it->first]=true;
									if(!refBackToFacesV2[vertIndex][j].hasBeenUsedForSmgrp)
									{
										m.attributeDataVec2[it->first][vertIndex] = m.attributeDataVec2[it->first][vertIndex]*0.5 + 
											inMesh.attributeDataVec2[it->first] [attIndex]*0.5;											
										refBackToFacesV2[vertIndex][j].hasBeenUsedForSmgrp=true;
									}

								}
							}
						}
						if(dealingWithVec3)
						{
							for(j=0; j < refBackToFacesV3[vertIndex].size(); j++)
							{
								//go through all the other faces that has used this vertex
								if((inMesh.smoothingGroupForAttributes[it->first])[refBackToFacesV3[vertIndex][j].refToAFace]==smgrp)
								{
									noSmoothingGroupMatch=false;
									smoothedAttribute[it->first]=true;
									if(!refBackToFacesV3[vertIndex][j].hasBeenUsedForSmgrp)
									{
										m.attributeDataVec3[it->first][vertIndex] = m.attributeDataVec3[it->first][vertIndex]*0.5 + 
											inMesh.attributeDataVec3[it->first] [attIndex]*0.5;											
										refBackToFacesV3[vertIndex][j].hasBeenUsedForSmgrp=true;
									}

								}
							}
						}
						if(dealingWithVec4)
						{
							for(j=0; j < refBackToFacesV4[vertIndex].size(); j++)
							{
								//go through all the other faces that has used this vertex
								if((inMesh.smoothingGroupForAttributes[it->first])[refBackToFacesV4[vertIndex][j].refToAFace]==smgrp)
								{
									noSmoothingGroupMatch=false;
									smoothedAttribute[it->first]=true;
									if(!refBackToFacesV4[vertIndex][j].hasBeenUsedForSmgrp)
									{
										m.attributeDataVec4[it->first][vertIndex] = m.attributeDataVec4[it->first][vertIndex]*0.5 + 
											inMesh.attributeDataVec4[it->first] [attIndex]*0.5;											
										refBackToFacesV4[vertIndex][j].hasBeenUsedForSmgrp=true;
									}

								}
							}
						}

						if(noSmoothingGroupMatch)
						{
							duplicateIt=true;
							smoothingGrpReb=true;
						}
					}

				}
				else if(potentialSmoothing)
				{

					duplicateIt = true;
				}

			}

			if(duplicateIt)
			{
				m.indices[i] = m.vertices.size();
				for(std::map<std::string,std::vector<unsigned int> >::iterator it = inMesh.indexForAttributes.begin();
					it!= inMesh.indexForAttributes.end(); it++)
				{
					unsigned int attIndex = it->second[i];
					if(inMesh.attributeData.find(it->first)!=inMesh.attributeData.end())
					{
						if(smoothedAttribute[it->first]==true)
							m.attributeData[it->first].push_back(m.attributeData[it->first][vertIndex]);
						else
							m.attributeData[it->first].push_back(inMesh.attributeData[it->first] [attIndex]);
					}
					if(inMesh.attributeDataVec2.find(it->first)!=inMesh.attributeDataVec2.end())
					{
						if(smoothedAttribute[it->first]==true)
							m.attributeDataVec2[it->first].push_back(m.attributeDataVec2[it->first][vertIndex]);
						else
							m.attributeDataVec2[it->first].push_back(inMesh.attributeDataVec2[it->first] [attIndex]);
					}
					if(inMesh.attributeDataVec3.find(it->first)!=inMesh.attributeDataVec3.end())
					{
						if(smoothedAttribute[it->first]==true)
							m.attributeDataVec3[it->first].push_back(m.attributeDataVec3[it->first][vertIndex]);
						else
							m.attributeDataVec3[it->first].push_back(inMesh.attributeDataVec3[it->first] [attIndex]);
					}
					if(inMesh.attributeDataVec4.find(it->first)!=inMesh.attributeDataVec4.end())
					{

						if(smoothedAttribute[it->first]==true)
							m.attributeDataVec4[it->first].push_back(m.attributeDataVec4[it->first][vertIndex]);
						else
							m.attributeDataVec4[it->first].push_back(inMesh.attributeDataVec4[it->first] [attIndex]);
					}

					if(inMesh.attributeDataMat3.find(it->first)!=inMesh.attributeDataMat3.end())
					{
						m.attributeDataMat3[it->first].push_back(inMesh.attributeDataMat3[it->first] [attIndex]);
					}

					if(inMesh.attributeDataMat4.find(it->first)!=inMesh.attributeDataMat4.end())
					{
						m.attributeDataMat4[it->first].push_back(inMesh.attributeDataMat4[it->first] [attIndex]);
					}


				}
				m.vertices.push_back( inMesh.vertices[vertIndex]);

			}
			else
			{
				m.indices[i]=vertIndex;
			}
		}
	}



	return m;
}
