#include "fusa_geometryNode.h"
#include "fusa_scenegraph.h"
#include "../OGLIncludes.h"
#include <fstream>
#include <iostream>

using namespace fusa;
int cGeometryNode::genBufferIdCounter=0;

cGeometryNode::cGeometryNode(cScenegraph *ptr_sceneLink): cSpatialNode(ptr_sceneLink)
{
  m_bufferId=-1;
  mptr_hMesh = 0;
}

cSpatialNode::NodeType cGeometryNode::getNodeType()const
{
  return cSpatialNode::ntGeometry;
}

bool cGeometryNode::pickNode()const
{
  //FIX_ME optimize this.
  cCameraNode* node = mptr_scenegraphLink->getActiveCamera();
  cMatrix4<float> camMat;
  cMatrix4<float> transMatrix;

  transMatrix.toTranslateMatrix(node->getCameraPositionTransform());
  camMat = (node->getCameraRotationTransform().getMatrix4()*transMatrix);

  cVec2f clip;
  clip.x = 0;//(fusa::mouseX/800.0f)*2.0 -1.0;
  clip.y = 0;//-(fusa::mouseY/600.0f)*2.0 + 1.0;

  cVec3f ans;// = from2DClipSpaceToWorldSpace(clip,node->getProjectionMatrix(),camMat);
  cVec3f rayO =node->getWorldPosition();
  cVec3f dir = rayO- ans;
  dir = rayO + (ans-rayO)*1000.0;
  //ans*=1200.0;
  /* DEBUG STUFF
  //std::cout<<"in clip:"<<clip.x<<" "<<clip.y<<std::endl;
  //std::cout<<"projectpoint:"<<ans.x<<" "<<ans.y<<" "<<ans.z<<std::endl;


  glDisable(GL_TEXTURE_2D);
  glColor3f(1,1,1);
  //glUseProgramObjectARB(0);

  glPushMatrix();
  //float *rotData= reinterpret_cast<float*> (&(node->getWorldRotation().getMatrix4().m_matrixData));
  //glMultMatrixf(rotData);
  cVec3f tmp(0,0,1);
  //rayO.y-=10;


  glBegin(GL_LINES);

  //glVertex3f(0,0,0);
  glVertex3f(rayO.x,rayO.y-0.1,rayO.z);
  glVertex3f(dir.x,dir.y-0.1,dir.z);

  glEnd();

  glPointSize(30.0);
  glBegin(GL_POINTS);

  glVertex3f(node->getWorldPosition().x,node->getWorldPosition().y,node->getWorldPosition().z);
  glVertex3f(dir.x,dir.y,dir.z);

  glEnd();

  glTranslatef(node->getWorldPosition().x,node->getWorldPosition().y,node->getWorldPosition().z);
  //glutWireSphere(6,12,12);
  glPopMatrix();
  /*glBegin(GL_POINTS);
  glVertex3f(node->getWorldPosition().x ,node->getWorldPosition().y ,node->getWorldPosition().z -0.3);
  glEnd();*/


  //	cCollTypes col;
  //we should now be able to do a ray intersect with the sphere
  return false;//col.raySphere(mesh.getBoundingSphereRadius(),getWorldPosition()+mesh.boundSphereOffset,rayO,(ans - rayO).getNormalized());
}


bool cGeometryNode::loadNode(std::ifstream &in, bool binForm,int versionForm)
{
  if(!cSpatialNode::loadNode(in,binForm,versionForm))
    {
      return false;
    }
  if(binForm)
    {
      if(versionForm==1)
	{

	  int nrVertices=0;
	  in.read(reinterpret_cast<char*>(&nrVertices),sizeof(int));
	  mesh.vertices.resize(nrVertices);
	  in.read(reinterpret_cast<char*> (&mesh.vertices[0].x),
		  sizeof(float)*3*nrVertices);
	  int nrOfAttribs;
	  in.read(reinterpret_cast<char*>(&nrOfAttribs),sizeof(int));
	  for(int i=0; i < nrOfAttribs; i++)
	    {
	      std::string attribName;
	      char c=in.get();
	      while(c!='\0')
		{
		  attribName+=(c);
		  c=in.get();
		}
	      int componentSize;
	      in.read(reinterpret_cast<char*>(&componentSize),sizeof(int));
	      if(componentSize==2)
		{

		  mesh.vec2AttributeMap[attribName] = std::vector<cVec2f> (0);
		  std::vector<cVec2f> &attribs = mesh.vec2AttributeMap[attribName];
		  attribs.resize(nrVertices);
		  in.read(reinterpret_cast<char*>(&attribs[0].x),sizeof(float)*2*nrVertices);
		}

	      if(componentSize==3)
		{

		  mesh.vec3AttributeMap[attribName] = std::vector<cVec3f> (0);
		  std::vector<cVec3f> &attribs = mesh.vec3AttributeMap[attribName];
		  attribs.resize(nrVertices);
		  in.read(reinterpret_cast<char*>(&attribs[0].x),sizeof(float)*3*nrVertices);
		}
	    }
	  int nrOfFaces;
	  in.read(reinterpret_cast<char*>(&nrOfFaces),sizeof(int));
	  mesh.faces.resize(nrOfFaces);
	  in.read(reinterpret_cast<char*>(&mesh.faces[0].v1),sizeof(int)*3*nrOfFaces);
	}
      mesh.calculateBoundingSphere();
    }
  else
    {
      if(versionForm==1)
	{
	  cVec3f min;
	  cVec3f max;

	  std::string buff;
	  std::getline(in,buff,':');
	  int nrVertices;
	  in>>nrVertices;
	  in.ignore();
	  for(int i=0; i < nrVertices; i++)
	    {
	      cVec3f temp;
	      in>>temp;
	      if(i==0)
		{
		  min = temp;
		  max = temp;
		}
	      else
		{
		  if(min.x > temp.x)
		    {
		      min.x = temp.x;
		    }
		  if(min.y > temp.y)
		    {
		      min.y = temp.y;
		    }
		  if(min.z > temp.z)
		    {
		      min.z = temp.z;
		    }

		  if(max.x < temp.x)
		    {
		      max.x = temp.x;
		    }
		  if(max.y < temp.y)
		    {
		      max.y = temp.y;
		    }
		  if(max.z < temp.z)
		    {
		      max.z = temp.z;
		    }
		}
	      mesh.vertices.push_back(temp);
	    }

	  //now find out what component has the biggest difference.
	  cVec3f maxMinDiff = max-min;

	  mesh.setBoundingSphere( fabs(maxMinDiff.magnitude())*0.5 );
	  mesh.boundSphereOffset = min + maxMinDiff*0.5;

	  int nrOfAttribs;
	  std::getline(in,buff,':');
	  in>>nrOfAttribs;
	  for(int i=0; i < nrOfAttribs; i++)
	    {
	      std::string attribName;
	      std::getline(in,buff,':');
	      std::getline(in,attribName);
	      std::getline(in,buff,':');
	      int componentSize;
	      in>>componentSize;
	      in.ignore();
	      if(componentSize==1)
		{
		  for(int j=0; j < nrVertices; j++)
		    {
		      float comp;
		      in>>comp;
		    }
		  //mesh.
		  //FIX_ME we don't support singe component attributes yet.
		}

	      if(componentSize==2)
		{
		  mesh.vec2AttributeMap[attribName] = std::vector<cVec2f> (0);
		  std::vector<cVec2f> &attribs = mesh.vec2AttributeMap[attribName];
		  for(int j=0; j < nrVertices; j++)
		    {
		      cVec2f data;
		      in>>data;
		      attribs.push_back(data);

		    }

		}

	      if(componentSize==3)
		{
		  mesh.vec3AttributeMap[attribName] = std::vector<cVec3f> (0);
		  std::vector<cVec3f> &attribs = mesh.vec3AttributeMap[attribName];
		  for(int j=0; j < nrVertices; j++)
		    {
		      cVec3f data;
		      in>>data;
		      attribs.push_back(data);

		    }
		}
	    }

	  int nrOfFaces;
	  std::getline(in,buff,':');
	  in>>nrOfFaces;
	  in.ignore();
	  for(int i=0; i < nrOfFaces; i++)
	    {
	      sFace face;
	      in>>face.v1>>face.v2>>face.v3;
	      mesh.faces.push_back(face);
	    }
	 
	  if(mesh.vertices.size()!=0)
	  {
		  in.ignore();
		  mesh.generateTangents("tangent","normals","texCoord1");
		  mptr_hMesh = new cHardMesh;
		  mesh.mapSoftMeshToHardMesh(mptr_hMesh);
	  }
	}
    }
  return in.good();
}
