#include "fusa_cameraNode.h"


using namespace fusa;


cCameraNode::cCameraNode(cScenegraph *ptr_sceneLink): cSpatialNode(ptr_sceneLink)
{
	setPerspective(75.0,800.0/600.0,0.3,56000);
	m_useLookAt = false;
}


void cCameraNode::setPerspective(float fovy, float aspect,float zNear,float zFar)
{
	m_projMatrix.toPerspective(fovy,aspect,zNear,zFar);
}

cMatrix4<float> cCameraNode::getProjectionMatrix()const
{
	return m_projMatrix;
}


cVec3f cCameraNode::getCameraPositionTransform()const
{
	cVec3f  res = m_worldPosition * -1.0;
	return res;
}

cQuat<float> cCameraNode::getCameraRotationTransform() const
{
	//since we want a camera that is default (no rotations) to look at positive z, then.. do ..
	cQuat<float> quat;
	quat.rotate(3.1415926535897932384626433832795,cVec3f(0,1,0));
	return (m_worldRotation*quat).inverse();

}

void cCameraNode::addCameraPass(const cCameraPass &camPass)
{
	cameraPasses.push_back(camPass);
}

int cCameraNode::getNrOfCameraPasses()const
{
	return cameraPasses.size();
}

cCameraPass& cCameraNode::AccessCameraPass(int i)
{
	return cameraPasses[i];
}

const cCameraPass& cCameraNode::AccessCameraPass(int i)const
{
	return cameraPasses[i];
}

void cCameraNode::lookAt(const cVec3f &lookPos,const cVec3f& upVec)
{
	this->m_camLookAtTarget = lookPos;
	this->m_camLookAtUpVec = upVec;
}
