#ifndef H_xxFUSA_TEXTURExx_H
#define H_xxFUSA_TEXTURExx_H
#include <vector>
#include "../graphicIncludes.h"
#include <string>
#include <map>

namespace fusa
{
  ///pixel with templetized type per channel
  ///i.e sPixel<float> pix(4) creates a pixel
  ///with 4 floats per pixel. you could treat this as rgba float.
  template<class ta,unsigned int channels>
  struct sPixel
  {
    sPixel()
    {
      for(unsigned int i=0; i < channels; i++)
	{
	  m_channels[i] =0;
	}
    }
   
    ta& operator[](unsigned int channel)
    {
      return m_channels[channel];
    }

    const ta& operator[](unsigned int channel)const
    {
      return m_channels[channel];
    }
  private:
    ta m_channels[channels];
  };

  template<class ta,unsigned int channels>
  class cApplicationTexture 
  {
  public:
    cApplicationTexture(unsigned int width,
			unsigned int height,unsigned int depth=1)
    {
      m_width = width;
      m_height = height;
      m_depth = depth;
      m_picture.resize(width*height*depth);

    }

    unsigned int getWidth()const
    {
      return m_width;
    }

    unsigned int getHeight()const
    {
      return m_height;
    }

    unsigned int getDepth()const
    {
      return m_depth;
    }

    sPixel<ta,channels>& Access(unsigned int width,unsigned int height,unsigned depth=0)
    {
      return m_picture[width + height*m_width + depth*m_width*m_height];
    }

    const sPixel<ta,channels>& Access(unsigned int width,unsigned int height,
			     unsigned depth=0)const
    {
      return m_picture[width + height*m_width + depth*m_width*m_height];
    }

    ta* getDataPointer()
    {
      return &(Access(0,0)[0]);
    }

    const ta* getDataPointer()const
    {
      return &(Access(0,0)[0]);
    }

    unsigned int getChannelsPerPixel()const
    {
      return channels;
    }


  protected:
  private:
    std::vector<sPixel<ta,channels> > m_picture;
    
    unsigned int m_width;
    unsigned int m_height;
    unsigned int m_depth;
  };
 
  class cTexture
  {
  public:

    cTexture(bool genId=true);
    void initImage(GLenum target,
		     GLint miplevel,
		     GLint internalFormat,
		     GLsizei width,
		     GLsizei height,
		     GLsizei depth,
		     GLint border,
		     GLenum format,
		     GLenum type,
		     const GLvoid* pixels);

	void initImageCubeMap(GLenum target,
		     GLint miplevel,
		     GLint internalFormat,
		     GLsizei width,
		     GLsizei height,
		     GLsizei depth,
		     GLint border,
		     GLenum format,
		     GLenum type,
		     const GLvoid* pixels);

	

    template<class ta,unsigned int dimensions>
    void initImage(GLenum target,
		     GLint miplevel,
		     GLint internalFormat,
		     GLint border,
		     GLenum format,
		     GLenum type,
		   const cApplicationTexture<ta,dimensions>& appTex)
    {
       const ta* pntr = &appTex.Access(0,0)[0];
       initImage(target,miplevel,internalFormat,
		appTex.getWidth(),appTex.getHeight(),
		appTex.getDepth(),border,format,type,
		pntr);
      //		,appTex.getDataPointer()
    }


    void bindTexture(unsigned int unit=0);
   
    void parameters(GLenum pName,GLint param);
    void parameters(GLenum pName,GLint *param);
    void parameters(GLenum pName,GLfloat param);
    void parameters(GLenum pName,GLfloat *param);


    void setId(GLuint id)
    {
      m_id = id;
    }

    bool isMipmapped()const
    {
      return m_mipmap;
    }

    GLuint m_id;
    GLuint m_target;
    int m_width;
    int m_height;
    int m_depth;
  private:
    bool m_mipmap;
  };

  ///a renderable texture is one that can be bound as a target for
  ///rendering operations.
  class cRenderableTexture : public cTexture
  {
  public:
  protected:
  private:
  };

  class cFileTexture : public cTexture
  {
  public:
    cFileTexture():cTexture(false)
    {
    }
    void loadFromFile(const std::string &filename,GLint target=GL_TEXTURE_2D,bool mipmapDo=true);
  protected:
    
  private:
  };

  cFileTexture& getTexture(const std::string& filename);
extern  std::map<std::string,cFileTexture> m_fTexMap;
  
}

#endif
