#ifndef H_xxFUSA_SHADERxx_H
#define H_xxFUSA_SHADERxx_H
#include <map>
#include <vector>
#include <string>
#include "../graphicIncludes.h"
#include "../math/fusa_mathincludes.h"
namespace fusa
{

    class cVertexProgram
    {
        public:
        cVertexProgram();
        bool compile();
        GLint getProgram()const
        {
            return m_vertProg;
        }
        std::vector<std::string>& SourceCode()
        {
            return m_vertProgSource;
        }
        private:
        GLint m_vertProg;
        std::vector<std::string> m_vertProgSource;

    };

    class cFragmentProgram
    {
        public:
        cFragmentProgram();
        bool compile();
        GLint getProgram()const
        {
            return m_fragProg;
        }
        std::vector<std::string>& SourceCode()
        {
            return m_fragProgSource;
        }
        private:
        GLint m_fragProg;
        std::vector<std::string> m_fragProgSource;
    };


  class cShVarVec2f : public cVec2f
  {
  public:
    friend class cShader;
    cShVarVec2f()
    {
      m_shaderProg = -1;
      m_location = -1;
    }
    void send();
  protected:

  private:
    GLint m_shaderProg;
    GLint m_location;

  };

  class cShVarVec3f : public cVec3f
  {
  public:
    friend class cShader;
    cShVarVec3f()
    {
      m_shaderProg = -1;
      m_location = -1;
    }
	cShVarVec3f(const cShVarVec3f &sh):cVec3f(sh)
    {
		m_shaderProg = sh.m_shaderProg;
		m_location = sh.m_location;
    }
	cShVarVec3f(const cVec3f &sh):cVec3f(sh)
    {
		
    }

	const cShVarVec3f& operator=(const cShVarVec3f &sh)
    {
		cVec3f::operator=(cVec3f(sh));
		m_shaderProg = sh.m_shaderProg;
		m_location = sh.m_location;
		return *this;
    }
	const cShVarVec3f& operator=(const cVec3f &sh)
    {
		cVec3f::operator=(sh);
		return *this;
    }
    void send();
  protected:

  private:
    GLint m_shaderProg;
    GLint m_location;

  };

 class cShVarVec4f : public cVec4f
  {
  public:
    friend class cShader;
 cShVarVec4f()
    {
      m_shaderProg = -1;
      m_location = -1;
    }

    void send();
  protected:
     private:
    GLint m_shaderProg;
    GLint m_location;

  };

  class cShVarMat4f : public cMatrix4<float>
  {
  public:
    friend class cShader;
    cShVarMat4f()
    {
      m_shaderProg = -1;
      m_location = -1;
    }

    void send();
  protected:
     private:
    GLint m_shaderProg;
    GLint m_location;

  };

  class cShader
  {
  public:
    cShader();
      ///compile and link programs. makes the shader usable if successfull.
    bool compileAndLink();
    GLint getAttribLocation(const std::string &attribName);
    GLint getUniformLocation(const std::string &uniformName);
    void activate();

    cFragmentProgram& FragProg()
    {
      return m_fragProg;
    }

    cVertexProgram& VertProg()
    {
      return m_vertProg;
    }

    template<class ta>
    void bindVar(const std::string &uniformName,
		ta &var)
    {
        var.m_shaderProg = m_shaderProgram;
	var.m_location = getUniformLocation(uniformName);
    }


  protected:
  private:
    cFragmentProgram m_fragProg;
    cVertexProgram m_vertProg;
    GLint m_shaderProgram;
    std::map<std::string,GLint> m_attribLocs;
    };

  class cFileShader : public cShader
  {
  public:
    void load(const std::vector<std::string> &vertFiles,
	      const std::vector<std::string> &fragFiles);
    void load(const std::string &vertFile,
	      const std::string &fragFile);
  private:
  };
}

#endif
