#ifndef H_xxFUSA_MATERIALxx_H
#define H_xxFUSA_MATERIALxx_H
#include <vector>
#include "../graphicIncludes.h"
#include <fstream>
#include <iostream>
#include <string>

namespace fusa
{

  class cFileShader;
  class cTexture;

  class cMaterial
  {
  public:

    
    cFileShader* getShader()
    {
      return m_shader;
    }
    void setShader(cFileShader* sh)
    {
      m_shader = sh;
    }

    GLint getPrimMode()
    {
      return m_primitiveMode;
    }
    void setPrimMode(GLint primMode)
    {
      m_primitiveMode = primMode;
    }

    void setFaceToCull(GLint cullface)
    {
      m_cullFace = cullface;
    }

    GLint getFaceToCull()const
    {
      return m_cullFace;
    }

    void setPrimCulling(bool trueFalse)
    {
      m_cullEnabled = trueFalse;
    }

    bool shouldPrimCull()const
    {
      return m_cullEnabled;
    }

    void setZBufferTesting(bool buffTest)
    {
      m_zBufferTesting = buffTest;
    }

    void setZBufferWriting(bool buffTest)
    {
      m_zBufferWriting = buffTest;
    }

    bool shouldZBufferTest()const
    {
      return m_zBufferTesting;
    }

    bool shouldZBufferWrite()const
    {
      return m_zBufferWriting;
    }

    void setLineWidth(float lW)
    {
      m_lineWidth = lW;
    }

    float getLineWidth()const
    {
      return m_lineWidth;
    }

    void setPointSize(float pSize)
    {
      m_pointSize = pSize;
    }

    float getPointSize()const
    {
      return m_pointSize;
    }

    void setBlend(GLint blendSrc,GLint blendDst,bool blending)
    {
      m_blendSrc = blendSrc;
      m_blendDst = blendDst;
      m_isBlending = blending;
    }

    GLint getBlendSrc()const
    {
      return m_blendSrc;
    }

    GLint getBlendDst()const
    {
      return m_blendDst;
    }

    bool shouldBlend()const
    {
      return m_isBlending;
    }

    std::vector<cTexture*>& Textures()
    {
      return m_textures;
    }

    void loadFromFile(const std::string &filename);


  protected:
    void readTextParameter(std::ifstream &f_in,std::string &parse)
    {
      std::getline(f_in,parse,':');
      std::getline(f_in,parse);
  
    }
  private:
    //zbuffer stuff
    bool m_zBufferTesting;
    bool m_zBufferWriting;

    //primitive stuff
    float m_lineWidth;
    float m_pointSize;
    GLint  m_primitiveMode;
    GLint m_cullFace;
    bool m_cullEnabled;
    

    //blend mode
    GLint m_blendSrc;
    GLint m_blendDst;
    bool m_isBlending;

    //textures
    std::vector<cTexture*> m_textures;
    //shader
    cFileShader* m_shader;

  };
}

#endif
