#ifndef H_xxHARDMESHxx_H
#define H_xxHARDMESHxx_H
#include "../scenegraph/fusa_mesh.h"
#include "../graphicIncludes.h"
#include <fstream>
namespace fusa
{

  class cBufferData
  {
  public:
    cBufferData();
    //Target:
    //GL_ARRAY_BUFFER for vertex attribs etc.
    //GL_ELEMENT_ARRAY_BUFFER for indices etc.
	//GL_PIXEL_PACK_BUFFER for pixel buffer object.
	//GL_PIXEL_UNPACK_BUFFER for pixel buffer object.
    
    //type:
    //GL_FLOAT, etc. gl types. look in your gl documentation.

    //Usage:
    //GL_STATIC_DRAW_ARB , specify seldom draw often
    //GL_STATIC_READ_ARB, you can read this data. 
    //GL_STATIC_COPY_ARB, you can draw and read this data
    //GL_DYNAMIC_DRAW_ARB, specify once per frame.
    //GL_DYNAMIC_READ_ARB
    //GL_DYNAMIC_COPY_ARB
    //GL_STREAM_DRAW_ARB specify more than once per frame.
    //GL_STREAM_READ_ARB
    //GL_STREAM_COPY_ARB
    void storeData(GLint target,GLint bytePerChannel,
		   GLint m_channelsPerElement,
		   GLint nrOfElements,
		   GLint type,
		   const void *data,GLint usage);
    void sendData(GLint nrOfElements,
		  const void *data,unsigned int offset=0);

    void saveToFile(std::ofstream &f_out);
    void loadFromFile(std::ifstream &f_in);

    GLuint m_buffer;
    GLint m_usage;
    GLint m_target;
    
    GLint m_bytesPerChannel;
    GLint m_nrOfElements;
    GLint m_channelsPerElement;
    GLint m_type;
    
    
    
    bool m_hasDataStored;
  };





  class cShader;

  class cHardMesh
  {
  public:
    void draw(cShader *shade=0,GLint drawType=GL_TRIANGLES);


    cBufferData m_vertices;
    cBufferData m_indices;
    std::map<std::string,cBufferData> m_attribBuffer;
    
    void saveToFile(std::ofstream &out_file);
    void loadFromFile(std::ifstream &in_file);
    void saveToFile(const std::string &filename);
    void loadFromFile(const std::string &filename);

  protected:
  private:

  

  };
}

#endif
