#include "fusa_controllers.h"
#include <fstream>
#include <string>

using namespace fusa;

//base controller
//_____________________________________________________________________________-

cBaseController::cBaseController()
{
	//do work on all three components.
	m_doWorkOn=3;

	m_repeatCount = 0;
}

cBaseController::cBaseController(const cBaseController &rhs)
{
	m_doWorkOn = rhs.m_doWorkOn;
}

const cBaseController& cBaseController::operator=(const cBaseController &rhs)
{
	m_doWorkOn = rhs.m_doWorkOn;
	return *this;
}

cBaseController::~cBaseController()
{
	
}

bool cBaseController::saveControllerFile(std::ofstream &out,bool binFormat)const
{
	if(binFormat)
	{
		
	}
	else
	{
		out<<getControllerType()<<std::endl;
		out<<"do work on:"<<m_doWorkOn<<std::endl;
	}
	
	if(out.good())
	{
		return true;
	}

	return false;
}

bool cBaseController::loadControllerFile(std::ifstream &in,bool binFormat,unsigned int formatVersion)
{
	//nothing to do really. the id tag is read  by controllerHandler.
	if(binFormat)
	{
		if(formatVersion==0)
		{
			//load up format version 0
		}
	}
	
	else
	{
		if(formatVersion==0)
		{
			//load up format version 0
			std::string reader;
			std::getline(in,reader,':');
			in>>m_doWorkOn;
			in.ignore();
		}
	}

	if(in.good())
	{
		return true;
	}

	return false;
}

unsigned int cBaseController::getFileFormatVersion()
{
	//file format version is 0.
	return 0;
}

void cBaseController::setNrOfComponentsToUpdate(unsigned int doWorkOn)
{
	m_doWorkOn=doWorkOn;
}

unsigned int cBaseController::getNrOfComponentsToUpdate()const
{
	return m_doWorkOn;
}

//linear controller
//_____________________________________________________________________________

cLinearController::cLinearController() : cBaseController()
{

}

cLinearController::cLinearController(const cLinearController &rhs):cBaseController(rhs)
{
	m_controllerKeys = rhs.m_controllerKeys;
}

const cLinearController& cLinearController::operator=(const cLinearController &rhs)
{
	cBaseController::operator=(rhs);
	m_controllerKeys.clear();
	m_controllerKeys = rhs.m_controllerKeys;
	return *this;
}

cBaseController* cLinearController::clone()const
{
	cLinearController *linCon = new cLinearController;
	*linCon=*this;
	return linCon;
}

fusa::cVec3f cLinearController::getData(float t, bool ignoreRepeat)const
{
	if(m_controllerKeys.size()==0)
			{
				//controller is empty. this is an error, so crash.
				//TODO someone write logger. plz.
				fusa::cVec3f ans;
				return ans;
			}
			t=clamp(t,0.0f,1.0f);	
			std::list<sLinearKey>::const_iterator pnt1=m_controllerKeys.begin();
			std::list<sLinearKey>::const_iterator pnt2=m_controllerKeys.begin();
			std::list<sLinearKey>::const_iterator last = m_controllerKeys.end();
			last--;
		
			for(; pnt2!=m_controllerKeys.end(); pnt2++)
			{
				if(t<pnt2->t)
				{
					break;
				}
			}
			
			if(pnt2==m_controllerKeys.end())
			{
				//we have allready checked for emptyness, so this is an ok operation.
				pnt2--;
				return cVec3f(pnt2->data);
			}

			if(pnt2==m_controllerKeys.begin())
			{
				//we have allready checked for emptyness, so this is an ok operation.
				return cVec3f(pnt2->data);
			}

			pnt1=pnt2;
			pnt1--;
			float localT = (t-pnt1->t)/(pnt2->t-pnt1->t);
			
			cVec3f res;
			if(m_doWorkOn==1)
			{
				res.x = pnt1->data.x*(1.0f-localT) + pnt2->data.x*localT;
			}
			
			else if(m_doWorkOn==2)
			{
				res.x = pnt1->data.x*(1.0f-localT) + pnt2->data.x*localT;
				res.y = pnt1->data.y*(1.0f-localT) + pnt2->data.y*localT;
			}
			
			else if(m_doWorkOn==3)
			{
				res = pnt1->data*(1.0f-localT) + pnt2->data*localT;
			}

			return res;
}

void cLinearController::addData(const fusa::cVec3f &data,float t)
{
	sLinearKey key;
	key.t=t;
	key.data=data;

	for(std::list<sLinearKey>::iterator it=m_controllerKeys.begin(); it!=m_controllerKeys.end(); it++)
	{
		if(t <= it->t)
		{
			if(m_controllerKeys.size()==1)
			{
				m_controllerKeys.push_front(key);
				return;
			}

			std::list<sLinearKey>::iterator it2=it;
			m_controllerKeys.insert(it2,key);
			return;
		}

	}
	m_controllerKeys.push_back(key);
}

unsigned short cLinearController::getNumberOfKeys()const
{
	return m_controllerKeys.size();
}

cLinearController::sLinearKey& cLinearController::KeyAccess(unsigned short keyNum)
{
	if(keyNum>= m_controllerKeys.size())
	{
		//TODO logger plz. (this is going to be bad)
	}

	std::list<sLinearKey>::iterator it=m_controllerKeys.begin();
	for(int i=0; i<keyNum; i++)
	{
		it++;
	}
	return *it;
}

const cLinearController::sLinearKey& cLinearController::KeyAccess(unsigned short keyNum)const
{
	if(keyNum>= m_controllerKeys.size())
	{
		//TODO logger plz. (this is going to be bad)
	}

	std::list<sLinearKey>::const_iterator it=m_controllerKeys.begin();
	for(int i=0; i<keyNum; i++)
	{
		it++;
	}
	return *it;
}

cVec3f cLinearController::getMaxValues()const
{
	cVec3f ans;
	if(m_controllerKeys.size()==0)
	{
		return ans;
	}

	ans.x = m_controllerKeys.front().data.x;
	ans.y = m_controllerKeys.front().data.y;
	ans.z = m_controllerKeys.front().data.z;
	std::list<sLinearKey>::const_iterator it=m_controllerKeys.begin();
	for(; it!=m_controllerKeys.end(); it++)
	{
		if(ans.x < it->data.x)
		{
			ans.x = it->data.x;
		}

		if(ans.y < it->data.y)
		{
			ans.y = it->data.y;
		}

		if(ans.z < it->data.z)
		{
			ans.z = it->data.z;
		}
	}
	return ans;
}

///gets min values per chan. (val.x is lowest possible x value in any point that is returned etc.. )
cVec3f cLinearController::getMinValues()const
{
	cVec3f ans;
	if(m_controllerKeys.size()==0)
	{
		return ans;
	}

	ans.x = m_controllerKeys.front().data.x;
	ans.y = m_controllerKeys.front().data.y;
	ans.z = m_controllerKeys.front().data.z;
	std::list<sLinearKey>::const_iterator it=m_controllerKeys.begin();
	for(; it!=m_controllerKeys.end(); it++)
	{
		if(ans.x > it->data.x)
		{
			ans.x = it->data.x;
		}

		if(ans.y > it->data.y)
		{
			ans.y = it->data.y;
		}

		if(ans.z > it->data.z)
		{
			ans.z = it->data.z;
		}
	}
	return ans;
}

void cLinearController::sortKeys()
{
	m_controllerKeys.sort();
}

void cLinearController::fixOverlapping()
{
	if(m_controllerKeys.size()<2)
	{
		return;
	}

	std::list<sLinearKey>::iterator it= m_controllerKeys.begin();
	std::list<sLinearKey>::iterator it2= m_controllerKeys.begin();
	it2++;
	while(it2!=m_controllerKeys.end())
	{

		if(it->t > it2->t)
		{
			it->t = it2->t - 0.0001f;
		}

		it++;
		it2++;
	}
}


bool cLinearController::saveControllerFile(std::ofstream &out,bool binFormat)const
{
	bool res=cBaseController::saveControllerFile(out,binFormat);
	if(!res)
	{
		return false;
	}
	
	if(binFormat)
	{
		
	}
	else
	{
		out<<"number of keys:"<<m_controllerKeys.size()<<std::endl;
		std::list<sLinearKey>::const_iterator it=m_controllerKeys.begin();
		for(unsigned int i=0; i < m_controllerKeys.size(); i++)
		{
			out<<"key "<<i<<":"<<it->data<<" "<<it->t<<std::endl;
			it++;
		}
	}

	return out.good();
	
}

bool cLinearController::loadControllerFile(std::ifstream &in,bool binFormat,unsigned int formatVersion)
{
	if( !cBaseController::loadControllerFile(in,binFormat,formatVersion))
	{
		return false;
	}
	if(binFormat)
	{
		if(formatVersion==0)
		{

		}
	}
	else
	{
		if(formatVersion==0)
		{
			m_controllerKeys.clear();
			std::string reader;
			int numOfKeys=0;
			std::getline(in,reader,':');
			in>>numOfKeys;
			in.ignore();
			for(int i=0; i<numOfKeys; i++)
			{
				sLinearKey key;
				std::getline(in,reader,':');
				in>>key.data>>key.t;
				m_controllerKeys.push_back(key);
			}
			in.ignore();

		}
	}

	return in.good();
}

//tcb controller
//_____________________________________________________________________________

cTcbController::cTcbController(): cBaseController()
{

}
cTcbController::cTcbController(const cTcbController &rhs):cBaseController(rhs)
{
	m_controllerKeys = rhs.m_controllerKeys;
}

const cTcbController& cTcbController::operator=(const cTcbController &rhs)
{
	cBaseController::operator=(rhs);
	m_controllerKeys.clear();
	m_controllerKeys = rhs.m_controllerKeys;
	return *this;
}

cBaseController::ControllerType cTcbController::getControllerType()const
{
	return tcbControllerType;
}

cBaseController* cTcbController::clone()const
{
	cTcbController *tcbCon = new cTcbController;
	*tcbCon=*this;
	return tcbCon;
}

fusa::cVec3f cTcbController::getData(float t, bool ignoreRepeat)const
{
	if (m_repeatCount > 0)
	{
		//t = t / ;
	}

	fusa::cVec3f result;
	clamp(t,0.0,1.0);

	cTcbController::sTcbKey p0;
	cTcbController::sTcbKey p1;
	cTcbController::sTcbKey p2;
	cTcbController::sTcbKey p3;

	std::list<cTcbController::sTcbKey>::const_iterator it=m_controllerKeys.begin();
	bool last=false;
	bool first=false;

	if(it!=m_controllerKeys.end())
	{
		if(it->t >t)
		{
			first = true;
			p1=*it;
			return p1.data;
		}
	}

	while(it!=m_controllerKeys.end())
	{
		if(it->t <=t)
		{
			it++;
		}
		else
		{
			//we have found the point.
			it--;
			if(it==m_controllerKeys.begin())
			{
				first=true;
				p1=*it;
			}
			else if(it!=m_controllerKeys.end())
			{

				p1=*it;
				it--;
				p0=*it;
				it++;
			}

			it++;
			if(it!=m_controllerKeys.end())
			{
				p2=*it;
			}
			it++;
			if(it!=m_controllerKeys.end())
			{
				p3=*it;
			}
			else
			{
				last=true;
			}
			break;
		}
	}

	if(it==m_controllerKeys.end())
	{
		last=true;
		if(it!=m_controllerKeys.begin())
		{
			it--;
		}
		p2=*it;
	}

	cVec3f t1;
	cVec3f t2;

	if(m_doWorkOn==1)
	{
		if(!first)
		{
			
			float s1 = (p2.t - p1.t)/(p2.t - p0.t);
			t1.x = (1.0f - p1.tens) * (1.0f - p1.cont) * (1.0f + p1.bias) * (p1.data.x - p0.data.x)
				+  (1.0f - p1.tens) * (1.0f + p1.cont) * (1.0f - p1.bias) * (p2.data.x - p1.data.x);//*/
			t1.x*=s1;

		}
		else
		{
			t1.x = (1.0f - p1.tens)*(1.0f + p1.cont)*(1.0f - p1.bias)*(p2.data.x - p1.data.x);
		}
		if( !last)
		{
			float s2 = (p2.t - p1.t)/(p3.t - p1.t);
			t2.x =  (1.0f - p2.tens) * (1.0f - p2.cont) * (1.0f - p2.bias) * (p3.data.x - p2.data.x)
				+ (1.0f - p2.tens) * (1.0f + p2.cont) * (1.0f + p2.bias) * (p2.data.x - p1.data.x);//*/
			t2.x*=s2;

		}
		else
		{
			t2.x = (1.0f - p2.tens)*(1.0f + p2.cont)*(1.0f + p2.bias)*(p2.data.x - p1.data.x);
		}

	}
	else if(m_doWorkOn==2)
	{
		if(!first)
		{
			
			float s1 = (p2.t - p1.t)/(p2.t - p0.t);
			t1.x = (1.0f - p1.tens) * (1.0f - p1.cont) * (1.0f + p1.bias) * (p1.data.x - p0.data.x)
				+  (1.0f - p1.tens) * (1.0f + p1.cont) * (1.0f - p1.bias) * (p2.data.x - p1.data.x);//*/
			t1.x*=s1;

			t1.y = (1.0f - p1.tens) * (1.0f - p1.cont) * (1.0f + p1.bias) * (p1.data.y - p0.data.y)
				+  (1.0f - p1.tens) * (1.0f + p1.cont) * (1.0f - p1.bias) * (p2.data.y - p1.data.y);//*/
			t1.y*=s1;

		}
		else
		{
			t1.x = (1.0f - p1.tens)*(1.0f + p1.cont)*(1.0f - p1.bias)*(p2.data.x - p1.data.x);
			t1.y = (1.0f - p1.tens)*(1.0f + p1.cont)*(1.0f - p1.bias)*(p2.data.y - p1.data.y);
		}
		if( !last)
		{
			float s2 = (p2.t - p1.t)/(p3.t - p1.t);
			t2.x =  (1.0f - p2.tens) * (1.0f - p2.cont) * (1.0f - p2.bias) * (p3.data.x - p2.data.x)
				+ (1.0f - p2.tens) * (1.0f + p2.cont) * (1.0f + p2.bias) * (p2.data.x - p1.data.x);//*/
			t2.x*=s2;

			t2.y =  (1.0f - p2.tens) * (1.0f - p2.cont) * (1.0f - p2.bias) * (p3.data.y - p2.data.y)
				+ (1.0f - p2.tens) * (1.0f + p2.cont) * (1.0f + p2.bias) * (p2.data.y - p1.data.y);//*/
			t2.y*=s2;

		}
		else
		{
			t2.x = (1.0f - p2.tens)*(1.0f + p2.cont)*(1.0f + p2.bias)*(p2.data.x - p1.data.x);
			t2.y = (1.0f - p2.tens)*(1.0f + p2.cont)*(1.0f + p2.bias)*(p2.data.y - p1.data.y);
		}
	}

	else
	{
		if(!first)
		{
			float s1 = (p2.t - p1.t)/(p2.t - p0.t);
			t1 = (1.0f - p1.tens) * (1.0f - p1.cont) * (1.0f + p1.bias) * (p1.data - p0.data)
				+  (1.0f - p1.tens) * (1.0f + p1.cont) * (1.0f - p1.bias) * (p2.data - p1.data);//*/
			t1*=s1;

		}
		else
		{
			t1 = (1.0f - p1.tens)*(1.0f + p1.cont)*(1.0f - p1.bias)*(p2.data - p1.data);
		}
		if( !last)
		{
			float s2 = (p2.t - p1.t)/(p3.t - p1.t);
			t2 =  (1.0f - p2.tens) * (1.0f - p2.cont) * (1.0f - p2.bias) * (p3.data - p2.data)
				+ (1.0f - p2.tens) * (1.0f + p2.cont) * (1.0f + p2.bias) * (p2.data - p1.data);//*/
			t2*=s2;

		}
		else
		{
			t2 = (1.0f - p2.tens)*(1.0f + p2.cont)*(1.0f + p2.bias)*(p2.data - p1.data);
		}

	}
	//time-scale t to fit to local scale.

	t=(t-p1.t)/(p2.t-p1.t);

	float tt = t*t;
	float ttt = tt*t;

	float h0 = 2.0f * ttt - 3.0f * tt + 1.0f;
	float h1 = -2.0f * ttt + 3.0f * tt;
	float h2 = ttt -2.0f * tt + t;
	float h3 = ttt - tt;

	if(m_doWorkOn==1)
	{
		result.x = h0*p1.data.x + h1*p2.data.x + h2*t1.x + h3*t2.x;
	}
	else if(m_doWorkOn==2)
	{
		result.x = h0*p1.data.x + h1*p2.data.x + h2*t1.x + h3*t2.x;
		result.y = h0*p1.data.y + h1*p2.data.y + h2*t1.y + h3*t2.y;
	}
	
	else
	{
		result = h0*p1.data + h1*p2.data + h2*t1 + h3*t2;
	}

	return result;
}

void cTcbController::addData(const fusa::cVec3f &data,float t,float tension,float bias,float cont)
{
	cTcbController::sTcbKey key;
	key.t=t;
	key.data=data;
	key.tens = tension;
	key.bias = bias;
	key.cont = cont;

	for(std::list<cTcbController::sTcbKey>::iterator it=m_controllerKeys.begin(); it!=m_controllerKeys.end(); it++)
	{
		if(t<=it->t)
		{
			if(m_controllerKeys.size()==1)
			{
				m_controllerKeys.push_front(key);
				return;
			}

			std::list<sTcbKey>::iterator it2=it;
			m_controllerKeys.insert(it2,key);
			return;
		}
	}
	m_controllerKeys.push_back(key);
}


void cTcbController::addData(const fusa::cVec3f &data,float tension,float bias,float cont)
{
	cTcbController::sTcbKey key;
	key.t=1.0f;
	key.data=data;
	key.tens = tension;
	key.bias = bias;
	key.cont = cont;

	float size = m_controllerKeys.size();
	float tVal = 0.0f;
	float tStep = 1.0f/size;
	for(std::list<cTcbController::sTcbKey>::iterator it=m_controllerKeys.begin(); it!=m_controllerKeys.end(); it++)
	{
		it->t = tVal;
		tVal+=tStep;
	}
	m_controllerKeys.push_back(key);
}

unsigned short cTcbController::getNumberOfKeys()const
{
	return m_controllerKeys.size();
}

cTcbController::sTcbKey& cTcbController::KeyAccess(unsigned short keyNum)
{
	if(keyNum>= m_controllerKeys.size())
	{
		//TODO logger plz. (this is going to be bad)
	}

	std::list<cTcbController::sTcbKey>::iterator it=m_controllerKeys.begin();
	for(int i=0; i<keyNum; i++)
	{
		it++;
	}
	return *it;
}

const cTcbController::sTcbKey& cTcbController::KeyAccess(unsigned short keyNum)const
{
	if(keyNum>= m_controllerKeys.size())
	{
		//TODO logger plz. (this is going to be bad)
	}

	std::list<cTcbController::sTcbKey>::const_iterator it=m_controllerKeys.begin();
	for(int i=0; i<keyNum; i++)
	{
		it++;
	}
	return *it;
}

cVec3f cTcbController::getMaxValues()const
{
	cVec3f ans;
	if(m_controllerKeys.size()==0)
	{
		return ans;
	}

	ans.x = m_controllerKeys.front().data.x;
	ans.y = m_controllerKeys.front().data.y;
	ans.z = m_controllerKeys.front().data.z;
	std::list<cTcbController::sTcbKey>::const_iterator it=m_controllerKeys.begin();
	for(; it!=m_controllerKeys.end(); it++)
	{
		if(ans.x < it->data.x)
		{
			ans.x = it->data.x;
		}

		if(ans.y < it->data.y)
		{
			ans.y = it->data.y;
		}

		if(ans.z < it->data.z)
		{
			ans.z = it->data.z;
		}
	}
	return ans;
}

cVec3f cTcbController::getMinValues()const
{
	cVec3f ans;
	if(m_controllerKeys.size()==0)
	{
		return ans;
	}

	ans.x = m_controllerKeys.front().data.x;
	ans.y = m_controllerKeys.front().data.y;
	ans.z = m_controllerKeys.front().data.z;
	std::list<cTcbController::sTcbKey>::const_iterator it=m_controllerKeys.begin();
	for(; it!=m_controllerKeys.end(); it++)
	{
		if(ans.x > it->data.x)
		{
			ans.x = it->data.x;
		}

		if(ans.y > it->data.y)
		{
			ans.y = it->data.y;
		}

		if(ans.z > it->data.z)
		{
			ans.z = it->data.z;
		}
	}
	return ans;
}
void cTcbController::sortKeys()
{
	m_controllerKeys.sort();
}

void cTcbController::fixOverlapping()
{
	if(m_controllerKeys.size()<2)
	{
		return;
	}

	std::list<sTcbKey>::iterator it= m_controllerKeys.begin();
	std::list<sTcbKey>::iterator it2= m_controllerKeys.begin();
	it2++;
	while(it2!=m_controllerKeys.end())
	{

		if(it->t > it2->t)
		{
			it->t=it2->t-0.00001f;
		}
		it++;
		it2++;
	}
}

bool cTcbController::saveControllerFile(std::ofstream &out,bool binFormat)const
{
	bool res=cBaseController::saveControllerFile(out,binFormat);
	if(!res)
	{
		return false;
	}
	
	if(binFormat)
	{
		
	}
	else
	{
		out<<"number of keys:"<<m_controllerKeys.size()<<std::endl;
		std::list<sTcbKey>::const_iterator it=m_controllerKeys.begin();
		for(unsigned int i=0; i < m_controllerKeys.size(); i++)
		{
			out<<"key "<<i<<":"<<it->data<<" "<<it->t<<" "<<it->tens<<" "<<it->bias<<" "<<it->cont<<std::endl;
			it++;
		}
	}

	return out.good();
	
}

bool cTcbController::loadControllerFile(std::ifstream &in,bool binFormat,unsigned int formatVersion)
{
	bool res=cBaseController::loadControllerFile(in,binFormat,formatVersion);
	if(!res)
	{
		return false;
	}
	
	if(binFormat)
	{
		if(formatVersion==0)
		{

		}
	}
	else
	{
		if(formatVersion==0)
		{
			std::string reader;
			std::getline(in,reader,':');
			unsigned int numberOfKeys=0;
			in>>numberOfKeys;
			
			for(unsigned int i=0; i < numberOfKeys; i++)
			{
				sTcbKey key;
				std::getline(in,reader,':');
				in>>key.data>>key.t>>key.tens>>key.bias>>key.cont;
				m_controllerKeys.push_back(key);
			}
			in.ignore();
		}
	}

	return in.good();
	
}

