/*******************************************************

Original Author...Hvard Christensen
Purpose...........Collection of controllers

Description:

********************************************************/

#ifndef H_xxCONTROLLERSERVERxx_H
#define H_xxCONTROLLERSERVERxx_H
#include <vector>
#include <fstream>
#include <string>
#include "fusa_controllers.h"

namespace fusa
{
	class cBaseController;
	class cLinearController;
	class cTcbController;

	///Manages controllers
	class cControllerServer
	{
	public:


		cBaseController* generateNewController(cBaseController::ControllerType contType)
		{
			cBaseController* newCont=createNewController(contType);
			
			if(newCont)
			{
				m_controllers.push_back(newCont);	
			}
			return newCont;
		}

		///this creates a new controller and returns it, but is independant of a controller-server object, thus it is static
		static cBaseController* createNewController(cBaseController::ControllerType contType)
		{
			cBaseController* newCont=0;
			switch(contType)
			{
			case cBaseController::linearControllerType:
				newCont = new cLinearController;
				break;
			case cBaseController::tcbControllerType:
				newCont = new cTcbController;
				break;
			}
			return newCont;
		}

		///It is independant of a controller-server object, thus is static.
		static cBaseController* loadController(std::ifstream &in,bool binForm=false, int versionNum=0)
		{
			cBaseController::ControllerType cType;
			int type;
			in>>type;
			cType = static_cast<cBaseController::ControllerType> (type);
			in.ignore();
			cBaseController *con = createNewController(cType);
			con->loadControllerFile(in,binForm,versionNum);
			//in.ignore();
			return con;
		}

		///adds a copy of that controller to the server.
		void addController(const cBaseController &cont)
		{
			cBaseController *newCon = cont.clone();
			if(newCon)
			{
				m_controllers.push_back(newCon);
			}
			
		}

		cBaseController* getController(unsigned int contrNr)const
		{
			if(contrNr>=m_controllers.size())
			{
				return 0;
			}
			return m_controllers[contrNr];
		}

		unsigned int getNrOfControllers()const
		{
			return m_controllers.size();
		}

		bool saveControllers(const std::string &fileName,bool binFormat=false)const
		{
			
			if(binFormat)
			{
			
			}
			else
			{
				std::ofstream out;
				out.open(fileName.c_str());
				out<<"controller file format version:"<<cBaseController::getFileFormatVersion()<<std::endl;
				out<<"number of controllers:"<<m_controllers.size()<<std::endl;
				for(unsigned int i=0; i<m_controllers.size(); i++)
				{
					if(!m_controllers[i]->saveControllerFile(out))
					{
						return false;
					}
				}
				return out.good();
			}
			return true;
		}

		bool loadControllers(const std::string &fileName,bool binFormat=false)
		{
			if(binFormat)
			{

			}
			else
			{
				std::ifstream in;
				std::string reader;
				in.open(fileName.c_str());
				if(!in.good())
				{
					return false;
				}
				
				m_controllers.clear();
				
				int version=0;
				std::getline(in,reader,':');
				in>>version;
				
				if(version==0)
				{
					int numberOfControllers=0;
					std::getline(in,reader,':');
					in>>numberOfControllers;
					in.ignore();
					for(int i=0; i < numberOfControllers; i++)
					{
						cBaseController::ControllerType cType;
						int type;
						in>>type;
						cType = static_cast<cBaseController::ControllerType> (type);
						in.ignore();
						cBaseController *con = generateNewController(cType);
						con->loadControllerFile(in,binFormat,version);
						in.ignore();
					}
				}

				return in.good();
			}

			return true;
		}

	protected:
		std::vector<cBaseController*> m_controllers;
		
	};
}

#endif
