#ifndef __TEXTURE_H
#define __TEXTURE_H

typedef struct texture
{
	int	bitsperpixel;
	int 	width,height;
	s32	*image;
	int	*clut;
	int	addr,clutaddr;
	s64	TW,TH;
}texture;

void texture_cleartexturemem(int color);
void texture_init(texture *tex);
void texture_upload(texture *tex, int addr);
void texture_load(texture *tex, char *file);
void texture_loadjpg(texture *tex, char *file);
void texture_loadalpha(texture *tex, char *file);
s64 texture_TEX0(texture* tex);
s64 texture_TEX1(texture* tex);
s64 texture_TEX2(texture* tex);
void texture_allocupload(texture *tex);

#endif
