#include <tamtypes.h>
#include <fileio.h>
#include <stdlib.h>
#include <kernel.h>

#define MM 2147483647
#define AA 48271
#define QQ 44488
#define RR 3399

#define RANDOM_MAX 0x7fff

s32 random()
{
	static s32 X = 0xfedeabe;
	X=AA*(X%QQ)-RR*(X/QQ);
	if(X<0) X+=MM;
	return X & RANDOM_MAX;
}

float f_random()
{
	return (float)random() / (float)RANDOM_MAX;
}

static int read_file_inner(const char* fname, void** ptr, int* size)
{
	int fd = fioOpen(fname, O_RDONLY);
	if(fd > 0)
	{
		*size = fioLseek(fd, 0, SEEK_END);		
		fioLseek(fd, 0, SEEK_SET);
		*ptr = malloc(*size);
		if(*ptr == 0)
		{
			fioClose(fd);
			nprintf("read_file(): Out of memory while loading %s\n", fname);
			SleepThread();
		}
		if(fioRead(fd, *ptr, *size) != *size)
		{
			fioClose(fd);
			nprintf("read_file(): Error reading from %s\n", fname);
			SleepThread();
		}
		fioClose(fd);
		return 1;
	}
	//nprintf("read_file(): Error loading %s\n", fname);
	//SleepThread();
	return 0;
}



void read_file(const char* filename, void** ptr, int* size)
{
	char fname[FIO_PATH_MAX];
	
	sprintf(fname, "host:%s",filename);
	if(!read_file_inner(fname, ptr, size))
	{
		sprintf(fname, "cdrom0:%s",filename);
		if(!read_file_inner(fname, ptr, size))
		{
			nprintf("read_file(): Error loading %s\n", filename);
			SleepThread();
		}
	}
}

void write_file(const char* fname, void* ptr, int size)
{
	int fd;
	fd = fioOpen(fname, O_CREAT|O_WRONLY);
	if(fd > 0)
	{
		if(fioWrite(fd, ptr, size) != size)
		{
			fioClose(fd);
			nprintf("read_file(): Error writing to %s\n", fname);
			SleepThread();
		}
		fioClose(fd);
	}
	else
	{
		nprintf("write_file(): Error opening %s\n", fname);
		SleepThread();
	}
}

void dumpmem(volatile void* beg_, volatile void* end_)
{	u8* beg=(u8*)beg_,*end=(u8*)end_;
	u32 cnt=0;
	nprintf("0000: ");
	while(beg<end)
	{
		nprintf("%2.2X ",*beg);
		if(++cnt % 16 == 0) nprintf("\n%4.4X: ",cnt);
		++beg;
	}
	nprintf("\n");
}


void comparemem(volatile void* beg_, volatile void* end_, volatile void* beg2_)
{	
	u8* beg=(u8*)beg_,*end=(u8*)end_,*beg2=(u8*)beg2_;
	u32 cnt=0;
	while(beg<end)
	{
		if(*beg!=*beg2)
			nprintf("%d != %d, cnt = %d\n", (int)*beg,(int)*beg2,cnt);
		++beg;
		++beg2;
		++cnt;
	}
}
