#ifndef _math_H_INCLUDED
#define _math_H_INCLUDED

#define M_PI 3.14159265358979323846


// ROW MAJOR
typedef struct Matrix
{
	float	xu,yu,zu,dummy1;
	float	xv,yv,zv,dummy2;
	float	xw,yw,zw,dummy3;
	float	xx,yy,zz,dummy4;
} Matrix __attribute__((aligned(16)));

typedef struct Vector3d
{
	float x, y, z, w;
} Vector3d __attribute__((aligned(16)));

typedef struct Vector2d
{
	int x, y, z, w;
} Vector2d;

extern void math_init();

extern void math_project_vertices(Vector2d* dst, Vector3d* src, int count);
extern void math_transform_vertices(Vector3d* dst, Vector3d* src, Matrix* m, int count);

extern void math_matrix_identity(Matrix *m);
extern void math_matrix_rotatex(Matrix *m, float a);
extern void math_matrix_rotatey(Matrix *m, float a);
extern void math_matrix_rotatez(Matrix *m, float a);
extern void math_matrix_move(Matrix *m, float x, float y, float z);
extern void math_matrix_lookat(Matrix *m, Vector3d* pos, Vector3d* target);
extern void math_matrix_project(Matrix *m, float fov, float z_near, float z_far);
extern void math_matrix_multiply(Matrix *dst, Matrix* a, Matrix* b);

extern void math_vector_calc_normal(Vector3d* dst, Vector3d* a, Vector3d* b, Vector3d* c);
extern void math_vector_normalize(Vector3d* dst, Vector3d* src);
extern void math_vector_mul(Vector3d* dst, Vector3d* a, Vector3d* b);
extern void math_vector_cross(Vector3d* dst, Vector3d* a, Vector3d* b);
extern float math_calc_light(Vector3d* n, Vector3d* pos, Vector3d* lightpos);

inline static float fmod(float x, float y)
{
	int i=x/y;
	return x-i*y;
}

/////////////////////// Nedenstende er med tak til craft^fudge a.k.a. drckluft/soopadoopa (dvs. han har skrevet det ;)
/////////////////////// fra funslower sourcen

#define __my_math_iter 20

inline static float sqrt(float a)
{
	float b;
	
	asm(
	"sqrt.s %0,%1\n"
	: "=f" (b)
	: "f" (a));
	
	return b;
}

// Taylor series
inline static float cos(float v)
{
	float res,w;
	int t;
	float fac;
	int i=(v)/(2*M_PI);
	v-=i*2*M_PI;

	fac=1;
	res=0;
	w=1;
	for(t=0;t<__my_math_iter;)
	{
		res+=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
		
		res-=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
	}
	return res;
}

inline static float sin(float v)
{
	float res,w;
	int t;
	float fac;
	int i=(v)/(2*M_PI);
	v-=i*2*M_PI;

	fac=1;
	res=0;
	w=v;
	for(t=1;t<__my_math_iter;)
	{
		res+=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
		
		res-=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
	}
	return res;
}


//// Nedenstaaende fra Cephes Math Library
/*
Cephes Math Library Release 2.2:  June, 1992
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

#define DP1		0.78515625f
#define DP2		2.4187564849853515625e-4f
#define DP3		3.77489497744594108e-8f
#define FOPI	1.27323954473516f
#define lossth	8192.0f

static inline float tan(float xx)
{
	float x, y, z, zz;
	int j;
	int sign;


	/* make argument positive but save the sign */
	if( xx < 0.0 )
	{
		x = -xx;
		sign = -1;
	}
	else
	{
		x = xx;
		sign = 1;
	}

	if( x > lossth )
		return(0.0);

	/* compute x mod PIO4 */
	j = FOPI * x; /* integer part of x/(PI/4) */
	y = j;

	/* map zeros and singularities to origin */
	if( j & 1 )
	{
		j += 1;
		y += 1.0;
	}

	z = ((x - y * DP1) - y * DP2) - y * DP3;

	zz = z * z;

	if( x > 1.0e-4 )
	{
		/* 1.7e-8 relative error in [-pi/4, +pi/4] */
		y =
			((((( 9.38540185543E-3 * zz
			+ 3.11992232697E-3) * zz
			+ 2.44301354525E-2) * zz
			+ 5.34112807005E-2) * zz
			+ 1.33387994085E-1) * zz
			+ 3.33331568548E-1) * zz * z
			+ z;
	}
	else
	{
		y = z;
	}

	if( j & 2 )
	{
		y = -1.0/y;
	}

	if( sign < 0 )
		y = -y;

	return( y );
}

#undef DP1
#undef DP2
#undef DP3
#undef FOPI
#undef lossth

extern float pow(float,float);
extern float exp(float);
extern float sinh(float);

#endif
