///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// TextFX4
// Copyright (c) 1995-2002 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////

#ifndef TEXTFX_H_INCLUDED
#define TEXTFX_H_INCLUDED


static const int TFX_ConsoleHeight=50;
static const int TFX_ConsoleWidth=80;
extern short TFX_FrameBuffer[];

// Present framebuffer to user
extern void TFX_Present();

// Set the title of the window
extern void TFX_SetTitle(char *aTitle);


enum TFX_CREATION_FLAGS
{
    TFX_DEFAULT=0xffff,
    TFX_AA_IBMSCII_PRINTABLES=1,
    TFX_AA_PURE_ASCII=2,
    
};

class TFXQuad
{
public:
    int x0,y0,x1,y1;
    TFXQuad() {};
    TFXQuad(int aX0, int aY0, int aX1, int aY1) { x0=aX0; x1=aX1; y0=aY0; y1=aY1; }
};



class TFX_TCConverter
{
public:
    // Calculate single color. Colors are in 0..255 range.
    virtual short int CalcColor(int aRed, int aGreen, int aBlue)=0;
    // Build look-up table. 
    virtual void BuildLUT(int aFlags=TFX_DEFAULT)=0;
    // Dump source buffer to target, 1x1->1x1 sampling
    virtual void Dump1x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch =  80, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer)=0;
    // Dump source buffer to target, 2x2->1x1 sampling 
    virtual void Dump2x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 160, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer)=0;
    // Dump source buffer to target, 4x4->1x1 sampling 
    virtual void Dump4x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 320, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer)=0;
    virtual ~TFX_TCConverter() {};
};



class TFX_BlockColor : public TFX_TCConverter
{
public:
    TFX_BlockColor();
    // Calculate single color. Colors are in 0..255 range.
    virtual short int CalcColor(int aRed, int aGreen, int aBlue);
    // Build look-up table. 
    virtual void BuildLUT(int aFlags=TFX_DEFAULT);
    // Dump source buffer to target, 1x1->1x1 sampling
    virtual void Dump1x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch =  80, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    // Dump source buffer to target, 2x2->1x1 sampling 
    virtual void Dump2x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 160, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    // Dump source buffer to target, 4x4->1x1 sampling 
    virtual void Dump4x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 320, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    virtual ~TFX_BlockColor();
private:
    short int * mBlockMap;
};



class TFX_AsciiArt : public TFX_TCConverter
{
public:
    TFX_AsciiArt();
    // Calculate single color. Colors are in 0..255 range.
    virtual short int CalcColor(int aRed, int aGreen, int aBlue);
    // Build look-up table. 
    virtual void BuildLUT(int aFlags=TFX_DEFAULT);
    // Dump source buffer to target, 1x1->1x1 sampling
    virtual void Dump1x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch =  80, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    // Dump source buffer to target, 2x2->1x1 sampling 
    virtual void Dump2x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 160, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    // Dump source buffer to target, 4x4->1x1 sampling 
    virtual void Dump4x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 320, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    virtual ~TFX_AsciiArt();
private:
    short int * mAsciiMap;
};


class TFX_AsciiArt2 : public TFX_TCConverter
{
public:
    TFX_AsciiArt2();
    // Calculate single color. Colors are in 0..255 range.
    virtual short int CalcColor(int aRed, int aGreen, int aBlue);
    // Build look-up table. 
    virtual void BuildLUT(int aFlags=TFX_DEFAULT);
    // Dump source buffer to target, 1x1->1x1 sampling
    virtual void Dump1x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch =  80, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    // Dump source buffer to target, 2x2->1x1 sampling 
    virtual void Dump2x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 160, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    // Dump source buffer to target, 4x4->1x1 sampling 
    virtual void Dump4x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch = 320, int aTgtX0 = 0, int aTgtY0 = 0, short *aTarget = TFX_FrameBuffer);
    virtual ~TFX_AsciiArt2();
private:
    short int * mAsciiMap;
};


#endif // TEXTFX_H_INCLUDED