/* PCX loader (c)1995-2001 Jari Komppa - freeware */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cfl.h"
#include "ramfile3.h"
/***************
  * Structures *
  ***************/

typedef struct {
 char manufacturer; /* 10 for paintbrush */
 char version; /* If 5 or more, 768 byte palette is found at the eof. */
 char encoding; /* 1 for .pcx */
 char bits_per_pixel; /* 1,4,8,24 */
 short int xmin; /* why min?! */
 short int ymin;
 short int xmax;
 short int ymax;
 short int horizontal_res; /* in dpi.. forget it */
 short int vertical_res;
 char palette_for_16c_modes[48]; /* 0=black, 255=white. in rgb triplets. */
 char reserved; /* should be 0 */
 char colour_planes;
 short int bytes_per_line;
 short int palette_type; /* to be ignored */
 short int hscreensize;
 short int vscreensize; /* These two are only found in some PCXes but should
                           be filled for compatibility's sake. */
 char filler[54];
} PCXHEADER;

/***************
  * Real stuff *
  ***************/

static void decode_pcx_line(int yoffs, int bytesperline, int realwidth, char * picdata, FILE * picfile) {
int depack,packto,counter;
char data;
    counter=0;
    while (counter<(bytesperline)) {
      data=(char)fgetc(picfile);
      if ((data&192)==192) {
        packto=data&63;
        data=(char)fgetc(picfile);
        for(depack=0;depack<packto;depack++) {
           if (counter<realwidth)
            *(picdata+yoffs+counter)=data;
           counter++;
        }
      }
      else {
       if (counter<realwidth)
        *(picdata+yoffs+counter)=data;
       counter++;
      }
    }
}

void getpcxinfo(char * filename, int * xsize, int * ysize) {
FILE * picfile;
PCXHEADER hdr;
  picfile=fopen(filename,"rb");
  if (picfile==NULL) 
  {
      *xsize=*ysize=0;
      return;
  }

  fread(&hdr,sizeof(PCXHEADER),1,picfile);
  if (hdr.manufacturer==10 && hdr.encoding==1) {
    *xsize=hdr.xmax-hdr.xmin+1;
    *ysize=hdr.ymax-hdr.ymin+1;
  } else {
    *xsize=*ysize=0;
  }
  fclose(picfile);
}

char * loadpcx(char * filename) {
FILE * picfile;
int picsize,ycount;
char * buf=NULL;
int xsize, ysize;
PCXHEADER hdr;
    picfile=fopen(filename,"rb");
    if (picfile==NULL) return NULL;
    fread(&hdr,sizeof(PCXHEADER),1,picfile);
    xsize=hdr.xmax-hdr.xmin+1;
    ysize=hdr.ymax-hdr.ymin+1;
    fseek(picfile,-769,SEEK_END);
    if((hdr.version>4)&&(hdr.encoding==1)&&(hdr.bits_per_pixel==8)&&
       (hdr.colour_planes==1)&&(fgetc(picfile)==12)) {

/* We can only handle v5+, PCX, 8b, one plane PCXes with 256c palette.
   (for the time being) */

        picsize=xsize*ysize;
        buf=new char[picsize];
        fseek(picfile,sizeof(PCXHEADER),SEEK_SET);
        for (ycount=0;ycount<ysize;ycount++)
         decode_pcx_line(ycount*(xsize),hdr.bytes_per_line,xsize,buf,picfile);
    }

    fclose(picfile);
    return(buf);
}


char * loadpcxpal(char * filename) {
FILE * picfile;
char * buf=NULL;
PCXHEADER hdr;
    picfile=fopen(filename,"rb");
    if (picfile==NULL) return NULL;
    fread(&hdr,sizeof(PCXHEADER),1,picfile);
    fseek(picfile,-769,SEEK_END);
    if((hdr.version>4)&&(hdr.encoding==1)&&(hdr.bits_per_pixel==8)&&
       (hdr.colour_planes==1)&&(fgetc(picfile)==12)) {

/* We can only handle v5+, PCX, 8b, one plane PCXes with 256c palette.
   (for the time being) */

        buf=new char[768];
        fread(buf,768,1,picfile);

    }

    fclose(picfile);
    return(buf);
}
