/* Original code by zoombapup/zen.
 * Reworked by Sol/Trauma, adding FLC support and other functionality.
 * (Also cleaned up, but remember, obfuscation is in the eye of the beholder =))
 *
 *  ** public domain **
 *
 * Version=1.2
 *
 * Revision history
 * 1.2 - Further cleanup, separated textmode stuff to different file.
 * 1.1 - Added FLC support. Released.
 * 1.0 - Cleaned up zoombapup's source, nuking lots of irrelevant stuff.
 *     - Added FLIDATA structure to gain re-entrancy.
 */
#pragma pack(1);
typedef struct { /* FLI player interface structure */
    char * framebuffer; /* Picture buffer. */
    char * flicdata;    /* Pointer to the (raw) fli data. */
    char * palette;     /* Pointer to 768 byte palette buffer. */
    int    palette_change; /* changes to 1 if palette changes */
    int    x_size;      /* x-size of framebuffer */
    int    y_size;      /* y-size of framebuffer */
    int    curframe;    /* Current frame */
    int    maxframe;    /* max. frame */
    int    looped;      /* changes to 1 if we're looped. */
    char * nextframe;   /* Pointer to next frame in flicdata */
    char * loopframe;   /* Pointer to loop frame in flicdata */
} FLIDATA;
#pragma pack();

FLIDATA * fli_open(char * filename,int offset);
  /* Opens a FLI or FLC file, and loads it to memory. */

void fli_zap(FLIDATA * flidata);
  /* Deallocates all data behind FLIDATA* */

void fli_renderframe(FLIDATA * flidata);
  /* Renders one frame. */
