void InitStageSprite(unsigned char b)
{
	const unsigned char *pointer;
	int base;
	char bank;
	
	pointer=imagepointers[b];
	base=imagebases[b];
	bank=imagebanks[b];
	LoadSprite((unsigned char *)pointer,base,bank);
}

void InitStageSprites(const unsigned char *spl,unsigned char num)
{
	for(unsigned char a=0;a<num;a++)
	{
		changeBank(FIXEDBANKSLOT);
		InitStageSprite(spl[a]);
	}
}

void InitAfterBossStage()
{
	// Destroy all enemies
	KillEnemyshoots();
	KillEnemies(1);

	// Music
	PSGStop();
	
	// Exit
	playertype=4;
	playercounter=0;
}
	
void InitCustomStageData()
{
	// Metemos aquí la velocidad de los disparos, ya que en alguna fase la retocamos
	playstageshootspeed=DEFAULTENEMYSHOOTSPEED+gamelevel;

	// Updates of stage
	switch(playstage)
	{
		case 1:InitStage7();break;
		case 2:InitStage5();break;
		case 3:InitStage4();break;
		case 4:InitStage2();break;
		case 5:InitStage3();break;
		case 6:InitStage1();break;
		case 7:InitStage6();break;
	}
}

void UpdatePlayStage()
{
	// Change bank
	//changeBank(playstagebank);

	// Updates of stage
	switch(playstage)
	{
		case 1:UpdateStage7();break;
		case 2:UpdateStage5();break;
		case 3:UpdateStage4();break;
		case 4:UpdateStage2();break;
		case 5:UpdateStage3();break;
		case 6:UpdateStage1();break;
		case 7:UpdateStage6();break;
	}
}

void InitStageData(unsigned int i)
{
	unsigned char *palette_bin;
	unsigned int palette_bin_bank;
	unsigned char *tilemap_l;
	unsigned int tilemap_l_size;
	unsigned char *tilemap_m;
	unsigned char *psg;
	unsigned int psg_bank;
	unsigned char loop_psg;
	
	// Prevent errors
	changeBank(FIXEDBANKSLOT);
	
	// Update where we stay
	i<<=3;

	// Get all data
	palette_bin=(unsigned char *)stageinitdata[i];i++;
	palette_bin_bank=(unsigned int)(stageinitdata[i]);i++;
	tilemap_l=(unsigned char *)stageinitdata[i];i++;
	tilemap_l_size=(unsigned int)(stageinitdata[i]);i++;
	tilemap_m=(unsigned char *)stageinitdata[i];i++;
	psg=(unsigned char *)stageinitdata[i];i++;
	psg_bank=(unsigned int)(stageinitdata[i++]);
	loop_psg=(unsigned int)(stageinitdata[i]);

	// The bank
	playstagebank=palette_bin_bank;
	
	// Load palette
	LoadBGPalette(palette_bin,palette_bin_bank);

	// The tilemap
	SetMapLines(tilemap_l,tilemap_l_size,tilemap_m);

	// Init map
	InitMap(palette_bin_bank);

	// Rom bank
	if(psg!=0)
		PlayMusic(psg,psg_bank,loop_psg);
}

// Pass A
void UpdateStagePassA()
{
	// Player indicators
	UpdatePlayerIndicators();

	// Update player
	UpdatePlayer();

	// Update player shoots
	UpdatePlayershoots();	

	// Enemy shoots
	UpdateEnemyshoots();

	// Update explosions
	UpdateExplosions();
}

		
void UpdateStagePassB()		
{
	// Enemies!!!
	UpdateEnemies();
}
		
// Pantalla de juego
void InitPlayStage()
{
	// Save continue stage, for continue :)
	laststagenum=stagenum;
	
	// Init stage
	InitStage();

	// Init script
	InitScripts();
	
	// Enemies set to 0
	InitEnemies();
	
	// And enemy shoots
	InitEnemyshoots();
	
	// Lo volvemos a apagar
	SMS_displayOff();

	// Scroller
	InitScroller();

	// Barrom
	InitBarrom();
	
	// Let's fill playstage
	if(stagenum<5)
		playstage=1+((basestage+stagenum)%4);
	else
		playstage=stagenum;

	// Last but not least, switch to stage (becase these are in other bank)...
	InitStageData(stagedatamarks[playstage-1]);

	// For the stage custom
	InitCustomStageData();
	
	// Init player
	InitPlayerSprite();

	// Init player shoots
	InitPlayershoots();

	// Init explosion sprite
	InitExplosions();
	
	// Do what we have to do
	InitPlayer();

	// Lo volvemos a encender
	SMS_displayOn();

	// Exit stage flag
	exitplaystage=0;
	
	// To make update at init
	updateplaystage=1;
	
	// Bucle
	while(1)
	{
		//WriteNumber(stageframe,4,0,0);
		/*
		WriteNumber(numscripts,2,0,0);
		WriteNumber(numenemies,2,0,1);
		WriteNumber(numenemyshoots,2,0,2);
		WriteNumber(numplayershoots,2,0,3);
		WriteNumber(numexplosions,2,0,4);
		*/

		// Update stage
		UpdateStage();

		// Scroller... note tha this is processed ***ALWAYS*** to do a sweet effect
		UpdateScroller();

		// Barrom
		UpdateBarrom();

		// Alternamos
		if(stageframe2mod==0)
			UpdateStagePassA();
		else
			UpdateStagePassB();

		// Scripter
		if((stageframe%16)==0)
			UpdateScripts();
		
		// Hay que salirse?
		if(exitplaystage==1)return;

		// Update psg
		UpdatePSG();
	}
}
