#include "defines.h"

// Final stage effects
const unsigned char stage6_fade_pink[]={0x22,0x12,0x11,0x01,0x00,0x01,0x11,0x12};
const unsigned char stage6_fade_blue[]={0x20,0x10,0x00,0x00,0x00,0x00,0x10,0x20};

// Skull shooting patterns
const signed char skullshootvelx[]={-3,-2,-1,0,1,2,3};
const signed char skullshootvely[]={1,2,3,4,3,2,1};
const signed char skullbshootvelx[]={4,3,2,1,0,-1,-2,-3,-4,-3,-2,-1,0,1,2,3};
const signed char skullbshootvely[]={0,1,2,3,4,3,2,1,0,-1,-2,-3,-4,-3,-2,-1};

// Paleta por defecto
const unsigned char palette_bin[]={0x00,0x3F,0x00,0x10,0x3A,0x38,0x3E,0x0C,0x08,0x04,0x1F,0x2F,0x1B,0x07,0x02,0x16};

// Stage 4
const unsigned char stage4_stormpalette[]={0x02,0x02,0x02,0x02,0x3f,0x28,0x14,0x02,0x02,0x02,0x02,0x02,0x3f,0x28,0x14,0x02};
const unsigned char stage4_seapalette[]={0x38,0x28,0x20,0x28};

// Stage 1
const unsigned char stage1_flashpalette[]={0x21,0x20,0x10,0x00,0x00,0x10,0x20,0x21};

// Arac moving
const unsigned char aracmovingx[]={2,6,7,3,2,6,1,5};
const unsigned char aracmovingy[]={5,5,2,6,3,5,2,4};
const unsigned int aracmovingt[]={45,20,40,30,45,60,30,20};

// Cross A moving
const unsigned char crossamovingx[]={4,6,2,5,6,4,2,3};
const unsigned char crossamovingy[]={6,3,4,6,4,1,3,4};
const unsigned int crossamovingt[]={60,80,70,30,50,20,40,70};

// Cross B moving
const unsigned char crossbmovingx[]={4,2,4,6,3,6,5,5};
const unsigned char crossbmovingy[]={6,4,3,2,6,5,3,3};
const unsigned int crossbmovingt[]={60,80,70,30,50,20,40,70};

// Fire end boss pattern
const signed char stage2endbossshootpatternx[]={-5,-3,-1,1,3,5};
const signed char stage2endbossshootpatterny[]={1,3,5,5,3,1};

// Lasers for enemy of stage 3
const unsigned char stage3enemylaserposx[]={20,40,40,40,20,0,0,0};
const unsigned char stage3enemylaserposy[]={0,0,20,40,40,40,20,0};
const unsigned char stage3laservelx[]={8,12,14,12,8,4,2,4};
const unsigned char stage3laservely[]={2,4,8,12,14,12,8,4};

// Balls
const unsigned char Stage1MiddleBossBPatternX[]={1,3,5,7,9,11,13,15};
const unsigned char Stage1MiddleBossBPatternY[]={2,3,4,5,5,4,3,2};

// 0 to 32, 32 amplitude
const unsigned char sinustable[]=
{128,131,134,137,141,144,147,150,
153,156,159,162,165,168,171,174,
177,180,183,186,188,191,194,196,
199,202,204,207,209,212,214,216,
219,221,223,225,227,229,231,233,
234,236,238,239,241,242,244,245,
246,247,249,250,250,251,252,253,
254,254,255,255,255,255,255,255,
255,255,255,255,255,255,255,254,
254,253,252,251,250,250,249,247,
246,245,244,242,241,239,238,236,
234,233,231,229,227,225,223,221,
219,216,214,212,209,207,204,202,
199,196,194,191,188,186,183,180,
177,174,171,168,165,162,159,156,
153,150,147,144,141,137,134,131,
128,125,122,119,115,112,109,106,
103,100,97,94,91,88,85,82,
79,76,73,70,68,65,62,60,
57,54,52,49,47,44,42,40,
37,35,33,31,29,27,25,23,
22,20,18,17,15,14,12,11,
10,9,7,6,6,5,4,3,
2,2,1,1,1,1,1,1,
1,1,1,1,1,1,1,2,
2,3,4,5,6,6,7,9,
10,11,12,14,15,17,18,20,
22,23,25,27,29,31,33,35,
37,40,42,44,47,49,52,54,
57,60,62,65,68,70,73,76,
79,82,85,88,91,94,97,100,
103,106,109,112,115,119,122,125};	

//////////////////////////////////////////////////
// JUKEBOX

const char *jukebox_songs[]=
{
	logo_psg,
	intro1_psg,
	intro3_psg,
	intro2_psg,
	select_psg,
	stage1_psg,
	stage2_psg,
	stage3_psg,
	stage4_psg,
	stage5_psg,
	flight_psg,
	stage7a_psg,
	stage7_psg,
	stage6_psg,
	escape_psg,
	norefuge_psg,
	boss_psg,
	ending_psg,
	gameover_psg
};

const unsigned char jukebox_repeat[]={0,1,0,0,1,1,1,1,1,1,1,0,1,1,1,0,1,0,0};

const char jukebox_banks[]=
{
	logo_psg_bank,
	intro1_psg_bank,
	intro3_psg_bank,
	intro2_psg_bank,
	select_psg_bank,
	stage1_psg_bank,
	stage2_psg_bank,
	stage3_psg_bank,
	stage4_psg_bank,
	stage5_psg_bank,
	flight_psg_bank,
	stage7a_psg_bank,
	stage7_psg_bank,
	stage6_psg_bank,
	escape_psg_bank,
	norefuge_psg_bank,
	boss_psg_bank,
	ending_psg_bank,
	gameover_psg_bank
};

const unsigned char *jukebox_names[]=
{
	"TITLE SCREEN ",
	"INTRO PART 1 ",
	"INTRO PART 2 ",
	"INTRO PART 3 ",
	"SELECT STAGE ",
	"SWEET FIELDS ",
	"VOLCANO FURY ",
	"JUNGLE WAVES ",
	"CLOUDY CITY  ",
	"TOKAI FOREVER",
	"SPACE STATION",
	"INTO FORTRESS",
	"REAL DEAL    ",
	"ALIEN TRAP   ",
	"ESCAPE       ",
	"NO REFUGE    ",
	"BOSS BATTLE  ",
	"GOOD ENDING  ",
	"BAD ENDING   "
};

const unsigned char selectorstatebasetiles[]={1,5,37,41};
const unsigned char *selectornamestage[]={" JUNGLE ","  CITY  "," VULCAN ","  CAVE  "};
const unsigned char selectormarkx[]={0,5,0,5};
const unsigned char selectormarky[]={14,14,9,9};
const unsigned char selectormarkt[]={27,36,18,9};

//////////////////////////////////////////////////
// INTRO 4 SCRIPT

const unsigned char intro4script[]=
{
	10,SCRIPT_SETEXPLOSION,100,45,1,	
	11,SCRIPT_SETEXPLOSION,100,85,1,
	12,SCRIPT_SETEXPLOSION,120,65,1,
	13,SCRIPT_SETEXPLOSION,140,45,1,
	14,SCRIPT_SETEXPLOSION,100,45,1,
	15,SCRIPT_SETEXPLOSION,120,85,1,
	16,SCRIPT_SETEXPLOSION,140,65,1,
	17,SCRIPT_SETEXPLOSION,100,85,1,
	18,SCRIPT_SETEXPLOSION,120,65,1,
	19,SCRIPT_SETEXPLOSION,140,45,1,
	20,SCRIPT_SETEXPLOSION,100,45,1,
	21,SCRIPT_SETEXPLOSION,120,85,1,
	22,SCRIPT_SETEXPLOSION,140,65,1,
	23,SCRIPT_SETEXPLOSION,100,85,1,
	24,SCRIPT_SETEXPLOSION,120,65,1,
	25,SCRIPT_SETEXPLOSION,140,45,1,
	26,SCRIPT_SETEXPLOSION,100,45,1,
	27,SCRIPT_SETEXPLOSION,120,85,1,
	28,SCRIPT_SETEXPLOSION,140,65,1,
	29,SCRIPT_SETEXPLOSION,100,85,1,
	30,SCRIPT_SETEXPLOSION,120,65,1,
	31,SCRIPT_SETEXPLOSION,140,45,1,
	32,SCRIPT_SETEXPLOSION,100,45,1,
	33,SCRIPT_SETEXPLOSION,120,85,1,
	34,SCRIPT_SETEXPLOSION,140,65,1,
	35,SCRIPT_SETEXPLOSION,100,85,1,
	36,SCRIPT_SETEXPLOSION,120,65,1,
	37,SCRIPT_SETEXPLOSION,140,45,1,
	38,SCRIPT_SETEXPLOSION,100,45,1,
	39,SCRIPT_SETEXPLOSION,120,85,1,
	40,SCRIPT_SETEXPLOSION,140,65,1,
	41,SCRIPT_SETPALETTE,3,0x34,0,
	41,SCRIPT_SETPALETTE,9,0x3e,0,
	41,SCRIPT_SETPALETTE,2,0x39,0,
	41,SCRIPT_SETPALETTE,7,0x15,0,
	41,SCRIPT_SETPALETTE,8,0x15,0,
	41,SCRIPT_SETPALETTE,12,0x15,0,
	41,SCRIPT_SETPALETTE,15,0x15,0,
	41,SCRIPT_SETPALETTE,0,0x15,0,
	42,SCRIPT_SETPALETTE,3,0x39,0,
	42,SCRIPT_SETPALETTE,9,0x3f,0,
	42,SCRIPT_SETPALETTE,2,0x3e,0,
	42,SCRIPT_SETPALETTE,7,0x3e,0,
	42,SCRIPT_SETPALETTE,8,0x3e,0,
	42,SCRIPT_SETPALETTE,12,0x3e,0,
	42,SCRIPT_SETPALETTE,15,0x3e,0,
	42,SCRIPT_SETPALETTE,0,0x3e,0,
	43,SCRIPT_SETPALETTE,3,0x3f,0,
	43,SCRIPT_SETPALETTE,9,0x3f,0,
	43,SCRIPT_SETPALETTE,2,0x3f,0,
	43,SCRIPT_SETPALETTE,7,0x3f,0,
	43,SCRIPT_SETPALETTE,8,0x3f,0,
	43,SCRIPT_SETPALETTE,12,0x3f,0,
	43,SCRIPT_SETPALETTE,15,0x3f,0,
	43,SCRIPT_SETPALETTE,0,0x3f,0,
	44,SCRIPT_FILLBACKGROUND,0,0,0,
	45,SCRIPT_SETPALETTE,0,0x39,0,
	45,SCRIPT_SETPALETTE,0,0x15,0,
	45,SCRIPT_SETPALETTE,0,0x00,0,
	46,SCRIPT_END,0,0,0};

	
//////////////////////////////////////////////////
// INTRO 1 SCRIPT

const unsigned char intro1script[]=
{
	12,SCRIPT_SETLABEL,0,14,250,
	12,SCRIPT_SETLABEL,1,16,250,
	50,SCRIPT_SETLABEL,2,14,250,
	50,SCRIPT_SETLABEL,3,16,250,
	62,SCRIPT_INITENEMY,INTROOVNILEFT,0,40,
	65,SCRIPT_INITENEMY,INTROOVNIRIGHT,240,40,
	68,SCRIPT_INITENEMY,INTROOVNILEFT,0,80,
	71,SCRIPT_INITENEMY,INTROOVNIRIGHT,240,80,
	87,SCRIPT_SETLABEL,4,14,250,
	87,SCRIPT_SETLABEL,5,16,250,
	88,SCRIPT_SETEXPLOSION,100,45,1,
	89,SCRIPT_SETEXPLOSION,120,85,1,
	90,SCRIPT_SETEXPLOSION,140,65,1,
	91,SCRIPT_SETEXPLOSION,100,85,1,
	92,SCRIPT_SETEXPLOSION,120,65,1,
	93,SCRIPT_SETEXPLOSION,140,45,1,
	94,SCRIPT_SETEXPLOSION,100,45,1,
	95,SCRIPT_SETEXPLOSION,120,85,1,
	96,SCRIPT_SETEXPLOSION,140,65,1,
	97,SCRIPT_SETEXPLOSION,100,85,1,
	98,SCRIPT_SETEXPLOSION,120,65,1,
	99,SCRIPT_SETEXPLOSION,140,45,1,
	100,SCRIPT_SETPALETTE,6,0X25,0,
	100,SCRIPT_SETEXPLOSION,100,45,1,
	101,SCRIPT_SETEXPLOSION,120,85,1,
	102,SCRIPT_SETEXPLOSION,140,65,1,
	103,SCRIPT_SETEXPLOSION,100,85,1,
	104,SCRIPT_SETEXPLOSION,120,65,1,
	105,SCRIPT_SETEXPLOSION,140,45,1,
	106,SCRIPT_SETEXPLOSION,100,45,1,
	107,SCRIPT_SETEXPLOSION,120,85,1,
	108,SCRIPT_SETEXPLOSION,140,65,1,
	109,SCRIPT_SETEXPLOSION,100,85,1,
	110,SCRIPT_SETEXPLOSION,120,65,1,
	111,SCRIPT_SETEXPLOSION,140,45,1,
	112,SCRIPT_SETPALETTE,6,0X11,0,
	112,SCRIPT_SETEXPLOSION,100,45,1,
	113,SCRIPT_SETEXPLOSION,120,85,1,
	114,SCRIPT_SETEXPLOSION,140,65,1,
	115,SCRIPT_SETEXPLOSION,100,85,1,
	116,SCRIPT_SETEXPLOSION,120,65,1,
	117,SCRIPT_SETEXPLOSION,140,45,1,
	118,SCRIPT_SETEXPLOSION,100,45,1,
	119,SCRIPT_SETEXPLOSION,120,85,1,
	120,SCRIPT_SETEXPLOSION,140,65,1,
	121,SCRIPT_SETEXPLOSION,100,85,1,
	122,SCRIPT_SETEXPLOSION,120,65,1,
	123,SCRIPT_SETEXPLOSION,140,45,1,
	124,SCRIPT_SETPALETTE,6,0X37,0,
	125,SCRIPT_END,0,0,0};

//////////////////////////////////////////////////
// INTRO 1 LABELS

const unsigned char *intro1labels[]=
{
	"PLANET EARTH",
	"THE YEAR IS 2084 AC",
	"UNKNOWN SHIPS APPEARED",
	"FROM OUTER SPACE",
	"BEGAN TO BOMBARD THE",
	"ENTIRE PLANET SURFACE"
};

//////////////////////////////////////////////////
// INTRO 2 SCRIPT

const unsigned char intro2script[]=
{
	1,SCRIPT_INITENEMY,INTROSIDEPLAYER,0,0,
	78+16,SCRIPT_SETPALETTE,3,0x34,0,
	78+16,SCRIPT_SETPALETTE,9,0x3e,0,
	78+16,SCRIPT_SETPALETTE,2,0x39,0,
	78+16,SCRIPT_SETPALETTE,7,0x15,0,
	78+16,SCRIPT_SETPALETTE,8,0x15,0,
	78+16,SCRIPT_SETPALETTE,12,0x15,0,
	78+16,SCRIPT_SETPALETTE,15,0x15,0,
	78+16,SCRIPT_SETPALETTE,0,0x15,0,
	79+16,SCRIPT_SETPALETTE,3,0x39,0,
	79+16,SCRIPT_SETPALETTE,9,0x3f,0,
	79+16,SCRIPT_SETPALETTE,2,0x3e,0,
	79+16,SCRIPT_SETPALETTE,7,0x3e,0,
	79+16,SCRIPT_SETPALETTE,8,0x3e,0,
	79+16,SCRIPT_SETPALETTE,12,0x3e,0,
	79+16,SCRIPT_SETPALETTE,15,0x3e,0,
	79+16,SCRIPT_SETPALETTE,0,0x3e,0,
	80+16,SCRIPT_SETPALETTE,3,0x3f,0,
	80+16,SCRIPT_SETPALETTE,9,0x3f,0,
	80+16,SCRIPT_SETPALETTE,2,0x3f,0,
	80+16,SCRIPT_SETPALETTE,7,0x3f,0,
	80+16,SCRIPT_SETPALETTE,8,0x3f,0,
	80+16,SCRIPT_SETPALETTE,12,0x3f,0,
	80+16,SCRIPT_SETPALETTE,15,0x3f,0,
	80+16,SCRIPT_SETPALETTE,0,0x3f,0,
	81+16,SCRIPT_FILLBACKGROUND,0,0,0,
	82+16,SCRIPT_KILLENEMIES,0,0,0,
	83+16,SCRIPT_SETPALETTE,0,0x39,0,
	84+16,SCRIPT_SETPALETTE,0,0x15,0,
	85+16,SCRIPT_SETPALETTE,0,0x00,0,
	86+16,SCRIPT_END,0,0,0};

////////////////////////////////////////////////////
// Intro 3 labels

const unsigned char *intro3labels[]=
{
	"ENEMIES ARE INVADING",
	"AND DESTROYING OUR PLANET",
	"WE HAVE TO DEFEND NOW",
	"AT YOUR ORDERS SIR",
	"LETS DEPLOY OUR",
	"BEST SECRET WEAPON",
	"SPACESHIP TX-1889-W",
	"ADVANCED TACTICAL FIGHTER",
	"LAST HOPE OF HUMANITY",
	"LEFT NOW AND DESTROY THEM ALL",
	"GOOD LUCK",
};

////////////////////////////////////////////////////
// Intro 3 script

const unsigned char intro3script[]=
{
	1,SCRIPT_INITENEMY,WARNING,1,0,
	27,SCRIPT_INITENEMY,INTRO3OBJECT,0,0,
	35,SCRIPT_SETLABEL,0,13,250,
	35,SCRIPT_SETLABEL,1,15,250,
	35,SCRIPT_SETLABEL,2,17,250,
	35+38,SCRIPT_SETLABEL,3,13,250,
	35+38,SCRIPT_SETLABEL,4,15,250,
	35+38,SCRIPT_SETLABEL,5,17,250,
	35+38+38,SCRIPT_SETLABEL,6,13,250,
	35+38+38,SCRIPT_SETLABEL,7,15,250,
	35+38+38,SCRIPT_SETLABEL,8,17,250,
	35+38+38+38,SCRIPT_SETLABEL,9,14,250,
	35+38+38+38,SCRIPT_SETLABEL,10,16,250,
	35+38+38+38+1,SCRIPT_END,0,0,0
};
	
//////////////////////////////////////////////////
// ENDING LABELS

// Finish stage
const unsigned char *finishlabels[]=
{
	"WELL DONE",
	"FINALLY THE ENEMY",
	"WAS DEFEATED",
	"NOW THE EARTH IS SAFE",
	"RETURN TO YOUR HOME",
	"AND ENTER IN HALL OF FAME",
	"MAYBE IN A NEAR FUTURE",
	"ALIENS WILL RETURN TO REVENGE",
	"BUT THIS IS OTHER STORY",
	"GAME DEVELOPMENT, GRAPHICS",
	"SOUND, MUSIC, DESIGN",
	"BY MIKE",
	"THANKS GUYS AT SMSPOWER",
	"FOUND A NICE SITE TO STAY",
	"AND MY WIFE AND HER PATIENCE",
	"FUN HARD WORK FOR THE",
	"SMSPOWER 2017 COMPO",
	"HOPE YOU ENJOYED IT AS I DID",
	"MARCH 2017, MIKGAMES",
	"THANKS FOR PLAYING"
};

//////////////////////////////////////////////////
// ENDING SCRIPT

const unsigned char finishscript[]=
{
	1,SCRIPT_INITENEMY,INTROSIDEPLAYER,1,32,
	1,SCRIPT_INITENEMY,INTROSTAR,100,40,
	1,SCRIPT_INITENEMY,INTROSTAR,200,48,
	1,SCRIPT_INITENEMY,INTROSTAR,40,56,
	1,SCRIPT_INITENEMY,INTROSTAR,160,64,
	1,SCRIPT_INITENEMY,INTROSTAR,120,72,
	1,SCRIPT_INITENEMY,INTROSTAR,240,80,
	1,SCRIPT_INITENEMY,INTROSTAR,60,88,
	1,SCRIPT_INITENEMY,INTROSTAR,180,96,
	1,SCRIPT_INITENEMY,INTROSTAR,120,104,
	6,SCRIPT_SETLABEL,0,13,250,
	6,SCRIPT_SETLABEL,1,15,250,
	6,SCRIPT_SETLABEL,2,17,250,
	43,SCRIPT_SETLABEL,3,13,250,
	43,SCRIPT_SETLABEL,4,15,250,
	43,SCRIPT_SETLABEL,5,17,250,
	81,SCRIPT_SETLABEL,6,13,250,
	81,SCRIPT_SETLABEL,7,15,250,
	81,SCRIPT_SETLABEL,8,17,250,
	118,SCRIPT_SETPALETTE,3,0x34,0,
	118,SCRIPT_SETPALETTE,9,0x3e,0,
	118,SCRIPT_SETPALETTE,2,0x39,0,
	118,SCRIPT_SETPALETTE,7,0x15,0,
	118,SCRIPT_SETPALETTE,8,0x15,0,
	118,SCRIPT_SETPALETTE,12,0x15,0,
	118,SCRIPT_SETPALETTE,15,0x15,0,
	118,SCRIPT_SETPALETTE,0,0x15,0,
	120,SCRIPT_SETPALETTE,3,0x3f,0,
	120,SCRIPT_SETPALETTE,9,0x3f,0,
	120,SCRIPT_SETPALETTE,2,0x3f,0,
	120,SCRIPT_SETPALETTE,7,0x3f,0,
	120,SCRIPT_SETPALETTE,8,0x3f,0,
	120,SCRIPT_SETPALETTE,12,0x3f,0,
	120,SCRIPT_SETPALETTE,15,0x3f,0,
	120,SCRIPT_SETPALETTE,0,0x3f,0,
	121,SCRIPT_FILLBACKGROUND,0,0,0,
	121,SCRIPT_KILLENEMIES,0,0,0,
	122,SCRIPT_SETPALETTE,0,0x39,0,
	124,SCRIPT_SETPALETTE,0,0x15,0,
	126,SCRIPT_SETPALETTE,0,0x00,0,
	137,SCRIPT_SETLABEL,9,6,250,
	137,SCRIPT_SETLABEL,10,8,250,
	137,SCRIPT_SETLABEL,11,10,250,
	175,SCRIPT_SETLABEL,12,6,250,
	175,SCRIPT_SETLABEL,13,8,250,
	175,SCRIPT_SETLABEL,14,10,250,
	212,SCRIPT_SETLABEL,15,6,250,
	212,SCRIPT_SETLABEL,16,8,250,
	212,SCRIPT_SETLABEL,17,10,250,
	250,SCRIPT_SETLABEL,18,7,250,
	250,SCRIPT_SETLABEL,19,9,250,
	251,SCRIPT_END,0,0,0
};

//////////////////////////////////////////////////
// STAGES INIT INFO

unsigned char stagedatamarks[]={6,4,3,1,2,0,5};

unsigned char *stageinitdata[]=
{
	stage1palette_bin,stage1palette_bin_bank,
	stage1tilemap_l,stage1tilemap_l_size,stage1tilemap_m,
	stage7a_psg,stage7a_psg_bank,0,

	stage2palette_bin,stage2palette_bin_bank,
	stage2tilemap_l,stage2tilemap_l_size,stage2tilemap_m,
	stage2_psg,stage2_psg_bank,1,
	
	stage3palette_bin,stage3palette_bin_bank,
	stage3tilemap_l,stage3tilemap_l_size,stage3tilemap_m,
	stage5_psg,stage5_psg_bank,1,

	stage4palette_bin,stage4palette_bin_bank,
	stage4tilemap_l,stage4tilemap_l_size,stage4tilemap_m,
	stage4_psg,stage4_psg_bank,1,
	
	stage5palette_bin,stage5palette_bin_bank,
	stage5tilemap_l,stage5tilemap_l_size,stage5tilemap_m,
	stage3_psg,stage3_psg_bank,1,

	stage6palette_bin,stage6palette_bin_bank,
	stage6tilemap_l,stage6tilemap_l_size,stage6tilemap_m,
	stage6_psg,stage6_psg_bank,1,
	
	stage7palette_bin,stage7palette_bin_bank,
	stage7tilemap_l,stage7tilemap_l_size,stage7tilemap_m,
	stage1_psg,stage1_psg_bank,1
};

////////////////////////////////////////////////////
// WW2PLANES MOVEMENT

const signed char ww2planemovementy[]=
{
	-WW2PLANE_SPEED,
	0,
	0,
	WW2PLANE_SPEED,
	WW2PLANE_SPEED_HALF,
	WW2PLANE_SPEED_HALF,
	-WW2PLANE_SPEED_HALF,
	-WW2PLANE_SPEED_HALF
};

const signed char ww2planemovementx[]=
{
	0,
	-WW2PLANE_SPEED,
	WW2PLANE_SPEED,
	0,
	WW2PLANE_SPEED_HALF,
	-WW2PLANE_SPEED_HALF,
	-WW2PLANE_SPEED_HALF,
	WW2PLANE_SPEED_HALF
};

const unsigned char ww2plane_pattern_a[]=
{
	240,20,
	45,WW2PLANE_DIR_LEFT,
	55,WW2PLANE_DIR_DOWNLEFT,
	60,WW2PLANE_DIR_DOWN,
	65,WW2PLANE_DIR_DOWNRIGHT,
	115,WW2PLANE_DIR_RIGHT,
	116,WW2PLANE_END
};

const unsigned char ww2plane_pattern_b[]=
{
	0,40,
	45,WW2PLANE_DIR_RIGHT,
	55,WW2PLANE_DIR_DOWNRIGHT,
	60,WW2PLANE_DIR_DOWN,
	65,WW2PLANE_DIR_DOWNLEFT,
	115,WW2PLANE_DIR_LEFT,
	116,WW2PLANE_END
};

const unsigned char ww2plane_pattern_c[]=
{
	200,192,
	40,WW2PLANE_DIR_UP,
	45,WW2PLANE_DIR_UPLEFT,
	50,WW2PLANE_DIR_LEFT,
	75,WW2PLANE_DIR_DOWNLEFT,
	80,WW2PLANE_DIR_LEFT,
	85,WW2PLANE_DIR_UPLEFT,
	120,WW2PLANE_DIR_UP,
	121,WW2PLANE_END
};

const unsigned char ww2plane_pattern_d[]=
{
	40,192,
	40,WW2PLANE_DIR_UP,
	45,WW2PLANE_DIR_UPRIGHT,
	50,WW2PLANE_DIR_RIGHT,
	75,WW2PLANE_DIR_DOWNRIGHT,
	80,WW2PLANE_DIR_RIGHT,
	85,WW2PLANE_DIR_UPRIGHT,
	120,WW2PLANE_DIR_UP,
	121,WW2PLANE_END
};

const unsigned char ww2plane_pattern_e[]=
{
	96,0,
	25,WW2PLANE_DIR_DOWN,
	30,WW2PLANE_DIR_DOWNLEFT,
	35,WW2PLANE_DIR_LEFT,
	40,WW2PLANE_DIR_UPLEFT,
	55,WW2PLANE_DIR_UP,
	60,WW2PLANE_DIR_UPRIGHT,
	95,WW2PLANE_DIR_RIGHT,
	100,WW2PLANE_DIR_DOWNRIGHT,
	105,WW2PLANE_DIR_DOWN,
	110,WW2PLANE_DIR_DOWNLEFT,
	115,WW2PLANE_DIR_LEFT,
	120,WW2PLANE_DIR_UPLEFT,
	135,WW2PLANE_DIR_UP,
	136,WW2PLANE_END
};

const unsigned char ww2plane_pattern_f[]=
{
	144,0,
	25,WW2PLANE_DIR_DOWN,
	30,WW2PLANE_DIR_DOWNRIGHT,
	35,WW2PLANE_DIR_RIGHT,
	40,WW2PLANE_DIR_UPRIGHT,
	55,WW2PLANE_DIR_UP,
	60,WW2PLANE_DIR_UPLEFT,
	95,WW2PLANE_DIR_LEFT,
	100,WW2PLANE_DIR_DOWNLEFT,
	105,WW2PLANE_DIR_DOWN,
	110,WW2PLANE_DIR_DOWNRIGHT,
	115,WW2PLANE_DIR_RIGHT,
	120,WW2PLANE_DIR_UPRIGHT,
	135,WW2PLANE_DIR_UP,
	136,WW2PLANE_END
};

const unsigned char *ww2plane_patterns[]=
{
	ww2plane_pattern_a,
	ww2plane_pattern_b,
	ww2plane_pattern_c,
	ww2plane_pattern_d,
	ww2plane_pattern_e,
	ww2plane_pattern_f,
};

////////////////////////////////////////////////////////////////////////////
// STAGE 4 ENEMIES AND SPAWNERS

#define SPAN_WAVESHIP80_SCRIPT 0
const unsigned char span_waveship80_script[]=
{
	1,SCRIPT_INITENEMY,WAVESHIP,80,0,
	1,SCRIPT_LOOP,1,1,4,
	2,SCRIPT_END,0,0,0
};

#define SPAN_WAVESHIP160_SCRIPT 1
const unsigned char span_waveship160_script[]=
{
	1,SCRIPT_INITENEMY,WAVESHIP,220,0,
	1,SCRIPT_LOOP,1,1,4,
	2,SCRIPT_END,0,0,0
};

#define SPAN_RANDOMRECTSHIP_SCRIPT 2
const unsigned char span_randomrectship_script[]=
{
	1,SCRIPT_INITENEMY,RECTSHIP,160,0,
	2,SCRIPT_INITENEMY,RECTSHIP,80,0,
	3,SCRIPT_INITENEMY,RECTSHIP,120,0,
	4,SCRIPT_INITENEMY,RECTSHIP,40,0,
	5,SCRIPT_INITENEMY,RECTSHIP,200,0,
	5,SCRIPT_LOOP,1,5,8,
	6,SCRIPT_END,0,0
};

#define SPAN_RECTSHIPLATERAL_SCRIPT 3
const unsigned char span_rectshiplateral_script[]=
{
	1,SCRIPT_INITENEMY,RECTSHIP,180,0,
	5,SCRIPT_INITENEMY,RECTSHIP,80,0,
	9,SCRIPT_INITENEMY,RECTSHIP,220,0,
	12,SCRIPT_INITENEMY,RECTSHIP,140,0,
	16,SCRIPT_INITENEMY,RECTSHIP,20,0,
	20,SCRIPT_LOOP,1,5,1,
	21,SCRIPT_END,0,0
};

#define SPAN_BOMBSHIPS_SCRIPT 4
const unsigned char span_bombships_script[]=
{
	1,SCRIPT_INITENEMY,BOMBSHIPRIGHT,0,0,
	3,SCRIPT_INITENEMY,BOMBSHIPLEFT,0,0,
	5,SCRIPT_LOOP,1,2,4,
	6,SCRIPT_END,0,0
};

#define SPAN_RANDOMWAVESHIP_SCRIPT 5
const unsigned char span_randomwaveship_script[]=
{
	2,SCRIPT_INITENEMY,WAVESHIP,100,0,
	5,SCRIPT_INITENEMY,WAVESHIP,200,0,
	8,SCRIPT_INITENEMY,WAVESHIP,150,0,
	11,SCRIPT_LOOP,2,3,2,
	12,SCRIPT_END,0,0
};

#define SPAN_TURNSHIPS_SCRIPT 6
const unsigned char span_turnships_script[]=
{
	1,SCRIPT_INITENEMY,TURNSHIP,180,0,
	2,SCRIPT_INITENEMY,TURNSHIP,180,0,
	3,SCRIPT_INITENEMY,TURNSHIP,180,0,
	4,SCRIPT_INITENEMY,TURNSHIP,180,0,

	6,SCRIPT_INITENEMY,TURNSHIP,60,0,
	7,SCRIPT_INITENEMY,TURNSHIP,60,0,
	8,SCRIPT_INITENEMY,TURNSHIP,60,0,
	9,SCRIPT_INITENEMY,TURNSHIP,60,0,

	11,SCRIPT_LOOP,0,8,1,
	12,SCRIPT_END,0,0
};

#define SPAN_SPREADSHIPS_SCRIPT 7
const unsigned char span_spreadships_script[]=
{
	1,SCRIPT_INITENEMY,SPREADSHIP,0,0,
	10,SCRIPT_LOOP,0,1,2,
	11,SCRIPT_END,0,0
};


//////////////////////////////////////////////////
// STAGE 4 SCRIPTS

#define STAGE4SCRIPTC 8
const unsigned char stage4scriptc[]=
{
	1,SCRIPT_INITENEMY,WARNING,0,0,
	16,SCRIPT_INITENEMY,STAGE4ENDBOSS,104,0,
	16,SCRIPT_INITENEMY,STAGE4ENDBOSSC,128,0,
	16,SCRIPT_END,0,0,0
};

#define STAGE4SCRIPTB 9
const unsigned char stage4scriptb[]=
{
	10,SCRIPT_INITSCRIPT,SPAN_TURNSHIPS_SCRIPT,0,0,
	10,SCRIPT_INITSCRIPT,SPAN_SPREADSHIPS_SCRIPT,0,0,

	//50,SCRIPT_INITSCRIPT,SPAN_SPREADSHIPS_SCRIPT,0,0,
	50,SCRIPT_INITSCRIPT,SPAN_WAVESHIP80_SCRIPT,0,0,
	60,SCRIPT_INITSCRIPT,SPAN_BOMBSHIPS_SCRIPT,0,0,
	70,SCRIPT_INITSCRIPT,SPAN_WAVESHIP160_SCRIPT,0,0,
	
	90,SCRIPT_INITSCRIPT,SPAN_RANDOMWAVESHIP_SCRIPT,0,0,
	90,SCRIPT_INITSCRIPT,SPAN_SPREADSHIPS_SCRIPT,0,0,
	90,SCRIPT_INITSCRIPT,SPAN_RECTSHIPLATERAL_SCRIPT,0,0,

	//140,SCRIPT_INITSCRIPT,SPAN_RANDOMWAVESHIP_SCRIPT,0,0,
	140,SCRIPT_INITSCRIPT,SPAN_TURNSHIPS_SCRIPT,0,0,
	140,SCRIPT_INITSCRIPT,SPAN_RECTSHIPLATERAL_SCRIPT,0,0,
	150,SCRIPT_INITSCRIPT,SPAN_SPREADSHIPS_SCRIPT,0,0,
	
	190,SCRIPT_INITSCRIPT,SPAN_RANDOMRECTSHIP_SCRIPT,0,0,
	200,SCRIPT_INITSCRIPT,SPAN_SPREADSHIPS_SCRIPT,0,0,
	//210,SCRIPT_INITSCRIPT,SPAN_SPREADSHIPS_SCRIPT,0,0,

	255,SCRIPT_INITSCRIPT,STAGE4SCRIPTC,0,0,
	255,SCRIPT_END,0,0,0
};

#define STAGE4SCRIPT 10
const unsigned char stage4script[]=
{
	12,SCRIPT_INITSCRIPT,SPAN_WAVESHIP80_SCRIPT,0,0,
	20,SCRIPT_INITSCRIPT,SPAN_WAVESHIP160_SCRIPT,0,0,
	28,SCRIPT_INITSCRIPT,SPAN_WAVESHIP80_SCRIPT,0,0,
	36,SCRIPT_INITSCRIPT,SPAN_WAVESHIP160_SCRIPT,0,0,
	50,SCRIPT_INITSCRIPT,SPAN_RANDOMRECTSHIP_SCRIPT,0,0,
	110,SCRIPT_INITSCRIPT,SPAN_TURNSHIPS_SCRIPT,0,0,
	140,SCRIPT_INITSCRIPT,SPAN_RANDOMWAVESHIP_SCRIPT,0,0,
	150,SCRIPT_INITSCRIPT,SPAN_BOMBSHIPS_SCRIPT,0,0,
	190,SCRIPT_INITSCRIPT,SPAN_RANDOMRECTSHIP_SCRIPT,0,0,
	255,SCRIPT_INITENEMY,STAGE4MIDDLEBOSS,108,0,
	255,SCRIPT_END,0,0,0
};

//////////////////////////////////////////////////
// STAGE 5 ENEMIES AND SPAWNERS

#define SPAN_WW2PLANEA_SCRIPT 11
const unsigned char span_ww2planea_script[]=
{
	1,SCRIPT_INITENEMY,WW2PLANE_TYPE_A,0,0,
	2,SCRIPT_INITENEMY,WW2PLANE_TYPE_A,0,0,
	3,SCRIPT_INITENEMY,WW2PLANE_TYPE_A,0,0,
	/*4,SCRIPT_INITENEMY,WW2PLANE_TYPE_A,0,0,*/
	5,SCRIPT_INITENEMY,WW2PLANE_TYPE_B,0,0,
	6,SCRIPT_INITENEMY,WW2PLANE_TYPE_B,0,0,
	7,SCRIPT_INITENEMY,WW2PLANE_TYPE_B,0,0,
	/*11,SCRIPT_INITENEMY,WW2PLANE_TYPE_B,0,0,*/
	8,SCRIPT_END,0,0
};

#define SPAN_WW2PLANEB_SCRIPT 12
const unsigned char span_ww2planeb_script[]=
{
	1,SCRIPT_INITENEMY,WW2PLANE_TYPE_C,0,0,
	2,SCRIPT_INITENEMY,WW2PLANE_TYPE_C,0,0,
	3,SCRIPT_INITENEMY,WW2PLANE_TYPE_C,0,0,
	/*4,SCRIPT_INITENEMY,WW2PLANE_TYPE_C,0,0,*/
	5,SCRIPT_INITENEMY,WW2PLANE_TYPE_D,0,0,
	6,SCRIPT_INITENEMY,WW2PLANE_TYPE_D,0,0,
	7,SCRIPT_INITENEMY,WW2PLANE_TYPE_D,0,0,
	/*11,SCRIPT_INITENEMY,WW2PLANE_TYPE_D,0,0,*/
	8,SCRIPT_END,0,0
};

#define SPAN_WW2PLANEC_SCRIPT 13
const unsigned char span_ww2planec_script[]=
{
	1,SCRIPT_INITENEMY,WW2PLANE_TYPE_E,0,0,
	3,SCRIPT_INITENEMY,WW2PLANE_TYPE_F,0,0,
	5,SCRIPT_INITENEMY,WW2PLANE_TYPE_E,0,0,
	7,SCRIPT_INITENEMY,WW2PLANE_TYPE_F,0,0,
	9,SCRIPT_INITENEMY,WW2PLANE_TYPE_E,0,0,
	11,SCRIPT_INITENEMY,WW2PLANE_TYPE_F,0,0,
	/*
	7,SCRIPT_INITENEMY,WW2PLANE_TYPE_E,0,0,
	8,SCRIPT_INITENEMY,WW2PLANE_TYPE_F,0,0,*/
	12,SCRIPT_END,0,0
};

#define SPAN_WW2ZEPPELINA_SCRIPT 14
const unsigned char span_ww2zeppelina_script[]=
{
	1,SCRIPT_INITENEMY,WW2ZEPPELIN,32,0,
	9,SCRIPT_INITENEMY,WW2ZEPPELIN,200,0,
	17,SCRIPT_INITENEMY,WW2ZEPPELIN,104,0,
	25,SCRIPT_INITENEMY,WW2ZEPPELIN,160,0,
	26,SCRIPT_END,0,0
};

//////////////////////////////////////////////////
// STAGE 5 SCRIPTS

#define STAGE5SCRIPTC 15
const unsigned char stage5scriptc[]=
{
	16,SCRIPT_INITENEMY,WARNING,0,0,
	32,SCRIPT_INITENEMY,STAGE5ENDBOSS,168,224-56,
	33,SCRIPT_END,0,0,0
};

#define STAGE5SCRIPTB 16
const unsigned char stage5scriptb[]=
{
	45,SCRIPT_INITENEMY,WW2ZEPPELIN,32,0,
	45,SCRIPT_INITENEMY,WW2ZEPPELIN,200,0,
	55,SCRIPT_INITSCRIPT,SPAN_WW2PLANEC_SCRIPT,0,0,	
	
	85,SCRIPT_INITSCRIPT,SPAN_WW2PLANEC_SCRIPT,0,0,	
	
	100,SCRIPT_INITSCRIPT,SPAN_WW2PLANEB_SCRIPT,0,0,	
	
	135,SCRIPT_INITSCRIPT,SPAN_WW2PLANEB_SCRIPT,0,0,	
	
	160,SCRIPT_INITSCRIPT,SPAN_WW2PLANEC_SCRIPT,0,0,	
	
	182,SCRIPT_INITENEMY,WW2ZEPPELIN,32,0,
	182,SCRIPT_INITENEMY,WW2ZEPPELIN,200,0,
	192,SCRIPT_INITSCRIPT,SPAN_WW2PLANEC_SCRIPT,0,0,	
	
	220,SCRIPT_INITSCRIPT,SPAN_WW2PLANEB_SCRIPT,0,0,	

	252,SCRIPT_INITSCRIPT,STAGE5SCRIPTC,0,0,	
	253,SCRIPT_END,0,0,0
};


#define STAGE5SCRIPT 17
const unsigned char stage5script[]=
{
	10,SCRIPT_INITSCRIPT,SPAN_WW2ZEPPELINA_SCRIPT,0,0,
	55,SCRIPT_INITSCRIPT,SPAN_WW2PLANEB_SCRIPT,0,0,
	75,SCRIPT_INITSCRIPT,SPAN_WW2PLANEB_SCRIPT,0,0,
	95,SCRIPT_INITSCRIPT,SPAN_WW2PLANEA_SCRIPT,0,0,	
	
	105,SCRIPT_INITENEMY,WW2ZEPPELIN,32,0,
	105,SCRIPT_INITENEMY,WW2ZEPPELIN,200,0,
	110,SCRIPT_INITSCRIPT,SPAN_WW2PLANEC_SCRIPT,0,0,	
	
	140,SCRIPT_INITSCRIPT,SPAN_WW2PLANEC_SCRIPT,0,0,	

	175,SCRIPT_INITSCRIPT,SPAN_WW2PLANEB_SCRIPT,0,0,

	201,SCRIPT_INITENEMY,WW2ZEPPELIN,32,0,
	201,SCRIPT_INITENEMY,WW2ZEPPELIN,200,0,
	206,SCRIPT_INITSCRIPT,SPAN_WW2PLANEB_SCRIPT,0,0,
	
	225,SCRIPT_INITSCRIPT,STAGE5SCRIPTB,0,0,
	225,SCRIPT_END,0,0
};

// Statics for stage 5
const unsigned int stage5_statics[]=
{
	353-1,WW2TANKLEFT,0,16,
	353-1,WW2TANKRIGHT,240,16,
	344-1,WW2TANKLEFT,0,16,
	335-1,WW2TANKLEFT,0,16,
	326-1,WW2TANKLEFT,0,16,
	317-1,WW2TANKLEFT,0,16,
	317-1,WW2TANKRIGHT,240,16,

	272-1,WW2TANKLEFT,0,16,
	272-1,WW2TANKRIGHT,240,16,
	263-1,WW2TANKLEFT,0,16,
	254-1,WW2TANKLEFT,0,16,
	245-1,WW2TANKLEFT,0,16,
	245-1,WW2TANKRIGHT,240,16,

	203-1,WW2SHIP,200,0,
	200-1,WW2SHIP,70,0,
	197-1,WW2SHIP,120,0,
		
	187-1,WW2TANKLEFT,0,16,
	187-1,WW2TANKRIGHT,240,16,
	178-1,WW2TANKLEFT,0,16,
	169-1,WW2TANKLEFT,0,16,
	160-1,WW2TANKLEFT,0,16,
	151-1,WW2TANKLEFT,0,16,
	151-1,WW2TANKRIGHT,240,16,

	148-1,WW2SHIP,200,0,
	145-1,WW2SHIP,70,0,	
	143-1,WW2SHIP,120,0,
	
	132-1,WW2TANKLEFT,0,16,
	132-1,WW2TANKRIGHT,240,16,
	123-1,WW2TANKLEFT,0,16,
	114-1,WW2TANKLEFT,0,16,
	105-1,WW2TANKLEFT,0,16,
	105-1,WW2TANKRIGHT,240,16,

	61-1,WW2TANKLEFT,0,16,
	61-1,WW2TANKRIGHT,240,16,	
	52-1,WW2TANKLEFT,0,16,
	43-1,WW2TANKLEFT,0,16,
	34-1,WW2TANKLEFT,0,16,
	34-1,WW2TANKRIGHT,240,16,
	1000,0,0,0,0
};

// Statics for stage 1
const unsigned int stage1_statics[]=
{
	476,FORTRESSDOOR,14*8,0,
	
	
	469,FORTRESSCANNONRIGHT,24,0,
	469,FORTRESSCANNONLEFT,216,0,
	462,FORTRESSCANNONRIGHT,48,0,
	462,FORTRESSCANNONLEFT,192,0,

	455,FORTRESSCANNONRIGHT,24,0,
	455,FORTRESSCANNONLEFT,216,0,
	
	453,FORTRESSSEARCHER,21*8,0,
	452,FORTRESSSEARCHER,21*8,0,
	451,FORTRESSSEARCHER,21*8,0,
	450,FORTRESSSEARCHER,21*8,0,
	449,FORTRESSSEARCHER,21*8,0,
	448,FORTRESSSEARCHER,21*8,0,
	
	
	448,FORTRESSCANNONRIGHT,48,0,
	448,FORTRESSCANNONLEFT,192,0,

	441,FORTRESSCANNONRIGHT,24,0,
	441,FORTRESSCANNONLEFT,216,0,

	439,FORTRESSSEARCHER,9*8,0,
	438,FORTRESSSEARCHER,9*8,0,
	437,FORTRESSSEARCHER,9*8,0,
	436,FORTRESSSEARCHER,9*8,0,
	435,FORTRESSSEARCHER,9*8,0,
	434,FORTRESSSEARCHER,9*8,0,
	
	434,FORTRESSCANNONRIGHT,48,0,
	434,FORTRESSCANNONLEFT,192,0,

	427,FORTRESSCANNONRIGHT,24,0,
	427,FORTRESSCANNONLEFT,216,0,

	421,FORTRESSSEARCHER,15*8,0,
	420,FORTRESSSEARCHER,19*8,0,
	420,FORTRESSSEARCHER,11*8,0,
	419,FORTRESSSEARCHER,7*8,0,
	419,FORTRESSSEARCHER,23*8,0,
	418,FORTRESSSEARCHER,19*8,0,
	418,FORTRESSSEARCHER,11*8,0,
	417,FORTRESSSEARCHER,15*8,0,
	
	409,FORTRESSCANNONRIGHT,88,0,
	409,FORTRESSCANNONLEFT,152,0,	
	405,FORTRESSCANNONRIGHT,88,0,
	405,FORTRESSCANNONLEFT,152,0,
	401,FORTRESSCANNONRIGHT,88,0,
	401,FORTRESSCANNONLEFT,152,0,

	401,FORTRESSSEARCHER,15*8,0,
	399,FORTRESSSEARCHER,15*8,0,	
	397,FORTRESSSEARCHER,15*8,0,	
	395,FORTRESSSEARCHER,15*8,0,	
	393,FORTRESSSEARCHER,15*8,0,	
	
	391,FORTRESSDOOR,14*8,0,

	377,FORTRESSSEARCHER,12*8,0,		
	377,FORTRESSSEARCHER,18*8,0,		
	375,FORTRESSSEARCHER,12*8,0,		
	375,FORTRESSSEARCHER,18*8,0,		
	373,FORTRESSSEARCHER,12*8,0,		
	373,FORTRESSSEARCHER,18*8,0,		
	371,FORTRESSSEARCHER,12*8,0,		
	371,FORTRESSSEARCHER,18*8,0,		
	369,FORTRESSSEARCHER,12*8,0,		
	369,FORTRESSSEARCHER,18*8,0,		

	362,FORTRESSCANNONLEFT,28*8,0,
	358,FORTRESSCANNONRIGHT,16,0,
	357,FORTRESSCANNONLEFT,28*8,0,

	354,FORTRESSPHANTOM,15*8,16,
	354,FORTRESSPHANTOM,12*8,36,
	354,FORTRESSPHANTOM,18*8,36,
	354,FORTRESSPHANTOM,9*8,56,
	354,FORTRESSPHANTOM,21*8,56,
	354,FORTRESSPHANTOM,6*8,76,
	354,FORTRESSPHANTOM,24*8,76,

	351,FORTRESSCANNONRIGHT,40,0,
	349,FORTRESSCANNONLEFT,25*8,0,

	345,FORTRESSCANNONRIGHT,40,0,

	343,FORTRESSPHANTOM,15*8,16,
	343,FORTRESSPHANTOM,12*8,36,
	343,FORTRESSPHANTOM,18*8,36,
	343,FORTRESSPHANTOM,9*8,56,
	343,FORTRESSPHANTOM,21*8,56,
	
	339,FORTRESSCANNONLEFT,22*8,0,
	335,FORTRESSCANNONRIGHT,64,0,

	332,FORTRESSCANNONLEFT,22*8,0,
	332,FORTRESSCANNONRIGHT,64,0,

	331,FORTRESSPHANTOM,15*8,16,
	331,FORTRESSPHANTOM,12*8,36,
	331,FORTRESSPHANTOM,18*8,36,
	
	325,FORTRESSCANNONLEFT,19*8,0,
	321,FORTRESSCANNONRIGHT,88,0,

	321,FORTRESSPHANTOM,17*8,16,
	321,FORTRESSPHANTOM,13*8,16,
	
	316,FORTRESSDOOR,14*8,0,
	
	294,STAGE1MIDDLEBOSS,108,0,
	
	285,FORTRESSDOOR,14*8,0,
	
	280,FORTRESSCANNONRIGHT,4*8,0,
	280,FORTRESSCANNONLEFT,26*8,0,
	276,FORTRESSCANNONRIGHT,6*8,0,
	276,FORTRESSCANNONLEFT,24*8,0,
	
	266,FORTRESSCANNONRIGHT,6*8,0,
	266,FORTRESSCANNONLEFT,24*8,0,
	262,FORTRESSCANNONRIGHT,6*8,0,

	261,FORTRESSPHANTOM,11*8,24,
	261,FORTRESSPHANTOM,15*8,24,
	261,FORTRESSPHANTOM,19*8,24,
	
	258,FORTRESSCANNONRIGHT,19*8,0,
	257,FORTRESSCANNONLEFT,24*8,0,
	253,FORTRESSCANNONLEFT,24*8,0,
	253,FORTRESSCANNONRIGHT,12*8,0,
	249,FORTRESSCANNONLEFT,18*8,0,
	
	244,FORTRESSCANNONRIGHT,6*8,0,
	236,FORTRESSCANNONRIGHT,6*8,0,
	236,FORTRESSCANNONLEFT,24*8,0,

	233,FORTRESSPHANTOM,11*8,24,
	233,FORTRESSPHANTOM,15*8,24,
	233,FORTRESSPHANTOM,19*8,24,

	230,FORTRESSCANNONRIGHT,19*8,0,
	230,FORTRESSCANNONLEFT,24*8,0,
	225,FORTRESSCANNONRIGHT,12*8,0,
	222,FORTRESSCANNONLEFT,24*8,0,
	215,FORTRESSCANNONRIGHT,6*8,0,
	215,FORTRESSCANNONLEFT,13*8,0,
	
	204,FORTRESSCANNONRIGHT,24,0,
	204,FORTRESSCANNONLEFT,216,0,
	
	200,FORTRESSSEARCHER,7*8,0,		
	197,FORTRESSSEARCHER,10*8,0,		
	
	197,FORTRESSCANNONRIGHT,48,0,
	197,FORTRESSCANNONLEFT,192,0,

	194,FORTRESSSEARCHER,13*8,0,		
	
	194,FORTRESSPHANTOM,15*8,16,
	192,FORTRESSPHANTOM,23*8,56,

	191,FORTRESSSEARCHER,16*8,0,		
	
	190,FORTRESSCANNONRIGHT,24,0,
	190,FORTRESSCANNONLEFT,216,0,
	
	188,FORTRESSSEARCHER,19*8,0,
	185,FORTRESSSEARCHER,22*8,0,		
	
	183,FORTRESSCANNONRIGHT,48,0,
	183,FORTRESSCANNONLEFT,192,0,

	182,FORTRESSSEARCHER,19*8,0,		
	179,FORTRESSSEARCHER,16*8,0,		
	176,FORTRESSSEARCHER,13*8,0,		
	
	176,FORTRESSCANNONRIGHT,24,0,
	176,FORTRESSCANNONLEFT,216,0,
	
	174,FORTRESSPHANTOM,15*8,16,

	173,FORTRESSSEARCHER,10*8,0,		
	
	173,FORTRESSPHANTOM,19*8,36,
	
	170,FORTRESSSEARCHER,7*8,0,		
	
	169,FORTRESSCANNONRIGHT,48,0,
	169,FORTRESSCANNONLEFT,192,0,

	167,FORTRESSSEARCHER,10*8,0,		
	164,FORTRESSSEARCHER,13*8,0,		
	
	162,FORTRESSCANNONRIGHT,24,0,
	162,FORTRESSCANNONLEFT,216,0,
	
	161,FORTRESSSEARCHER,16*8,0,		
	158,FORTRESSSEARCHER,19*8,0,		
	155,FORTRESSSEARCHER,22*8,0,		
	
	155,FORTRESSCANNONRIGHT,48,0,
	155,FORTRESSCANNONLEFT,192,0,
	
	154,FORTRESSPHANTOM,15*8,16,
	152,FORTRESSPHANTOM,23*8,56,

	152,FORTRESSSEARCHER,19*8,0,		
	149,FORTRESSSEARCHER,16*8,0,		
	146,FORTRESSSEARCHER,13*8,0,		
	
	145,FORTRESSCANNONLEFT,28*8,0,

	143,FORTRESSSEARCHER,10*8,0,		

	141,FORTRESSCANNONRIGHT,16,0,
	
	
	140,FORTRESSPHANTOM,15*8,24,

	140,FORTRESSSEARCHER,7*8,0,		
	
	140,FORTRESSCANNONLEFT,28*8,0,
	
	137,FORTRESSSEARCHER,10*8,0,		
	134,FORTRESSSEARCHER,13*8,0,		
	
	134,FORTRESSCANNONRIGHT,40,0,
	132,FORTRESSCANNONLEFT,25*8,0,
	
	131,FORTRESSSEARCHER,16*8,0,		
	128,FORTRESSSEARCHER,19*8,0,		
	
	128,FORTRESSPHANTOM,19*8,24,

	128,FORTRESSCANNONRIGHT,40,0,
	
	125,FORTRESSSEARCHER,22*8,0,		
	
	123,FORTRESSCANNONLEFT,22*8,0,
	
	122,FORTRESSSEARCHER,19*8,0,		
	
	120,FORTRESSCANNONRIGHT,64,0,
	
	120,FORTRESSPHANTOM,15*8,24,
	
	119,FORTRESSSEARCHER,16*8,0,		
	116,FORTRESSSEARCHER,16*8,0,		
	
	116,FORTRESSCANNONLEFT,22*8,0,
	
	116,FORTRESSCANNONRIGHT,64,0,
	
	113,FORTRESSSEARCHER,16*8,0,		
	110,FORTRESSSEARCHER,16*8,0,		

	110,FORTRESSPHANTOM,11*8,24,
	
	109,FORTRESSCANNONRIGHT,88,0,
	
	107,FORTRESSCANNONLEFT,19*8,0,
	
	107,FORTRESSSEARCHER,16*8,0,		
	104,FORTRESSSEARCHER,16*8,0,		
	
	104,FORTRESSCANNONRIGHT,88,0,
	
	98,FORTRESSDOOR,14*8,0,

	93,FORTRESSWAVE,8*8,0,
	84,FORTRESSWAVE,19*8,0,
	75,FORTRESSWAVE,20*8,0,
	66,FORTRESSWAVE,13*8,0,
	57,FORTRESSWAVE,18*8,0,
	
	34,FORTRESSDOOR,14*8,0,
		
	15,WARNING,0,0,
	1,STAGE1ENDBOSS,100,0,
	
	1000,0,0,0,0
};


// Statics for stage 2
const unsigned int stage2_statics[]=
{

	477,VULCANBIRD,3*8,16,
	477,VULCANBIRD,8*8,16,
	477,VULCANBIRD,13*8,16,
	474,VULCANBIRD,17*8,16,
	474,VULCANBIRD,22*8,16,
	474,VULCANBIRD,27*8,16,
	477-6,VULCANBIRD,3*8,16,
	477-6,VULCANBIRD,8*8,16,
	477-6,VULCANBIRD,13*8,16,
	474-6,VULCANBIRD,17*8,16,
	474-6,VULCANBIRD,22*8,16,
	474-6,VULCANBIRD,27*8,16,
	
	
	477-18,VULCANBIRD,3*8,16,
	476-18,VULCANBIRD,7*8,16,
	475-18,VULCANBIRD,11*8,16,
	474-18,VULCANBIRD,15*8,16,
	473-18,VULCANBIRD,19*8,16,
	472-18,VULCANBIRD,23*8,16,
	471-18,VULCANBIRD,27*8,16,
	470-18,VULCANBIRD,23*8,16,
	469-18,VULCANBIRD,19*8,16,
	468-18,VULCANBIRD,15*8,16,
	467-18,VULCANBIRD,11*8,16,
	466-18,VULCANBIRD,7*8,16,

	477-30,VULCANBIRD,3*8,16,
	476-30,VULCANBIRD,7*8,16,
	475-30,VULCANBIRD,11*8,16,
	474-30,VULCANBIRD,15*8,16,
	473-30,VULCANBIRD,19*8,16,
	472-30,VULCANBIRD,23*8,16,
	471-30,VULCANBIRD,27*8,16,
	470-30,VULCANBIRD,23*8,16,
	469-30,VULCANBIRD,19*8,16,
	468-30,VULCANBIRD,15*8,16,
	467-30,VULCANBIRD,11*8,16,
	466-30,VULCANBIRD,7*8,16,
	466-31,VULCANBIRD,3*8,16,
	
	
	430,VULCANVULCAN,7*8,0,
	430,VULCANVULCAN,24*8,0,
	419-5,VULCANTANKLEFT,0,32,
	419-5,VULCANTANKRIGHT,240,32,
	410,VULCANTANKSTOP,60,0,
	401,VULCANTANKSTOP,60,0,
	399,VULCANBIRD,14*8,16,
	399,VULCANBIRD,20*8,16,
	399,VULCANBIRD,26*8,16,
	392-5,VULCANTANKLEFT,0,32,
	392-5,VULCANTANKRIGHT,240,32,
	386,VULCANTANKSTOP,(23*8)+4,0,
	384,VULCANBIRD,4*8,16,
	384,VULCANBIRD,10*8,16,
	384,VULCANBIRD,16*8,16,
	378-5,VULCANTANKLEFT,0,32,
	378-5,VULCANTANKRIGHT,240,32,
	370,VULCANTANKSTOP,60,0,
	361,VULCANVULCAN,21*8,0,
	350,VULCANTANKSTOP,60,0,
	344-5,VULCANTANKLEFT,0,32,
	344-5,VULCANTANKRIGHT,240,32,
	336,VULCANBIRD,4*8,16,
	336,VULCANBIRD,10*8,16,
	336,VULCANBIRD,16*8,16,
	334,VULCANTANKSTOP,(23*8)+4,0,
	330-5,VULCANTANKLEFT,0,32,
	330-5,VULCANTANKRIGHT,240,32,
	322,VULCANTANKSTOP,60,0,
	315-5,VULCANTANKLEFT,0,32,
	315-5,VULCANTANKRIGHT,240,32,
	310,VULCANTANKSTOP,15*8,0,
	300,VULCANVULCAN,25*8,0,
	295,VULCANTANKSTOP,15*8,0,
	286,VULCANVULCAN,6*8,0,
	280,VULCANTANKSTOP,15*8,0,
	274-5,VULCANTANKLEFT,0,32,
	274-5,VULCANTANKRIGHT,240,32,
	
	262,VULCANBIRD,7*8,16,
	262,VULCANBIRD,12*8,16,
	262,VULCANBIRD,17*8,16,
	262,VULCANBIRD,22*8,16,
	
	259,VULCANBIRD,6*8,16,
	259,VULCANBIRD,24*8,16,
	
	255,VULCANBIRD,20*8,16,
	255,VULCANBIRD,10*8,16,
	
	251,VULCANBIRD,14*8,16,
	251,VULCANBIRD,24*8,16,
	
	247,VULCANBIRD,12*8,16,
	247,VULCANBIRD,26*8,16,
	
	243,VULCANBIRD,3*8,16,
	243,VULCANBIRD,15*8,16,
	243,VULCANBIRD,24*8,16,
	
	239,VULCANBIRD,15*8,16,
	
	235,VULCANBIRD,10*8,16,
	235,VULCANBIRD,21*8,16,
	
	231,VULCANBIRD,8*8,16,
	231,VULCANBIRD,16*8,16,
	231,VULCANBIRD,24*8,16,
	
	223,VULCANTANKSTOP,8*8,0,
	223,VULCANTANKSTOP,23*8,0,
	219,VULCANSTATION,(14*8)-4,0,
		
	203,VULCANTANKSTOP,15*8,0,
	203,VULCANVULCAN,25*8,0,
	195,VULCANTANKSTOP,15*8,0,
	192,VULCANVULCAN,6*8,0,
	187,VULCANTANKSTOP,15*8,0,
	180,VULCANTANKSTOP,15*8,0,
	180,VULCANBIRD,3*8,16,
	180,VULCANBIRD,27*8,16,
	173,VULCANBIRD,7*8,16,
	173,VULCANBIRD,23*8,16,
	
	171,VULCANTANKSTOP,15*8,0,
	168-5,VULCANTANKLEFT,0,32,
	168-5,VULCANTANKRIGHT,240,32,
	162,VULCANTANKSTOP,(23*8)+4,0,
	160,VULCANBIRD,4*8,16,
	160,VULCANBIRD,10*8,16,
	160,VULCANBIRD,16*8,16,
	154-5,VULCANTANKLEFT,0,32,
	154-5,VULCANTANKRIGHT,240,32,
	146,VULCANTANKSTOP,60,0,
	137,VULCANVULCAN,22*8,0,
	136,VULCANTANKSTOP,60,0,
	126,VULCANTANKSTOP,60,0,
	124,VULCANBIRD,14*8,16,
	124,VULCANBIRD,20*8,16,
	124,VULCANBIRD,26*8,16,
	116,VULCANBIRD,14*8,16,
	116,VULCANBIRD,20*8,16,
	116,VULCANBIRD,26*8,16,
	111-5,VULCANTANKLEFT,0,32,
	111-5,VULCANTANKRIGHT,240,32,
	106,VULCANTANKSTOP,(23*8)+4,0,
	104,VULCANBIRD,4*8,16,
	104,VULCANBIRD,10*8,16,
	104,VULCANBIRD,16*8,16,
	98-5,VULCANTANKLEFT,0,32,
	98-5,VULCANTANKRIGHT,240,32,
	
	86,VULCANBIRD,17*8,16,
	86,VULCANBIRD,3*8,16,
	82,VULCANBIRD,10*8,16,
	82,VULCANBIRD,26*8,16,
	78,VULCANBIRD,21*8,16,
	78,VULCANBIRD,6*8,16,
	75,VULCANLASER,19*8,16,
	74,VULCANBIRD,11*8,16,
	74,VULCANBIRD,20*8,16,
	70,VULCANBIRD,25*8,16,
	70,VULCANBIRD,4*8,16,
	67,VULCANLASER,6*8,16,
	66,VULCANBIRD,10*8,16,
	66,VULCANBIRD,28*8,16,	
	62,VULCANBIRD,11*8,16,
	62,VULCANBIRD,24*8,16,
	59,VULCANLASER,1*8,16,
	58,VULCANBIRD,15*8,16,
	58,VULCANBIRD,5*8,16,
	54,VULCANBIRD,2*8,16,
	54,VULCANBIRD,21*8,16,
	51,VULCANLASER,10*8,16,
	50,VULCANBIRD,28*8,16,
	50,VULCANBIRD,9*8,16,
	46,VULCANBIRD,3*8,16,
	46,VULCANBIRD,19*8,16,
	43,VULCANLASER,19*8,16,
	42,VULCANBIRD,27*8,16,
	42,VULCANBIRD,16*8,16,
	38,VULCANBIRD,5*8,16,
	38,VULCANBIRD,25*8,16,
	36,VULCANBIRD,13*8,16,
	36,VULCANBIRD,28*8,16,
	35,VULCANLASER,25*8,16,
	27,VULCANLASER,15*8,16,
		
	18,WARNING,0,0,
	4,STAGE2ENDBOSS,104,0,
	
};

#define SPAN_ASTEROIDS_FULL_SCRIPT 18
const unsigned char span_asteroids_full_script[]=
{
	1,SCRIPT_INITENEMY,SPACEASTEROIDMEDIUM,0,0,
	1,SCRIPT_INITENEMY,SPACEASTEROIDLITTLE,0,0,
	2,SCRIPT_INITENEMY,SPACEASTEROIDMEDIUM,0,0,
	2,SCRIPT_INITENEMY,SPACEASTEROIDLITTLE,0,0,
	3,SCRIPT_INITENEMY,SPACEASTEROIDLITTLE,0,0,
	3,SCRIPT_INITENEMY,SPACEASTEROIDBIG,0,0,
	4,SCRIPT_INITENEMY,SPACEASTEROIDMEDIUM,0,0,
	4,SCRIPT_INITENEMY,SPACEASTEROIDLITTLE,0,0,
	4,SCRIPT_LOOP,0,8,4,
	5,SCRIPT_END,0,0
};

#define SPAN_ASTEROIDS_LITTLE_SCRIPT 19
const unsigned char span_asteroids_little_script[]=
{
	1,SCRIPT_INITENEMY,SPACEASTEROIDBIG,0,0,
	8,SCRIPT_INITENEMY,SPACEASTEROIDMEDIUM,0,0,
	12,SCRIPT_INITENEMY,SPACEASTEROIDBIG,0,0,
	16,SCRIPT_INITENEMY,SPACEASTEROIDMEDIUM,0,0,
	20,SCRIPT_INITENEMY,SPACEASTEROIDLITTLE,0,0,
	22,SCRIPT_LOOP,0,4,3,
	5,SCRIPT_END,0,0
};

#define STAGE3SCRIPTB 20
const unsigned char stage3scriptb[]=
{
	13,SCRIPT_INITSCRIPT,SPAN_ASTEROIDS_FULL_SCRIPT,0,0,
	42,SCRIPT_INITSCRIPT,SPAN_ASTEROIDS_FULL_SCRIPT,0,0,
	82,SCRIPT_INITENEMY,WARNING,2,0,
	82,SCRIPT_ADVANCESCROLLER,0,0,0,
	83,SCRIPT_END,0,0,0
};
	
#define STAGE3SCRIPT 21
const unsigned char stage3script[]=
{
	10,SCRIPT_INITSCRIPT,SPAN_ASTEROIDS_FULL_SCRIPT,0,0,
	30,SCRIPT_INITSCRIPT,SPAN_SPREADSHIPS_SCRIPT,0,0,
	40,SCRIPT_INITSCRIPT,SPAN_ASTEROIDS_FULL_SCRIPT,0,0,
	70,SCRIPT_INITSCRIPT,SPAN_ASTEROIDS_LITTLE_SCRIPT,0,0,
	70,SCRIPT_INITSCRIPT,SPAN_RANDOMWAVESHIP_SCRIPT,0,0,
	80,SCRIPT_INITSCRIPT,SPAN_BOMBSHIPS_SCRIPT,0,0,
	120,SCRIPT_INITSCRIPT,SPAN_RANDOMRECTSHIP_SCRIPT,0,0,
	185,SCRIPT_INITENEMY,SPACESTATION,108,0,

	186,SCRIPT_END,0,0,0
};


// Statics for stage 3
const unsigned int stage3_statics[]=
{
	285,WAVESHIP,128,0,
	283,WAVESHIP,128,0,
	281,WAVESHIP,128,0,
	279,WAVESHIP,128,0,
	277,WAVESHIP,128,0,
	275,WAVESHIP,128,0,
	
	263,SPACESHOOTER,15*8,0,
	259,SPACESHOOTER,8*8,0,
	259,SPACESHOOTER,22*8,0,

	253,WAVESHIP,128,0,
	251,WAVESHIP,128,0,
	249,WAVESHIP,128,0,
	247,WAVESHIP,128,0,
	245,WAVESHIP,128,0,
	243,WAVESHIP,128,0,
	
	243,SPACESHOOTER,1*8,0,
	243,SPACESHOOTER,29*8,0,
	239,SPACESHOOTER,1*8,0,
	239,SPACESHOOTER,29*8,0,

	229,WAVESHIP,64,0,
	227,WAVESHIP,64,0,
	225,WAVESHIP,64,0,
	223,WAVESHIP,64,0,
	221,WAVESHIP,64,0,
	219,WAVESHIP,64,0,

	217,SPACESHOOTER,20*8,0,
	217,SPACESHOOTER,27*8,0,
	
	206,WAVESHIP,188,0,
	204,WAVESHIP,188,0,
	202,WAVESHIP,188,0,
	200,WAVESHIP,188,0,
	198,WAVESHIP,188,0,
	196,WAVESHIP,188,0,
	
	194,SPACESHOOTER,2*8,0,
	191,SPACESHOOTER,7*8,0,
	
	187,TURNSHIP,48,0,
	186,TURNSHIP,48,0,
	185,TURNSHIP,48,0,
	184,TURNSHIP,48,0,
	183,TURNSHIP,48,0,
	182,TURNSHIP,48,0,
	181,TURNSHIP,208,0,
	180,TURNSHIP,208,0,
	179,TURNSHIP,208,0,
	178,TURNSHIP,208,0,
	177,TURNSHIP,208,0,
	176,TURNSHIP,208,0,

	169,SPACESHOOTER,15*8,0,
	165,SPACESHOOTER,8*8,0,
	165,SPACESHOOTER,21*8,0,
	
	160,WAVESHIP,108,0,
	155,WAVESHIP,148,0,
	150,WAVESHIP,68,0,
	145,WAVESHIP,208,0,
	
	145,SPACESHOOTER,21*8,0,
	
	140,WAVESHIP,108,0,
	
	137,SPACESHOOTER,5*8,0,
	
	135,WAVESHIP,88,0,
		
	130,WAVESHIP,158,0,
	130,WAVESHIP,118,0,	
	
	126,SPACESHOOTER,13*8,0,
	126,SPACESHOOTER,18*8,0,	
		
	120,WAVESHIP,208,0,
	120,WAVESHIP,96,0,
	
	115,SPACESHOOTER,24*8,0,	
	112,SPACESHOOTER,24*8,0,	
	110,SPACESHOOTER,11*8,0,
	
	110,WAVESHIP,200,0,
	
	109,SPACESHOOTER,24*8,0,
	107,SPACESHOOTER,7*8,0,
	107,SPACESHOOTER,13*8,0,
	
	105,WAVESHIP,130,0,
	100,WAVESHIP,90,0,
	
	93,SPACESHOOTER,10*8,0,
	91,SPACESHOOTER,23*8,0,
	
	90,WAVESHIP,138,0,
	80,WAVESHIP,78,0,
	
	40,STAGE3ENDBOSS,46,0,
	39,STAGE3ENDBOSSB,180,0,
};


// Statics for stage 7
const unsigned int stage7_statics[]=
{
	448,MONSTERMISSILLEFT,8*8,0,

	445,MONSTERBLOB,10*8,0,
	445,MONSTERBLOB,19*8,0,

	444,MONSTERMISSILRIGHT,22*8,0,

	440,MONSTERBLOB,17*8,216,

	438,MONSTERMISSILLEFT,4*8,0,
	
	435,MONSTERBLOB,15*8,0,
	
	433,MONSTERMISSILRIGHT,26*8,0,
	
	430,MONSTERBLOB,10*8,0,
		
	428,MONSTERMISSILLEFT,4*8,0,

	425,MONSTERBLOB,19*8,0,
	
	423,MONSTERMISSILRIGHT,26*8,0,

	420,MONSTERBLOB,9*8,0,
	415,MONSTERBLOB,20*8,0,
	
	415,MONSTERMISSILRIGHT,22*8,0,
	411,MONSTERMISSILLEFT,8*8,0,

	410,MONSTERBLOB,15*8,0,

	406,MONSTERMISSILLEFT,4*8,0,
	402,MONSTERMISSILRIGHT,26*8,0,

	398,MONSTERMISSILRIGHT,10*8,0,
	394,MONSTERMISSILLEFT,20*8,0,

	394,MONSTERBLOB,6*8,0,
	390,MONSTERBLOB,23*8,0,
	
	388,MONSTERMISSILLEFT,4*8,0,
	384,MONSTERMISSILRIGHT,26*8,0,
	
	382,MONSTERBLOB,10*8,0,
	378,MONSTERBLOB,16*8,0,
	
	378,MONSTERMISSILLEFT,6*8,0,	
	
	376,MONSTERBLOB,14*8,0,

	373,MONSTERMISSILLEFT,6*8,0,
	
	371,MONSTERMISSILRIGHT,20*8,0,

	370,MONSTERBLOB,20*8,0,
	
	360,MONSTERBLOB,7*8,0,
	360,MONSTERBLOB,14*8,0,
	
	357,MONSTERMISSILRIGHT,19*8,0,
	
	350,MONSTERBLOB,7*8,0,
	350,MONSTERBLOB,16*8,0,
	
	347,MONSTERMISSILLEFT,5*8,0,
	345,MONSTERMISSILRIGHT,19*8,0,

	340,MONSTERBLOB,6*8,0,
	340,MONSTERBLOB,17*8,0,
	
	326,MONSTERHEAD,14*8,0,
	
	310,MONSTERBLOB,16*8,0,
	
	306,MONSTERMISSILLEFT,10*8,0,
	
	305,MONSTERBLOB,16*8,0,

	300,MONSTERBLOB,20*8,216,

	291,MONSTERMISSILLEFT,10*8,0,
	
	289,MONSTERMISSILRIGHT,24*8,0,
	
	
	288,MONSTERBLOB,21*8,0,
	285,MONSTERBLOB,12*8,0,

	280,MONSTERBLOB,14*8,0,
	
	271,MONSTERMISSILRIGHT,22*8,0,
	
	269,MONSTERMISSILLEFT,8*8,0,
	
	269,MONSTERBLOB,11*8,0,
	265,MONSTERBLOB,20*8,0,

	260,MONSTERMISSILRIGHT,24*8,0,
	
	260,MONSTERBLOB,17*8,0,
	
	255,MONSTERBLOB,10*8,0,
	
	251,MONSTERMISSILLEFT,8*8,0,
	
	250,MONSTERBLOB,14*8,0,
	
	245,MONSTERBLOB,15*8,0,
	245,MONSTERBLOB,10*8,216,
	
	239,MONSTERMISSILLEFT,8*8,0,
	
	236,MONSTERMISSILRIGHT,22*8,0,

	235,MONSTERBLOB,15*8,0,
	
	230,MONSTERBLOB,13*8,0,
		
	224,MONSTERMISSILRIGHT,22*8,0,
	224,MONSTERMISSILLEFT,8*8,0,
	
	194,STAGE7MIDDLEBOSS,104,0,
	
	184,MONSTERHEAD,14*8,0,
	
	174,MONSTERMISSILLEFT,20*8,0,
	174,MONSTERMISSILRIGHT,10*8,0,
	
	170,MONSTERBLOB,23*8,0,
	170,MONSTERBLOB,7*8,0,
	
	166,MONSTERMISSILLEFT,4*8,0,
	166,MONSTERMISSILRIGHT,26*8,0,

	162,MONSTERBLOB,23*8,0,
	162,MONSTERBLOB,7*8,0,

	159,MONSTERMISSILLEFT,20*8,0,
	159,MONSTERMISSILRIGHT,10*8,0,

	150,MONSTERBLOB,11*8,216,
	150,MONSTERBLOB,19*8,216,

	138,MONSTERMISSILLEFT,8*8,0,
	138,MONSTERMISSILRIGHT,22*8,0,

	136,MONSTERBLOB,7*8,216,
	133,MONSTERBLOB,7*8,0,
	130,MONSTERBLOB,120*8,0,
	
	121,MONSTERHEAD,8*8,0,
	
	111,MONSTERBLOB,8*8,0,
	
	104,MONSTERHEAD,21*8,0,
	
	
	95,MONSTERBLOB,20*8,0,
	
	83,MONSTERBLOB,7*8,0,
	83,MONSTERBLOB,24*8,0,
	
	70,MONSTERHEAD,14*8,0,
	
	41,WARNING,0,0,
	11,STAGE7ENDBOSS,128,30,
};

/////////////////////////////////////////////
// SPAWNERS

const unsigned char *spawners[]=
{
	span_waveship80_script,
	span_waveship160_script,
	span_randomrectship_script,
	span_rectshiplateral_script,
	span_bombships_script,
	span_randomwaveship_script,
	span_turnships_script,
	span_spreadships_script,
	stage4scriptc,
	stage4scriptb,
	stage4script,
	span_ww2planea_script,
	span_ww2planeb_script,
	span_ww2planec_script,
	span_ww2zeppelina_script,
	stage5scriptc,
	stage5scriptb,
	stage5script,
	span_asteroids_full_script,
	span_asteroids_little_script,
	stage3scriptb,
	stage3script
};

// Function pointers

extern void InitWarning(enemy *en);
extern void InitIntroSidePlayer(enemy *en);
extern void InitIntroStar(enemy *en);
extern void InitWaveShip(enemy *en);
extern void InitTurnShip(enemy *en);
extern void InitBombShipLeft(enemy *en);
extern void InitBombShipRight(enemy *en);
extern void InitSpreadShip(enemy *en);
extern void InitStage4MiddleBoss(enemy *en);
extern void InitStage4EndBoss(enemy *en);
extern void InitWW2Zeppelin(enemy *en);
extern void InitWW2Ship(enemy *en);
extern void InitWW2Plane(enemy *en);
extern void InitWW2Tank(enemy *en);
extern void InitStage5EndBoss(enemy *en);
extern void InitIntro3Object(enemy *en);
extern void InitMonsterBlob(enemy *en);
extern void InitMonsterHead(enemy *en);
extern void InitMonsterMissilLeft(enemy *en);
extern void InitMonsterMissilRight(enemy *en);
extern void InitStage7MiddleBoss(enemy *en);
extern void InitStage7EndBoss(enemy *en);
extern void InitStage7Object(enemy *en);
extern void InitFortressDoor(enemy *en);
extern void InitFortressWave(enemy *en);
extern void InitFortressPhantom(enemy *en);
extern void InitFortressCannonRight(enemy *en);
extern void InitFortressCannonLeft(enemy *en);
extern void InitStage1MiddleBoss(enemy *en);
extern void InitStage1EndBoss(enemy *en);
extern void InitStage4Object(enemy *en);
extern void InitVulcanStation(enemy *en);
extern void InitVulcanVulcan(enemy *en);
extern void InitVulcanBird(enemy *en);
extern void InitVulcanLaser(enemy *en);
extern void InitVulcanLava(enemy *en);
extern void InitVulcanTank(enemy *en);
extern void InitStage2EndBoss(enemy *en);
extern void InitStage2Object(enemy *en);
extern void InitSpaceAsteroidBig(enemy *en);
extern void InitSpaceAsteroidMedium(enemy *en);
extern void InitSpaceAsteroidLittle(enemy *en);
extern void InitSpaceStation(enemy *en);
extern void InitSpaceShooter(enemy *en);
extern void InitStage3EndBoss(enemy *en);
extern void InitStage6EndBoss(enemy *en);
extern void InitSkullBoneA(enemy *en);
extern void InitSkullBoneB(enemy *en);
extern void InitSkullBoneC(enemy *en);
extern void InitStage5Missile(enemy *en);
extern void InitStage7EndBossB(enemy *en);
extern void InitStage4EndBossB(enemy *en);
extern void InitStage3Laser(enemy *en);
extern void InitStage1MiddleBossB(enemy *en);
extern void InitStage1MiddleBossC(enemy *en);
extern void InitStage6EndBossB(enemy *en);
extern void InitStage6Object(enemy *en);

const MyInitEnemyFunction initenemyfunctions[]=
{
	0,
	InitWarning,
	0,
	0,
	InitIntroSidePlayer,
	InitIntroStar,
	InitWaveShip,
	0,
	InitTurnShip,
	InitBombShipLeft,
	InitBombShipRight,
	InitSpreadShip,
	InitStage4MiddleBoss,
	InitStage4EndBoss,
	InitWW2Zeppelin,
	InitWW2Ship,
	InitWW2Plane,
	InitWW2Plane,
	InitWW2Plane,
	InitWW2Plane,
	InitWW2Plane,
	InitWW2Plane,
	InitWW2Tank,
	InitWW2Tank,
	InitStage5EndBoss,
	InitIntro3Object,
	InitMonsterBlob,
	InitMonsterHead,
	InitMonsterMissilLeft,
	InitMonsterMissilRight,
	InitStage7MiddleBoss,
	InitStage7EndBoss,
	InitStage7Object,
	0,
	InitFortressDoor,
	InitFortressWave,
	InitFortressPhantom,
	InitFortressCannonLeft,
	InitFortressCannonRight,
	InitStage1MiddleBoss,
	InitStage1EndBoss,
	InitStage4Object,
	InitVulcanStation,
	InitVulcanVulcan,
	InitVulcanBird,
	InitVulcanLaser,
	InitVulcanLava,
	InitVulcanTank,
	InitVulcanTank,
	InitVulcanTank,
	InitStage2EndBoss,
	InitStage2Object,
	InitSpaceAsteroidBig,
	InitSpaceAsteroidMedium,
	InitSpaceAsteroidLittle,
	InitSpaceStation,
	InitSpaceShooter,
	InitStage3EndBoss,
	InitStage6EndBoss,
	InitSkullBoneA,
	InitSkullBoneB,
	InitSkullBoneC,
	InitStage5Missile,
	InitStage7EndBossB,
	InitStage4EndBossB,
	InitStage4EndBoss,
	InitStage3EndBoss,
	InitStage3Laser,
	InitStage3Laser,
	InitStage3Laser,
	InitStage3Laser,
	InitStage3Laser,
	InitStage3Laser,
	InitStage3Laser,
	InitStage3Laser,
	InitStage1MiddleBossB,
	InitStage1MiddleBossC,
	InitStage6EndBossB,
	InitStage6Object
};

extern unsigned char UpdateWarning(enemy *en);
extern unsigned char UpdateIntroSidePlayer(enemy *en);
extern unsigned char UpdateIntroOvni(enemy *en);
extern unsigned char UpdateIntroStar(enemy *en);
extern unsigned char UpdateWaveShip(enemy *en);
extern unsigned char UpdateRectShip(enemy *en);
extern unsigned char UpdateTurnShip(enemy *en);
extern unsigned char UpdateBombShip(enemy *en);
extern unsigned char UpdateSpreadShip(enemy *en);
extern unsigned char UpdateStage4MiddleBoss(enemy *en);
extern unsigned char UpdateStage4EndBoss(enemy *en);
extern unsigned char UpdateWW2Zeppelin(enemy *en);
extern unsigned char UpdateWW2Ship(enemy *en);
extern unsigned char UpdateWW2Plane(enemy *en);
extern unsigned char UpdateWW2Tank(enemy *en);
extern unsigned char UpdateStage5EndBoss(enemy *en);
extern unsigned char UpdateIntro3Object(enemy *en);
extern unsigned char UpdateMonsterBlob(enemy *en);
extern unsigned char UpdateMonsterHead(enemy *en);
extern unsigned char UpdateMonsterMissil(enemy *en);
extern unsigned char UpdateStage7MiddleBoss(enemy *en);
extern unsigned char UpdateStage7EndBoss(enemy *en);
extern unsigned char UpdateStage7Object(enemy *en);
extern unsigned char UpdateFortressSearcher(enemy *en);
extern unsigned char UpdateFortressDoor(enemy *en);
extern unsigned char UpdateFortressWave(enemy *en);
extern unsigned char UpdateFortressPhantom(enemy *en);
extern unsigned char UpdateFortressCannon(enemy *en);
extern unsigned char UpdateStage1MiddleBoss(enemy *en);
extern unsigned char UpdateStage1EndBoss(enemy *en);
extern unsigned char UpdateStage4Object(enemy *en);
extern unsigned char UpdateVulcanStation(enemy *en);
extern unsigned char UpdateVulcanVulcan(enemy *en);
extern unsigned char UpdateVulcanBird(enemy *en);
extern unsigned char UpdateVulcanLaser(enemy *en);
extern unsigned char UpdateVulcanLava(enemy *en);
extern unsigned char UpdateVulcanTank(enemy *en);
extern unsigned char UpdateStage2EndBoss(enemy *en);
extern unsigned char UpdateStage2Object(enemy *en);
extern unsigned char UpdateSpaceAsteroid(enemy *en);
extern unsigned char UpdateSpaceStation(enemy *en);
extern unsigned char UpdateSpaceShooter(enemy *en);
extern unsigned char UpdateStage3EndBoss(enemy *en);
extern unsigned char UpdateStage6EndBoss(enemy *en);
extern unsigned char UpdateSkullBoneAB(enemy *en);
extern unsigned char UpdateSkullBoneC(enemy *en);
extern unsigned char UpdateStage5Missile(enemy *en);
extern unsigned char UpdateStage7EndBossB(enemy *en);
extern unsigned char UpdateStage4EndBossB(enemy *en);
extern unsigned char UpdateStage3Laser(enemy *en);
extern unsigned char UpdateStage1MiddleBossB(enemy *en);
extern unsigned char UpdateStage1MiddleBossC(enemy *en);
extern unsigned char UpdateStage6EndBossB(enemy *en);
extern unsigned char UpdateStage6Object(enemy *en);

const MyUpdateEnemyFunction updateenemyfunctions[]=
{
	0,
	UpdateWarning,
	UpdateIntroOvni,
	UpdateIntroOvni,
	UpdateIntroSidePlayer,
	UpdateIntroStar,
	UpdateWaveShip,
	UpdateRectShip,
	UpdateTurnShip,
	UpdateBombShip,
	UpdateBombShip,
	UpdateSpreadShip,
	UpdateStage4MiddleBoss,
	UpdateStage4EndBoss,
	UpdateWW2Zeppelin,
	UpdateWW2Ship,
	UpdateWW2Plane,
	UpdateWW2Plane,
	UpdateWW2Plane,
	UpdateWW2Plane,
	UpdateWW2Plane,
	UpdateWW2Plane,
	UpdateWW2Tank,
	UpdateWW2Tank,
	UpdateStage5EndBoss,
	UpdateIntro3Object,
	UpdateMonsterBlob,
	UpdateMonsterHead,
	UpdateMonsterMissil,
	UpdateMonsterMissil,
	UpdateStage7MiddleBoss,
	UpdateStage7EndBoss,
	UpdateStage7Object,
	UpdateFortressSearcher,
	UpdateFortressDoor,
	UpdateFortressWave,
	UpdateFortressPhantom,
	UpdateFortressCannon,
	UpdateFortressCannon,
	UpdateStage1MiddleBoss,
	UpdateStage1EndBoss,
	UpdateStage4Object,
	UpdateVulcanStation,
	UpdateVulcanVulcan,
	UpdateVulcanBird,
	UpdateVulcanLaser,
	UpdateVulcanLava,
	UpdateVulcanTank,
	UpdateVulcanTank,
	UpdateVulcanTank,
	UpdateStage2EndBoss,
	UpdateStage2Object,
	UpdateSpaceAsteroid,
	UpdateSpaceAsteroid,
	UpdateSpaceAsteroid,
	UpdateSpaceStation,
	UpdateSpaceShooter,
	UpdateStage3EndBoss,
	UpdateStage6EndBoss,
	UpdateSkullBoneAB,
	UpdateSkullBoneAB,
	UpdateSkullBoneC,
	UpdateStage5Missile,
	UpdateStage7EndBossB,
	UpdateStage4EndBossB,
	UpdateStage4EndBoss,
	UpdateStage3EndBoss,
	UpdateStage3Laser,
	UpdateStage3Laser,
	UpdateStage3Laser,
	UpdateStage3Laser,
	UpdateStage3Laser,
	UpdateStage3Laser,
	UpdateStage3Laser,
	UpdateStage3Laser,
	UpdateStage1MiddleBossB,
	UpdateStage1MiddleBossC,
	UpdateStage6EndBossB,
	UpdateStage6Object
};

// Scrollers

const signed int stage4_scrollers[]=
{
133*32,12,28*32,0,12,
133*32,12,28*32,-4,12, 
133*32,12,28*32,4,12, 
133*32,2,28*32,2,8, 
133*32,2,28*32,-2,8,
133*32,2,28*32,2,8, 
133*32,2,28*32,-2,8,
133*32,2,28*32,2,8, 
133*32,2,28*32,-2,8,
133*32,200,28*32,0,4,
126*32,1,0*32,0,8,
65*32,20,28*32,0,10,
65*32,10,28*32,-6,10,
65*32,11,28*32,6,10,
7*32,1,0*32,0,4,
7*32,10000,28*32,0,12
};

const signed int stage1_scrollers[]=
{
292*32,1,0*32,0,2,
289*32,10000,2*32,0,4,
2*32,1,0*32,0,2,
1*32,10000,2*32,0,6
};

const signed int stage2_scrollers[]=
{
(33+29)*32,1,0*32,0,2,
3*32,1,0*32,0,2,
2*32,20000,2*32,0,2
};

const signed int stage5_scrollers[]=
{
412*32,11,28*32,0,6,
386*32,1,0*32,0,4,
2*32,1,0*32,0,2,
1*32,7000,7*32,0,16
};

const signed int stage3_scrollers[]=
{
292*32,100,28*32,0,4,
3*32,100,28*32,0,2
};

const signed int stage7_scrollers[]=
{
20*32,1,0*32,0,2,
10*32,10000,7*32,0,6
};

const signed int stage6_scrollers[]=
{
8*32,10000,28*32,0,2,
1*32,10000,28*32,0,12
};

// Pointer to sprites and where they go
const unsigned char *imagepointers[]=
{
	0,
	warning_psgcompr,
	introovni_psgcompr,
	0,
	introsideplayer_psgcompr,
	introstar_psgcompr,
	waveship_psgcompr,
	rectship_psgcompr,
	turnship_psgcompr,
	bombship_psgcompr,
	0,
	spreadship_psgcompr,
	stage4middleboss_psgcompr,
	stage4endboss_psgcompr,
	ww2zeppelin_psgcompr,
	ww2ship_psgcompr,
	ww2plane_psgcompr,
	0,
	0,
	0,
	0,
	0,
	ww2tank_psgcompr,
	0,
	stage5endboss_psgcompr,
	0,
	monsterblob_psgcompr,
	monsterhead_psgcompr,
	monstermissil_psgcompr,
	0,
	stage7middleboss_psgcompr,
	stage7endboss_psgcompr,
	0,
	fortresssearch_psgcompr,
	fortressdoor_psgcompr,
	fortresswave_psgcompr,
	fortressphantom_psgcompr,
	fortresscannon_psgcompr,
	0,
	stage1middleboss_psgcompr,
	stage1endboss_psgcompr,
	0,
	vulcanstation_psgcompr,
	vulcanvulcan_psgcompr,
	vulcanbird_psgcompr,
	vulcanlaser_psgcompr,
	vulcanlava_psgcompr,
	vulcantank_psgcompr,
	0,
	0,
	stage2endboss_psgcompr,
	0,
	spaceasteroidbig_psgcompr,
	spaceasteroidmedium_psgcompr,
	spaceasteroidlittle_psgcompr,
	spacestation_psgcompr,
	spaceshooter_psgcompr,
	stage3endboss_psgcompr,
	skull_psgcompr,
	bone_psgcompr,
	0,
	0,
	0,
	0,
	stage4endbossb_psgcompr,
	stage4endbossc_psgcompr
};

const int imagebases[]=
{
	0,
	WARNINGBASE,
	INTROOVNIBASE,
	0,
	INTROSIDEPLAYERBASE,
	INTROSTARBASE,
	WAVESHIPBASE,
	RECTSHIPBASE,
	TURNSHIPBASE,
	BOMBSHIPBASE,
	0,
	SPREADSHIPBASE,
	STAGE4MIDDLEBOSSBASE,
	STAGE4ENDBOSSBASE,
	WW2ZEPPELINBASE,
	WW2SHIPBASE,
	WW2PLANEBASE,
	0,
	0,
	0,
	0,
	0,
	WW2TANKBASE,
	0,
	STAGE5ENDBOSSBASE,
	0,
	MONSTERBLOBBASE,
	MONSTERHEADBASE,
	MONSTERMISSILBASE,
	0,
	STAGE7MIDDLEBOSSBASE,
	STAGE7ENDBOSSBASE,
	0,
	FORTRESSSEARCHERBASE,
	FORTRESSDOORBASE,
	FORTRESSWAVEBASE,
	FORTRESSPHANTOMBASE,
	FORTRESSCANNONBASE,
	0,
	STAGE1MIDDLEBOSSBASE,
	STAGE1ENDBOSSBASE,
	0,
	VULCANSTATIONBASE,
	VULCANVULCANBASE,
	VULCANBIRDBASE,
	VULCANLASERBASE,
	VULCANLAVABASE,
	VULCANTANKBASE,
	0,
	0,
	STAGE2ENDBOSSBASE,
	0,
	SPACEASTEROIDBIGBASE,
	SPACEASTEROIDMEDIUMBASE,
	SPACEASTEROIDLITTLEBASE,
	SPACESTATIONBASE,
	SPACESHOOTERBASE,
	STAGE3ENDBOSSBASE,
	STAGE6ENDBOSSBASE,
	SKULLBONEBASE,
	0,
	0,
	0,
	0,
	STAGE4ENDBOSSBASEB,
	STAGE4ENDBOSSBASEC
};

const unsigned char imagebanks[]=
{
	0,
	warning_psgcompr_bank,
	introovni_psgcompr_bank,
	0,
	introsideplayer_psgcompr_bank,
	introstar_psgcompr_bank,
	waveship_psgcompr_bank,
	rectship_psgcompr_bank,
	turnship_psgcompr_bank,
	bombship_psgcompr_bank,
	0,
	spreadship_psgcompr_bank,
	stage4middleboss_psgcompr_bank,
	stage4endboss_psgcompr_bank,
	ww2zeppelin_psgcompr_bank,
	ww2ship_psgcompr_bank,
	ww2plane_psgcompr_bank,
	0,
	0,
	0,
	0,
	0,
	ww2tank_psgcompr_bank,
	0,
	stage5endboss_psgcompr_bank,
	0,
	monsterblob_psgcompr_bank,
	monsterhead_psgcompr_bank,
	monstermissil_psgcompr_bank,
	0,
	stage7middleboss_psgcompr_bank,
	stage7endboss_psgcompr_bank,
	0,
	fortresssearch_psgcompr_bank,
	fortressdoor_psgcompr_bank,
	fortresswave_psgcompr_bank,
	fortressphantom_psgcompr_bank,
	fortresscannon_psgcompr_bank,
	0,
	stage1middleboss_psgcompr_bank,
	stage1endboss_psgcompr_bank,
	0,
	vulcanstation_psgcompr_bank,
	vulcanvulcan_psgcompr_bank,
	vulcanbird_psgcompr_bank,
	vulcanlaser_psgcompr_bank,
	vulcanlava_psgcompr_bank,
	vulcantank_psgcompr_bank,
	0,
	0,
	stage2endboss_psgcompr_bank,
	0,
	spaceasteroidbig_psgcompr_bank,
	spaceasteroidmedium_psgcompr_bank,
	spaceasteroidlittle_psgcompr_bank,
	spacestation_psgcompr_bank,
	spaceshooter_psgcompr_bank,
	stage3endboss_psgcompr_bank,
	skull_psgcompr_bank,
	bone_psgcompr_bank,
	0,
	0,
	0,
	0,
	stage4endbossb_psgcompr_bank,
	stage4endbossc_psgcompr_bank
};

const unsigned char stage3spriteslist[]=
{
	WAVESHIP,
	RECTSHIP,
	TURNSHIP,
	BOMBSHIPLEFT,
	SPACESHOOTER,
	SPREADSHIP,
	SPACESTATION,
	SPACEASTEROIDBIG,
	SPACEASTEROIDMEDIUM,
	SPACEASTEROIDLITTLE,
	STAGE3ENDBOSS,
	WARNING
};

const unsigned char stage1spriteslist[]=
{
	FORTRESSSEARCHER,
	FORTRESSDOOR,
	FORTRESSWAVE,
	FORTRESSPHANTOM,
	FORTRESSCANNONLEFT,
	STAGE1MIDDLEBOSS,
	STAGE1ENDBOSS,
	WARNING
};

const unsigned char stage2spriteslist[]=
{
	VULCANVULCAN,
	VULCANLASER,
	VULCANLAVA,
	VULCANTANKLEFT,
	VULCANSTATION,
	VULCANBIRD,
	STAGE2ENDBOSS,
	WARNING
};

const unsigned char stage7spriteslist[]=
{
	MONSTERBLOB,
	MONSTERHEAD,
	MONSTERMISSILLEFT,
	STAGE7MIDDLEBOSS,
	STAGE7ENDBOSS,
	WARNING
};

const unsigned char stage5spriteslist[]=
{
	WW2ZEPPELIN,
	WW2SHIP,
	WW2PLANE_TYPE_A,
	WW2TANKLEFT,
	STAGE5ENDBOSS,
	WARNING
};

const unsigned char stage4spriteslist[]=
{
	WAVESHIP,
	RECTSHIP,
	TURNSHIP,
	BOMBSHIPLEFT,
	SPREADSHIP,
	STAGE4MIDDLEBOSS,
	STAGE4ENDBOSS,
	WARNING,
	STAGE4ENDBOSSB,
	STAGE4ENDBOSSC
};


// ORIGINAL...
const unsigned char stage6spriteslist[]=
{
	STAGE6ENDBOSS,
	SKULLBONEA,
	VULCANLASER
};

const unsigned char stage6script[]=
{
	30,SCRIPT_INITENEMY,STAGE6ENDBOSS,108,0,
	31,SCRIPT_END,0,0,0
};

const unsigned char stage6scriptb[]=
{
	30,SCRIPT_INITENEMY,STAGE6ENDBOSSB,108,224-56,
	31,SCRIPT_END,0,0,0
};


