// Check collision with playershoot
unsigned char checkEnemyPlayerShoot(enemy *en, playershoot *ps)
{
	if((en->enemyposy<ps->playershooty+12)
	   &&(en->enemyposy+en->enemyheight>ps->playershooty)
	   &&(en->enemyposx<ps->playershootx+16)
	   &&(en->enemyposx+en->enemywidth>ps->playershootx))
       return 1;
	return 0;
}

// Get energy for boss
unsigned char GetBossEnergy(unsigned char p)
{
	return p+(gamelevel==0?0:30);
}

// Get direction to player
void GetEnemyDirection(enemy *en)
{
	signed int dx,dy,dm;
	
	// Better granularity although faster enemy shoots
	dx=playerx-en->enemyposx;
	dy=playery-en->enemyposy;
	dm=abs(dx)+abs(dy);
	dx*=3;
	dy*=3;
	dx/=dm;
	dy/=dm;
	
	en->enemyparama=dx;
	en->enemyparamb=dy;
}

// Remove enemy
void RemoveEnemy(signed char a)
{
	enemy *ea,*eb;
	
	// Remove list of sprites
	if(a<numenemies-1)
	{
		ea=&enemies[a];
		eb=&enemies[numenemies-1];
		
		ea->enemyposx=eb->enemyposx;
		ea->enemyposy=eb->enemyposy;
		ea->enemytype=eb->enemytype;			
		ea->enemyframe=eb->enemyframe;	
		ea->enemyparama=eb->enemyparama;	
		ea->enemyparamb=eb->enemyparamb;	
		ea->enemyenergy=eb->enemyenergy;
		ea->enemywidth=eb->enemywidth;
		ea->enemyheight=eb->enemyheight;
	}
	// Bajamos el numero de enemys
	if(numenemies>0)numenemies--;
}

void KillEnemy(unsigned char a)
{
	enemy *en;
	unsigned char t;
	
	// Security check
	if(a>=numenemies)return;
	
	// Get enemy
	en=&enemies[a];
	
	// Type of explosion
	if(en->enemywidth<=17)
		InitExplosion(en->enemyposx,en->enemyposy,1);
	else
		InitSpawnedExplosion(en->enemyposx,en->enemyposy,en->enemywidth,en->enemyheight);

	// Get enemy type
	t=en->enemytype;
	
	// Remove
	RemoveEnemy(a);	

	// Custom remove
	switch(t)
	{
		case STAGE1ENDBOSS:
		case STAGE2ENDBOSS:
		case STAGE3ENDBOSS:
		case STAGE3ENDBOSSB:
		case STAGE4ENDBOSS:
		case STAGE4ENDBOSSC:
		case STAGE5ENDBOSS:
		case STAGE7ENDBOSS:		
		case STAGE6ENDBOSSB:
			InitAfterBossStage();
		break;
		case STAGE6ENDBOSS:
			FinishStage6EndBoss();
		break;
		case STAGE7MIDDLEBOSS:
			FinishStage7MiddleBoss();
		break;
		case SPACESTATION:
			FinishSpaceStation();
		break;
		case VULCANSTATION:
			FinishVulcanStation();
		break;
		case STAGE1MIDDLEBOSS:
			FinishStage1MiddleBoss();
		break;
		case STAGE4MIDDLEBOSS:
			FinishStage4MiddleBoss();
		break;
	}
}

void KillEnemies(unsigned char force)
{
	signed char a;
	
	if(numenemies>0)
		for(a=numenemies-1;a>=0;a--)
			if((force==1)||(enemies[a].enemywidth<=16))
				KillEnemy(a);
}


				
// Update enemy
void UpdateEnemy(unsigned char a)
{
	unsigned char erase;
	enemy *en;
	playershoot *ps;
	
	// Security check
	if(a>=numenemies)return;
	
	// Get enemy
	en=&enemies[a];
	
	// By defect
	erase=1;
	
	// Update
	if(updateenemyfunctions[en->enemytype]!=0)
		erase=(*(updateenemyfunctions[en->enemytype]))(en);
	
	// View if have to erase
	if(erase==0)
		RemoveEnemy(a);
	else
	{
		// Increase counter
		en->enemyframe++;	
		
		// Collision with player shoot	
		if(a%2==stageframe4mod>>1)
		{
			if(numplayershoots>0)
			{
				for(signed char b=numplayershoots-1;b>=0;b--)
				{
					ps=&playershoots[b];
					if(checkEnemyPlayerShoot(en,ps)==1)
					{
						en->enemyenergy--;
						if(en->enemyenergy==0)
							KillEnemy(a);
						else 
							InitExplosion(ps->playershootx,ps->playershooty,0);
					
						// Remove in all cases
						RemovePlayershoot(b);
						
						// No more collisions
						return;
					}		
				}
			}
		}
	}
}

// Update all enemys
void UpdateEnemies()
{
	signed char q;
	
	// Need change here, by consensus
	changeBank(FIXEDBANKSLOT);

	// For each enemy
	if(numenemies>0)
		for(q=numenemies-1;q>=0;q--)
			UpdateEnemy(q);
}

// Create a enemy
void InitEnemy(unsigned char x, unsigned char y,unsigned char t)
{
	enemy *en;
	
	if(numenemies<MAXENEMIES)
	{
		// Get enemy
		en=&enemies[numenemies];
		
		// Data
		en->enemyposx=x;
		en->enemyposy=y;
		en->enemytype=t;
		en->enemyframe=0;
		en->enemyenergy=1;
		en->enemyparama=0;
		en->enemyparamb=0;
		en->enemywidth=16;
		en->enemyheight=16;

		// Increase
		numenemies++;
		
		// Init
		if(initenemyfunctions[t]!=0)
			(*(initenemyfunctions[t]))(en);
	}		
}

// Init all enemys
void InitEnemies()
{
	numenemies=0;
}

