.ifndef __MENU_ASM__
.define __MENU_ASM__

.include "decompressors.inc"
.include "bossSelection.asm"

.define ballsBuffer tempVars
.define BackgroundDinamicPalEntries 4
.define SpriteDinamicPalEntries 4
 
.section "menu.palettes" free

menu.backgroundPalette:	
	.db $01 $00 $3f $39 $3C $2B $34 $39 
menu.backgroundPaletteEnd:
menu.spritePalette:	
	.db $39 $3f $00 $3f $03
menu.spritePaletteEnd:	
.ends

.section "menu.startPasswordText" free
menu.startPasswordText:
	.byte 8
	.word $3ada | VramWrite
	.word endSeqOuti - 8*4
	.asc "START   "
	
	.byte 8
	.word $3b5a | VramWrite
	.word endSeqOuti - 8*4
	.asc "PASSWORD"
	
menu.passwordFailText:	
	.byte 8
	.word $3ada | VramWrite
	.word endSeqOuti - 8*4
	.asc "PASSWORD"
	
	.byte 7
	.word $3b5a | VramWrite
	.word endSeqOuti - 7*4
	.asc "ERROR !"
.ends

.section "menu.clearPalette" free
menu.clearPalette:
	xor a
	ld b, 32
	ld hl, hasNewPalette
	inc (hl)
	inc l
	
-:		ld (hl), a
		inc l
	djnz -
	ret
.ends

.section "menu.loadTiles" free
menu.loadTiles:
	decompress menuTiles, $2020, menuTilesCount
	decompress openingSpritesTiles + arrowTile, $03E0, 1
	
	decompress alphabetTiles.1 + alphabetTiles, $0400 + passwordMenuTilesSize, 5
	decompress alphabetTiles.A + alphabetTiles, $0400 + passwordMenuTilesSize + 32*5, 5
	
	ld b, 80
	ld a, passwordMenuTilesSize
	out (VdpControlPort), a
	ld a, $04 | VramWrite.hi
	out (VdpControlPort), a
-:		
		in a, (VdpDataPort)
		ld a, $ff
		out (VdpDataPort), a 
		in a, (VdpDataPort)
		in a, (VdpDataPort)
	djnz -
	jumpDecompress passwordMenuTiles, $0400, passwordMenuTilesCount
	
.ends

;hl text address
;b number of lines
;c : $ff
.section "menu.loadText" free
menu.loadText:
--:		push bc
		ld a, 1
		ld de, vramRaw.haveData		
		ld (de), a
		inc e
		ld b, (hl)
		inc hl
		fastLdir 4
-:			ldi
			ld (de), a
			inc e
		djnz -
		push hl
		call prepareForVblank
		pop hl
		pop bc
	djnz --
	ret
.ends

.section "menu.passPositionTable" align $100 free
menu.passPositionTable:
	.db 0*16, 4*16, 1*16, 0*16
	.db 1*16, 0*16, 2*16, 1*16
	.db 2*16, 1*16, 3*16, 0*16
	.db 3*16, 2*16, 4*16, 3*16
	.db 4*16, 3*16, 0*16, 4*16
.ends

;d: most significant part of the table address
;b: number of right shifts on + 2
.section "menu.updateCursorPosition" free
menu.updateCursorPosition:
	ld hl, objectTable.2.y
	cp (UKey | DKey) + 1
	jr c, +
		ld l, <objectTable.2.x
		rra
		rra
		and %00000011
+:	ld e, a
	ld a, (hl)
-:		rrca
	djnz -
	or e
	ld e, a
	ld a, (de)
	ld (hl), a
	ret
.ends

.macro menu.loadPasswordSprites
	ld a, objects.passMenu.general
	ld (objectTable.1.objType), a
	ld a, objects.passMenu.cursor
	ld (objectTable.2.objType), a
	call objectsToSprites
.endm

.macro menu.passwordBallPositioning
	; get mask
	ld a, (hl)
	.rept 4
		add a, a
	.endr
	sbc a, a
	ld h, a
	
	;get byte
	ld de, objectTable.2.y
	ld a, (de)
	.rept 4
		rrca
	.endr
	ld l, a
	dec e
	dec e
	;get bit
	ld a, (de)
	ld bc, (16 << 8) | %10000000
	add a, b
menu.passwordBallPositioningUnrollBits:
		rlc c
		sub b
	jr nz, menu.passwordBallPositioningUnrollBits
	
	ld d, h
	ld h, >ballsBuffer
	
	ld a, (hl)
	xor d
	or c
	xor d
	cp (hl)
	ld (hl), a
	
.endm

.macro menu.ballsBufferToObjects
	ld hl, objectTable.3.objType
	ld de, _sizeof_object
	ld bc, 9 << 8
	push hl
-: 		ld (hl), c
		add hl, de
	djnz -
	
	pop iy
	ld hl, ballsBuffer + 4
--:		ld bc, (4 << 12)|(1 << 4)
-:			ld a, (hl)
			and c
			jr z, +
				ld (iy + object.objType), objects.passMenu.ball
				ld (iy + object.x), b
				ld a, l
				.rept 4
					add a, a
				.endr
				ld (iy + object.y), a
				add iy, de
+:			srl c
			ld a, b
			sub 16
			ld b, a
		jr nc, -
		dec l
	jp p, --	
.endm

.section "menu.updateBallCounter" free
menu.updateBallCounterRawDataInit:
	.db $01 
	.dw VramWrite | $05e0, endSeqOuti - 64
menu.updateBallCounter:
	ld bc, (64 << 8) | (VdpDataPort + 5)
	ld e, a
	.rept 5
		add a, a
	.endr
	add a, $c0
	out (VdpControlPort), a
	ld a, $31
	bit 3, e ;the original value is 8 or 9, so the carry flag will ocur in the last add a, a
	jr nz, +
	jr nc, ++
+:		inc a
++:	out (VdpControlPort), a
	
	ld de, vramRaw.haveData
	ld hl, menu.updateBallCounterRawDataInit
	fastLdir 5
	ex de, hl
-:		ini
	djnz -	
	ret
.ends

.define cursorColor (tempVars + 5)
.section "menu.passCursorColors" align $100 free
menu.passCursorColors:
	.db $00 $15 $2a $3f $3f $3f $2a $15
.ends
.macro menu.animatePassCursor
	ld hl, hasNewPalette
	inc (hl)
	
	ld l, <(palette + 17)
	xor a
	or ixh
	jr z, ++
		ld de, cursorColor
		ld a, (de)
		inc a
		and %00001111
+:		ld (de), a
		ld d, >menu.passCursorColors
		rra
		ld e, a
		ld a, (de)
++:	ld (hl), a	
.endm

;hl: address of the expected boss position in the buffer
;zf: if the boss is present, the flag will return != 0
.section "menu.isBossPresent" free
menu.isBossPresent:
	ld a, (hl)
	push bc
	ld c, a
	rlca
	rlca
	rlca
	ld e, a
	ld d, >ballsBuffer
	ld a, c
	and %00011111
	ld b, ixl
	inc b
	rrca
-:		rlca
		cp %00100000
		jr nz, +
		ld a, 1
		inc e
+:	djnz -
	ld c, a
	ld a, %00000011
	and e
	inc a
	ld e, a
	ld a, (de)
	and c
	pop bc
	ret	
.ends

; returns:
; c: bosses
; ixl: eTanks
.section "menu.bossesExpectedPositions" free
menu.bossesExpectedPositions:
	.db ((1 << 5) | (1 << 2)), ((2 << 5) | (1 << 0)); bubbleman
	.db ((2 << 5) | (1 << 1)), ((3 << 5) | (1 << 2)); airman
	.db ((1 << 5) | (1 << 3)), ((0 << 5) | (1 << 3)); quickman
	.db ((2 << 5) | (1 << 4)), ((0 << 5) | (1 << 1)); heatman
	.db ((0 << 5) | (1 << 4)), ((2 << 5) | (1 << 2)); woodman
	.db ((3 << 5) | (1 << 0)), ((3 << 5) | (1 << 4)); metalman
	.db ((3 << 5) | (1 << 3)), ((1 << 5) | (1 << 0)); flashman
	.db ((3 << 5) | (1 << 1)), ((1 << 5) | (1 << 4)); crashman
.ends

; \1: jump location when the password is correct
.macro menu.validadePassword
	ld hl, menu.bossesExpectedPositions
	ld c, $ff ; numETanks
	
	ld a, (ballsBuffer)
-:		inc c
		srl a
	jr nz, -		
	ld ixl, c		
	ld bc, 1		;b: bosses beat´n, c: mask

-:		call menu.isBossPresent
		inc hl
		jr nz, +
		call menu.isBossPresent
		jp z, ++
			ld a, c
			add a, b
			ld b, a
+:			inc hl
		sla c
	jr nz, -
	jp \1
++:	
.endm


.macro menu.passwordMenu
	ld hl, ballsBuffer + 6
	xor a
-:		dec l
		ld (hl), a
	jr nz, -	
	call menu.fadeOutContent
	call clearObjectTable
	ld hl, passwordMenuMap
	call menu.loadScrollingLeft
	menu.loadPasswordSprites
	ld a, 9
	call menu.updateBallCounter
	call menu.fadeInContent
	ld hl, pressedKeys
	ld ix, (9 << 8) | $19
menu.passwordMainLoop:	
		ld a, UKey | DKey | LKey | RKey
		and (hl)
		jr nz, menu.updateCursorPositionJp
		
		ld a, BKey | CKey
		and (hl)
		jr z, menu.passCheckDpadHolded
		menu.passwordBallPositioning
		jr z, menu.passResetTimer
		ld a, d
		add a, a
		inc a
		neg
		add a, ixh
		ld ixh, a
		call menu.updateBallCounter
		jr menu.passResetTimer
menu.passCheckDpadHolded:	
		ld l, <holdedKeys
		ld a, UKey | DKey | LKey | RKey
		and (hl)
		jr z, menu.passResetTimer
		
		dec ixl
		jr nz, menu.ballsBufferToObjects
		ld ixl, $19 - 8
menu.updateCursorPositionJp:
		ld d, >menu.passPositionTable
		ld b, 2
		call menu.updateCursorPosition
		jr menu.ballsBufferToObjects
menu.passResetTimer:		
		ld ixl, $19
		ld l, <pressedKeys
		
menu.ballsBufferToObjects:	
		menu.animatePassCursor
		menu.ballsBufferToObjects
		call objectsToSprites
		call prepareForVblank
		
		xor a
		cp ixh
	jp nz, menu.passwordMainLoop
menu.validadePassword:
	menu.validadePassword menu.passwordHit
	call menu.cleanAndFade
	
	ld hl, startPasswordMenuMapEnd
	call menu.loadScrollingRight
	ld hl, menu.passwordFailText
	ld bc, (2 << 8) | $ff
	call menu.loadText
	call menu.fadeInContent
	call menu.delay
	call menu.fadeOutContent
	ld hl, menu.startPasswordText
	ld bc, (2 << 8) | $ff
	call menu.loadText
	call menu.fadeInContent
	jp menu.startPasswordMenuLoop
menu.passwordHit:
	menu.passwordHit
	call menu.delay
.endm	

.section "menu.delay" free
menu.delay:
	ld b, $7d
-:		push bc
		call prepareForVblank
		pop bc
	djnz -
	ret
.ends

.section "menu.cleanAndFade" free
menu.cleanAndFade:
	call menu.delay
	call menu.fadeOutContent
	call clearObjectTable
	jp prepareForVblank ; call + ret
	
.ends


; b: bosses beaten
; ixl: num etanks 
.section "menu.passwordHitText" free
menu.passwordHitText:
	.byte 1
	.word $3ad6 | VramWrite
	.word endSeqOuti - 8*4
	.word $0198
	.word $01A8
	.asc " B A Q H W M F C 1 2 3"
.ends
.macro menu.passwordHit
	ld c, 0
	ld a, Item1Boss ; HeatMan
	and b
	.if 1 == Item1Boss
		add a, c
		ld c, a
	.else
		jr z, +
			inc c
	.endif
+:	ld a, Item2Boss ; AirMan
	and b
	.if 2 == Item2Boss
		add a, c
		ld c, a
	.else
		jr z, +
			set 1, c
	.endif
+:	ld a, Item3Boss ;FlashMan
	and b
	.if 4 == Item3Boss
		add a, c
		ld c, a
	.else
		jr z, +
			set 2, c
	.endif
+:
	ld hl, numEtanks
	ld e, ixl
	ld (hl), e  ;numEtanks
	inc l
	ld (hl), b  ; bossesBeaten
	inc l
	ld (hl), c  ; itens
	push bc
	call menu.cleanAndFade
	
	ld hl, passwordHitMap
	call menu.loadScrollingLeft

	ld hl, menu.passwordHitText
	ld de, vramRaw.haveData
	fastLdir 7
	push hl
	ld hl, vramRaw.buffer
	fastLdir 46
	pop hl
	ld e, <vramRaw.buffer + 2
	fastLdir 2
	
	pop ix
	ld a, ixh 
	ld bc, (8 << 8) | (16 + 1 + 6 + 1)
	
-:			rra
			jr c, +
				ldi
				inc hl
				dec c
				inc e
				inc e
			jr ++
+:				ldi
				inc e
				ldi
++:				inc e
			djnz -
	
		ld a, ixl
		ld b, 3
		dec c
	jr nz, -

	ld bc, (3 << 8)| $ff
-		push bc
		call prepareForVblank
		ld hl, vramRaw.haveData
		inc (hl)
		inc l
		ld a, 128
		add a, (hl)
		ld (hl), a
		inc l
		jr nc, +
			inc (hl)
+:		ld de, vramRaw.buffer
		ld hl, vramRaw.buffer + 16
		fastLdir 32
		pop bc
	djnz -	
	ld hl, vramRaw.haveData
	ld (hl), b
	call menu.fadeInContent
.endm

.macro menu.startPassword
	ld hl, startPasswordMenuMap
	call menu.loadDirectly
	call menu.loadTiles
	call clearObjectTable
	
	ld hl, menu.backgroundPalette
	ld de, hasNewPalette
	fastLdir 8
	xor a
	ld (palette + 1), a
	
	ld hl, menu.spritePalette
	ld de, palette + 16
	fastLdir 5
	
	ld a, (resolutionDependencies.introTextScroll)
	add a, 16
	ld (verticalScroll + 1), a
	
	call turnOnVdp
	
	ld bc, (2 << 8) | $ff
	ld hl, menu.startPasswordText
	call menu.loadText
	
	ld hl, hasNewPalette
	inc (hl)
	inc l
	inc l
	ld (hl), $3f

menu.startPasswordMenuLoop:	
	ld hl, objectTable.1.objType
	ld de, $60 | (objects.startPassMenu.arrow << 8)
	ld (hl), d
-:		ld a, (frameCounter)
		and $08
		ld a, $f0
		jr z, +
			ld a, e
+:		ld (objectTable.1.y), a
		
		push de
		call objectsToSprites
		call prepareForVblank
		pop de
		ld a, (hl)
		and StartKey | BKey | UKey | DKey
		jr z, -
		and StartKey | BKey
		jr nz, +
			ld a, ($60 + $70) & $ff
			sub e
			ld e, a
	jr -

+:  ld a, $60
	cp e
	jp z, endStartMenu
		menu.passwordMenu
endStartMenu:
	
.endm

.section "menu.fadeOutContent" free
menu.fadeOutContent:
	ld bc, (16 << 8) | %00000011 
-:		ld a, c
		and b
		push bc
		jr nz, +
			ld hl, hasNewPalette
			inc (hl)
			inc l
			inc l
			ld hl, palette
			ld b, BackgroundDinamicPalEntries
			call fadeOutPalette
			ld l, (<palette) + 17
			ld b, SpriteDinamicPalEntries
			call fadeOutPalette
+:		call prepareForVblank
		pop bc
	djnz -
	ret	
.ends

.section "menu.fadeInContent" free
menu.fadeInContent:
	ld b, 4
-:		push bc
		call prepareForVblank
		pop bc
		ld a, (frameCounter)
		and %00000011
		jr nz, -
			ld hl, hasNewPalette
			inc (hl)
			inc l
			ld de, menu.backgroundPalette+1
			ex de, hl
			push bc
			ld c, b
			ld b, BackgroundDinamicPalEntries
			call fadeInPalette
			ld hl, menu.spritePalette + 1
			ld de, palette + 17
			pop bc
			push bc
			ld c, b
			ld b, SpriteDinamicPalEntries
			call fadeInPalette
			pop bc
	djnz -
	call prepareForVblank
	ret
.ends

;hl:menu's first column address
.section "menu.loadDirectly" free
menu.loadDirectly:	
	call turnOffVdp
	ld a, $ff
	ld (column.columnAddress), a
	
	ld bc, 16 << 8
--:		push bc
		call depackMenuColumns
		push hl
		
		ld bc, 2 << 8 | VdpDataPort
-:			push bc
			ld hl, column.columnAddress
			inc (hl)
			call outputColumn
			
			ld de, column.buffer
			fastLdir 2*VramRowCount
			pop bc
		djnz -	
		
		pop hl
		pop bc
	djnz --
	jp turnOnVdp ;call turnOnVdp
				 ;ret
.ends

;hl:menu's first column address
.section "menu.loadScrollingLeft" free
menu.loadScrollingLeft:	
	ld a, $ff
	ld (column.columnAddress), a
	
	ld bc, <columnOrientation.left | (16 << 8) 
--:		push bc
		call depackMenuColumns
		push hl
		
		ld b, 2
-:			push bc
			ld hl, column.hasNewColumn
			inc (hl)
			inc l
			inc (hl)
			
			ld hl, horizontalScroll + 1			
			ld a, (hl)
			sub 8
			ld (hl), a
			.rept 3
				call prepareForVblank
			.endr
			
			ld hl, column.buffer + VramRowCount*2
			ld de, column.buffer
			fastLdir 2*VramRowCount
			pop bc
		djnz -
		
		pop hl
		pop bc
	djnz --
	ret
.ends

;hl:menu's first column address
.section "menu.loadScrollingRight" free
menu.loadScrollingRight:	
	ld a, VramColumnCount
	ld (column.columnAddress), a
	
	ld bc, <columnOrientation.right | (16 << 8)
--:		push bc
		inc hl
-:			dec hl
			dec hl
			ld a, %00001111
			cp (hl)
		jp c, -
		
		push hl
		call depackMenuColumns
		
		ld b, 2
-:			push bc
			ld hl, column.hasNewColumn
			inc (hl)
			inc l
			dec (hl)
			
			ld hl, horizontalScroll + 1
			ld a, (hl)
			add a, 8
			ld (hl), a
			.rept 3
				call prepareForVblank
			.endr
			ld hl, column.buffer + VramRowCount*2
			ld de, column.buffer
			fastLdir 2*VramRowCount
			pop bc
		djnz -

		pop hl
		
		pop bc
	djnz --
	ret
.ends

.endif