.macro fastOtir args count
  .if count == 256
    call endSeqOuti - 256*2
  .else
    .if count > 256
      ld b, count >> 8
fastOtirLoop:
      call endSeqOuti - 256*2
      djnz fastOtirLoop
    .endif
    .if count & $00ff != 0
      call endSeqOuti - (count & $00ff)*2
    .endif
  .endif
.endm

.macro jpFastOtir args count
  .if count == 256
    jp endSeqOuti - 256*2
  .else
    .if count > 256
      ld b, count >> 8
fastOtirLoop:
      jp endSeqOuti - 256*2
      djnz fastOtirLoop
    .endif
    .if count & $00ff != 0
      jp endSeqOuti - (count & $00ff)*2
    .endif
  .endif
.endm

.macro fastLdir args count
  .if count == 256
    call endSeqLdi - 256*2
  .else
    .if count > 256
      ld b, count >> 8
fastLdirLoop:
      call endSeqLdi - 256*2
      djnz fastLdirLoop
    .endif
    .if count & $00ff != 0
      call endSeqLdi - (count & $00ff)*2
    .endif
  .endif
.endm


.macro jpfastLdir args count
  .if count == 256
    jp endSeqLdi - 256*2
  .else
    .if count > 256
      ld b, count >> 8
fastLdirLoop:
      jp endSeqLdi - 256*2
      djnz fastLdirLoop
    .endif
    .if count & $00ff != 0
      jp endSeqLdi - (count & $00ff)*2
    .endif
  .endif
.endm

.macro jumpDe
  push de
  ret
.endm

.bank 0 slot 0
.section "seqOuti" free
  .rept 256
    outi
  .endr
endSeqOuti:
  ret
.ends

.section "seqLdi" free
  .rept 256
    ldi
  .endr
endSeqLdi:
  ret
.ends

.section "callDe" free
callDe:  
  jumpDe
.ends