.ifndef __GRAPHICS__
.define __GRAPHICS__

.include "bossAttributes.inc"

.bank 15 slot 2

.define megamanSteadTempTilesCount 17
.define megamanSteadTempTilesBank 15
.section "megamanSteadTempTiles" free
megamanSteadTempTiles:
	.incbin "imagens\megamanSteadTemp.psgcompr" skip 2
.ends

.include "imagens\alphabet.indexes.inc"
.define alphabetTilesCount 42
.define alphabetTilesSize alphabetTilesCount*32
.define alphabetTiles.A alphabetTiles.11
.define alphabetTilesBank 15
.section "alphabetTiles" free
alphabetTiles:
	.incbin "imagens\alphabet.psgcompr" skip 2
.ends

.define bossSelectionTilesCount 19
.define bossSelectionTilesSize bossSelectionTilesCount*32
.define bossSelectionTilesBank 15
.section "bossSelectionTiles" free
bossSelectionTiles:
	.incbin "imagens\bossSelection.psgcompr" skip 2
.ends

.define bossFacesTilesCount 144
.define bossFacesTilesSize bossSelectionTilesCount*32
.define bossFacesTilesBank 15
.section "bossFacesTiles" free
bossFacesTiles:
	.incbin "imagens\bossFaces.psgcompr" skip 2
.ends

.define openingTilesCount 268
.define openingTilesSize openingTilesCount*32
.define openingTilesBank 15
.section "openingTiles" free
openingTiles:
	.incbin "imagens\opening.psgcompr" skip 2
.ends

.include "imagens\openingSprites.indexes.inc"
.define openingSpritesTilesCount 24
.define openingSpritesTilesSize openingSpritesTilesCount*32
.define arrowTile openingSpritesTiles.14
.define openingSpriteTilesBank 15
.section "openingSpritesTiles" free
openingSpritesTiles:
	.incbin "imagens\openingSprites.psgcompr" skip 2
.ends

.define menuTilesCount 18
.define menuTilesSize menuTilesCount*32
.define menuTilesBank 15
.section "menuTiles" free
menuTiles:
	.incbin "imagens\menu.psgcompr" skip 2
.ends

.define passwordMenuTilesCount 5
.define passwordMenuTilesSize passwordMenuTilesCount*32
.define passwordMenuTilesBank 15
.section "passwordMenuTiles" free
passwordMenuTiles:
	.incbin "imagens\passwordMenu.psgcompr" skip 2
.ends

.define openingMapBank 15
.section "openingMap" free
openingMap:
	.include "maps\openingMap.inc"
.ends

.define bossSelectionMapBank 15
.include "maps\bossSelectionMap.inc"


.bank 15 slot 2
.define bubbleManTilesCount 94*2
.define bubbleManTilesSize bubbleManTilesCount*32
.define bubbleManTilesBank 15
.section "bubbleMan" free
bubbleManPalette:
	.db $08 $00 $00 $00 $00 $00 $00 $00
bubbleManIntroText:
	.asc "BUBBLEMAN"
	
bubbleManBossTimers:
	.db 31, (bubbleMan.anim + 5), bubbleMan.anim  
	.incbin "imagens\bubbleman.m.psgcompr" skip 2
.ends

.endif