.ifndef __BOSS_SELECTION_ASM__
.define __BOSS_SELECTION_ASM__

.include "bossAttributes.inc"
.bank 2 slot 1

.define bossSelection.palette.size 1 + 17
.section "bossSelection.palette" free
bossSelection.palette:
	.db $01
	.db	$34 $3F $00 $3C $1B $02 $13 $17 $2B $08 $2F $0E $07 $00 $00 $00
	.db	$34
bossSelection.blinkPalette:	
	.db $01
	.db	$2a $3F $3F $3F $3F $2a $3F $2a $3F $2a $3F $3F $2a $3F $3F $3f
	.db	$2a
	
.ends

.section "bossSelection.text" free
bossSelection.text:
	.db 11
	.db 16
	.dw  VramWrite | $3852
	.asc " PRESS  START "
	.db 8
	.dw  VramWrite | $3a0a
	.asc "BUBBLE"
	.db 5
	.dw  VramWrite | $3a1c
	.asc "AIR"
	.db 7
	.dw  VramWrite | $3a2a
	.asc "QUICK"
	.db 6
	.dw  VramWrite | $3c0a
	.asc "HEAT"
	.db 5
	.dw  VramWrite | $3c1c
	.asc "Dr."
	.db 6
	.dw  VramWrite | $3c2a
	.asc "WOOD"
	.db 6
	.dw  VramWrite | $3c5e
	.asc "WILY"
	.db 7
	.dw  VramWrite | $3e0a
	.asc "METAL"
	.db 7
	.dw  VramWrite | $3e1a
	.asc "FLASH"		
	.db 7
	.dw  VramWrite | $3e2a
	.asc "CRASH"		
	
.ends

.section "bossSelection.cursorPosition" align $100 free
bossSelection.cursorPosition:
	.db 0*64, 0*64, 1*64, 0*64
	.db 1*64, 0*64, 2*64, 1*64
	.db 2*64, 1*64, 2*64, 2*64
.ends

.macro bossSelection.loadMap
	ld hl, column.columnAddress
	ld (hl), 32
	inc l
	ld bc, $0198
	call bossSelection.loadTileToColumn
	fastLdir 27*2
	
	ld de, 6
	
	ld hl, column.buffer + 2
	ld (hl), e
	inc l
	ld (hl), d
	
	ld l,  <column.buffer + 54
	ld (hl), e
	inc l
	ld (hl), d
	
	ld hl, bossSelectionMapLastColumn
---:	ld de, column.buffer + 4 ;put the destination pointer back to the begining
		push hl	;save the global origin pointer
		ld l, (hl)
		
		ld c, 27 ;load counter 3 + 3*8(number of entries)
--:			push hl
			ld b, 8
-:				ld a, (hl)
				rla
				rla
				and 1
				
				ldi
				ld (de), a
				inc e
			djnz -
			pop hl
			dec c
		jr nz, --
		
		ld c, VdpDataPort
		ld hl, column.columnAddress
		dec (hl)
		call outputColumn
		pop hl
		dec l
	jp p, ---

.endm

.macro bossSelection.loadBossFace
	push af
	ld a, 1
	ld e, 4
--:		ld c, VdpControlPort
		out (c), l
		out (c), h
		dec c
	
		ld b, 4
-:			out (c), d	
			inc d
			out (VdpDataPort), a
		djnz -
		ld c, 64
		add hl, bc
		dec e
	jr nz, --
	pop af
.endm


; \1 address to jump in case the cursor is over wili logo
; return:
;  a: least significant part
.section "cursorPositionToAddressTable" align $100 free
cursorPositionToAddressTable:
	.db	$01 bubbleManTilesBank
	.dw bubbleManPalette
	.db $02 
	.db 0 0 0
	.db $04
	.db 0 0 0	
	.db $08 
	.db 0 0 0
	.db $10
	.db 0 0 0
	.db $20
	.db 0 0 0
	.db $40
	.db 0 0 0
	.db $80
	.db 0 0 0
.ends
.macro cursorPostionToAddress
teste:
	ld hl, objectTable.2.y
	ld a, (hl)
	rlca
	rlca
	ld b, a
	rlca		; multiply by 2
	add a, b 	; multiply by 3
	ld b, a
	ld l, <objectTable.2.x
	ld a, (hl)
	rlca
	rlca
	add a, b
	cp $04
	jp z, \1
	jp m, cursorPostionToAddress.ignoreDec
		dec a
cursorPostionToAddress.ignoreDec:
	rlca
	rlca
	ld l, a
	ld h, >cursorPositionToAddressTable
.endm

;hl: position in the column buffer
;bc: name table entry
;return:
;de: will be positioned two positions ahead of hl
;hl will be preserved
.section "bossSelection.loadTileToColumn" free
bossSelection.loadTileToColumn:
	ld (hl), c
	inc l
	ld (hl), b
	ld d, h
	ld e, l
	dec l
	inc e
	ret
.ends

.define bossIntroText tempVars
.define bossTimers tempVars + 9
.macro loadBossIntroScreen
	ld a, (hl)
	ld (mapperSlot2), a
	inc l
	ld e, (hl)
	inc l
	ld d, (hl)
	
	
	ld hl, palette + 24
	ex de, hl
	fastLdir 8
	
	ld de, bossIntroText
	fastLdir 11
	ld a, (hl)
	ld (objectTable.2.objType), a
	inc hl
	
	ex de, hl
	
	ld ixl, e
	ld ixh, d
	
	ld hl, VramWrite | (20*32)
	ld (tileDecompVramPtr),hl 
	
	call clearSpriteTable
	call prepareForVblank

	ld b, $34
-:		push bc
		ld a, %00000011
		and b
		jr nz, ++
			ld hl, bossSelection.blinkPalette
			ld a, %00000100
			and b
			jr nz, +
				ld hl, bossSelection.palette
+:			ld de, hasNewPalette
			fastLdir bossSelection.palette.size
++:		call decompressSingleTile
		inc ix		; skip the mirrored tiles
		call prepareForVblank
		pop bc
	djnz -
	
	call turnOffVdp
	ld hl, column.buffer
	ld bc, 02
	call bossSelection.loadTileToColumn
	fastLdir 55
	
	ld l, <column.buffer + 20
	ld bc, $0198
	call bossSelection.loadTileToColumn
	fastLdir 10
	
	ld a, $0c
	ld (column.buffer + 18), a
	ld a, $0e 
	ld (column.buffer + 32), a
	ld bc, (31 << 8) | VdpDataPort
-:		push bc
		ld hl, column.columnAddress
		ld (hl), b
		call outputColumn
		pop bc
		dec	b
	jp p, -	
	
	call turnOnVdp
	ld hl, hasNewPalette
	inc (hl)
	inc l
	xor a
	ld bc, $343c
	ld (hl), c
	ld l, <palette + 2
	ld (hl), a
	inc l
	ld (hl), b
	ld l, <palette + 16
	ld (hl), a
	ld l, <palette + 19
	ld (hl), a
	
	ld b, $18
-:		push bc
		call prepareForVblank
		pop bc
	djnz -	

	ld hl, objectTable.2.y
	ld (hl), $20
	ld l, <objectTable.2.x
	ld (hl), $80

	ld b, $0b
-:		push bc
		ld de, objectTable.2.y
		ld a, (de)
		add a, 8
		ld (de), a
		ld e, <objectTable.2.frameTimer
		xor a
		ld (de), a
		call animateBossIntro
		call prepareForVblank
		pop bc
	djnz -
	
	ld de, _sizeof_object
	ld a, objects.bossIntro.stars
	ld hl, objectTable.3.objType
	ld b, 3
	
-:		ld (hl), a
		add hl, de
		inc a
	djnz -
	
	ld c, 4
	
--:		ld b, 8
		ld a, 1
		cp c
		jr nz, +
			ld b, 13*8
+:		ld hl, hasNewPalette
		inc (hl)
		ld l, <palette + 19
		ex de, hl
		ld hl, bossSelection.blinkPalette + 2
		push bc
		ld b,  1
		call fadeInPalette
		pop bc
-:			push bc
			call animateStars
			call prepareForVblank
			pop bc
		djnz -
		dec c
	jr nz, --
	
	ld b, $50
	call bossSelection.animateBframes
		
	ld hl, vramRaw.destiny
	ld de, $3bd4 | VramWrite
	ld (hl), e
	inc l
	ld (hl), d
	inc l
	ld de, endSeqOuti - 2*2
	ld (hl), e
	inc l
	ld (hl), d
	inc hl
	inc l
	ld (hl), 1
	
	ld c, 9
	ld hl, bossIntroText 
		
--:		ld b, 4
		ld a, (hl)
		inc l
		ld (vramRaw.buffer), a
		push hl
		ld hl, vramRaw.haveData
		inc (hl)
		ld l, <vramRaw.destiny
		inc (hl)
		inc (hl)
		pop hl
-:			push hl
			push bc
			call animateStars
			call prepareForVblank
			pop bc
			pop hl
		djnz -
		dec c
	jr nz, --
	
	ld b, $bf
	call bossSelection.animateBframes
	
.endm

.section "bossSelection.animateBframes" free
bossSelection.animateBframes:
-:		push bc
		call clearSpriteTable
		call animateBossIntro
		call animateStars
		call prepareForVblank
		pop bc
	djnz -
	ret
.ends
	
.define QuickManHornLocation VramWrite | $38b2
.define PositionFirstFace VramWrite | $38cc
.define FirstTileFacePosition 0
.section "bossSelection.show" free
bossSelection.show:
	call turnOffVdp
	ld a, 16
	out (VdpControlPort), a
	ld a, CramWrite.hi
	out (VdpControlPort), a
	xor a
	out (VdpDataPort), a
	
	decompress bossSelectionTiles, 0, bossSelectionTilesCount
	decompress bossFacesTiles, 256*32, bossFacesTilesCount
	bossSelection.loadMap
	
	ld hl, PositionFirstFace
	ld a, (bossesBeaten)
	ld d, FirstTileFacePosition
		; bf  ol  bf
	ld c, 3 + 1 + 2 ;this counter have two functions, when hit zero for the first time,
					;its time to place the willy logo instead a boss face.
					;ol: outer loop, bf: boss faces
----:	ld b, 3
---:	dec c
		jr z, +		;Write Willy logo and re-value the counter
		rra
		jr nc, ++	;Write boss face
			ld e, a
			ld a, 16
			add a, d
			ld d, a
			ld a, e
			inc h
			push bc
		jr +++
			    ; bf  ol  bf  ol
+:			ld c, 1 + 1 + 3 + 1 ; when hits zero for the second time, its to exit the loop
++:			push bc
			bossSelection.loadBossFace
+++:		ld bc, -240
			add hl, bc
			pop bc
		djnz ---
		push bc
		ld bc, $1d0
		add hl, bc
		pop bc
		dec c
	jr nz, ----	

	ld a, (bossesBeaten)
	and QuickMan
	jr nz, +  
		ld a, <QuickManHornLocation
		out (VdpControlPort), a
		ld a, >QuickManHornLocation
		out (VdpControlPort), a
		ld a, 1
		out (VdpDataPort), a
		dec a
		out (VdpDataPort), a
+:	ld hl, bossSelection.text
	call loadPassiveText
	
	ld hl, bossSelection.palette
	ld de, hasNewPalette
	fastLdir bossSelection.palette.size
	
	call clearObjectTable
	ld hl, objectTable.2.y
	ld a, 64
	ld (hl), a
	ld l, <objectTable.2.x
	ld (hl), a
	
	call turnOnVdp
-:		call objectsToSprites
		call prepareForVblank
		ld a, StartKey | BKey
		and (hl)
		jr nz, ++
		ld a, UKey | DKey | LKey | RKey
		and (hl)
		ld d, >bossSelection.cursorPosition
		ld b, 4
		call menu.updateCursorPosition
		ld a, (frameCounter)
		ld l, <objectTable.2.objType
		and $08
		ld a, objects.bossSelection.cursor
		jr z, +
			xor a
+:		ld (hl), a
	jr -
++:	

	cursorPostionToAddress -

	ld a, (bossesBeaten)
	and (hl)
	jr nz, -
	inc l
	
	loadBossIntroScreen
	-:
	jp -
	ret
.ends


.section "animateBossIntro" free
animateBossIntro:
	ld de, objectTable.2.frameTimer
	ld hl, bossTimers
	ld a, (de)
	add a, (hl)
	jr nc, +
		xor a
		ld (de), a
		inc l
		ld e, <objectTable.2.objType
		ld a, (de)
		inc a
		cp (hl)
		jr nz, +
			dec a
+:	ld (de), a
	call clearSpriteTable
	ld de, spriteTable
	ld iy, objectTable.2.objType
	ld (iy + object.y + 1), $ff
	ld h, >bossAttributes
	jp objectToSprites

.ends

.section "animateStars" free
animateStars:
	ld de, spriteTable + 23
	ld iy, objectTable.3.objType
	ld a, (frameCounter)
	and %00000011
	jr nz, +
		inc (iy + object.x)
+:	ld h, >objects.openingTable
	call objectToSprites
	
	ld bc, _sizeof_object
	add iy, bc
	inc (iy + object.x)
	inc (iy + object.x)
	ld h, >objects.openingTable
	call objectToSprites
	
	ld bc, _sizeof_object
	add iy, bc
	ld a, 4
	add a, (iy + object.x)
	ld (iy + object.x), a
	ld h, >objects.openingTable
	call objectToSprites
	ret
.ends

.endif


