;SMS FM Tool by Chris Covell, January-March 2015

TxtMessage:
.db "-**THIS IS ONE LINE OF TEXT! **-",0


.define RowNumMax 13       	;Number of the LAST row on-screen!

ColNumMaxTbl: .db 6,6,6,6,6,6,6,6,6,7,6,6,7,5
.db 1,1,1

RowSprPosTbl:	;Table for Cursor Y-positions
.db 3*8,4*8,5*8,6*8,7*8,8*8,9*8,10*8,11*8	  ;For Channel Nos
.db 14*8,18*8,19*8,22*8,23*8			;For others
.db 0,0,0,0,$E0,$E0,$E0	;Dummies
;Multiply the above by *4* to get MAP offsets

ColSprPosTbl:	;Table for Cursor X-positions
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8	;Last 1 is a dummy
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8 ;ch 1
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8	;ch 2
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8
.db 0*8,3*8,7*8,11*8,15*8,19*8,23*8,0*8 ;ch 8
.db 0*8,3*8,7*8,12*8,17*8,21*8,25*8,29*8 ;Rhythm
.db 0*8,4*8,9*8,13*8,17*8,23*8,27*8,0*8  ;Mod/Car
.db 0*8,4*8,9*8,13*8,17*8,23*8,27*8,0*8  ;Mod/Car
.db 0*8,4*8,5*8,6*8,7*8,9*8,16*8,24*8    ;ADSR etc
.db 0*8,4*8,5*8,6*8,7*8,9*8,0*8,0*8

ColSprLenTbl:	;Table for width of metasprite
.db 2,3,3,3,3,3,8,8	;Last one a dummy
.db 2,3,3,3,3,3,8,8
.db 2,3,3,3,3,3,8,8
.db 2,3,3,3,3,3,8,8
.db 2,3,3,3,3,3,8,8
.db 2,3,3,3,3,3,8,8
.db 2,3,3,3,3,3,8,8
.db 2,3,3,3,3,3,8,8
.db 2,3,3,3,3,3,8,8
.db 2,3,4,4,3,3,3,3	;Rhythm
.db 3,4,3,3,5,3,5,8	;MODCAR
.db 3,4,3,3,5,3,5,8
.db 3,1,1,1,1,6,7,8     ;ADSR
.db 3,1,1,1,1,6,8,8

ColBGWrtTbl:	;Table for Background writing offsets
.db 0,4,8,12,15,20,23,0	  ;"0" is NEVER written to, hopefully.
.db 0,4,8,12,15,20,23,0
.db 0,4,8,12,15,20,23,0
.db 0,4,8,12,15,20,23,0
.db 0,4,8,12,15,20,23,0
.db 0,4,8,12,15,20,23,0
.db 0,4,8,12,15,20,23,0
.db 0,4,8,12,15,20,23,0
.db 0,4,8,12,15,20,23,0
.db 0,4,8,13,18,22,26,30 ;Rhythm
.db 0,6,10,14,19,24,29,0 ;MOD/CAR
.db 0,6,10,14,19,24,29,0
.db 0,4,5,6,7,11,18,27		;ADSR
.db 0,4,5,6,7,11, 0, 0

DefTxt:
;----0123456789ABCDEF0123456789ABCDEF
.db $FF
.db "*YM2413 FM TOOL BY CHRIS COVELL*",$FF,0
PanelTxt:
.db "--%---%---%---%---%---%---------",$FF
.db "CH/KEY/SUS/OCT/FRQ/VOL/INSTRUMNT",$FF
.db " 1/ a /   / 4 /100/ F /8 ORGAN  "
.db " 2/   /   / 4 /100/ F /7 TRUMPET"
.db " 3/   /   / 4 /100/ F /6 OBOE   "
.db " 4/   /   / 4 /100/ F /5CLARINET"
.db " 5/   /   / 4 /100/ F /4 FLUTE  "
.db " 6/   /   / 4 /100/ F /3 PIANO  "
.db " 7/   /   / 4 /100/ F /2 GUITAR "
.db " 8/   /   / 4 /100/ F /1 VIOLIN "
.db " 9/   /   / 4 /100/ F /0 CUSTOM "
.db "--$---#---$%--$-%-$-%-$-%---%---",$FF
.db "RHYTHM/BASS/SNAR/TOM/CYM/HIH/VOL",$FF
.db " >    /    /    /   /   /   / F "
.db "------$----$----$---$---$---$---",$FF
.db " CUSTOM INSTRUMENT DEFINITIONS  "
.db "   /TREM/VIB/SUS/RTKSC/MUL/LVKSC",$FF
.db "MOD/    /   /   /     / 0 /  0  "
.db "CAR/    /   /   /     / 0 /  0  "
.db "---#----#---$--%$-----$%--$-----",$FF
.db "   /ADSR/DSTORT/TOT LVL/FEEDBACK",$FF
.db "MOD/1111/      /  00   /   0    "
.db "CAR/1111/      /<PAUSE> FOR OPT "
;.db "                                "
.db 0

;----0123456789ABCDEF0123456789ABCDEF
Hint_Key:
.db "  'KEY' ON STARTS NOTE PLAYING  ",0
Hint_Sust:
.db "SUSTAIN LETS NOTE FADE GRADUALLY",0
Hint_Oct:
.db " SET OCTAVE RANGE LOWER-HIGHER  ",0
Hint_Frq:
.db "     NOTE FREQUENCY <PITCH>     ",0
Hint_Vol_Real:
.db "VOLUME 0-F<YM REG.STORED AS F-0>",0
Hint_Vol:
.db "         VOLUME CONTROL         ",0
Hint_Inst:
.db "       INSTRUMENT CHOICE        ",0
Hint_Rtm:
.db "RHYTHM SOUNDS USE CHANNELS 7,8,9",0
Hint_RtmKey:
.db "WHEN KEYED ON, DON'T CHANGE 7-9!",0
Hint_RtmBD:
.db "       *BASS DRUM* TRIGGER      ",0
Hint_RtmSD:
.db "      *SNARE DRUM* TRIGGER      ",0
Hint_RtmTT:
.db "        *TOM-TOM* TRIGGER       ",0
Hint_RtmCM:
.db "      *TOP-CYMBAL* TRIGGER      ",0
Hint_RtmHH:
.db "       *HIGH-HAT* TRIGGER       ",0
Hint_MOD:
.db " MODULATION OSCILLATOR SETTINGS ",0
Hint_CAR:
.db "   CARRIER OSCILLATOR SETTINGS  ",0
Hint_Trm:
.db " AMPLITUDE MODULATION <TREMOLO> ",0
Hint_Vib:
.db "        VIBRATO CONTROL         ",0
Hint_SusM:
.db "      SUSTAINED MODULATION      ",0
Hint_SusC:
.db "  SUSTAINED <NON-FADING> NOTE   ",0
Hint_Rtsc:
.db " RATE KEY SCALE - ADSR IS FASTER",0
Hint_Mul:
.db " OSCILLATOR FREQUENCY MULTIPLIER",0
Hint_Ex1:
.db "*  MARIO IS NOT A FAT PLUMBER. *",0
Hint_Ex2:
.db "<HE WAS A CARPENTER BY TRAINING>",0
Hint_Ex3:
.db "CAN ",$FF,"YOU",$FF," LOOSEN GIRDERS ONEHANDED",0
Hint_Lvsc:
.db " LEVEL SCALE - HIGH NOTES SOFTER",0
Hint_Atk:
.db "ATTACK RATE - SPEED TO MAX LEVEL",0
Hint_Dky:
.db "DECAY RATE- SPEED TO SUSTAIN LVL",0
Hint_SusVol:
.db "SUSTAIN LEVEL - <0 IS LOUDEST>  ",0
Hint_Rls:
.db "RELEASE RATE - SPEED TO SILENCE ",0
Hint_Dstrt:
.db "FLATTEN NEGATIVE PART OF SINWAVE",0
Hint_Totl:
.db "CONTROL OVERALL MODULATION LEVEL",0
Hint_Fbk:
.db " SET MODULATOR FEEDBACK CONSTANT",0




;--------------- TABLE FOR ADDRESSES OF HINT TEXT! ----
Hint_Add_Tbl:
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol_Real,Hint_Inst,DefTxt
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw DefTxt,Hint_Ex1,Hint_Ex2,Hint_Ex3,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw DefTxt,Hint_Key,Hint_Sust,Hint_Oct,Hint_Frq,Hint_Vol,Hint_Inst,DefTxt
.dw Hint_Rtm,Hint_RtmKey,Hint_RtmBD,Hint_RtmSD,Hint_RtmTT,Hint_RtmCM,Hint_RtmHH,Hint_Vol
.dw Hint_MOD,Hint_Trm,Hint_Vib,Hint_SusM,Hint_Rtsc,Hint_Mul,Hint_Lvsc,DefTxt
.dw Hint_CAR,Hint_Trm,Hint_Vib,Hint_SusC,Hint_Rtsc,Hint_Mul,Hint_Lvsc,DefTxt
.dw Hint_MOD,Hint_Atk,Hint_Dky,Hint_SusVol,Hint_Rls,Hint_Dstrt,Hint_Totl,Hint_Fbk
.dw Hint_CAR,Hint_Atk,Hint_Dky,Hint_SusVol,Hint_Rls,Hint_Dstrt,DefTxt,DefTxt


TxtFM_Pass:
.db "FM ENABLED!",0
TxtFM_Fail:
.db "NO FM UNIT!",0
TxtPaddle_Pass:
.db " PADDLE CONNECTED  ",0
TxtPaddle_Fail:
.db " PADDLE NOT CONNECTED",0

Controls_Txt:
;----0123456789ABCDEF0123456789ABCDEF
.db "<PAUSE> TO STAY ON THIS SCREEN  "
.db "                                "
.db "                                "
.db "A PADDLE IS RECOMMENDED FOR FAST"
.db "NOTE SLIDES, ETC.               "
.db "                                "
.db "MOVE CURSOR WITH PADDLE OR PAD. "
.db "PAD <1> BUTTON OR PADDLE TRIGGER"
.db "SELECTS EACH OPTION, PARAMETER. "
.db "                                "
.db "<PAUSE> OR PAD <2> CYCLES KEYING"
.db "OPTIONS FOR NOTE <RE>TRIGGERING."
.db "                                "
.db "OR HOLD <TRG,1> AND <PAUSE,2> TO"
.db "LOCK <PAUSE,2> AS KEYING BUTTONS"
.db "                                "
.db "<'KEY' MEANS LIKE A PIANO KEY.> "
.db 0

;----0123456789ABCDEF0123456789ABCDEF
Txt2CON:
.db "USE SECRET DETUNE WITH P2 TRG.",0
TxtBlank:
.db "                                ",0
TxtDetuneOn:
.db " <DETUNE>  ",0
TxtDetuneOff:
.db " <NO DETUNE>    ",0

Instrument_Txt:
    ;123456789  A B C D E F G
.db "0 CUSTOM ",0,0,0,0,0,0,0
.db "1 VIOLIN ",0,0,0,0,0,0,0
.db "2 GUITAR ",0,0,0,0,0,0,0
.db "3 PIANO  ",0,0,0,0,0,0,0
.db "4 FLUTE  ",0,0,0,0,0,0,0
.db "5CLARINET",0,0,0,0,0,0,0
.db "6 OBOE   ",0,0,0,0,0,0,0
.db "7 TRUMPET",0,0,0,0,0,0,0
.db "8 ORGAN  ",0,0,0,0,0,0,0
.db "9 HORN   ",0,0,0,0,0,0,0
.db "A SYNTH  ",0,0,0,0,0,0,0
.db "B HARPSCH",0,0,0,0,0,0,0
.db "C VIBRAPH",0,0,0,0,0,0,0
.db "D SYNBASS",0,0,0,0,0,0,0
.db "EWOODBASS",0,0,0,0,0,0,0
.db "FELECBASS",0,0,0,0,0,0,0

;----0123456789ABCDEF0123456789ABCDEF
TrgMode_Txt:
.db "<2>,PAUSE KEY  ",0
.db "<1> SELECTS    ",0
.db "<1> REKEYS     ",0
.db "<1> KEYS ON,OFF",0

.db "PAUSE REKEYS   ",0
.db "TRG. SELECTS   ",0
.db "TRG. REKEYS    ",0
.db "TRG.KEYS ON,OFF",0



Print_FM_Paddle:

;;    	ld a,17
;;	ld (lineno),a
;;    	call Go_Line
;;   	ld a,(cont1)
;;   	call Print_Byte		;Print button state
;;   	ld a,(trigger)
;;   	call Print_Byte
;;   	ld a,(Curr_Inst)
;;   	call Print_Byte

;	ld a,(cont2_Paddle_On)
;   	call Print_Byte
;    	ld a,(cont2_Paddle_Cur)
;   	call Print_Byte 	;Print current Controller 2
;	ld a,(cont2)
;   	call Print_Byte

;;	ret


	ld a,(FM_Present)
	or a
	jr z,prt_no_fm
	ld hl,TxtFM_Pass
	jr prt_fm
prt_no_fm:
    	ld hl,TxtFM_Fail
prt_fm:
    	ld a,2		;23=last line of SMS display.
	ld (lineno),a
    	call Go_Line
    	call Print_Text

	ld a,(Paddle_On)
	or a
	jr z,prt_no_paddle
	ld hl,TxtPaddle_Pass
    	call Print_Text

	ld a,(Paddle_Cur)
   	call Print_Byte 	;Print current paddle value

	jr prt_paddle
prt_no_paddle:
    	ld hl,TxtPaddle_Fail
    	call Print_Text
prt_paddle:

;Now print hidden info if 2nd Controller is used!
	ld a,(cont2_Paddle_On)
	or a
	jr nz,print_hidden
	ld a,(cont2)	;Last chance if some button pressed
	or a
	jr z,no_print_hidden
print_hidden:
    	ld hl,Txt2CON
    	ld a,3
	ld (lineno),a
    	call Go_Line
    	call Print_Text
	ld a,(cont2_Paddle_On)
	or a
	jr z,hidden_end
    	ld a,(cont2_Paddle_Cur)
   	call Print_Byte 	;Print current Controller 2
        jr hidden_end

no_print_hidden:
    	ld hl,TxtBlank
    	ld a,3
	ld (lineno),a
    	call Go_Line
    	call Print_Text
hidden_end:
	ret



Setup_VBWr_Destination:		;Point to screen correctly for writing...
	push DE
	;E contain column num.
	ld HL,RowSprPosTbl	;Table for Row Writes (for sprites tho...)
	add HL,DE
	ld a,(HL)		;Get Value from the Table
	ld l,a
	xor a
	ld h,a                  ;Value in HL
	add HL,HL		;x2
	add HL,HL		;x4... easy multiplication!
	;HL now has a 32-byte-aligned ROW number.
	push HL			;store it...


	ld HL,ColBGWrtTbl	;Column writing table this time
	call Row_Col_in_DE	;Row,column offset
	add HL,DE
	ld a,(HL)		;Get *WRITING OFFSET*

	pop HL			;Restore Row Offset
	ld e,a
	xor a
	ld d,a                  ;Add Row offset to Col offset =
	add HL,DE		;Total Offset!
	add HL,HL		;x2 because each MAP cell uses 2 bytes!
	ex DE,HL		;Put total in DE
        ld HL,VRAM_MAP          ;Get VRAM offset
	add HL,DE		;Finally, add everything together!
	ld (VBL_Write_ADDR),HL	;And store it!

	pop DE
	ret










Setup_VBWr_Checkmark:	;A contains 0 or else, as a checkmark
	ld (VBL_Write_DATA),a		;Set as data for VB Writing
	ld a,1
	ld (VBL_Write_TYPE),a	;Type is now Check!
	ret

Setup_VBWr_HEX:	;A contains HEX value
	ld (VBL_Write_DATA),a		;Set as data for VB Writing
	ld a,2
	ld (VBL_Write_TYPE),a	;Type is now HEX!
	ret

Setup_VBWr_Nyb:	;A contains nybble
	ld (VBL_Write_DATA),a		;Set as data for VB Writing
	ld a,3
	ld (VBL_Write_TYPE),a	;Type is now Nybble!
	ret

Setup_VBWr_3Nybs: ;A contains nybble
	and $0F		;Isolate nybble just in case
	or  $10 	;Type is now 3 nybbles
	ld (VBL_Write_TYPE),a
	ret

Setup_VBWr_String:
	ld (VBL_Write_DATA),a		;Set as data for VB Writing
	ld a,$20
	ld (VBL_Write_TYPE),a	;Type is now Nybble!
	ret


Init_Message:
    	xor a	;Clear A
	ld (lineno),a
    	call Go_Line
    	ld hl,DefTxt               ; Location of my message
    	call Print_Text
	ld a,1
	ld (lineno),a
    	call Go_Line
    	ld hl,PanelTxt               ; Location of my Screen
    	call Print_Text
	ret








Auto_Text_Print:

;	ld HL,VRAM_MAP		;Point to TOP of screen
;	call	VRAMToHL

;	ld a,(Paddle_On)  	;PRINT DEBUG STUFF!!
;   	call Print_Byte
;	ld a,(Paddle_Cur)
;   	call Print_Byte
;	ld a,(cont1)
;   	call Print_Byte
;	ld a,(trigger)
;   	call Print_Byte

;	ld a,(cont2_Paddle_On)
;   	call Print_Byte
;	ld a,(cont2_Paddle_Cur)
;   	call Print_Byte
;	ld a,(cont2)
;   	call Print_Byte
;	ld a,(cont2_trg)
;   	call Print_Byte

;	ld a,(cont2_Pdl1)  	;PRINT DEBUG STUFF!!
;   	call Print_Byte
;	ld a,(cont2_Pdl2)
;   	call Print_Byte
;	ld a,(cont2_Pdl3)
;   	call Print_Byte
;	ld a,(cont2_PdlAvg)
;   	call Print_Byte

;====== Check if detuning needs printing ====
	ld a,(detune_chg)
	or a
	jr z,no_detune_print

	xor a
	ld (detune_chg),a	;Turn off flag!

	ld HL,VRAM_MAP+$05E0	;Point to near bottom of screen
	call	VRAMToHL
	ld a,(detune_on)	;Check if Detune turned ON or OFF
	or a
	jr z,prt_off_detune

	ld HL,TxtDetuneOn
        call Print_Text
			;Now print Detuning Level!
	ld a,(detune_lvl+1)	;Get high byte
	bit 7,a
	jr z,prt_pos_detune
	push AF
	ld a,'-'	;Negative
	out ($be),a
	ld a,$10	;SPRITES BEHIND MAP
	out ($be),a
	pop AF
	cpl
	and $0f
	call Print_Nybble
	ld a,(detune_lvl)	;Get high byte
	cpl
	call	Print_Byte
	jr no_detune_print

prt_pos_detune:
	push AF
	ld a,' '	;Space
	out ($be),a
	ld a,$10	;SPRITES BEHIND MAP
	out ($be),a
	pop AF
	and $0f
	call Print_Nybble
	ld a,(detune_lvl)	;Get high byte
	call	Print_Byte
	jr no_detune_print

prt_off_detune:
	ld HL,TxtDetuneOff
        call Print_Text

no_detune_print:
;=============================

	ld a,(old_trigmode)
	ld b,a
	ld a,(trigger_mode)
	cp b
	jr z,no_trig_print
	ld (old_trigmode),a	;Save as old trigger
	ld HL,VRAM_MAP+$05E0	;Point to near bottom of screen
	call	VRAMToHL
        ld HL,TrgMode_Txt
   	ld a,(Paddle_On)
	and $40			;isolate one bit
	ld b,a
	ld a,(trigger_mode)
	add a,a
	add a,a
	add a,a			;*16!
	add a,a
	or b			;Add in that bit
	ld e,a
	xor a
	ld d,a
	add HL,DE
        call Print_Text
	ret

no_trig_print:
	;Check if we need to trigger a HINT
        ld a,(RowNum)
	ld b,a
	ld a,(ColNum)
	xor b		;Combine Row,Col to one variable
	ld b,a
	ld a,(RowColXOR)
	cp b		;Has cursor moved?
	jr z,no_row_col_change ;If not, never mind...
	;If so, make new XOR for next time
	ld a,b
	ld (RowColXOR),a
	ld HL,Hint_Delay
	ld (delayHint),HL
	ret
no_row_col_change:
	ld a,(delayHint+1)	;Is top byte Zero?
	or a
	jr nz,reg_hint_dec	;If not, decrement delay regularly
	ld a,(delayHint)
	cp 1                    ;If delay is now 1, print a message
	jr z,Print_New_Hint
	cp 0                    ;If delay is totally zero, do nothing!
	jr nz,reg_hint_dec	;If not, decrement delay regularly
	ret
reg_hint_dec:
	ld HL,(delayHint)
	dec HL
	ld (delayHint),HL
	ret

Print_New_Hint:
	xor a	;Hint Delay now ZERO!
	ld (delayHint),a
	call	Row_Col_in_DE
	ld HL,VRAM_MAP		;Point to TOP of screen
	call	VRAMToHL
	ld	HL,Hint_Add_Tbl
	add	HL,DE
	add	HL,DE	;Word-Sized Tbl
	ld	a,(HL)	;Get Text Pointer in a,b!
	ld	b,a
	inc	HL
	ld	a,(HL)
	ld	h,a
	ld	l,b
        call Print_Text
	ret






Row_Col_in_DE:      ;Combines Row, Col offset in DE register
	push BC
	ld a,(RowNum)	;Get row number
 	add a,a
	add a,a
	add a,a		;Multiply by 8
	ld c,a
        ld a,(ColNum)	;Get column number
	or c		;OR with Row*8
	ld e,a
	xor a
	ld d,a
	pop BC
	ret