;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Top source of Sega Master System FMV demo
; Written by Alex Marshall <trap15@raidenii.net>
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.incdir	"src"

.def HEIGHT2X 0

; Memory Map for Master System (w/ Sega Mapper)
.memorymap
	defaultslot	1
	; Fixed ROM
	slot		0	$0000	$4000
	; Mapped ROM Area 1
	slot		1	$4000	$4000
	; Mapped Area 2
	slot		2	$8000	$4000
	; RAM
	slot		3	$C000	$2000
.endme

; Bank Map
.if HEIGHT2X == 0
.rombankmap
	bankstotal	64
	banksize	$4000
	banks		64
.endro
.else
.rombankmap
	bankstotal	128
	banksize	$4000
	banks		128
.endro
.endif

	.bank	0	slot 0
.include	"mem.i"
.include	"main.S"
.include	"mapper.S"
.include	"vdp.S"
.include	"tiletbl.S"
.include	"fmv.S"

	.org	$3F00
cmdtbl:
.rept	$20
	.dw	deltacmd_entry
.endr
.rept	$20
	.dw	keyfrmcmd_entry
.endr
.rept	$20
	.dw	palcmd_entry
.endr
.rept	$20
	.dw	bankcmd_entry
.endr

.include	"data.S"

.smstag


