/*
 * Copyright (c) 2011, Harley Laue
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * Neither the name of the <organization> nor the
 *      names of its contributors may be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/io.h>
#include <sys/sn79489.h>

void sn79489_latch_volume(uint8_t channel, uint8_t data) {
	/*
	 * bit 7 must be 1 for a latch
	 * make sure bits 5 & 6 are the only ones channel affects
	 * bit 4 must be 1 for the volume
	 * bit 7   bit 6 & 5       bit 3-0
	 * 0x90 | (channel&0x6F) | 0x0F & data
	 * 0x90 is a combining bits 7 and 4
	 */
	sn79489_register_write(0x90 | (channel & 0x60) | (0x0F & data));
}

void sn79489_latch_tone(uint8_t channel, uint8_t data) {
	/*
	 * bit 7 must be 1 for a latch
	 * make sure bits 5 & 6 are the only ones channel affects
	 * bit 4 must be 0 for the tone/noise
	 *  bit 7  bit 6 & 5       bit 3-0
	 * 0x80 | (channel&0x60) | (0x0F & data)
	 */
	sn79489_register_write(0x80 | (channel & 0x60) | (0x0F & data));
}

void sn79489_data_write(uint8_t data) {
	/* make sure bits 6 & 7 are zero */
	sn79489_register_write(0x3F & data);
}

void sn79489_latch(uint8_t data) {
	/* bit 7 must be 1, other than that, let the user handle data */
	sn79489_register_write(0x80 | data);
}

