// King Kong for the Sega Master System
// Copyright by Ventzislav Tzvetkov
// http://hirudov.com
// Enjoy

#include <stdlib.h>
#include <sms.h>

#define FALSE 0
#define TRUE  1


#define FIRE   1
#define RIGHT  2
#define LEFT   4
#define DOWN   8
#define UP    16

static unsigned char GraphicsPalette[] = {0x00, 0x15, 0x3A, 0x0F, 0x30, 0x2B, 0x14, 0x03,
				0x04, 0x0C, 0x1B, 0x06, 0x17, 0x02, 0x1B, 0x3F};

static unsigned char SpritesPalette[] = {0x00, 0x24, 0x0C, 0x0F, 0x30, 0x32, 0x3C, 0x03,
				0x09, 0x04, 0x3A, 0x06, 0x17, 0x02, 0x2B, 0x3F};


//We use zeroed regions for black palette to save space.
//static unsigned char BlackPalette[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


// Tiles
static unsigned int TitleScreenRight[] = {
  7,  8,  9, 10, 11, 12, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 39, 40, 41, 42, 43, 44, 45, 14, 15, 16, 17, 18, 19, 20, 21,  0,
 71, 72, 73, 74, 75, 76, 77, 46, 47, 48, 49, 50, 51, 52,  0,  0,
103,104,105,106,107,108,619, 78, 79, 80, 81, 82, 83, 84,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,113,114,626,116,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  7,  8,  9, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 39, 40, 41, 42, 22, 23, 24, 53, 14, 15, 16, 17, 18, 19, 20, 21,
 71, 72, 73, 74, 85, 86, 87, 54, 46, 47, 48, 49, 50, 51, 52,  0,
103,104,105,106,117,118,119, 55, 78, 79, 80, 81, 82, 83, 84,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,113,114,626,116}
,

TitleScreen[] = {
  0,  1,  2,  3,  4,  5,  0,  0,
 32, 33, 34, 35, 36, 37, 38,  0,
 64, 65, 66, 67, 68, 69, 70,  0,
 96, 97, 98, 99,100,101,102,  0,
128,129,130,131,132,133,134,  0,
160,161,162,163,164,165,166,167,
191,159,110,111,112,125,126,127,
  0, 25, 26, 27, 28, 29, 30, 31,
 56, 57, 58, 59, 60, 61, 62, 63,
 88, 89, 90, 91, 92,  0, 94, 95,
  0,  0,122,123,124,  0,  0,  0,
152,153,154,155,156,157,158,  0,
184,185,186,187,188,189,190,  0,
  6,135,109,621, 93,  0,  0,  0,
120,121}
,

TitleScreen2[] = {
  0,  0,  0,  0,  0,  0,  0,  0,179,  0,169,177,177,176,  0,  0,  0,  0,  0,  0,  0,  0,
137,200,  0,197,140,149,195,115,144,194,147,136,197,  0,195,115,197,140,195,146,150,197,
  0,  0,143,195,195,151,178,182,182,143,144,193,196,139,150,197,183,138,150,148,  0,  0,
};


static unsigned int GameScreen[] = {
333,845,354,355,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,341,342,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,361,873,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,373,374,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,256,768,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31, 31, 31, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,288,800,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 63, 63, 63, 63,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,205,336,325,326,326,327,325,326,326,327,325,326,326,327, 95, 95, 95, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,338,339,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,133,162,160,160,160,160,160,160,160,160,160,160,160,160,160,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,165,166,275,787,  0,333,845,  0,  0,333,845,  0,  0,333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,  0,  0,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,  0,  0,  0,  0,333,845,
333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,336,324,205,336,324,205,333,845,
333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,339,850,338,339,850,338,333,845,
333,845,  0,  0,275,787,205,336,324,205,336,  0,  0,  0,  0,  0,  0,  0,  0,205,336,324,205,336,324,205,336,324,205,333,845,
333,845,  0,  0,275,787,338,339,850,338,339,  0,  0,  0,  0,  0,  0,  0,  0,338,339,850,338,339,850,338,339,850,338,333,845,
333,845,  0,  0,275,787,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,  0,  0,  0,  0,333,845,
333,845,205,336,  0,  0,  0,205,336,324,205,336,324,205,336,  0,  0,  0,205,336,275,787,  0,205,336,  0,  0,  0,  0,333,845,
333,845,338,338,  0,  0,  0,338,339,850,338,339,850,338,339,  0,  0,  0,338,339,275,787,  0,338,339,  0,  0,  0,  0,333,845,
333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
333,845,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,333,845,
352,353,266,267,268,301,301,301,301,301,301,301,270,271,272,273,274,301,301,301,301,301,349,350,351,301,301,301,301,301,301,
368,369,298,299,300,301,301,301,301,301,301,301,302,303,304,305,1298,301,301,301,301,301,381,382,383,301,301,301,301,301,301,
};

static unsigned int LivesTiles[]= {320,321,322,323},
		NumberTiles[]  = {277,309,278,310,279,311,280,312,281,313,282,314,283,315,284,316,285,317,286,318},
		Girder1Tiles[] = {343,344,345,375,376,377},
		Girder2Tiles[] = {346,347,348,378,379,380},
		BarelLeftTiles[] = {213,214,245,246},
		BarelRightTiles[] = {358,  0, 357, 334},
		BarelRightSTiles[] = {360,337,356,171},
		BarelTopTiles[] = {364,365,306,160},
		BarelTopRightTiles[] = {362,363,257, 0},
		BarelTopRightSTiles[] = {289,337,359,171},
		BarelBottomLeftTiles[] = {192,0,224,225},
		BarelBottomTiles[] = {194,195,226,227},
		BarelBottomRightTiles[] = {222,223,254,255},
		BarelBottomRightSTiles[] = {177,337,193,171},
		BarelFallingDiagonal1Tiles[] = {198,  0,230,231},
		BarelFallingDiagonal2Tiles[] = {196,197,228,229},
		BarelStraightTiles[] = {0x116E,0x116F,0x1114,0x114F},
		CraneHook2[] = {18},
		BarelBlankTiles[]= {  0,  0},
		BarelPlatformBlankTiles[] = {  0,  0,160,160},
		CraneHook5[] = {307,308},
		KongPlatform[] = {0,0,326,326},
		CraneStick[]  = {186,0xB7,0x9A,0x10D,0x30D,0x29A,0x2B7,0x30D},
		CraneControlUp = 66,
		CraneHook1[] = {331,332},
		CraneHook3[] = {42,74},
		CraneHook4[] = {69,101},
		Heart[] = {64,32},
		Hook[]  = {31,63,95},
		Platform1Falling[] = {0,328,329,
				   0, 330,122,
				   180,181,0,
				   182},
		PrincessCrying[] = { 0,  0,
				    79,199,
				   262,263,
				   294,295,
				     0,  0,
				   232,233,
				   264,265,
				   296,297},
		Platform2Falling[] = {319,  0,
				      287,119,
				      151,842,
				        0,116},
		Platform3Falling[] = {841,840,0,
				   634, 842,0,
				   0,693,692,
				   0,0,694},
		HappyPrincess[] = {259,771,
				   291,803,
				   258,770,
				   290,802},

		FinalPrincess[]  = {370,371,
				    340,372,
				    260,261,
				    292,293}
;

static char KongXCoordinates[]={40,72,104};

extern char KingKong_TitleGraphics[];

void vbl_handler() {
//	int i;
//	int y;
//	char *c;
//
//	for (i = 48, y = 12, *c; i--, y += 12, c++) {
//		set_sprite(i, 12, y, *c);
//	}
}

static unsigned char MarioCoordinates[] = {
			         1,  2,  0, 33, 34,  0, 65,  0, 46,154,  // Position  0 MarioRight1
				 3,  4,  5, 35, 36, 37, 67, 68, 74,156,  // Position  1 MarioRight2
				 6,  7,  0, 38, 39,  0, 70, 71,102,155,  // Position  2 MarioRight3
				 8,  9, 10, 40, 41,  0, 72, 73,133,156,  // Position  3 MarioRight4
				13, 14, 15, 45, 46, 47, 77, 78,168,153,  // Position  4 MarioClimb1
				19, 20,  0, 51, 52,  0, 83,  0,168,119,  // Position  5 MarioLeft1
				21, 22, 23, 53, 54, 55, 85, 86,132,120,  // Position  6 MarioLeft2
				24, 25,  0, 56, 57,  0, 88, 89,102,120,  // Position  7 MarioLeft3
				26, 27,  0, 58, 59,  0, 90, 91, 74,120,  // Position  8 MarioLeft4
				11, 12,  0, 43, 44,  0, 75, 76, 40,120,  // Position  9 MarioClimb
				16, 17,  0, 48, 49, 50, 80, 81, 39, 94,  // Position 10 MarioClimb2
				13, 14, 15, 45, 46, 47, 77, 78, 36, 62,  // Position 11 MarioClimb1
				28, 29, 30, 60, 61, 62, 92, 93, 39, 41,  // Position 12 MarioManetteHandDown
			       102,103,104,134,135,136,  0,167, 78, 42,  // Position 13 MarioLoopUp
			        99,100,  0,131,132,  0,163,164,118, 40,  // Position 14 MarioManette
			       105,106,107,137,138,139,169,170,165, 50,  // Position 15 MarioFalling
			       114,115,  0,146,147,148,178,179,176, 62,  // Position 16 MarioCrash
			       108,109,110,140,141,142,172,173,210,142,  // Position 17 MarioFall
			       111,112,113,143,144,145,  0,  0,218,166,  // Position 18 MarioFelt
			       117,118,  0,149,150,  0,  0,  0, 42,144,  // Position 19 MarioJumpRight
			       117,118,  0,149,150,  0,  0,  0,133,144,  // Position 20 MarioJumpRight
			       120,121,  0,152,153,  0,184,185,132, 96,  // Position 21 MarioJumpLeft
			       120,121,  0,152,153,  0,184,185,101, 96,  // Position 22 MarioJumpLeft
			       123,124,  0,155,156,  0,187,188,168, 30,  // Position 23 MarioJumpForHook
			       126,127,  0,158,159,  0,190,191,166,  7,  // Position 24 MarioGrippedToHook
			       126,127,  0,158,159,  0,190,191,199, 63,  // Position 25 MarioGrippedToHook
				 0,  0,  0,  0,  0,  0,  0,  0,192,150,  // Position 26 Blank Mario
			        96, 97, 98,128,129,130,  0,161, 37, 41	 // Position 27 MarioManetteHandUp
},

	KingKongSprite[] = {0,203,204,0,
			    234,235,236,237,
			    215,216,217,218,
			    247,248,249,250,
//			    279,280,281,282,
//			    152,153,154,0
},
	KingKongThrowSprite[] = {174,175,176,0,
				 206,207,208,209,
				 238,239,240,241,
				 200,201,202,0},
	KingKongFeltSprite[] = {210,211,212,0,
				242,243,244,0,
				219,220,221,0,
				251,252,253,0},
	GameOverSprite[]     = {94,125,157,189,
				82,168,84,87}
;
void SetFourBlankSprites (int SpriteNumber) {
	set_sprite(SpriteNumber,    0,   192,250);
	set_sprite(SpriteNumber+1,  0,   192,250);
	set_sprite(SpriteNumber+2,  0,   192,250);
	set_sprite(SpriteNumber+3,  0,   192,250);

}

void SetFourBarelSprites (int x, int y, int SpriteNumber, int * SpriteData) {

	set_sprite(SpriteNumber,  x,      y, (int *) SpriteData[0]);
	set_sprite(SpriteNumber+1,x+8,    y, (int *) SpriteData[1]);
	set_sprite(SpriteNumber+2,  x,    y+8, (int *) SpriteData[2]);
	set_sprite(SpriteNumber+3,x+8,    y+8, (int *) SpriteData[3]);

}

void Delay(int MilliSeconds){

int i;

for (i=0;i<MilliSeconds;i++) wait_vblank_noint();

set_sound_volume(0,0);

}

unsigned int Barels, Barels2,KeyFlag;

DrawKong(int KingKongX, int KingKongY, char *KongState)
{
int SpriteNumber=48,i,j;

for (j=0;j<4;j++) {
	for (i=0;i<4;i++) set_sprite(SpriteNumber++,  KingKongX+i*8, KingKongY, *KongState++);
	KingKongY+=8;}

//set_sprite(48,  KingKongX,    0, *KongState++);
//set_sprite(49,  KingKongX+8,  0, *KongState++);
//set_sprite(50,  KingKongX+16, 0, *KongState++);
//set_sprite(51,  KingKongX+24, 0, *KongState++);


//set_sprite(52,  KingKongX   , 7, *KongState++);
//set_sprite(53,  KingKongX+8 , 7, *KongState++);
//set_sprite(54,  KingKongX+16, 7, *KongState++);
//set_sprite(55,  KingKongX+24, 7, *KongState++);


//set_sprite(56,  KingKongX,   15, *KongState++);
//set_sprite(57,  KingKongX+8 ,15, *KongState++);
//set_sprite(58,  KingKongX+16,15, *KongState++);
//set_sprite(59,  KingKongX+24,15, *KongState++);


//set_sprite(60,  KingKongX,   23, *KongState++);
//set_sprite(61,  KingKongX+8, 23, *KongState++);
//set_sprite(62,  KingKongX+16,23, *KongState++);
//set_sprite(63,  KingKongX+24,23, *KongState++);
}

void clear_vram(){
load_palette(&GameScreen[5], 0, 32);
#asm	
;==============================================================
; Clear VRAM
;==============================================================
; Sets all of VRAM to zero
;==============================================================
.clear_vram
	ld	hl,$0000
;	push	af
	ld 	a,l
        out 	($bf),a
        ld 	a,h
        or 	$40
        out 	($bf),a
;	pop 	af
	; Output 16KB of zeroes
	ld 	hl, $4000    ; Counter for 16KB of VRAM
	ld 	a, $00       ; Value to write
.clearVRAM1
	out 	($be),a      ; Output to VRAM address, which is auto-incremented after each write
	dec 	h
	jp 	nz, clearVRAM1
	dec 	l
	jp 	nz, clearVRAM1
#endasm


}


void DrawBarels(){

/* Check Where the Barels are and Draw them if any else erase: */

	if (Barels & 0x8000) set_bkg_map( BarelStraightTiles,6,3, 2, 2); // DrawImage(my_window->RPort,&BarelFallStraight,86,59);
	else set_bkg_map(KongPlatform,6,3,2,2);

	if (Barels2 & 0x10) set_bkg_map( BarelStraightTiles,10,3, 2, 2); //DrawImage(my_window->RPort,&BarelFallStraight,128,59);
	else set_bkg_map(KongPlatform,10,3,2,2);

	if (Barels2 & 0x200) set_bkg_map( BarelStraightTiles,14,3, 2, 2); //DrawImage(my_window->RPort,&BarelFallStraight,164,59);
	else set_bkg_map(KongPlatform,14,3,2,2);

	if (Barels & 0x4000) SetFourBarelSprites (52,29,36, &BarelFallingDiagonal1Tiles[0]); //DrawImage(my_window->RPort,&BarelFallingDiagonal1,86,73);
	else SetFourBlankSprites(36);

	if (Barels2 & 0x8) SetFourBarelSprites (81,29,28, &BarelFallingDiagonal2Tiles[0]); //DrawImage(my_window->RPort,&BarelFallingDiagonal2,128,74);
	else SetFourBlankSprites(28);

	if (Barels2 & 0x100) SetFourBarelSprites (116,29,40, &BarelFallingDiagonal1Tiles[0]); //DrawImage(my_window->RPort,&BarelFallingDiagonal1,164,73);
	else SetFourBlankSprites(40);

	if (Barels & 0x2000) SetFourBarelSprites (52,57,32, &BarelFallingDiagonal2Tiles[0]); //DrawImage(my_window->RPort,&BarelFallingDiagonal2,86,103);
	else SetFourBlankSprites(32); 

	if (Barels2 & 0x4) SetFourBarelSprites (82,58,44, &BarelFallingDiagonal1Tiles[0]); //DrawImage(my_window->RPort,&BarelFallingDiagonal1,128,103);
	else SetFourBlankSprites(44);

	if (Barels2 & 0x80) SetFourBarelSprites (113,57,24, &BarelFallingDiagonal2Tiles[0]); //DrawImage(my_window->RPort,&BarelFallingDiagonal2,164,103);
	else SetFourBlankSprites(24);

	if (Barels & 0x800) set_bkg_map( BarelTopRightTiles,3, 9, 2, 2); //DrawImage(my_window->RPort,&BarelTopRight,56,121);
	else set_bkg_map( BarelBlankTiles,3, 9, 2, 2);

	if (Barels & 0x1000) set_bkg_map( BarelRightSTiles,7,9, 2, 2); //DrawImage(my_window->RPort,&BarelRight,86,118);
	else set_bkg_map( BarelPlatformBlankTiles,7,9, 2, 2); 

	if (Barels2 & 0x1) set_bkg_map( BarelBottomRightSTiles, 9, 9, 2, 2); //DrawImage(my_window->RPort,&BarelBottomRight,110,118);
	else set_bkg_map( BarelPlatformBlankTiles, 9, 9, 2, 2);

	if (Barels2 & 0x2) SetFourBarelSprites (80, 68,20, &BarelBottomTiles[0]); //DrawImage(my_window->RPort,&BarelBottom,128,118);
	else SetFourBlankSprites(20); //RectFill(my_window->RPort, 128,118, 137,127);

	if (Barels2 & 0x20) SetFourBarelSprites (99, 68, 8, &BarelBottomLeftTiles[0]);
	else SetFourBlankSprites(8); //RectFill(my_window->RPort, 146,118, 157,127);

	if (Barels2 & 0x40) set_bkg_map( BarelRightSTiles, 14,9, 2, 2);//set_bkg_map( BarelLeftTiles, 14,8, 2, 2); //DrawImage(my_window->RPort,&BarelLeft,164,118);
	else set_bkg_map( BarelPlatformBlankTiles, 14, 9, 2, 2);

	if (Barels & 0x400) set_bkg_map( BarelTopTiles,3,16, 2, 2); //DrawImage(my_window->RPort,&BarelTop,56,166);
	else set_bkg_map( BarelPlatformBlankTiles,3,16, 2, 2);

	if (Barels & 0x200) set_bkg_map( BarelTopRightSTiles,7,16, 2, 2); //DrawImage(my_window->RPort,&BarelTopRight,86,171);
	else set_bkg_map( BarelPlatformBlankTiles,7,16, 2, 2);

	if (Barels & 0x100) set_bkg_map( BarelRightSTiles,11,16, 2, 2); //DrawImage(my_window->RPort,&BarelRight,116,171);
	else set_bkg_map( BarelPlatformBlankTiles,11,16, 2, 2);

	if (Barels & 0x80) set_bkg_map( BarelBottomRightSTiles, 15,16, 2, 2); //DrawImage(my_window->RPort,&BarelBottomRight,146,171);
	else set_bkg_map( BarelPlatformBlankTiles, 15,16, 2, 2);

	if (Barels & 0x40) SetFourBarelSprites (155,124, 16, &BarelBottomTiles[0]); //DrawImage(my_window->RPort,&BarelBottom,176,171);
	else SetFourBlankSprites(16);

	if (Barels & 0x20) SetFourBarelSprites (203,124,12, &BarelBottomLeftTiles[0]); //DrawImage(my_window->RPort,&BarelBottomLeft,212,171);
	else SetFourBlankSprites(12); 

	if (Barels & 0x1) set_bkg_map( BarelRightTiles, 7,20, 2, 2); //DrawImage(my_window->RPort,&BarelRight,86,206);
	else set_bkg_map( BarelBlankTiles, 7,20, 2, 2);

	if (Barels & 0x2) set_bkg_map( BarelBottomRightTiles, 11,20, 2, 2); //DrawImage(my_window->RPort,&BarelBottomRight,116,206);
	else set_bkg_map( BarelBlankTiles, 11,20, 2, 2);

	if (Barels & 0x4) set_bkg_map( BarelBottomTiles, 15,20, 2, 2); //DrawImage(my_window->RPort,&BarelBottom,145,206);
	else set_bkg_map( BarelBlankTiles, 15,20, 2, 2);

	if (Barels & 0x8) set_bkg_map( BarelBottomLeftTiles, 19,20, 2, 2); //DrawImage(my_window->RPort,&BarelBottomLeft,176,206);
	else set_bkg_map( BarelBlankTiles, 19,20, 2, 2);

	if (Barels & 0x10) set_bkg_map( BarelLeftTiles, 26,20, 2, 2); //DrawImage(my_window->RPort,&BarelLeft,212,206);
	else set_bkg_map( BarelBlankTiles, 26,20, 2, 2);

}


void MoveMario(int MarioPlace){

int MarioX, MarioY,i;

MarioPlace *= 10;

MarioX = MarioCoordinates[MarioPlace+8];
MarioY = MarioCoordinates[MarioPlace+9];

for (i=0;i<3;i++) set_sprite(i, MarioX+i*8,    MarioY,    MarioCoordinates[MarioPlace+i]);
//	set_sprite(1, MarioX+8,  MarioY,    MarioCoordinates[MarioPlace+1]);
//	set_sprite(2, MarioX+16, MarioY,    MarioCoordinates[MarioPlace+2]);
for (i=0;i<3;i++) set_sprite(i+3, MarioX+i*8,    MarioY+8,    MarioCoordinates[MarioPlace+i+3]);
//	set_sprite(3, MarioX,    MarioY+8,  MarioCoordinates[MarioPlace+3]);
//	set_sprite(4, MarioX+8 , MarioY+8,  MarioCoordinates[MarioPlace+4]);
//	set_sprite(5, MarioX+16, MarioY+8,  MarioCoordinates[MarioPlace+5]);
	set_sprite(6, MarioX,    MarioY+16, MarioCoordinates[MarioPlace+6]);
	set_sprite(7, MarioX+8,  MarioY+16, MarioCoordinates[MarioPlace+7]);

}


//void pause_handler() {
//Delay(500);
//}

void DrawGirder1(int x) {
	set_bkg_map( Girder1Tiles,    x, 11, 3, 2);
}

void DrawGirder2(int x) {
	set_bkg_map( Girder2Tiles,    x, 11, 3, 2);
}

void ClearGirder(int x) {
	set_bkg_map( &GameScreen[4],    x, 11, 3, 2);
}

void DrawCraneControl(int Control){
if (Control){
//SetAPen(my_window->RPort,0);
//RectFill(my_window->RPort,68,98,76,99);
//RectFill(my_window->RPort,224,90,253,97);
//SetAPen(my_window->RPort,17);
//WritePixel(my_window->RPort,74,100);
//WritePixel(my_window->RPort,76,100);
//SetAPen(my_window->RPort,7);
//WritePixel(my_window->RPort,75,101);
set_bkg_map( &CraneControlUp, 4,7, 1, 1); //DrawImage(my_window->RPort,&CraneControlUp,64,88);
set_bkg_map( CraneStick, 24,4, 6, 1); //DrawImage(my_window->RPort,&CraneStick,206,54);
set_bkg_map( &GameScreen[4], 26,7, 4, 1); //DrawImage(my_window->RPort,&CraneStick,206,54);
//MarioBob->BobVSprite->ImageData = MarioManetteHandUp;
//MarioBob->BobVSprite->X=73;
//InitMasks(MarioBob->BobVSprite);
}

	else {
//	SetAPen(my_window->RPort,0);
//	RectFill(my_window->RPort,64,88,70,96);
//	RectFill(my_window->RPort,206,54,253,61);
//	RectFill(my_window->RPort,196,60,205,67);
//	SetAPen(my_window->RPort,4);
//	RectFill(my_window->RPort,74,98,75,98);
//	RectFill(my_window->RPort,68,99,76,99);
//	WritePixel(my_window->RPort,74,100);
//	WritePixel(my_window->RPort,76,100);
//	WritePixel(my_window->RPort,75,101);
set_bkg_map( &GameScreen[4], 22,4, 8, 1); //DrawImage(my_window->RPort,&CraneStick,206,54);
set_bkg_map( &GameScreen[220], 4,7, 1, 1); //DrawImage(my_window->RPort,&CraneControlUp,64,88);
set_bkg_map( CraneStick, 26,7, 4, 1); //DrawImage(my_window->RPort,&CraneControlUp,64,88);
//	DrawImage(my_window->RPort,&CraneStickSmall,224,90);
}
//SetAPen(my_window->RPort,0);
}

int HighScore,Score,KingKongPosition,Level,Lives,NewGame;

void DrawNumberTile (int number, int x)
{
	set_bkg_map( &NumberTiles[number*2],    x, 22, 1, 2);
}


void DrawHighScore(int ScoreNumber){
DrawNumberTile ((ScoreNumber/1000),26);
DrawNumberTile (((ScoreNumber%1000)/100),27);
DrawNumberTile (((ScoreNumber%100)/10),28);
DrawNumberTile ((ScoreNumber%10),29);

}

int DrawScore(int ScoreNumber){
if (ScoreNumber>9999) {//EndSequence();

ScoreNumber=Barels=Barels2=0;
DrawBarels();

do  {
set_bkg_map( &GameScreen[279],1,ScoreNumber,31,1);

ScoreNumber++;} while (ScoreNumber<24);

do {
set_bkg_map( &GameScreen[279],6,ScoreNumber,2,1);
ScoreNumber--;
} while (ScoreNumber>12);

DrawKong(24,159,&KingKongSprite[32]);
DrawCraneControl(0);
set_bkg_map( FinalPrincess,4,7,2,4);
set_bkg_map( &GameScreen[565],3,11,5,1);
set_bkg_map( &GameScreen[596],3,12,5,1);

MoveMario(25);
while (1)

{
ScoreNumber = read_joypad1();
Delay(3);

		if ((ScoreNumber & JOY_FIREA))	{clear_vram(); return 1;}

set_bkg_map( Heart, 6,7, 1, 1);
//DrawImage(my_window->RPort,&SmallHeart,68,24);
set_sound_freq(0,1150);	set_sound_volume(0, 0x0A);
//DrawScore(++Score);Delay(3);
//WaitTOF();

set_bkg_map( &Heart[1], 7,6, 1, 1);
//DrawImage(my_window->RPort,&BigHeart1,72,18);

Delay(3);//wait_vblank_noint();//WaitTOF();RectFill(my_window->RPort,68,24,72,29);
set_bkg_map( &GameScreen[4], 6,6, 2, 2);

}

}

if ((ScoreNumber%2000)==0) {Lives+=(Lives<4);DrawLives();}
DrawNumberTile ((ScoreNumber/1000),18);
DrawNumberTile (((ScoreNumber%1000)/100),19);
DrawNumberTile (((ScoreNumber%100)/10),20);
DrawNumberTile ((ScoreNumber%10),21);
if (ScoreNumber>HighScore) {DrawHighScore(HighScore=ScoreNumber);}

return 0;
}

void DrawLivesTiles (int x)
{
			set_bkg_map( LivesTiles,    x, 22, 2, 2);
}

void DrawBlankTiles (int x)
{
			set_bkg_map( &GameScreen[738], x,22, 2, 2);
}


DrawLives()
{

	if (Lives>3) DrawLivesTiles(10);
		 else DrawBlankTiles(10);

	if (Lives>2) DrawLivesTiles(8);
		 else DrawBlankTiles(8);

	if (Lives>1) DrawLivesTiles(6);
		 else DrawBlankTiles(6);
}


LevelScreen() {
		/* Draw new screen */

	load_tiles(&KingKong_TitleGraphics[6432], 0, 448, Lives=4);

	set_bkg_map( GameScreen, 1, 0, 31, 24);

	DrawLives();

	DrawScore(Score=0);
	DrawHighScore(HighScore);Level=2;

	DrawCraneControl(0);

	wait_vblank_noint();

	load_palette(GraphicsPalette, 0, 32);
//	load_palette(SpritesPalette, 16, 16);

}

//char version[]="$VER: King Kong V1.0  2003-2009";

void main() {

char *KongState;

int MarioPosition,KingKongX,RandomSeed, Direction,Jump,CraneStatus,Hooks,DeadFlag,JoyStack,Girder,Ticks,
GirderDelay,BarelDelay;

START:
NewGame=TRUE;

//	add_raster_int(vbl_handler);
//	add_pause_int(pause_handler);

clear_vram();

while (TRUE) {
	set_vdp_reg(VDP_REG_HINT_COUNTER, 0xFF);
	set_vdp_reg(VDP_REG_FLAGS1, VDP_REG_FLAGS1_SCREEN/* | VDP_REG_FLAGS1_VINT*/);
	set_bkg_map(TitleScreen, 2, 2,  8,15); set_bkg_map(TitleScreenRight, 16, 3, 16,11);
	set_bkg_map(TitleScreen2,5,18, 22, 3);

//goto TEST;

	load_tiles(KingKong_TitleGraphics, 0, 448, 4);
	load_palette(GraphicsPalette, 0, 16);
//	load_palette(SpritesPalette, 16, 16);





	while (1) {
		JoyStack = read_joypad1();
//		wait_vblank_noint();

	/* Wait for fire on the title screen. Do some additional stuff here, after finishing the game */
	/* Text on sprites etc.... */

		if ((JoyStack & JOY_FIREA)) {
			break;
		}

		RandomSeed++;

		}

		srand (RandomSeed);

		/* Fade out screen */

	clear_vram();


  /* Stay in the while loop until the end */
  while( 1 )
  {
if (NewGame) {LevelScreen();Hooks=4;
BarelDelay=6;GirderDelay=5;;
KongState=&KingKongSprite[0];
MoveMario(Barels=Barels2=Jump=CraneStatus=Girder=NewGame=KingKongPosition=MarioPosition=0);
}

//TEST:

/* Game here */

if (Direction==0) {
if (JoyStack=read_joypad1()){if (KeyFlag==FALSE){
KeyFlag=TRUE;
if (JoyStack & JOY_UP)   {Direction=UP;}
if (JoyStack & JOY_DOWN) {Direction=DOWN;}
if (JoyStack & JOY_LEFT) {Direction=LEFT;}
if (JoyStack & JOY_RIGHT){Direction=RIGHT;}
if ((JoyStack & JOY_FIREA) && Jump==0) {Jump=6;}
}} else if (KeyFlag && Direction==0) KeyFlag=FALSE;}


/* Mario moves: */
if (Direction && Jump==0) switch (Direction) {
        case LEFT:

if (MarioPosition==12) if (CraneStatus==0) DrawCraneControl(CraneStatus=21);

if (MarioPosition>0 && MarioPosition<5) if  
((MarioPosition==1 && (Barels & 0x1))|| (MarioPosition==0x2 && (Barels & 0x2))
|| (MarioPosition==3 && (Barels & 0x4))|| (MarioPosition==0x4 && (Barels & 0x8)))
 DeadFlag=TRUE; else {MoveMario(--MarioPosition);Ticks++;}
if (MarioPosition>4 && MarioPosition<9) if 
((MarioPosition==5 && (Barels & 0x40))|| (MarioPosition==6 && (Barels & 0x80))
|| (MarioPosition==7 &&(Barels & 0x100))|| (MarioPosition==8 &&(Barels & 0x200)))
 DeadFlag=TRUE; else {MoveMario(++MarioPosition);Ticks++;}
if (MarioPosition>12) {MoveMario(--MarioPosition);Ticks++;}
break;
          case RIGHT:
if (MarioPosition==5) if (Barels & 0x20) DeadFlag=TRUE;
else MoveMario(MarioPosition=17); else {
if (MarioPosition<4) if
((MarioPosition==0 && (Barels & 0x1))  || (MarioPosition==1 && (Barels & 0x2))
|| (MarioPosition==2 && (Barels & 0x4))|| (MarioPosition==3 && (Barels & 0x8)))
DeadFlag=TRUE; else {MoveMario(++MarioPosition);Ticks++;}
if (MarioPosition>5 && MarioPosition<10) if
((MarioPosition==6 && (Barels & 0x40))  || (MarioPosition==7 && (Barels & 0x80))
|| (MarioPosition==8 &&(Barels & 0x100))|| (MarioPosition==9 &&(Barels & 0x200)))
DeadFlag=TRUE; else {MoveMario(--MarioPosition);Ticks++;}

if (MarioPosition>11&&MarioPosition<15){MoveMario(++MarioPosition);Ticks++;}}
break;

       case UP:
if (MarioPosition==4) {MoveMario(++MarioPosition);Ticks++;}
if (MarioPosition>8 && MarioPosition<12){MoveMario(++MarioPosition);Ticks++;}
break;

       case DOWN:
if (MarioPosition==5) {MoveMario(--MarioPosition);Ticks++;}
if (MarioPosition>9 && MarioPosition<13){MoveMario(--MarioPosition);Ticks++;}
break;
}

/* Is the crane switched on? */
if (CraneStatus) {
CraneStatus--;if (MarioPosition==12) if (CraneStatus) {
MoveMario(27);

//MarioBob->BobVSprite->ImageData = MarioManetteHandUp;
//MarioBob->BobVSprite->X=73;
//InitMasks(MarioBob->BobVSprite);

} else {MoveMario(MarioPosition);}

 switch(CraneStatus) {
case 20:
set_bkg_map( CraneHook1, 24,5, 2, 1);
// DrawImage(my_window->RPort,&CraneHook1,212,61);
 break;

case 16:
set_bkg_map( CraneHook2, 24,5, 2, 1);
// RectFill(my_window->RPort,212,61,223,64);
// DrawImage(my_window->RPort,&CraneHook2,210,62);
 break;

case 12:
set_bkg_map( CraneHook3, 24,5, 1, 2);
// RectFill(my_window->RPort,210,62,217,69);
// DrawImage(my_window->RPort,&CraneHook3,208,62);
 break;

case 8:
set_bkg_map( &GameScreen[4], 24,5, 1, 2);
set_bkg_map( CraneHook4, 23,4, 1, 2);
// RectFill(my_window->RPort,208,62,211,73);
// DrawImage(my_window->RPort,&CraneHook4,201,61);
 break;

case 4:
set_bkg_map( CraneHook5, 22,4, 2, 2);
// RectFill(my_window->RPort,201,61,206,71);
// DrawImage(my_window->RPort,&CraneHook5,196,60);
 break;

case 0:
if (MarioPosition==12){
MoveMario(MarioPosition);   //SortGList(my_window->RPort);WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
}
DrawCraneControl(0);
break;
}
}

/* Work is done with movement and message variables, erase them: */
Direction=0;

/* Is Mario Jumping? */
if (Jump) {
Jump--;if (Jump==5) switch (MarioPosition) {
 case 0: MoveMario(MarioPosition=19);Ticks++;break;
 case 3: MoveMario(MarioPosition=20);Ticks++;break;
 case 6: MoveMario(MarioPosition=21);Ticks++;break;
 case 7: MoveMario(MarioPosition=22);Ticks++;break;
 case 14: MoveMario(MarioPosition=23);Jump=1;Ticks++;
 if (CraneStatus) CraneStatus++;
 break;
 default: Jump=0;break;
}
if (Jump==0) switch (MarioPosition) {
 case 19: MoveMario(MarioPosition=0);break;
 case 20: MoveMario(MarioPosition=3);break;
 case 21: MoveMario(MarioPosition=6);break;
 case 22: MoveMario(MarioPosition=7);break;
 case 23:

Delay(20);

if (CraneStatus>0 && CraneStatus<5)
 {


set_bkg_map( CraneStick, 22,0, 8, 1); //DrawImage(my_window->RPort,&CraneControlUp,64,88);
set_bkg_map( &GameScreen[4], 22,4, 8, 1); //DrawImage(my_window->RPort,&CraneStick,206,54);

MoveMario(24);//SortGList(my_window->RPort);WaitTOF();

//DrawGList(my_window->RPort, ViewPortAddress(my_window));
//DrawBarels();
//RectFill(my_window->RPort,196,60,205,67);
//DrawImage(my_window->RPort,&CraneStickSmall,224,16);
//SetAPen(my_window->RPort,20);
//RectFill(my_window->RPort,226,24,226,29);
//SetAPen(my_window->RPort,0);
//RectFill(my_window->RPort,206,54,253,61);
Delay(5);//WaitTOF();
set_bkg_map( &GameScreen[4], 16+Hooks,2, 1, 3); //RectFill(my_window->RPort,176+RandomSeed*6,33,181+RandomSeed*6,58);
for (Direction=0;Direction<10;Direction++) {Delay(3); NewGame=DrawScore(++Score);}
//WaitTOF();
if (Hooks==1) {/* KingKong Falls */

Delay(10);//wait_vblank_noint();//WaitTOF();/*Sound */
//KingKongBob->BobVSprite->X=116;
//InitMasks(KingKongBob->BobVSprite);
//SortGList(my_window->RPort);WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));

set_bkg_map( &GameScreen[188], 5,3,12, 2);

//for(Direction=74;Direction<147;Direction+=36) {}//DrawImage(my_window->RPort,&Platform,i,54);
Delay(10);//wait_vblank_noint();//WaitTOF();/*Sound */

DrawKong(72,-1,KingKongSprite);
set_bkg_map( &GameScreen[128], 5,4,12, 1);

//RectFill(my_window->RPort,74,54,181,58);
Delay(10);
DrawKong(104,-1,&KongState[0]);
set_bkg_map( &GameScreen[188], 5,3,12, 2);

//wait_vblank_noint();//WaitTOF();/*Sound */
//KingKongBob->BobVSprite->X=152;
//InitMasks(KingKongBob->BobVSprite);
//SortGList(my_window->RPort);WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
//for(Direction=74;Direction<147;Direction+=36) {}//DrawImage(my_window->RPort,&Platform,i,54);
//Delay(5);//RectFill(my_window->RPort,74,54,181,58);
//DrawImage(my_window->RPort,&PlatformFalling1,74,58);
//DrawImage(my_window->RPort,&PlatformFalling12,65,73);
//DrawImage(my_window->RPort,&PlatformFalling2,108,60);
//DrawImage(my_window->RPort,&PlatformFalling31,141,60);
//DrawImage(my_window->RPort,&PlatformFalling32,133,68);
//KingKongBob->BobVSprite->ImageData = KingKongFelt;
//KingKongBob->BobVSprite->X=176;
//KingKongBob->BobVSprite->Y=94;
//InitMasks(KingKongBob->BobVSprite);
//SortGList(my_window->RPort);WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
Delay(25);

set_bkg_map( Platform1Falling,5,3,3, 4);

set_bkg_map( Platform2Falling,11,3,2, 4);

set_bkg_map( Platform3Falling,16,3,3, 4);

DrawKong(165,53,&KingKongFeltSprite[Direction=0]);

do {

set_bkg_map( Heart, 5,1, 1, 1);
//DrawImage(my_window->RPort,&SmallHeart,68,24);
set_sound_freq(0,1150);	set_sound_volume(0, 0x0A);
NewGame=DrawScore(++Score);Delay(3);
//WaitTOF();

set_bkg_map( &Heart[1], 6,0, 1, 1);
//DrawImage(my_window->RPort,&BigHeart1,72,18);

Delay(3);//wait_vblank_noint();//WaitTOF();RectFill(my_window->RPort,68,24,72,29);
set_bkg_map( &GameScreen[4], 5,0, 2, 2);
//RectFill(my_window->RPort,72,18,79,25);
//Delay(1);
Direction++;
} while (Direction<20);
if (Score>5000) {set_bkg_map( HappyPrincess,3,0,2, 4);//DrawImage(my_window->RPort,&HappyPrincess,57,23);
Level=8;}
Level+=(Level<7);Direction=0;

set_bkg_map( &GameScreen[4],5,3,3, 4);

set_bkg_map( &GameScreen[4],11,3,2, 4);

set_bkg_map( &GameScreen[4],16,3,3, 4);

set_bkg_map( &GameScreen[128], 5,4,12, 1);

do {
set_bkg_map( Hook, 16+Hooks,2, 1, 3);
Hooks++;
}
while (Hooks<5);

}

//RectFill(my_window->RPort,224,16,253,29);
set_bkg_map( &GameScreen[4], 22,0, 8, 1); //DrawImage(my_window->RPort,&CraneStick,206,54);
DrawCraneControl(1);
MoveMario(23);//DrawImage(my_window->RPort,&CraneStick,206,54);
//DrawImage(my_window->RPort,&CraneHook5,196,60);
//SortGList(my_window->RPort);WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
Delay(20);
//RectFill(my_window->RPort,206,54,253,61);
DrawCraneControl(0);
MoveMario(25);//SortGList(my_window->RPort);
//wait_vblank_noint();//WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
//RectFill(my_window->RPort,196,60,205,67);
//DrawImage(my_window->RPort,&CraneStickSmall,224,90);
//SetAPen(my_window->RPort,20);
//RectFill(my_window->RPort,226,98,226,100);
Delay(20);
MoveMario(0);
if (Direction==0) {
//KingKongBob->BobVSprite->ImageData = KingKong;
//KingKongBob->BobVSprite->X=80;
//KingKongBob->BobVSprite->Y=19;
//InitMasks(KingKongBob->BobVSprite);WaitTOF();
//for(Direction=182;Direction<201;Direction+=6) {}//DrawImage(my_window->RPort,&Hook,i,33);
//KingKongPosition=0;
//SetAPen(my_window->RPort,0);
//RectFill(my_window->RPort,73,58,85,74);
//for(Direction=74;Direction<147;Direction+=36) {}//DrawImage(my_window->RPort,&Platform,i,54);
//RectFill(my_window->RPort,65,75,75,87);
//RectFill(my_window->RPort,108,60,121,96);
//RectFill(my_window->RPort,141,60,162,67);
//RectFill(my_window->RPort,133,68,146,71);
}
//SortGList(my_window->RPort);WaitTOF();
//wait_vblank_noint();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
//SetAPen(my_window->RPort,0);
//RectFill(my_window->RPort,226,98,226,100);
//RectFill(my_window->RPort,196,60,205,67);

Hooks--;

Barels&=0xFFF8;

 MarioPosition=0;break;}
 MoveMario(MarioPosition=15);
 break;
 default: KeyFlag=FALSE;break;
}
}


/* Delay more or less ((6-(Level/2))/50) seconds. Depending on Level. */
Delay(6-(Level/2));//SortGList(my_window->RPort);
//WaitTOF(); /* Wait for the beam and draw the bobs and the Barels: */
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
DrawBarels();

//wait_vblank_noint();

/* If the Girder Delay needs refresh - redraw the girders */
GirderDelay--; if (GirderDelay==0) {Girder<<=1;
GirderDelay=5; if ((rand()%90)<11+Level) Girder++;
if (Girder & 16) DrawGirder1(4); //DrawImage(my_window->RPort,&Girder1,68,131);
 else ClearGirder(4);            //RectFill(my_window->RPort, 68,131, 91,141);
if (Girder & 8) DrawGirder2(8);  //DrawImage(my_window->RPort,&Girder2,98,131);
 else ClearGirder(8);            //RectFill(my_window->RPort, 98,131,121,141);
if (Girder & 4) DrawGirder1(12); //DrawImage(my_window->RPort,&Girder1,128,131);
 else ClearGirder(12);           //RectFill(my_window->RPort,128,131,151,141);
if (Girder & 2) DrawGirder2(16); //DrawImage(my_window->RPort,&Girder2,158,131);
 else ClearGirder(16);           //RectFill(my_window->RPort,158,131,181,141);
if (Girder & 1) DrawGirder1(20); //DrawImage(my_window->RPort,&Girder1,188,131);
 else ClearGirder(20);           //RectFill(my_window->RPort,188,131,211,141);
}
BarelDelay--; if (BarelDelay==0) {Ticks+=2;//Ticks++;
/* Check if Barel hits Mario */
if ((MarioPosition==0 &&(Barels & 0x1)) || (MarioPosition==1 && (Barels & 0x2))
|| (MarioPosition==2 &&(Barels & 0x4))  || (MarioPosition==3 && (Barels & 0x8)))
DeadFlag=TRUE;

if ((MarioPosition==4 &&(Barels & 0x10)) || (MarioPosition==5 && (Barels & 0x40))
|| (MarioPosition==6 &&(Barels & 0x80))||(MarioPosition==7 && (Barels & 0x100))
||(MarioPosition==8 &&(Barels & 0x200))||(MarioPosition==9 && (Barels & 0x400))
||(MarioPosition==11&&(Barels&0x1000))||(MarioPosition==12&&(Barels&0x4000))
|| (MarioPosition==13 && (Barels2 & 0x8))
|| (MarioPosition==14 && (Barels2 & 0x100))) DeadFlag=TRUE;
if (DeadFlag==FALSE) {if (Barels & 1) NewGame=DrawScore(++Score);
if (Barels2 & 0x20) Barels2=(Barels2 & 0xFFDF)|0x4;
if (Barels2 & 0x1 ) Barels|=0x2000;
 Barels  >>=1;
 Barels2 >>=1; BarelDelay=6;
if (KingKongPosition & 8 ) {
if (KingKongPosition== 8) Barels|=0x8000;
if (KingKongPosition== 9) Barels2|=0x10;
if (KingKongPosition==10) Barels2|=0x200;
KingKongPosition-=4;
//KingKongBob->BobVSprite->ImageData = KingKong;

KongState=&KingKongSprite[0];

}
else if (KingKongPosition & 4) KingKongPosition-=4; else {
if ((rand()%90)<26+Level) {KingKongPosition+=8;
//KingKongBob->BobVSprite->ImageData=KingKongBarel;

KongState = &KingKongThrowSprite[0];


} else if ((rand()%90<45))
{if (KingKongPosition==1) if ((rand() % 20)<10)
KingKongPosition=0; else KingKongPosition=2;
else KingKongPosition=1;
//KingKongBob->BobVSprite->X=KongXCoordinates[KingKongPosition];

}
}

//InitMasks(KingKongBob->BobVSprite);
} else BarelDelay=1;
}

DrawKong(KongXCoordinates[KingKongPosition%4],-1,&KongState[0]);

/* Make The Ticks. */
if (Ticks) { set_sound_freq(Ticks=0,3150);	set_sound_volume(0, 0x0A);
		}

/* Check for some killing positions */
if (MarioPosition==15 || MarioPosition==17) {++MarioPosition;DeadFlag=TRUE;}

if ((MarioPosition==10 &&(Girder & 16))||(MarioPosition==21 &&(Girder & 2 ))
|| (MarioPosition==22 && (Girder & 4 ))) DeadFlag=TRUE;

if (DeadFlag) {//StartSong(4);
Delay(15);
for (Jump=0;Jump<4;Jump++){
Delay(10);
MoveMario(MarioPosition);set_sound_freq(0,1150);set_sound_volume(0, 0x0A);//StartSong(2);
//SortGList(my_window->RPort);WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
DrawBarels();
Delay(10);
//MarioBob->BobVSprite->ImageData = MarioBlank;
//InitMasks(MarioBob->BobVSprite);
//SortGList(my_window->RPort);WaitTOF();
//DrawGList(my_window->RPort, ViewPortAddress(my_window));
MoveMario(26);
DrawBarels();}
MoveMario(MarioPosition=0);Lives--;DrawLives();
/* Remove first three barels and clear the flags */
Barels&=0xFFF8;DeadFlag=Jump=FALSE;

if (Lives==0) {
//GameOver();
Barels=Barels2=0;DrawBarels();
Barels=113;Barels2=99;CraneStatus=GirderDelay=-1;Girder=Ticks=1;
Jump=-3;
KingKongPosition=72;

while (1) {

set_bkg_map( &PrincessCrying[((GirderDelay>0?1:0)*8)], 3,RandomSeed=0,2, 4);

wait_vblank_noint();

DrawKong(KingKongPosition,Jump,&KingKongSprite[0]);

Delay(2);//wait_vblank_noint();

do {

set_sprite(RandomSeed,Barels+RandomSeed*8,Barels2,GameOverSprite[RandomSeed]);
set_sprite(RandomSeed+4,Barels+RandomSeed*8,Barels2+8,GameOverSprite[RandomSeed+4]);
RandomSeed++;

} while (RandomSeed<4);
Barels+=CraneStatus;
Barels2+=Girder;
KingKongPosition+=Ticks;
if (KingKongPosition%4==0) Jump+=GirderDelay;
if (KingKongPosition%16==0) {GirderDelay=-GirderDelay;set_sound_freq(0,950);	set_sound_volume(0, 0x0A);}

if (KingKongPosition<41 || KingKongPosition>103) Ticks=-Ticks;
if (Barels<24  || Barels>208) CraneStatus=-CraneStatus;
if (Barels2<34 ||Barels2>158) Girder=-Girder;

//for (RandomSeed=0;RandomSeed<4;RandomSeed++) {
//set_sprite(52+RandomSeed,Barels+RandomSeed*8, Barels2+8,GameOverSprite[RandomSeed+4]);
//}

if (++NewGame>3000) goto START;

JoyStack = read_joypad1();
if	 ((JoyStack & JOY_FIREA)) break;

}

}

}

}

	}
}
