unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, GraphicEx;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Board: TImage;
    Button1: TButton;
    edtWidth: TEdit;
    edtHeight: TEdit;
    Memo1: TMemo;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    lblStatus: TLabel;
    Button6: TButton;
    ListBox1: TListBox;
    CheckBox1: TCheckBox;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    procedure Button1Click(Sender: TObject);
    procedure BoardMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BoardMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure ListBox1KeyPress(Sender: TObject; var Key: Char);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  bwidth,bheight:integer;
  DrawWith:TColor;
  rowhints:array[1..100,0..100] of integer; // hard-coded limits, lovely
  colhints:array[1..100,0..100] of integer;
const
  s=16;

implementation

{$R *.dfm}

procedure PopulateFilenameList();
var
  sr:TSearchRec;
begin
  // populate filename list
  Form1.ListBox1.Items.Clear();
  if FindFirst(ExtractFilePath(paramstr(0))+'boards\*.*', faAnyFile, sr) = 0 then begin
    repeat
      if (sr.Attr and faDirectory) = 0
      then Form1.ListBox1.Items.Add(sr.Name);
    until FindNext(sr) <> 0;
    FindClose(sr);
  end;
end;

procedure UpdateWH();
begin
  Form1.edtWidth.Text:=IntToStr(bwidth);
  Form1.edtHeight.Text:=IntToStr(bheight);
end;

procedure DrawBoard(c:TColor;bm:TBitmap);
var
  x,y:integer;
begin
  bm.Width:=(s+1)*(bwidth+3);
  bm.Height:=s*(bheight+2);
  with bm.Canvas do begin
    if c<>clFuchsia then begin
      Pen.Color:=clWhite;
      Brush.Color:=clWhite;
      Rectangle(0,0,bm.width,bm.height);
    end;

    Pen.Color:=clBlack;
    Brush.Color:=c;
    if c=clFuchsia then Brush.Style:=bsClear; // hack special case
    for x:=1 to bwidth do
    for y:=1 to bheight do
      Rectangle(x*s,y*s,(x+1)*s,(y+1)*s);
  end;
end;

function GetColour(x,y:integer;bm:TBitmap):TColor;
begin
  result:=bm.Canvas.Pixels[x*s+4,y*s+4];
end;

procedure UpdateSmall;
var
  x,y:integer;
  sml,smt:integer;
begin
  sml:=(bwidth+2)*s;
  smt:=s;

  for x:=1 to bwidth do
  for y:=1 to bheight do
  with Form1.Board.Canvas do
  begin
    Pixels[sml+x,smt+y]:=GetColour(x,y,Form1.Board.Picture.Bitmap);
  end;
end;

procedure SetColour(x,y:integer;c:TColor;bm:TBitmap);
begin
  if (X<1) or (Y<1) or (X>bwidth) or (Y>bheight) then exit;
  with bm.Canvas do begin
    Pen.Color:=clBlack;
    Brush.Color:=c;
    Rectangle(x*s,y*s,(x+1)*s,(y+1)*s);

    Pixels[(bwidth+2)*s+x,s+y]:=c;
  end;
end;

procedure GetHints;
var
  x,y,i,count:integer;
  c:TColor;
begin
  // rows
  for y:=1 to bheight do begin
    count:=0;
    i:=0;
    rowhints[y][0]:=0;
    for x:=1 to bwidth do begin
      // count blacks
      c:=GetColour(x,y,Form1.Board.Picture.Bitmap);
      if (c=clWhite) and (i>0)
      then begin
        Inc(count);
        rowhints[y][count]:=i;
        rowhints[y][0]:=count;
        i:=0;
      end
      else if c=clBlack then Inc(i);
    end;
    // may have ended on black
    if (i>0) then begin
      Inc(count);
      rowhints[y][count]:=i;
      rowhints[y][0]:=count;
    end;
  end;
  // columns (copy+paste)
  for x:=1 to bwidth do begin
    count:=0;
    i:=0;
    colhints[x][0]:=0;
    for y:=1 to bheight do begin
      // count blacks
      c:=GetColour(x,y,Form1.Board.Picture.Bitmap);
      if (c=clWhite) and (i>0)
      then begin
        Inc(count);
        colhints[x][count]:=i;
        colhints[x][0]:=count;
        i:=0;
      end
      else if c=clBlack then Inc(i);
    end;
    if (i>0) then begin
      Inc(count);
      colhints[x][count]:=i;
      colhints[x][0]:=count;
    end;
  end;
end;

function MakeHintText:string;
var
  x,y,i:integer;
begin
  GetHints;
  result:=Format('%d %d'#13#10,[bwidth,bheight]);
  // rows
  for y:=1 to bheight do begin
    for i:=1 to rowhints[y][0] do
      result:=result+Format('%d ',[rowhints[y][i]]);
    if rowhints[y][0]=0 then result:=result+'0';
    result:=result+#13#10;
  end;
  // cols
  for x:=1 to bwidth do begin
    for i:=1 to colhints[x][0] do
      result:=result+Format('%d ',[colhints[x][i]]);
    if colhints[x][0]=0 then result:=result+'0';
    result:=result+#13#10;
  end;
end;

procedure ParseString(s:string;sl:TStringList);
var
  i:integer;
  ts:string;
begin
  sl.Clear;
  ts:='';
  for i:=1 to Length(s) do begin
    if s[i]=' ' then begin
      if Length(ts)>0 then sl.Add(ts);
      ts:='';
    end else ts:=ts+s[i];
  end;
  if Length(ts)>0 then sl.Add(ts);
end;

function IsXLegal(x,y:integer;bm:TBitmap):boolean;
var
  prevWasBlack:boolean;
  hintNum:integer; // which hint are we processing
  consecCount:integer; // how many consecutive black tiles so far
	nX:integer;
  breakout:boolean;
begin
  // initialisation
  prevWasBlack:=false;
  hintNum:=0;
  consecCount:=0;
  breakout:=false;

  for nX:=1 to bwidth do begin
    if GetColour(nX,y,bm)=clBlack then begin
      if not prevWasBlack // new black sequence encountered
      then Inc(hintNum);

      Inc(consecCount);
      if (hintNum>rowhints[y][0]) // there are more black tile strips than there are hints,
      or (consecCount>rowhints[y][hintNum]) // or the current black strip is larger than the hints permit
      then begin
        result:=false;
        exit;
      end;

      prevWasBlack:=true;
    end else if GetColour(nX,y,bm)=clWhite then begin
      if prevWasBlack then begin
        if consecCount<>rowHints[y][hintNum] then begin
          result:=false;
          exit;
        end;

        prevWasBlack:=false;
        consecCount:=0;
      end;
    end else begin
      // if it's still legal when we encounter the first undefined
      // tile, the entire row is legal
      breakout:=true;
      break; // out of for loop
    end;
  end;

  if not breakout then begin
    // the entire row is filled, so the hints must be completely matched
    if hintNum=rowhints[y][0] then begin
      if prevWasBlack then begin
        // we haven't done the check for the last black strip, so do it now
        if consecCount=rowhints[y][hintNum] then begin
          result:=true;
          exit;
        end else begin
          result:=false;
          exit;
        end;
      end else begin
        result:=true;
        exit;
      end;
    end else begin
      result:=false;
      exit;
    end;
  end;
  result:=true;
end;

function IsYLegal(x,y:integer;bm:TBitmap):boolean;
var
  prevWasBlack:boolean;
  hintNum:integer; // which hint are we processing
  consecCount:integer; // how many consecutive black tiles so far
	nY:integer;
  breakout:boolean;
begin
  // initialisation
  prevWasBlack:=false;
  hintNum:=0;
  consecCount:=0;
  breakout:=false;

  for nY:=1 to bheight do begin
    if GetColour(x,nY,bm)=clBlack then begin
      if not prevWasBlack // new black sequence encountered
      then Inc(hintNum);

      Inc(consecCount);
      if (hintNum>colhints[x][0]) // there are more black tile strips than there are hints,
      or (consecCount>colhints[x][hintNum]) // or the current black strip is larger than the hints permit
      then begin
        result:=false;
        exit;
      end;

      prevWasBlack:=true;
    end else if GetColour(x,nY,bm)=clWhite then begin
      if prevWasBlack then begin
        if consecCount<>colHints[x][hintNum] then begin
          result:=false;
          exit;
        end;

        prevWasBlack:=false;
        consecCount:=0;
      end;
    end else begin
      // if it's still legal when we encounter the first undefined
      // tile, the entire row is legal
      breakout:=true;
      break; // out of for loop
    end;
  end;

  if not breakout then begin
    // the entire row is filled, so the hints must be completely matched
    if hintNum=colhints[x][0] then begin
      if prevWasBlack then begin
        // we haven't done the check for the last black strip, so do it now
        if consecCount=colhints[x][hintNum] then begin
          result:=true;
          exit;
        end else begin
          result:=false;
          exit;
        end;
      end else begin
        result:=true;
        exit;
      end;
    end else begin
      result:=false;
      exit;
    end;
  end;
  result:=true;
end;

function IsLegal(x,y:integer;bm:TBitmap):boolean;
begin
  result:=IsXLegal(x,y,bm) and IsYLegal(x,y,bm);
end;

procedure MoveLeft(var x:integer;var y:integer;var solved:boolean);
begin
  Dec(x);
  if x=0 then begin
    x:=bwidth;
    Dec(y);
    if y=0 then solved:=true; // failure
  end;
end;

procedure MoveRight(var x:integer;var y:integer;var solved:boolean);
begin
  Inc(x);
  if x=bwidth+1 then begin
    x:=1;
    Inc(y);
    if y=bheight+1 then solved:=true; // success
  end;
end;

function Solve(visual:boolean):String;
var
  bm:TBitmap;
  solved:boolean;
  x,y:integer;
  c:TColor;
begin
  if visual then begin
    bm:=Form1.Board.Picture.Bitmap;
  end else
    bm:=TBitmap.Create;

  // draw to a bitmap in memory
  DrawBoard(clGray,bm);

  // iterate...
  solved:=false;
  x:=1;
  y:=1;

  while not solved do begin
    if visual then Application.ProcessMessages;
    c:=GetColour(x,y,bm);
    if c=clGray then begin
      // undefined, try white
      SetColour(x,y,clWhite,bm);
      if IsLegal(x,y,bm) then MoveRight(x,y,solved);
    end else if c=clWhite then begin
      // white failed, try black
      SetColour(x,y,clBlack,bm);
      if IsLegal(x,y,bm) then MoveRight(x,y,solved);
    end else begin
      // black failed too, move back
      SetColour(x,y,clGray,bm);
      MoveLeft(x,y,solved);
    end;
  end;

  if y=0 then result:='failed!'
  else
  if not visual then Form1.Board.Picture.Assign(bm);

  if not visual then bm.Free;
end;

function SolveText(const s:String):String;
var
  sl,tsl:TStringList;
  w,h,i,j:integer;
  ts:String;
begin
  // parse in board data
  sl:=TStringList.Create;
  tsl:=TStringList.Create;
  sl.Text:=s;

  ts:=sl.Strings[0];
  w:=StrToIntDef(Copy(ts,1,Pos(' ',ts)-1),-1);
  h:=StrToIntDef(Copy(ts,Pos(' ',ts)+1,10),-1);
  if (w=-1) then begin
    result:='Bad width';
    exit;
  end;
  if (h=-1) then begin
    result:='Bad height';
    exit;
  end;
  if (sl.Count <> w+h+1) then begin
    result:='Data does not match width, height';
    exit;
  end;

  // parse in rows, cols
  for i:=1 to h do begin
    ParseString(sl.Strings[i],tsl);
    rowhints[i][0]:=tsl.Count; // 1st item says how many
    for j:=0 to tsl.Count-1 do
      rowhints[i][j+1]:=StrToInt(tsl.Strings[j]);
  end;

  for i:=h+1 to w+h do begin
    ParseString(sl.Strings[i],tsl);
    colhints[i-h][0]:=tsl.Count; // 1st item says how many
    for j:=0 to tsl.Count-1 do
      colhints[i-h][j+1]:=StrToInt(tsl.Strings[j]);
  end;

  bwidth:=w;
  bheight:=h;

  result:=Solve(false);

  tsl.Free;
  sl.Free;
end;

//////////////////////////////////////////////

procedure TForm1.Button1Click(Sender: TObject);
begin
  bwidth:=StrToInt(EdtWidth.Text);
  bheight:=StrToInt(EdtHeight.Text);
  DrawBoard(clWhite,Form1.Board.Picture.Bitmap);
end;

procedure TForm1.BoardMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  X:=X div s;
  Y:=Y div s;
  if Button=mbLeft
  then SetColour(X,Y,clBlack,Form1.Board.Picture.Bitmap)
  else SetColour(X,Y,clWhite,Form1.Board.Picture.Bitmap);
  if CheckBox1.Checked then Button6.Click;
end;

procedure TForm1.BoardMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  c:TColor;
begin
  X:=X div s;
  Y:=Y div s;
  c:=GetColour(X,Y,Form1.Board.Picture.Bitmap);
  if ssLeft in Shift
  then SetColour(X,Y,clBlack,Form1.Board.Picture.Bitmap)
  else if ssRight in Shift
  then SetColour(X,Y,clWhite,Form1.Board.Picture.Bitmap);
  if CheckBox1.Checked and (GetColour(X,Y,Form1.Board.Picture.Bitmap)<>c) then Button6.Click;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  UpdateSmall;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Memo1.Text:=MakeHintText;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  s:string;
begin
  s:=SolveText(Memo1.Text);
  UpdateWH();
  if Length(s)>0 then Memo1.Lines.Insert(0,s);
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  success:string;
begin
  // parse image for hints
  GetHints;
  success:=Solve(true);
  if Length(success)=0 then begin
    lblStatus.Caption:='OK';
    lblStatus.Font.Color:=clGreen;
  end else begin
    lblStatus.Caption:='Bad';
    lblStatus.Font.Color:=clRed;
  end;
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  data:string;
  tsi: TStartupInfo;
  tpi: TProcessInformation;
  nRead: DWORD;
  aBuf: Array[0..101] of char;
  sa: TSecurityAttributes;
  hOutputReadTmp, hOutputRead, hOutputWrite, hInputWriteTmp, hInputRead,
  hInputWrite, hErrorWrite: THandle;
  FOutput,Cmd,WorkDir: String;
begin
  WorkDir:=ExtractFilePath(ParamStr(0));
  cmd:='nonogram.exe';
  data:=MakeHintText+#26;

  FOutput := '';

  sa.nLength              := SizeOf(TSecurityAttributes);
  sa.lpSecurityDescriptor := nil;
  sa.bInheritHandle       := True;

  CreatePipe(hOutputReadTmp, hOutputWrite, @sa, 0);
  DuplicateHandle(GetCurrentProcess(), hOutputWrite, GetCurrentProcess(),
    @hErrorWrite, 0, true, DUPLICATE_SAME_ACCESS);
  CreatePipe(hInputRead, hInputWriteTmp, @sa, 0);

  // Create new output read handle and the input write handle. Set
  // the inheritance properties to FALSE. Otherwise, the child inherits
  // the these handles; resulting in non-closeable handles to the pipes
  // being created.
  DuplicateHandle(GetCurrentProcess(), hOutputReadTmp,  GetCurrentProcess(),
    @hOutputRead,  0, false, DUPLICATE_SAME_ACCESS);
  DuplicateHandle(GetCurrentProcess(), hInputWriteTmp, GetCurrentProcess(),
    @hInputWrite, 0, false, DUPLICATE_SAME_ACCESS);
  CloseHandle(hOutputReadTmp);
  CloseHandle(hInputWriteTmp);

  FillChar(tsi, SizeOf(TStartupInfo), 0);
  tsi.cb         := SizeOf(TStartupInfo);
  tsi.dwFlags    := STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
  tsi.hStdInput  := hInputRead;
  tsi.hStdOutput := hOutputWrite;
  tsi.hStdError  := hErrorWrite;

  CreateProcess(nil, PChar(Cmd), @sa, @sa, true, 0, nil, PChar(WorkDir),
    tsi, tpi);
  CloseHandle(hOutputWrite);
  CloseHandle(hInputRead );
  CloseHandle(hErrorWrite);
  Application.ProcessMessages;

  WriteFile(hInputWrite,data[1],Length(data),nRead,nil);
  repeat
     if (not ReadFile(hOutputRead, aBuf, 16, nRead, nil)) or (nRead = 0) then
     begin
        if GetLastError = ERROR_BROKEN_PIPE then Break
        else MessageDlg('Pipe read error, could not execute file', mtError, [mbOK], 0);
     end;
     aBuf[nRead] := #0;
     FOutput := FOutput + PChar(@aBuf[0]);
     Application.ProcessMessages;
  until False;

//  if GetExitCodeProcess(tpi.hProcess, nRead) = True
//  then form1.caption:=inttostr(nRead);
  Form1.Memo1.Text:=data+#13#10+FOutput;
  if Pos('Ambiguous',FOutput)>0 then begin
    lblStatus.Caption:='Bad';
    lblStatus.Font.Color:=clRed;
  end else if Pos('Inconsistent',FOutput)>0 then begin
    lblStatus.Caption:='Inconsistent!';
    lblStatus.Font.Color:=clRed;
  end else begin
    lblStatus.Caption:='OK';
    lblStatus.Font.Color:=clGreen;
  end;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  PopulateFilenameList();
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
var
  fn:string;
  pic:TPicture;
begin
  fn:=ExtractFilePath(ParamStr(0))+'boards\'+ListBox1.Items[ListBox1.ItemIndex];
  pic:=TPicture.Create();

  pic.LoadFromFile(fn);

  // convert to 1bpp
  pic.Bitmap.Monochrome:=true;

  // preview
  // Board.Canvas.Draw(0,0,pic.Bitmap);

  // draw into grid
  bwidth:=pic.Width;
  bheight:=pic.Height;
  UpdateWH();
  DrawBoard(clWhite,Board.Picture.Bitmap);
  Board.Canvas.StretchDraw(Rect(s,s,(bwidth+1)*s,(bheight+1)*s),pic.Bitmap);
  DrawBoard(clFuchsia,Board.Picture.Bitmap);
  pic.Free();
  UpdateSmall();
  Button6.Click();
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  PopulateFilenameList();
end;

procedure TForm1.ListBox1KeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then ListBox1DblClick(Sender);
end;

procedure TForm1.Button8Click(Sender: TObject);
var
  pic:TPicture;
begin
  with TSaveDialog.Create(Form1) do begin
    InitialDir:=ExtractFilePath(ParamStr(0))+'boards';
    Filter:='BMP files (*.bmp)|*.bmp|All files (*.*)|*.*';
    if Execute then begin
      pic:=TPicture.Create;
      pic.Bitmap.Width:=bwidth;
      pic.Bitmap.Height:=bheight;
      UpdateSmall;
      // the logic for these rects is a bit screwy but hey, it works...
      pic.Bitmap.Canvas.CopyRect(Rect(-1,-1,bwidth,bheight),Board.Canvas,Rect((bwidth+2)*s,s,(bwidth+2)*s+bwidth+1,s+bheight+1));
      pic.SaveToFile(FileName);
      PopulateFilenameList();
    end;
  end;
end;

procedure TForm1.Button9Click(Sender: TObject);
var
  sr:TSearchRec;
  filelist:TStringList;
  dir,fn,ofn:string;
  i,x,y:integer;
  bm:TBitmap;
  f,raw:TMemoryStream;
  c:TColor;
  b,current:Byte;
  s:string;
begin
  filelist:=TStringList.Create;

  dir:=ExtractFilePath(paramstr(0))+'boards\';
  if FindFirst(dir+'*.bmp', faAnyFile, sr) = 0 then begin
    repeat
      if (sr.Attr and faDirectory) = 0
      then filelist.Add(dir+sr.Name);
    until FindNext(sr) <> 0;
    FindClose(sr);
  end;

  bm:=TBitmap.Create;
  f:=TMemoryStream.Create;
  raw:=TMemoryStream.Create;

  for i:=0 to filelist.Count-1 do begin
    fn:=filelist[i];
    ofn:=ChangeFileExt(fn,'.rle1');
    bm.LoadFromFile(fn);
    f.Clear;
    raw.clear;
    b:=bm.width;
    f.Write(b,1);
    raw.write(b,1);
    b:=bm.height;
    f.Write(b,1);
    raw.write(b,1);
    // now to figure out a format...
    for y:=0 to bm.Height-1 do
    for x:=0 to bm.Width-1 do begin
      c:=bm.Canvas.Pixels[x,y];
      if c=clBlack then b:=1 else b:=0;
      raw.Write(b,1)
    end;

    // pack the bits to f
    raw.seek(2,soFromBeginning);
    while (raw.Position<raw.Size) do begin
      current:=0;
      for x:=0 to 7 do begin
        raw.Read(b,1);
        current:=current or (b shl (7-x));
      end;
      f.Write(current,1);
    end;

    f.SaveToFile(ChangeFileExt(fn,'.dat'));
//    raw.savetofile(ChangeFileExt(fn,'.bin'));
  end;

  f.Free;
  bm.Free;

  filelist.Sort;
  s:='.dw ';
  for i:=0 to filelist.Count-1 do begin
    filelist[i]:=Format('Level%.03d: .incbin "%s.dat"',[i,ChangeFileExt(ExtractFileName(filelist[i]),'')]);
    s:=s+Format('Level%.03d ',[i]);
  end;
  filelist.Insert(0,'Levels:');
  filelist.Insert(1,s);
  filelist.Add(Format('.define NumberOfLevels %d',[filelist.Count-2]));

  filelist.SaveToFile(ExtractFilePath(ParamStr(0))+'boards\levels.inc');

  filelist.free;
end;

end.
