program SokoSplit;
	var i       : Integer;
		InFile  : Text;
		S       : String;
		NewLevel: Boolean;
		Ch	    : Char;
		Cnt		: Integer;
		LvlNo   : Integer;
		LvlName : String;
		Level	: array [0..17] of String;

	function TrimRight(S: String): String;
		begin
			while (S <> '') and (S[Length(S)] = ' ') do
				Delete(S, Length(S), 1);
			TrimRight := S;
		end;

	procedure WriteLevel;
		var OutFile: Text;
			FName  : String;
			i	   : Integer;
		begin
			if Cnt > 18 then
				begin
					Writeln('Level ', LvlNo, ' is too big');
					Exit;
				end;

			Str(LvlNo, FName);
			while Length(FName) < 8 do
				FName := '0' + FName;
			Assign(OutFile, FName + '.lev');
			Rewrite(OutFile);

			if LvlName <> '' then
				Writeln(OutFile, '; ', LvlName);

			for i := 0 to Pred(Cnt) do
                Writeln(OutFile, Level[i]);

			Close(OutFile);
		end;
Begin
	if ParamCount < 1 then
		begin
			Writeln('Sokoban Level Pack Splitter v1.0 by Haroldo O. Pinheiro');
			Writeln('Usage: SOKOSPLT <source>');
			Halt(1);
		end;

	Assign(InFile, ParamStr(1));
	Reset(InFile);

	Cnt     := 0;
	LvlNo   := 1;
	LvlName := '';
	while not Eof(InFile) do
		begin
			Readln(InFile, S);
			S := TrimRight(S);

			if (Cnt <> 0) and ((S = '') or (S[1] = ';') or (S[1] = '''')) then
				begin
					WriteLevel;
					Cnt     := 0;
					LvlName := '';
					Inc(LvlNo);
				end;

			if (S <> '') then
				begin
					if S[1] in [';', ''''] then
						begin
							if (S[1] = '''') then
								LvlName := Copy(S, 2, Length(S) - 2)
							else
								LvlName := Copy(S, 2, Length(S));
							while (LvlName <> '') and (LvlName[1] in [' ', #9]) do
								Delete(LvlName, 1, 1);
						end
					else
						begin
                            Level[Cnt] := S;
							Inc(Cnt);
						end;
				end;
		end;

	if Cnt <> 0 then
		WriteLevel;

	Close(InFile);
End.