program SokoRLE;
	var i       : Integer;
		InFile  : Text;
		OutFile : Text;
		S       : String;
		NewLevel: Boolean;
		Ch	    : Char;
		Cnt		: Integer;

	function TrimRight(S: String): String;
		begin
			while (S <> '') and (S[Length(S)] = ' ') do
				Delete(S, Length(S), 1);
			TrimRight := S;
		end;

	procedure OutCnt;
		begin
			if Cnt <> 1 then
            	Write(OutFile, Cnt);
			if (Ch = ' ') then
				Write(OutFile, '-')
			else
				Write(OutFile, Ch);
			Cnt := 0;
		end;
Begin
	if ParamCount < 2 then
		begin
			Writeln('Sokoban RLE encoder v1.0 by Haroldo O. Pinheiro');
			Writeln('Usage: SOKORLE <source> <dest>');
			Halt(1);
		end;

	Assign(InFile, ParamStr(1));
	Reset(InFile);

	Assign(OutFile, ParamStr(2));
	Rewrite(OutFile);

	NewLevel := False;
	while not Eof(InFile) do
		begin
			Readln(InFile, S);
			S := TrimRight(S);
			if S = '' then
				begin
					if NewLevel then
						Writeln(OutFile);
					NewLevel := False;
				end
			else if (S[1] = ';') then
				begin
					Writeln(OutFile, S);
				end
			else
				begin
					Cnt := 0;
					Ch  := #0;
					for i := 0 to Length(S) do
						begin
                        	if Cnt <> 0 then
								if (S[i] <> Ch) or (Cnt = 9) then
										OutCnt;
							Ch := S[i];
							Inc(Cnt);
						end;

                    if Cnt <> 0 then
						OutCnt;

					Write(OutFile, '|');
				end;
		end;

	Close(OutFile);
	Close(InFile);
End.