#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sms.h>
#include "sk_core.h"
#include "sk_levelpack.h"

UBYTE *lpk_seek_map(UBYTE *mappack, UBYTE mapnum) {
	UBYTE *p = mappack + 6;
	UWORD *w = mappack + 4;

	if (*mappack != 'S') {
		puts("Invalid mappack signature!");
	}

	while (mapnum) {
		p += *w;
		w = p;
		p += 2;
		mapnum--;
	}

	return p;
}

void lpk_load_map(sk_levelmap *level, UBYTE *mappack, UBYTE mapnum) {
	UBYTE buffer[4096];
	UBYTE *p;

	memset(buffer, 0, sizeof(buffer));
	p = lpk_seek_map(mappack, mapnum);
	aplib_depack(p, buffer);
	sk_load_map(level, buffer);
}

UWORD lpk_count_maps(UBYTE *mappack) {
	UBYTE *p = mappack + 6;
	UWORD *w = mappack + 4;
	UWORD cnt = 0;

	if (*mappack != 'S') {
		puts("Invalid mappack signature!");
	}

	while (*w) {
		p += *w;
		w = p;
		p += 2;
		cnt++;
	}

	return cnt;
}
