pico-8 cartridge // http://www.pico-8.com
version 11
__lua__

frame = 0
palettes = {}
cube = {}
plasma_sin_x={}
plasma_sin_y={}

col={5,5,6,7,7}
team_tidx={1,2,3,4}
sl_tidx={5,2,6,3,7,5,5,8,9,6,10,3}
fg_tidx={65,66,67,67,68,66,69,69,70}
skl_tidx={71,72,66,73,72,67,70,74,65}
and_tidx={75}
year_tidx={76,77,78,79}
end_tidx={17, 18, 19, 22, 19, 20, 21}
maxh=30
coffset=10
freq=5

fade = 1
currentscene=0
lastscene=0
scenestart = { 1 }

-- length of scenes in frames
scenelength = { 300,  -- starfield
	        420,  -- starfield and authors
	        30,   -- starfield fade out
	        330,  -- plasma fade in
	        500,  -- plasma and cube
	        30,   -- plasma and cube fade out
	        30,   -- twister fade in
	        500,  -- twister 
	        30,   -- twister fade out
	        30,   -- 3d cube fade in
	        580,  -- 3d cube
	        30,   -- 3d cube fade out
	        150   -- checkers
	      }

function _init()
	init_palettes(palettes)	
	init_3d()
	init_plasma()

	set_palette(palettes[1], 0)

	-- calculate start times for scenes
	local framepos = 0
	for scene in all(scenelength) do
		framepos += scene
		add(scenestart, framepos)	
	end
	-- add empty end scene
	add(scenestart, framepos+1)
	lastscene = #scenestart
end

function _update()
	if (currentscene != lastscene) then 
		if (frame == scenestart[currentscene+1]) then
			currentscene+=1

			-- currentscene=13 -- set to force scene
		end 
	end
	frame += 1
end

function _draw()

	if (currentscene == 0) then
		-- todo: start music
		music(0)
		rectfill(0,0, 127, 127, 0)
	elseif (currentscene == 1) then
		draw_starfield()
	elseif (currentscene == 2) then
		draw_starfield()
		draw_authors()
	elseif (currentscene == 3) then
		draw_starfield()
		draw_authors()
		draw_fade_out()
	elseif (currentscene == 4) then
		draw_fade_in()
		rectfill(0, 0, 127, 40, 0)
		rectfill(0, 88, 127, 127, 0)
		draw_plasma(0, 40, 127, 87)
		cube:setposition(0, 0, -5)
	elseif (currentscene == 5) then
		rectfill(0, 20, 127, 40, 0)
		rectfill(0, 88, 127, 127, 0)
		draw_plasma(0, 40, 127, 87)
		draw_3d_outline(cube, 7)
	elseif (currentscene == 6) then
		rectfill(0, 20, 127, 40, 0)
		rectfill(0, 88, 127, 127, 0)
		draw_plasma(0, 40, 127, 87)
		draw_3d_outline(cube, 7)
		draw_fade_out()
	elseif (currentscene == 7) then
		draw_fade_in()
		draw_twister(0, 0, 127, 127, 64+sin(frame/39+2)*10)
	elseif (currentscene == 8) then
		draw_twister(0, 0, 127, 127, 64+sin(frame/39+2)*10)
	elseif (currentscene == 9) then
		draw_twister(0, 0, 127, 127, 64+sin(frame/39+2)*10)
		draw_fade_out()
	elseif (currentscene == 10) then
		draw_fade_in()
		cube:setposition(14, 22, -7.5)
		draw_3d(cube)
	elseif (currentscene == 11) then
		draw_3d(cube)
	elseif (currentscene == 12) then
		draw_3d(cube)
		draw_fade_out()
	elseif (currentscene == 13) then
		draw_fade_in()
		draw_checkers(0, 0, 127, 127, 4, 9)
		logo(end_tidx, 34, 58)
	elseif (currentscene == lastscene) then
		-- todo: end music
		rectfill(0,0, 127, 127, 0)
	end
end

function debug_print(txt)
	rectfill(0, 0, 15, 5, 0)
	print(txt, 0, 0, 7)
end

function init_palettes(palettes)
	for i=1,7 do
		add(palettes, { sget(i, 0), sget(i, 1), sget(i, 2),
				sget(i, 3), sget(i, 4), sget(i, 5),
				sget(i, 6), sget(i, 7), sget(i, 8),
				sget(i, 9), sget(i, 10),sget(i, 11),
				sget(i, 12),sget(i, 13),sget(i, 14),
				sget(i, 15) })
	end
end

function set_palette(palette, ondisplay)
	for i=0,15 do
		pal(i, palette[i+1], ondisplay)
	end
end

function draw_fade_out()
	if ((frame % 3) == 0) then
		if (fade < 5) then
			fade += 1
		end
		set_palette(palettes[fade], 1)
	end
end

function draw_fade_in()
	if ((frame % 3) == 0) then
		if (fade > 1) then
			fade -= 1
		end
		set_palette(palettes[fade], 1)
	end
end

function draw_starfield()
	cls()
	starfield()
	bounce(sl_tidx, 8, 80, 60)
	logo(team_tidx, 45, 8)
end

lineanim=1
authors_step=0
function draw_authors()
	if (authors_step == 0) then
		if (lineanim < 64) then
			lineanim+=1
		else
			authors_step=1
		end
	else
		if (lineanim >= 0) then
			lineanim-=1
		end

		logo(fg_tidx, 20, 95)
		logo(and_tidx, 96, 95)
		logo(skl_tidx, 27, 105)
		logo(year_tidx, 45, 115)
	end

	if (lineanim > 0) then
		line(0, 95, lineanim, 95, 11)
		line(127-lineanim, 95, 127, 95, 11)
		line(0, 97, lineanim, 97, 11)
		line(127-lineanim, 97, 127, 97, 11)
		line(0, 99, lineanim, 99, 3)
		line(127-lineanim, 99, 127, 99, 3)
		line(0, 101, lineanim, 101, 3)
		line(127-lineanim, 101, 127, 101, 3)

		line(0, 105, lineanim, 105, 11)
		line(127-lineanim, 105, 127, 105, 11)
		line(0, 107, lineanim, 107, 11)
		line(127-lineanim, 107, 127, 107, 11)
		line(0, 109, lineanim, 109, 3)
		line(127-lineanim, 109, 127, 109, 3)
		line(0, 111, lineanim, 111, 3)
		line(127-lineanim, 111, 127, 111, 3)

		line(0, 115, lineanim, 115, 11)
		line(127-lineanim, 115, 127, 115, 11)
		line(0, 117, lineanim, 117, 11)
		line(127-lineanim, 117, 127, 117, 11)
		line(0, 119, lineanim, 119, 3)
		line(127-lineanim, 119, 127, 119, 3)
		line(0, 121, lineanim, 121, 3)
		line(127-lineanim, 121, 127, 121, 3)
	end
end

function bounce(arr, x, yoff, scale)
	cidx=1
	for i in all(arr) do
		y=yoff-scale*abs(cos(frame/180+cidx/100))
		cidx+=1
		x+=8
		spr(i, x, y)
	end
end

function starfield()
	for c=0,5 do
		srand(c)
		color(col[c+1])
		for i=0,20 do
			speed=c+1
			x = (rnd(128) + speed * frame) % 128
			y = rnd(128)
			pset(x, y)
		end
	end
end

function logo(arr, x, y)
	for i in all(arr) do
		spr(i, x, y)
		x+=8
	end
end

function draw_checkers(x0, y0, xw, yw, color1, color2)
	rectfill(x0, y0, xw, yw, color1)
	for y=y0,yw,10 do
		for x=x0,xw,10 do
			rectfill(x, y, x+4, y+4, color2)
			rectfill(x+5, y+5, x+9, y+9, color2)
		end
	end
end

twister_col1=5
twister_col2=1
twister_col3=2
twister_col4=13
function draw_twister(x0, y0, xw, yw, offset)
	scale=22

	draw_checkers(x0, y0, xw, yw, 6, 8)

	for y=y0,yw do
		angle = sin(y/2200 + frame/250)*0.9
		
		x1 = offset + sin(angle)*scale

		-- 90 degrees (pi/2) => 0.25 in pico 8
		x2 = offset + sin(angle + 0.25)*scale

		-- 180 degrees (pi) => 0.5 in pico 8
		x3 = offset + sin(angle + 90*2)*scale

		-- 270 degrees (3pi/2) => 0.75 in pico 8
		x4 = offset + sin(angle + 0.75)*scale

		if (x1 < x2) then
			line(x1, y, x2, y, twister_col1)
			pset(x1, y, 0)
			pset(x2, y, 0)
		end
		if (x2 < x3) then
			line(x2, y, x3, y, twister_col2)
			pset(x2, y, 0)
			pset(x3, y, 0)
		end
		if (x3 < x4) then
		 	line(x3, y, x4, y, twister_col3)
			pset(x3, y, 0)
			pset(x4, y, 0)
		end
		if (x4 < x1) then
			line(x4, y, x1, y, twister_col4)
			pset(x4, y, 0)
			pset(x1, y, 0)
		end
	end
end

function init_plasma()
        for i=0,511 do
                plasma_sin_x[i] = sin(i / 63)*3 + 3
                plasma_sin_y[i] = sin(i / 43)*2 + 2
        end
end

function draw_plasma(x0, y0, xw, yw)
        local t = frame%254

	set_palette(palettes[6], 0)
        for x=x0,xw do
        for y=y0,yw do
                local col1=plasma_sin_x[x+y]*2 + plasma_sin_y[y+t]*2 + 4
                local col2=plasma_sin_y[x+t]*3 + plasma_sin_y[y*2] + 4
                local col=(col1 + col2) / 3
                pset(x, y, col+1)
        end
        end
	set_palette(palettes[1], 0)
end

function init_3d()
	-- create a cube
        cube = new_object(14, 22, -7.5)
        cube:setrotation(0.8, 1.2, 0.3)
	cube:addvertex(-1, 1, 1)
	cube:addvertex(1, 1, 1)
	cube:addvertex(-1, -1, 1)
	cube:addvertex(1, -1, 1)
	cube:addvertex(-1, 1, -1)
	cube:addvertex(1, 1, -1)
	cube:addvertex(1, -1, -1)
	cube:addvertex(-1, -1, -1)

	cube_color1=12
	cube_color2=8
	cube_color3=7
	cube_color4=10
	cube_color5=11
	cube_color6=6

	cube:addface(2, 1, 3, cube_color1) 
	cube:addface(2, 3, 4, cube_color1)
	cube:addface(2, 4, 7, cube_color2)
	cube:addface(2, 7, 6, cube_color2)
	cube:addface(1, 2, 5, cube_color3) 
	cube:addface(2, 6, 5, cube_color3)
	cube:addface(3, 8, 4, cube_color4)
	cube:addface(4, 8, 7, cube_color4)
	cube:addface(1, 8, 3, cube_color5)
	cube:addface(1, 5, 8, cube_color5)
	cube:addface(5, 6, 7, cube_color6)
	cube:addface(5, 7, 8, cube_color6)
end

function new_object(pos_x, pos_y, pos_z)
	object = {
		-- position
		x = pos_x, y = pos_y, z = pos_z,

		-- current rotation (degrees)
		xdeg = 0, ydeg = 0, zdeg = 0,

		-- rotation speed (degrees)
		xrot = 0, yrot = 0, zrot = 0,

		vertices = {},
		faces = {},

		setposition = function(self, x0, y0, z0)
			self.x = x0
			self.y = y0
			self.z = z0
		end,

		addvertex = function(self, x0, y0, z0)
			vertex = { x = x0, y = y0, z = z0 }
			add(self.vertices, vertex)
		end,

		addface = function(self, a0, b0, c0, col)
			face = { a = a0, b = b0, c = c0, color = col }
			add(self.faces, face)
		end,

		rotationmatrix = function(self)
			rot = { { 1, 0, 0 },
				{ 0, 1, 0 },
				{ 0, 0, 1 }}

			-- z rotation, convert from degrees to pico8 format
			local s = sin(self.zdeg/180)
			local c = cos(self.zdeg/180)
			rot[2][2] = c
			rot[2][3] = -s
			rot[3][2] = s
			rot[3][3] = c	
				
			-- x rotation, convert from degrees to pico 8 format
			local s = sin(self.xdeg/180)
			local c = cos(self.xdeg/180)
			xrotm =  { { 1, 0, 0 },
				   { 0, 1, 0 },
				   { 0, 0, 1 }}

			xrotm[1][1] = c
			xrotm[1][2] = -s
			xrotm[2][1] = s
			xrotm[2][2] = c	
			tmprot = { { rot[1][1], rot[1][2], rot[1][3] },
				   { rot[2][1], rot[2][2], rot[2][3] },
				   { rot[3][1], rot[3][2], rot[3][3] }}
			for i=1,3 do
				for j=1,3 do
					rot[i][j] = tmprot[1][j] * xrotm[i][1] +
					            tmprot[2][j] * xrotm[i][2] +
					            tmprot[3][j] * xrotm[i][3]
				end
			end

			-- y rotation, convert from degrees to pico 8 format
			local s = sin(self.ydeg/180)
			local c = cos(self.ydeg/180)
			yrotm =  { { 1, 0, 0 },
				   { 0, 1, 0 },
				   { 0, 0, 1 }}

			yrotm[1][1] = c
			yrotm[1][3] = -s
			yrotm[3][1] = s
			yrotm[3][3] = c	
			tmprot = { { rot[1][1], rot[1][2], rot[1][3] },
				   { rot[2][1], rot[2][2], rot[2][3] },
				   { rot[3][1], rot[3][2], rot[3][3] }}
			for i=1,3 do
				for j=1,3 do
					rot[i][j] = tmprot[1][j] * yrotm[i][1] +
					            tmprot[2][j] * yrotm[i][2] +
					            tmprot[3][j] * yrotm[i][3]
				end
			end

			return rot

		end,

		setrotation = function(self, x, y, z)
			self.xrot = x
			self.yrot = y
			self.zrot = z
		end,
		rotate = function(self)
			self.xdeg += self.xrot
			if (self.xdeg >= 360) then self.xdeg = 0 end

			self.ydeg += self.yrot
			if (self.ydeg >= 360) then self.ydeg = 0 end

			self.zdeg += self.zrot
			if (self.zdeg >= 360) then self.zdeg = 0 end
		end,

		screencoords = function(self, vertex, rot)
			xd = (127/2) / 0.5774 -- tan(60/2) - dist to x proj plane
			yd = (127/2) / 0.5774 -- tan(60/2) - dist to y proj plane

			z = (vertex.x * rot[1][3]) +
			    (vertex.y * rot[2][3]) +
			    (vertex.z * rot[3][3]) +
			    self.z

			x = (vertex.x * rot[1][1]) +
			    (vertex.y * rot[2][1]) +
			    (vertex.z * rot[3][1])
			x = x * xd / z

			y = (vertex.x * rot[1][2]) +
			    (vertex.y * rot[2][2]) +
			    (vertex.z * rot[3][2])
			y = y * yd / z
			
			-- translate
			x = x + (127/2) + self.x
			y = y + (127/2) - self.y
			return { x = x, y = y, z = z }
		end
	}

	return object
end

function ceil(n)
	return flr(n+0x0.ffff)
end

function draw_triangle(point1, point2, point3, color)
	p1 = { x = point1.x, y = point1.y, z = point1.z }
	p2 = { x = point2.x, y = point2.y, z = point2.z }
	p3 = { x = point3.x, y = point3.y, z = point3.z }
	tmp = { x = 0, y = 0, z = 0 }

	ux = (p2.x - p1.x)
	uy = (p2.y - p1.y)
	vx = (p3.x - p1.x)
	vy = (p3.y - p1.y)

	normal = (ux*vy) - (uy*vx)

	if (normal < 0) then return end

	if (p1.y > p2.y) then
		tmp.x = p2.x
		tmp.y = p2.y
		tmp.z = p2.z

		p2.x = p1.x
		p2.y = p1.y
		p2.z = p1.z
		p1.x = tmp.x
		p1.y = tmp.y
		p1.z = tmp.z
	end

	if (p2.y > p3.y) then
		tmp.x = p3.x
		tmp.y = p3.y
		tmp.z = p3.z

		p3.x = p2.x
		p3.y = p2.y
		p3.z = p2.z
		p2.x = tmp.x
		p2.y = tmp.y
		p2.z = tmp.z
	end

	if (p1.y > p2.y) then
		tmp.x = p2.x
		tmp.y = p2.y
		tmp.z = p2.z

		p2.x = p1.x
		p2.y = p1.y
		p2.z = p1.z
		p1.x = tmp.x
		p1.y = tmp.y
		p1.z = tmp.z
	end

	dydx_p1p2 = 0
	if ((p2.y - p1.y) > 0) then
		dydx_p1p2 = (p2.x - p1.x) / (p2.y - p1.y)
	end

	dydx_p1p3 = 0
	if ((p3.y - p1.y) > 0) then
		dydx_p1p3 = (p3.x - p1.x) / (p3.y - p1.y)
	end

	if (dydx_p1p2 > dydx_p1p3) then
		for y=ceil(p1.y),ceil(p3.y) do
			if (y < p2.y) then
				draw_scanline(y, p1, p3, p1, p2, color)
			else
				draw_scanline(y, p1, p3, p2, p3, color)
			end
		end
	else
		for y=ceil(p1.y),ceil(p3.y) do
			if (y < p2.y) then
				draw_scanline(y, p1, p2, p1, p3, color)
			else
				draw_scanline(y, p2, p3, p1, p3, color)
			end
		end
	end

end

function draw_scanline(y, p1, p2, p3, endpoint, color)
	grad1 = (y - p1.y) / (p2.y - p1.y)
	grad2 = (y - p3.y) / (endpoint.y - p3.y)

	x0 = p1.x + (p2.x - p1.x)*(max(0, min(grad1, 1)))
	xend = p3.x + (endpoint.x - p3.x)*(max(0, min(grad2, 1)))

	line(x0, y, xend, y, color)
end

function draw_3d(object)
	rectfill(0, 0, 127, 80, 2)
	map(0, 4, 0, 47, 127, 17)

	line(0, 80, 127, 80, 1)
	line(0, 81, 127, 81, 1)
	line(0, 82, 127, 82, 0)
	rectfill(0, 83, 127, 127, 1)

	rot = object:rotationmatrix()

	-- draw faces
	for face in all(object.faces) do
		vertex1 = object.vertices[face.a]
		vertex2 = object.vertices[face.b]
		vertex3 = object.vertices[face.c]

		point1 = object:screencoords(vertex1, rot)
		point2 = object:screencoords(vertex2, rot)
		point3 = object:screencoords(vertex3, rot)

		draw_triangle(point1, point2, point3, face.color)
	end

	object:rotate()


	set_palette(palettes[2], 0)
	a = 0
	for y=80,40,-1 do
		for x=0,127 do
			pset(x, 83+a+ plasma_sin_x[flr(frame%512/6)]*0.5+ plasma_sin_y[x]*0.5, pget(x, y))		
		end
		a += 1
	end
	set_palette(palettes[1], 0)
end

function draw_3d_outline(object, color)
	rot = object:rotationmatrix()

	-- draw cube outline
	point1 = object:screencoords(object.vertices[1], rot)
	point2 = object:screencoords(object.vertices[2], rot)
	point3 = object:screencoords(object.vertices[3], rot)
	point4 = object:screencoords(object.vertices[4], rot)
	point5 = object:screencoords(object.vertices[5], rot)
	point6 = object:screencoords(object.vertices[6], rot)
	point7 = object:screencoords(object.vertices[7], rot)
	point8 = object:screencoords(object.vertices[8], rot)

	line(point1.x, point1.y, point2.x, point2.y, color)
	line(point1.x, point1.y, point3.x, point3.y, color)
	line(point1.x, point1.y, point5.x, point5.y, color)
	line(point5.x, point5.y, point6.x, point6.y, color)
	line(point5.x, point5.y, point8.x, point8.y, color)
	line(point6.x, point6.y, point2.x, point2.y, color)
	line(point6.x, point6.y, point7.x, point7.y, color)
	line(point7.x, point7.y, point8.x, point8.y, color)
	line(point7.x, point7.y, point4.x, point4.y, color)

	line(point4.x, point4.y, point2.x, point2.y, color)
	line(point4.x, point4.y, point3.x, point3.y, color)
	line(point3.x, point3.y, point8.x, point8.y, color)

	object:rotate()
end


__gfx__
00000000666666606666666006666600666666006666666066666600666666006660000066606660066666602222222222222226666666666222222222222222
111000a0677777506770775067777750677777506777775067777750677777506750000067506750677777502222222222222666666666666662222222222222
221100a0666755506777775067706750677777506776666067777750000077506750000067506750677555502222222222266666666666666666622222222222
33110090006a50006775555067777750675757506777775067705750666677506750000067506750677666602222222226666666666666666666666222222222
44221090006950006aa500006aa66a506a5a5a506555aa506aa05a506aaaa5006a5000006a506a506aa6aa502222222266666666666666666666666622222222
55111080006850006995666069906950695959500006995069905950695555006996666069566950699559502222222666666666666666666666666662222222
66d51080006850006888885068806850685858506888885068805850685000000888885068888850688888502222226666666666666666666666666666222222
77651010005550006555555065506550655555505555555065505550655000000055555005555500055555502222266666666666666666666666666666622222
88211010666666606200062066666620620006206666600000000000000000000000000000000000000000002222266666666666666666666666666666622222
99421020222622206200062062222220662006206222660000000000000000000000000000000000000000002222666666666666666666666666666666662222
a9421080000620006200062062000000666206206200062000000000000000000000000000000000000000002222666666666666666666666666666666662222
bb331080000620006666662066666620666626206200062000000000000000000000000000000000000000002226666666666666666666666666666666666222
ccd51090000620006222262062222220626666206200062000000000000000000000000000000000000000002226666666666666666666666666666666666222
dd511090000620006200062062000000620666206200662000000000000000000000000000000000000000002266666666666666666666666666666666666622
ee4210a0000620006200062066666620620066206666620000000000000000000000000000000000000000002266666666666666666666666666666666666622
f94210a0000220002200022022222220220002202222200000000000000000000000000000000000000000002266666666666666666666666666666666666622
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222266666666666666666666666666666666666622
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222266666666666666666666666666666666666622
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222266666666666666666666666666666666666622
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222266666666666666666666666666666666666622
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222266666666666666666666666666666666666622
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222266666666666666666666666666666666666622
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222226666666666666666666666666666666666222
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222226666666666666666666666666666666666222
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222222666666666666666666666666666666662222
00000000000000000000000000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeddddddddddddddddddddddddddddddddeeee
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222222266666666666666666666666666666622222
00000000000000000000000000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeddddddddddddddddddddddddddddddeeeee
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222222226666666666666666666666666666222222
00000000000000000000000000000000000000000000000000000000000000000000000000000000888888888888888eeeeeeeeeeeeeeeeeeeeeeeeee8888888
00000000000000000000000000000000000000000000000000000000000000000000000000000000222222222222222266666666666666666666666622222222
0000000000000000000000000000000000000000000000000000000000000000000000000000000088888888888888888eeeeeeeeeeeeeeeeeeeeee888888888
00000000bbbbbbb0bb000bb0bb000000bbbbbbb0bbbbbb00bbbbbbb0bbbbbbb0bb000bb0bbbbbbb000bb00000bbbbb00bbbbbbb00bbbbb0000bb0000bbbbbbb0
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000bb000000bb000bb0bb000000bb000000bb00bbb0bbbbb000bbbbb000bb00bb00bb000bb000000000bb00bbb0bb00bbb0bb000bb00bbb00000000bb00
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000333330003300033033000000330033303300330033300000000333303303330033303300003300000333000003330000330003300033000000033000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000330000000333330033333330333333303333333033333330333333303300033033000330003300003330033033333330033333000033000000330000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__gff__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
2223000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3233350000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000350000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000012131415161700393939000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
2a0b0c0d0e0f2a2a2a2a2a2a2a2a2a2a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
2a1b2c2c2c1f2a2a2a2a2a2a2a2a2a2a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
2a2b2c2c2c2f2a2a2a2a2a2a2a2a2a2a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3a3b3c3d3e3f3a3a3a3a3a3a3a3a3a3a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000002929000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001a753344231a653344231a753344231a653344231a753344231a653344231a753344231a653344231a753344231a653344231a753344231a653344231a753344231a653344231a753344231a65334423
011000000e3551a355003050e3551a355003050e3551a355113551d35500305113551d35500305113551d3550c35518355003050c35518355003050c35518355133551f35500305133551f35500305133551f355
000f00002d255000002b255112052625529255292252921526255240002400029255292552d25530255182052b255000002b205262552b255242552b20524205262052620529205262552b2552d255000002b255
011000000e355344030e325344030e355344030e3253440311355344031132511305113553440311325344030c355344030c325344030c355344030c32534403133551f315133251f325133551f335133251f355
010800000e1510e1110e1510e111111510e111151510e1110e1510e1110e1510e111111510e111151510e1110e1510e1110e1510e111131510e1110c1510e1110e1510e1110e1510e111131510e1110c1510e111
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 41424304
00 01424304
00 01024344
00 01024344
00 01024344
00 01024344
00 01024344
00 01024344
00 01020344
00 01024344
00 01020344
00 01024344
00 01020344
00 01024344
00 41024344
00 41024344
00 41424304
00 05414344
00 05424344
00 01054344
00 01054344
00 01054344
00 41054344
00 01054344
00 41054344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344

