﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SpaceRescueMapper
{
    public partial class Form1 : Form
    {
        //zmienne
        private Room[,] Rooms = new Room[10, 10]; //pomieszczenia jako przyciski
        private RoomConnection[,] DoorsHor = new RoomConnection[9,10]; //poziome połączenia między pomieszczeniami
        private RoomConnection[,] DoorsVer = new RoomConnection[10, 9]; //pionowe połączenia między pomieszczeniami
        private int[,] Map = new int[10, 10];

// konstruktor
        public Form1()
        {
            InitializeComponent();

#region tablica pomieszczen
            for (int i = 0; i < 10; i++)//iteruj po rzedach
            {

                for (int j = 0; j < 10; j++)//iteruj po kolumnach
                {
                    Rooms[j, i] = new Room(this);   //tworzy obiekt typu Room:Button i podaje siebie jako argument
                    Rooms[j, i].Parent = this;      //dodaj do formularza
                    Rooms[j, i].Location = new System.Drawing.Point(0 + j * 40, i * 40 + 40);
                    Rooms[j, i].Visible = true;

                }
            }
#endregion

#region tablica poziomych drzwi
            for (int i = 0; i < 10; i++)//iteruj po rzedach
            {

                for (int j = 0; j < 9; j++)//iteruj po kolumnach
                {
                    DoorsHor[j, i] = new RoomConnection("hor");   //tworzy obiekt typu Room:Button i podaje siebie jako argument
                    DoorsHor[j, i].Parent = this;      //dodaj do formularza
                    DoorsHor[j, i].Location = new System.Drawing.Point(j * 40+20, i * 40 + 45);
                    DoorsHor[j, i].Visible = true;

                }
            }
#endregion

            #region tablica pionowych drzwi
            for (int i = 0; i < 9; i++)//iteruj po rzedach
            {

                for (int j = 0; j < 10; j++)//iteruj po kolumnach
                {
                    DoorsVer[j, i] = new RoomConnection("ver");   //tworzy obiekt typu Room:Button i podaje siebie jako argument
                    DoorsVer[j, i].Parent = this;      //dodaj do formularza
                    DoorsVer[j, i].Location = new System.Drawing.Point(j * 40 + 5, i * 40 + 60);
                    DoorsVer[j, i].Visible = true;

                }
            }
            #endregion

        }

        private void btnWynik_Click(object sender, EventArgs e)
        {
            PoliczWynik();
        }

        private void PoliczWynik()
        {
        //utwórz mapę wynikową w tablicy
            for (int i = 0; i < 10; i++)//iteruj po rzedach
            {

                for (int j = 0; j < 10; j++)//iteruj po kolumnach
                {
                    int kod = 0;    //kod lokacji o współrzędnych j,i
                    
                    kod += Rooms[j, i].Color;   //dodaj dwa bity koloru
                    kod += Rooms[j, i].WallType * 4; //dwa bity na typ ściany
              
            //lewe drzwi
                    if (j>0)            //nie sprawdzamy drzwi dla najbardziej lewej kolumny
                    {
                    if (DoorsHor[j-1,i].OnOff==1) kod+=16;
                    }
             //prawe drzwi
                    if (j < 9)            //nie sprawdzamy drzwi dla najbardziej prawej kolumny
                    {
                        if (DoorsHor[j, i].OnOff == 1) kod += 32;
                    }
            //dolne drzwi
                    if (i<9)
                    {
                        if (DoorsVer[j, i].OnOff == 1) kod += 64;
                    }

               //górne drzwi
                    if (i >0)
                    {
                        if (DoorsVer[j, i-1].OnOff == 1) kod += 128;
                    }


                    
                    Map[j, i] = kod;
                }
            }
        //zapisz mapę wynikową jako dane
            tbxWynik.Text="";
            for (int i = 0; i < 10; i++)//iteruj po rzedach
            {
                tbxWynik.Text += Environment.NewLine+" .BYTE ";

                for (int j = 0; j < 10; j++)//iteruj po kolumnach
                {
                    tbxWynik.Text += Map[j, i].ToString();
                    if (j < 9) tbxWynik.Text += ",";
                 
                }
            }
        }

        private void btnZapisz_Click(object sender, EventArgs e)
        {
            PoliczWynik();                              //uaktualnienie tablicy
            //zapisywanie mapy do pliku
      
            string SaveText = "";

            for (int i = 0; i < 10; i++)                //iteruj po rzedach
            {

                for (int j = 0; j < 10; j++)            //iteruj po kolumnach
                {
                    SaveText += Map[j, i].ToString() + Environment.NewLine; //pisz jako liczby, jedna pod drugą
                }
            }
    
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string nazwaPliku = saveFileDialog1.FileName;
        
                FileStream plik = new FileStream(nazwaPliku, FileMode.Create,
                FileAccess.Write, FileShare.None);
                StreamWriter zapisywacz = new StreamWriter(plik);
                zapisywacz.Write(SaveText);

                zapisywacz.Close();
                plik.Close();
            }
        }

        private void btnWczytaj_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {

                #region czytanie z pliku
                string nazwaPliku = openFileDialog1.FileName;
                FileStream plik = new FileStream(nazwaPliku, FileMode.Open,
                FileAccess.Read, FileShare.None);
                StreamReader odczytywacz = new StreamReader(plik);


                //czytaj dane 
                for (int i = 0; i < 10; i++)//iteruj po rzedach
                {

                    for (int j = 0; j < 10; j++)//iteruj po kolumnach
                    {
                        //kolory i sciany w pomiezczeniach
                        Map[j, i] = Convert.ToInt32(odczytywacz.ReadLine());
                        Rooms[j, i].Color = (Map[j,i] & 3);
                        Rooms[j, i].WallType = (Map[j, i] & 12)/4;
                        Rooms[j,i].SetProperties();

                        //połączenia miedzy pomieszczeniami
                        //lewe drzwi
                        if (j > 0)
                        {
                            if ((Map[j, i] & 16) == 16)
                            {
                                DoorsHor[j - 1, i].OnOff = 1;
                                DoorsHor[j - 1, i].SetColor();
                            }
                            else
                            {
                                DoorsHor[j - 1, i].OnOff = 0;
                                DoorsHor[j - 1, i].SetColor();
                            }
                        }

                        //prawe drzwi
                        if (j < 9)
                        {
                            if ((Map[j, i] & 32) == 32)
                            {
                                DoorsHor[j, i].OnOff = 1;
                                DoorsHor[j, i].SetColor();
                            }
                            else
                            {
                                DoorsHor[j, i].OnOff = 0;
                                DoorsHor[j, i].SetColor();
                            }
                        }

                        //dolne drzwi
                        if (i < 9)
                        {
                            if ((Map[j, i] & 64) == 64)
                            {
                                DoorsVer[j, i].OnOff = 1;
                                DoorsVer[j, i].SetColor();
                            }
                            else
                            {
                                DoorsVer[j, i].OnOff = 0;
                                DoorsVer[j, i].SetColor();
                            }
                        }

                        //górne drzwi
                        if (i > 0)
                        {
                            if ((Map[j, i] & 128) == 128)
                            {
                                DoorsVer[j, i-1].OnOff = 1;
                                DoorsVer[j, i-1].SetColor();
                            }
                            else
                            {
                                DoorsVer[j, i-1].OnOff = 0;
                                DoorsVer[j, i-1].SetColor();
                            }
                        }



                    }
                }
             
                odczytywacz.Close();
                plik.Close();
                #endregion

                
            }


        }


      

    

    }
}