	DEVICE ZXSPECTRUM48

	ORG 23766
Start
	DI
	LD SP,31000
	EI
	XOR A					;clear screen
	LD (23624),A 
	OUT (254),A
	LD A,70
	LD (23693),A			;Basic system variable
	CALL 3435				;Rom CLS
	LD A,2
	CALL 5633				;open channel for typing
							
;set game variables
	LD HL,Variables
	LD DE,Window1Time
	LD BC,7
	LDIR

	XOR A
	LD B,17
Start2
	LD (DE),A
	INC DE
	DJNZ Start2	
	
;create window sprite
	LD HL,Window+2
	LD DE,Window+11
	LD BC,27
	LDIR
		
;draw game screen	
	CALL DrawBackground
	CALL DrawHouse
	CALL TypeScore
	
;-----------------------
Mainloop
	LD B,5
MainLoop2	
	HALT
	DJNZ MainLoop2						;delay
	
	CALL FindCrosshairPos				;redraw background at old crosshair position
	LD DE,BackgroundCopy
	CALL DrawSprite

	CALL MenInWindows					;draw people in windows and change their times

	CALL GameControl					;change crosshair position + deal with shooting
	
	CALL StoreBackground				;store background at new position

	CALL FindCrosshairPos				;draw crosshair at new position	
	LD DE,Crosshair
	CALL DrawSprite
	
	CALL DrawTime						;draw time bar
	JR Mainloop
;-----------------------

Variables								;initial game variables values
	.BYTE 70,100,150,12,2,1,1			;to be copied at the game start
	
	INCLUDE <Logic.asm>					;more game code inserted here
	INCLUDE <Graphics.asm>

		
;game variables	
	ORG 30000	

WindowPosList
	REPT 40
	.BYTE 0
	ENDR
	
	
Window1Time		.BYTE 70	
Window2Time		.BYTE 100
Window3Time		.BYTE 150

CrosshairY 	.BYTE 12
CrosshairX 	.BYTE 1

BackgroundCopy
	.BYTE 1,1
	.BYTE 0,0,0,0,0,0,0,0
	.BYTE 0

Window1Nr		.BYTE 0
Window1Man		.BYTE 0

Window2Nr		.BYTE 0
Window2Man		.BYTE 0

Window3Nr		.BYTE 0
Window3Man		.BYTE 0

				
Score			.BYTE 0
				.BYTE 0		;it has to be so score displays correctly
				
WaitingTime		.EQU 50
AppearTime		.EQU 30				

	SAVESNA "Gangsta.sna",Start
	SAVEBIN "Gangsta.bin",23766,1006
