DrawBackground
	LD HL,22528+32
	LD BC,256*160+89
	
;paint sky with attributes
DrawBackground2		
	LD (HL),C
	INC HL
	DJNZ DrawBackground2		
	
	LD BC,256*64+112	
DrawBackground3
	LD (HL),C
	INC HL
	DJNZ DrawBackground3
	
;draw rows of background tiles
	LD HL,16384+224
	LD DE,City
	LD BC,16*256+2
	CALL DrawBackground5
	
	LD HL,20480+102
	LD DE,Wall
	LD BC,20*256+1
	CALL DrawBackground5

	LD HL,16384+128
	LD DE,Sky
	CALL DrawBackground4	
	
	LD HL,20480+128
	LD DE,Ground

;continuing to DrawBackground4 and ending with its RET
	
DrawBackground4
	LD BC,32*256+1				;B - nr of tiles in the row, C- tiles width in chars
DrawBackground5
	PUSH HL
	PUSH DE
	PUSH BC
	CALL DrawSprite
	POP BC
	POP DE
	POP HL
	LD A,L
	ADD A,C
	LD L,A
	DJNZ DrawBackground5
	RET

;---------------------------------	
DrawHouse
	LD HL,16384+102				;top left corner of the house
	EXX
	LD HL,WindowPosList			;table with windows positions
	EXX
	
	LD C,4						;height of the house (windows)
DrawHouse2	
	LD B,5						;width of the house (windows)
	PUSH HL
	
DrawHouse3
	PUSH BC
	PUSH HL	
	
;draw one window
	PUSH HL
	LD C,4						;draw wall around window (4x4 cahrs)
DrawHouse5	
	LD B,4
	PUSH HL
DrawHouse6
	PUSH HL
	PUSH BC
	LD DE,Wall
	CALL DrawSprite				;one brick
	POP BC
	POP HL
	INC L
	DJNZ DrawHouse6				;do a row of bricks

	POP HL
	CALL OneCharDown			;go down to next row
	DEC C
	JR NZ,DrawHouse5			;do 4 rows
	
	POP HL						;restore top upper corner
	CALL OneCharDown			;window is one char right and one char down from the corner
	INC L
	
	PUSH HL						;write window position into windows list
	EXX
	POP DE						;read window position into alternate DE
	LD (HL),E
	INC HL
	LD (HL),D
	INC HL
	EXX
	
	LD DE,Window				;draw window
	CALL DrawSprite
	
	POP HL						;next window in the row
	POP BC
	
	LD A,L						;position of next window
	ADD A,4
	LD L,A
	DJNZ DrawHouse3				;do all windows in the row
	
	POP HL
	LD B,4
DrawHouse7
	CALL OneCharDown			;next windows row - 4 chars down
	DJNZ DrawHouse7
	
	DEC C
	JR NZ,DrawHouse2			;do all rows
	RET	
	
	
;-------------	
FindCrosshairPos
	LD BC,(CrosshairY)			;BC - crosshair position (0-31,0-23)
	LD HL,16384
		
FindCrosshairPos2				;find position
	CALL OneCharDown
	DEC C
	JR NZ,FindCrosshairPos2
	
FindCrosshairPos3	
	INC L
	DJNZ FindCrosshairPos3		;position ready
	RET	
	
;---------------------------------
StoreBackground
	CALL FindCrosshairPos
	LD B,8						;copy to buffer background behind crosshair
	LD C,H
	LD DE,BackgroundCopy+2
DrawCrosshair4	
	LD A,(HL)					;one char - 8 bytes
	LD (DE),A
	INC H
	INC DE
	DJNZ DrawCrosshair4		
	
	CALL AttributeAddress		;store attribute
	LD A,(HL)					
	LD (DE),A	
	RET
	
;---------------------------------
DrawSprite
;HL - screen position
;DE - graphics address

	LD A,(DE)					;read size into BC (B-width,C-height)
	LD B,A
	INC DE
	LD A,(DE)
	LD C,A
	INC DE
	
	
DrawSprite2	
	PUSH HL
	PUSH BC
	
DrawSprite3
;one row of characters			
	
	PUSH BC
	LD B,8						;8 bytes in a char
	LD C,H
	
DrawSprite4		
;one character
	LD A,(DE)					;read and copy graphics
	LD (HL),A
	INC H						;next byte in the char
	INC DE						;next graphics byte
	DJNZ DrawSprite4
	
	CALL AttributeAddress		;paint attribute
	LD A,(DE)			
	LD (HL),A
		
	LD H,C						;restore graphics address
		
	INC DE						;next data byte
	
	INC L						;go one character right
	POP BC
	DJNZ DrawSprite3			;all chars in the row
	
	POP BC
	POP HL						;back to leftmost character
	CALL OneCharDown			;next row
	DEC C
	JR NZ,DrawSprite2			;all rows
	RET	
	
AttributeAddress
	LD H,C				
	LD A,80						;graphics address to attribute address
	SRL H
	SRL H
	SRL H
	ADD A,H
	LD H,A
	RET	
	

;-----------
OneCharDown
	LD A,L
	ADD A,32
	LD L,A
	RET NC						;stay in the same screen segment
	
	LD A,H						;next screen segment
	ADD A,8
	LD H,A
	RET
	
;---------------------
TypeScore
	LD BC,3*256+24
	CALL 3545					;PRINT AT X,Y (BC - coordinates)

	LD BC,0*256+11				;length
	LD DE,Text1
	CALL 8252
	
TypeScore2
	LD BC,3*256+12
	CALL 3545					;PRINT AT X,Y (BC - coordinates)
	
	LD BC,(Score)				;print number
	CALL 6683
	RET
	
Text1		.BYTE "BODY COUNT:"
Text2		.BYTE "GAME OVER"
;---------------------
DrawTime
;draw bar which shows time left until gangster shoots

;clear old time bar
	LD HL,16384+512+13			;position
	LD C,3						;nr of pixel lines
DrawTime2
	LD B,8						;width in chars
	PUSH HL
	XOR A
DrawTime3
	LD (HL),A					;clear one byte
	INC L
	DJNZ DrawTime3				;do one pixel line
	
	POP HL
	INC H
	DEC C						;do 3 pixel lines
	JR NZ,DrawTime2

;find shortest time which will be displayed
	LD HL,Window1Time			;time table
	LD DE,Window1Man			;man in window status table
	LD BC,3*256+255				;B=3 (nr of windows), C=255 (first value of time)
DrawTime4
	LD A,(HL)
	CP AppearTime				;did man already appeared in current window?
	JR NC,DrawTime5				;not appeared yet, skip this window
	
	CP C						;is this the shortest time?
	JR NC,DrawTime5				;no, skip this window
	
	LD A,(DE)					;is a gangster in this window?
	OR A
	JR Z,DrawTime5				;no skip this window
	
	LD A,(HL)					;current time becomes the shortest one
	LD C,A
	
DrawTime5
	INC HL						;next window
	INC DE
	INC DE
	DJNZ DrawTime4	
	
;draw time bar for the shortest time	
	LD A,C
	CP 255						;was the first value of time changed (window with gangster found) ?
	RET Z						;no, don't draw the time
	
	LD DE,3*256+255				;D - nr of pixel lines, E- full byte
	LD HL,16384+512+13			;bar position
	
DrawTime6	
	PUSH AF
	PUSH HL
DrawTime7
	LD (HL),E					;draw full bytes of the bar
	INC L
	SUB 8
	JR NC,DrawTime7
	DEC L
	
	LD B,0
	ADD A,8
	OR A
	JR Z,DrawTime9		
	
DrawTime8						;find the last, not complete byte of the bar
	SCF
	RR B
	DEC A
	JR NZ,DrawTime8
DrawTime9		
	LD (HL),B					;draw the last byte of the bar
	
	POP HL
	POP AF
	INC H
	DEC D
	JR NZ,DrawTime6				;do 3 pixels lines
	RET


;---------------------
;graphics

Crosshair:
	.BYTE 1,1
	.BYTE	 60, 66,129,153,153,129, 66, 60
	.BYTE	  2

Wall:
	.BYTE 1,1
	.BYTE	  0,191,191,191,  0,247,247,247
	.BYTE	  1
	
Sky:
	.BYTE 1,2									;size
	.BYTE	  0,255,  0,  0,  0,255,  0,  0		;one char - graphics
	.BYTE 94									;one char - attribute
	.BYTE	255,  0,255,  0,255,255,  0,255
	.BYTE	 94
	
Ground:
	.BYTE 1,1
	.BYTE	  0,255,255,235, 85,170, 80,  0
	.BYTE	 66
	
	
City:
	.BYTE 2,1
	.BYTE	120,120,120,120,123,123,123,123
	.BYTE	112
	.BYTE	  0,  0, 62, 62,190,190,190,190
	.BYTE	112
	
Gangster:
	.BYTE 2,2
	.BYTE	  3,  7,  0,  1,  7,  4, 51, 80
	.BYTE	  7
	.BYTE	128,192,  0,  0,192, 64,128, 48
	.BYTE	  7
	.BYTE	115,  3, 49,176,193,112,  1, 16
	.BYTE	  7
	.BYTE	152, 12,  4,  6,  2,  2, 34, 34
	.BYTE	  7
	
Innocent:
	.BYTE 2,2	
	.BYTE	  3,  6,  5, 12, 11, 11, 13,  4
	.BYTE 71
	.BYTE	224,112,176,152,232,108,220, 24
	.BYTE 71
	.BYTE	  1, 11, 19, 19, 19, 33, 36, 36
	.BYTE 71
	.BYTE	192,232,228,100, 98, 66, 18, 18
	.BYTE 71
	
	
Window	
	.BYTE 2,2
	.BYTE	  0,126,126,126,126,126,126,  0
	.BYTE 5

;end of program	

CodeEnd
	DISPLAY /D,CodeEnd	
	
	