.MEMORYMAP
DEFAULTSLOT 0
SLOTSIZE $10000
SLOT 0 $0000
.ENDME

.ROMBANKMAP
BANKSTOTAL 1
BANKSIZE $10000
BANKS 1
.ENDRO

.BANK 0

;****************************************************************************
;*****
;*****
;*****  1K Kilodium - C-64 entry to Minigame Competition 2006
;*****
;*****  aleksi.eeben@gmail.com
;*****
;*****
;****************************************************************************


;-----  Zeropage variables

;-      $02-$1a zeroed at startup 

.DEFINE scr             $02
.DEFINE scrh            $03


;-      $20-$3f initialized at start of new game

.DEFINE ships           $20


;-      $40-$7f zeroed when new ship

.DEFINE xscroll         $40             ; x-scroll pixels & decimal bits
.DEFINE xspeed          $41             ; x-scrolling/movement speed
.DEFINE xchar           $42             ; x-scroll char (low 3 bits)

.DEFINE yspeed          $43             ; y-movement speed
.DEFINE yfine           $44             ; y-coordinate decimals
.DEFINE ycoord          $45             ; y-coordinate

.DEFINE collision       $46
.DEFINE explosion       $47

.DEFINE panel1          $7c
.DEFINE panel2          $7d
.DEFINE panel3          $7e


;-      zeropage other/temporary

.DEFINE pchar           $f9
.DEFINE bitmask         $fa
.DEFINE rnd0            $fb
.DEFINE rnd1            $fc
.DEFINE rnd2            $fd
.DEFINE tmp             $fe
.DEFINE tmph            $ff


;-----  Load address

.SECTION "BANKHEADER"
        .DW     $0801
.ENDS

.ORG $0801
.SECTION "Entry" FORCE

;-----  Basic line

        .DB     $0a,$08,$01,$00,$9e,$33,$30,$36,$37,$00


;-----  Entry

Entry:
        ldy     #$00
        ldx     #$11
_sidilp
        lda.w   sidinit,x               ; init sid
        sta     $d407,x
        sty     $02,x                   ; clear some zeropage
        dex
        bpl     _sidilp
        bmi     Init
.ENDS

.ORG $081c
.SECTION "Main" FORCE

;-----  Char graphics at $081c

gfx:
        .INCBIN "gfx.bin"


;-----  Init code (later overwritten by inverted chars)

Init:
        ldx     #$0b
_inisprlp
        lda.w   sprites,x               ; sprite shapes
        sta     $07f8,x
        lda     #$55
        sta     $0d00,x                 ; clear some characters
        sta     $0810,x                 
        dex
        bpl     _inisprlp

        stx     $0ffe                   ; laser sprite

_phalp
        lda     $0ae1,y                 ; copy sprite upper half and 223
        pha                             ; bytes of garbage to stack

        lda     #$09                    ; and init color memory
        sta     $d800,y
        sta     $d900,y
        sta     $da00,y
        sta     $dac0,y
        lda     #$00
        sta     $dbc0,y                 ; bottom line color
        sta     $0efe,y                 ; also clear laser sprite

        dey
        bne     _phalp

_plalp
        pla                             ; mirror 74 lines of garbage and
        sta     $0bdb,x                 ; 11 lines of ship sprite from stack
        pla
        sta     $0bdc,x
        pla
        sta     $0bdd,x
        dex
        dex
        dex
        bne     _plalp


;-      new game entry

NewGame:
        ldx     #$06
        stx     ships
        lda     #$b0
_clrsclp
        sta     $07df,x
        dex
        bpl     _clrsclp


;-      new ship entry

NewShip:
        dec     ships
        beq     NewGame

        ldx     #$00
_newslp
        lda     #$a0                    ; clear screen
        sta     ycoord                  ; also ship y-coordinate
        sta     explosion
        sta     $0400,x
        sta     $0500,x
        sta     $0600,x
        sta     $06df,x

        cpx     #$40
        bcs     _nskip

        lda     #$00                    ; clear some zeropage every new ship
        sta     $40,x

        lda     $0bc0,x                 ; also create ship shadow sprite
        and     #$55
        sta     tmp
        lda     $0bc0,x
        and     #$aa
        lsr
        ora     tmp
        sta     tmp
        asl     a
        ora     tmp
        sta     $0c00,x

        lda     $0810,x                 ; and create inverted chars
        eor     #$ff
        sta     $0858,x

        lda.w   videoinit-1,x           ; and init video chip
        sta     $cfff,x
_nskip
        inx
        bne     _newslp                 ; end of new ship init loop

        lda     ships
        ora     #$b0
        sta     $07c0


;-----  Main loop

Mainloop:
        jsr     Raster

;-      check wall collision

        lda     $d001
        and     #$f8
        sta     tmp
        asl
        rol     scrh
        asl
        rol     scrh

        clc
        adc     tmp
        sta     scr

        lda     scrh
        and     #$03
        adc     #$03
        sta     scrh

        ldy     #$45
        lda     (scr),y
        cmp     #$09

        beq     _crash
        

;-      move enemies

        lda     $d01e                   ; check collisions
        sta     collision

        ldy     #$0a
        lda     #$20
        sta     bitmask

_nextenemy
        ldx     collision
        txa
        and     bitmask
        beq     _nohit
        txa
        and     #$40                    ; enemy hit
        bne     _enemyhit
        txa
        and     #$01                    ; player hit
        beq     _nohit

_crash
        jmp     NewShip                 ; player explosion

_enemyhit
        ldx     #$04
        jsr     AddScore
        lda     $d010
        ora     bitmask
        ldx     #$c0
        stx     explosion
         
        bne     _enemask

_nohit
        lda     xspeed
        lsr
        lsr
        lsr
        lsr
        lsr
        clc
        adc     #$fc
        bpl     _enepos

        clc
        adc     $d000,y
        bcs     _noec
        bcc     _enewr
_enepos
        clc
        adc     $d000,y
        bcc     _noec
_enewr
        tax
        lda     $d010
        eor     bitmask
_enemask
        sta     $d010
        txa
_noec
        sta     $d000,y
        lsr     bitmask
        dey
        dey
        bne     _nextenemy


;-      read joystick

        lda     $dc00

        ldx     #$00                    ; check joystick up/down
        lsr
        bcs     _rjnotup
        ldx     #$fd
_rjnotup
        lsr
        bcs     _rjnotdn
        ldx     #$03
_rjnotdn
        pha
        txa
        clc
        adc     yspeed
        bvs     _rjywrp
        sta     yspeed
_rjywrp        

        pla
        ldx     #$00
        lsr                             ; check joystick left/right
        bcs     _rjnotle
        ldx     #$08
_rjnotle
        lsr
        pha
        bcs     _rjnotri
        ldx     #$f8
_rjnotri
        txa
        clc
        adc     xspeed
        cmp     #$e0
        bcs     _rjxbnd
        sta     xspeed
_rjxbnd

        pla                             ; check fire button
        lsr
        bcs     _rjnofire
        lda     $d00c
        bne     _rjnofire
        lda     #$50
        sta     $d00c
        lda     ycoord
        adc     #$e2
        sta     $d00d
_rjnofire


;-      move ship in y-direction

        ldy     #$00                    ; sign-extend, slow down and scale
        ldx     yspeed
        stx     tmp
        beq     _msnomove
        bpl     _msnong
        inc     yspeed                  ; slow down negative value
        dey
        .DB     $0c                     ; skip next 2 bytes with nop $ffff
_msnong
        dec     yspeed
_msnomove
        tya
        ldx     #$05
_msscale
        asl     tmp
        rol
        dex
        bne     _msscale

        sta     tmph

        lda     yfine
        clc
        adc     tmp
        sta     yfine
        lda     ycoord
        adc     tmph

        cmp     #$33                    ; ship sprite y-boundaries
        bcs     _msnotop
        lda     #$33
        bne     _mshitb
_msnotop
        cmp     #$d4
        bcc     _msnobot
        lda     #$d4
_mshitb
        ldx     #$00                    ; zero y-speed if hit top or bottom
        stx     yspeed

_msnobot

        sta     ycoord
        sta     $d001                   ; set ship sprite y-coordinate
        clc
        adc     #$06
        sta     $d00f                   ; ship shadow sprite y-coordinate


;-      explosion sound

        lda     explosion
        lsr
        sta     $d40f
        sta     explosion


;-      laser sound & movement

        lda     $d00c
        beq     _nolaser

        clc                             ; move laser
        adc     #$10
        bne     _laskip
_nolaser
        sta     $d00d                   ; laser sprite off
_laskip
        sta     $d00c
        sta     $d408                   ; laser sound


;-      scroll in x-direction

        lda     xspeed                  ; check x-speed
        cmp     #$e0
        beq     _noxslodo
        inc     xspeed                  ; slow down x-speed
_noxslodo
        clc
        adc     xscroll
        sta     xscroll

        php                             ; flags to stack
        lsr                             ; scale down to pixels
        lsr
        lsr
        lsr
        lsr

        ora     #$10                    ; multicolor mode & x-scroll
        sta     $d016                   

        plp
        bcs     _noleap


;-      scroll over char boundary

        ldy     #$41
_leaplp1
        lda     $03c0,y
        sta     $03bf,y
        iny
        bne     _leaplp1
_leaplp2
        lda     $04c0,y
        sta     $04bf,y
        iny
        bne     _leaplp2
_leaplp3
        lda     $05c0,y
        sta     $05bf,y
        iny
        bne     _leaplp3
_leaplp4
        lda     $06c0,y
        sta     $06bf,y
        iny
        bne     _leaplp4


;-      background drawing

        inc     xchar
        lda     xchar
        and     #$07
        sta     pchar
        bne     _nonewpanel


;-      create new panels

        ldx     #$02
_cnlp
        jsr     Random
        and     #$18
        sta     panel1,x
        dex
        bpl     _cnlp

;-      draw panels

_nonewpanel
        lda     #$04
        sta     scrh
        lda     #$27
        sta     scr

        lda     xchar
        and     #$08
        php
        beq     _npski
        jsr     _drawhex
_npski
        lda     panel1
        jsr     DrawPanel
        lda     panel2
        jsr     DrawPanel

        plp
        beq     _npthird

        jsr     _drawhex
        beq     _npdone
_npthird
        lda     panel3
        jsr     DrawPanel
_npdone
_noleap
        jmp     Mainloop


;-----  Draw Panel

DrawPanel:
        beq     _drawspace
        sta     tmph

        ldy     #$00

        ldx     pchar
/*
        lda     xchar
        and     #$07
        pha
        tax
*/
        lda.w   paneltop,x
        sta     (scr),y
        jsr     _linedown

        txa
        ora     tmph
        tax

        lda.w   panelha-8,x
        sta     (scr),y
        jsr     _linedown

        lda     #$04
        sta     tmp
_dplp
        lda.w   panelmid-8,x
        sta     (scr),y
        jsr     _linedown
        dec     tmp
        bne     _dplp

        lda.w   panelhb-8,x
        sta     (scr),y
        jsr     _linedown

/*
        pla
        tax
*/
        ldx     pchar

        lda.w   panelbot,x
        sta     (scr),y

_linedown
        lda     scr
        clc
        adc     #$28
        sta     scr
        bcc     _ldnoc
        inc     scrh
_ldnoc
        rts

_drawhex
        ldx     #$04
        .DB     $0c                     ; skip next 2 bytes with nop $ffff
_drawspace
        ldx     #$08
;        sta     tmp
_dslp
        ldy     #$00
        lda     #$a0
        sta     (scr),y
        jsr     _linedown
        dex
        bne     _dslp
        rts



;-      panel construction

paneltop:
        .DB     $03,$04,$0b,$0b,$0b,$0b,$05,$06
panelbot:
        .DB     $0e,$0f,$0b,$0b,$0b,$0b,$0c,$0d

panelmid:
        .DB     $07,$0b,$0b,$0b,$0b,$0b,$0b,$08
        .DB     $07,$0b,$09,$0a,$a0,$a0,$0b,$08
        .DB     $07,$08,$a0,$a0,$a0,$a0,$07,$08

panelha:
        .DB     $07,$0b,$0b,$0b,$0b,$0b,$0b,$08
        .DB     $07,$0b,$09,$0a,$0e,$0f,$0b,$08
        .DB     $07,$0b,$0c,$0d,$0e,$0f,$0b,$08

panelhb:
        .DB     $07,$0b,$0b,$0b,$0b,$0b,$0b,$08
        .DB     $07,$0b,$05,$06,$a0,$a0,$0b,$08
        .DB     $07,$0b,$05,$06,$03,$04,$0b,$08



;-----  Do raster split

Raster:
        ldx     #$14                    ; start of score display
        lda     #$07
        ldy     #$f2
        jsr     _waitli

        dex                             ; back to graphics
        ldy     #$fa
_waitli
        cpy     $d012                   ; wait for rasterline y
        bne     _waitli

        ldy     #$0b
_tmlp
        dey
        bne     _tmlp

        sta     $d016                   ; set x-scroll
        stx     $d018                   ; set character generator
        rts


;-----  Add Score

_ascarry
        lda     #$b0
        sta     $07df,x
        dex
AddScore:
        inc     $07df,x                 ; add 1 to digit x
        lda     $07df,x
        cmp     #$ba                    ; carry to next digit
        beq     _ascarry
        ;
        ;

;-----  Generate pseudo-random number

Random:
        inc     rnd2
        lda     rnd2
        clc
        adc     rnd1
        adc     rnd2
        sta     rnd1
        eor     rnd2
        sta     rnd2
        sbc     rnd0
        sta     rnd0
        rts


;-      video chip init table

videoinit:
        .DB     $70,$80         ; player ship sprite
        .DB     $70,$33         ; enemy 1 sprite
        .DB     $50,$5b         ; enemy 2 sprite
        .DB     $f0,$83         ; enemy 3 sprite
        .DB     $b8,$ab         ; enemy 4 sprite
        .DB     $90,$d3         ; enemy 5 sprite
        .DB     $00,$00         ; laser sprite
        .DB     $76,$86         ; shadow sprite

        .DB     $3e             ; $d010 sprite x-coordinate msb's

        .DB     $1b             ; $d011 screen y-scroll
        .DB     $00,$00,$00     ; $d012 raster pos/irq & latches not used

        .DB     $ff             ; $d015 enable all sprites
        .DB     $17             ; $d016 multicolor mode & x-scroll
        .DB     $40             ; $d017 laser sprite y-expanded
        .DB     $13             ; $d018 character generator at $0800

        .DB     $00,$00         ; $d019-$d01a video irq's not used

        .DB     $00             ; $d01b no sprites below background
        .DB     $3f             ; $d01c sprite 0-5 multicolor
        .DB     $40             ; $d01d laser sprite x-expanded

        .DB     $00,$00         ; $d01e-$d01f sprite collisions

        .DB     $00,$0c         ; $d020-$d021 border/background color
        .DB     $0b,$0f         ; $d022-$d023 multicolor mode colors
        .DB     $00             ; $d024 background color 3 not used

        .DB     $01,$0c         ; $d025-$d026 multicolor sprite colors

        .DB     $0f             ; sprite colors
        .DB     $0d
        .DB     $03
        .DB     $07
        .DB     $0d
        .DB     $03
        .DB     $07
        .DB     $0b
.ENDS


.ORG $0bc0
.SECTION "sprite" FORCE

;-----  Ship sprite upper half at $0bc0

sprite:
        .INCBIN "sprite.bin"


;-      SID init table, later overwritten by mirrored half of ship sprite

sidinit:
        .DB     $00,$00,$00,$00,$11,$00,$20     ; voice 2 (laser)
        .DB     $00,$00,$00,$00,$81,$00,$f0     ; voice 3 (explosion)
        .DB     $00,$60                         ; filter cutoff
        .DB     $f4,$1f                         ; filter & volume


;-      sprite shapes, overwritten by mirrored half of ship sprite

sprites:
        .DB     $2f,$2f,$2f,$2f,$2f,$2f,$3f,$30


;-      sys3067

        sei
        jmp     Entry
.ENDS
