;***********************
;** General variables **
;***********************
memvar				.EQU $CC00
yint				.EQU memvar+1
vbl_cnt				.EQU memvar+2
scr_cnt				.EQU memvar+3
txt_cnt				.EQU memvar+4
txt_cnt2			.EQU memvar+5
sin_cnt				.EQU memvar+6
sin2_cnt			.EQU memvar+7
curyscr				.EQU memvar+8
scroll				.EQU memvar+9
vblnr				.EQU memvar+10
yint2				.EQU memvar+11
sin_cnt2			.EQU memvar+12
char				.EQU memvar+50

samp_cnt_h                      .EQU memvar+100
samp_cnt_l                      .EQU memvar+101
samp_pos_h                      .EQU memvar+102
samp_pos_l                      .EQU memvar+103
samp_bank                       .EQU memvar+104


.org	0

.org $40
  jp Vblank_interrupt
  reti
.org $48
  jp lcd_interrupt
  reti
.org $50
;  jp TIMER_int *Disabled* (reason: not enough CPU-Power for this crappy code)
  reti
.org $58
  reti
.org $60
  reti

.org $100
  nop
  jp begin

;Nintendo Scrolling Title Graphic
;***********************************************
.byte	0ceh,0edh,66h,66h,0cch,13,0,11,3,73h
.byte	0,83h,0,12,0,13,0,8,17,31,88h,89h,0
.byte	14,0dch,0cch,6eh,0e6h,0ddh,0ddh,0d9h
.byte	99h,0bbh,0bbh,67h,63h,6eh,0eh,0ech,0cch
.byte	0ddh,0dch,99h,09fh,0bbh,0b9h,33h,3eh
;***********************************************

.byte   "BIG SCROLLER    "              ;Title of the game
.byte	0,0,0				;Not used
.byte	0 				;Cartridge type: Rom only
					; 0 - Rom only      3 - ROM+MBC1+RAM+Battery
					; 1 - ROM+MBC1      5 - ROM+MBC2
					; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery
.byte	1				;Rom Size:
					; 0 - 256kBit =  32kB =  2 banks
					; 1 - 512kBit =  64kB =  4 banks
					; 2 -   1MBit = 128kB =  8 banks
					; 3 -   2MBit = 256kB = 16 banks
					; 4 -   4MBit = 512kB = 32 banks
.byte   0				;Ram Size:
					; 0 - None
					; 1 -  16kBit =  2kB = 1 bank
					; 2 -  64kBit =  8kB = 1 bank
					; 3 - 256kBit = 32kB = 4 banks
.byte	"A","G"				;Manufacturer code:
.byte	1				;Version Number
.byte	0ah				;Complement check
.word	0				;Checksum


begin:

;***********
;** SETUP **
;***********
  di
  xor a
  ldh ($40),a			;Turn off screen

; Copy Sprite handler to high ram
  ld      hl,VblankFirst
  ld      de,$FF80
  ld      b,VblankLast-VblankFirst
loadh:
  ld      a,(hli)
  ld      (de),a
  inc     de
  dec     b
  jp      nz,loadh

  ld a,%01000100		;set lcdc int
  ldh ($41),a
  ld a,%00000011
  ldh ($FF),a                   ;We want LCDC int + Vblank
  xor a
  ldh ($42),a			;Scroll X
  ldh ($43),a			;Scroll Y

  ld a,%11100100			;"normal" colours
  ldh ($47),a			;BG palette
  ldh ($48),a			;OBJ0 palette
  ldh ($49),a			;OBJ1 palette

  ld a,10			;Set map (background part)
  ld hl,$9C00
  ld b,32
setmap1:
  ld c,32
setmap2:
  call wrAtohl
  inc hl
  dec c
  jr nz,setmap2
  dec b
  jr nz,setmap1


  ld hl,tiles_chars
  call load_tiles		;load tiles
  ld hl,map_bg
  call load_map			;load map (textpart)

  ld a,%11010001
  ldh ($40),a			;Turn screen on
  ld a,64
  ldh ($43),a
  ld (scroll),a


  xor a				;Reset a bun of variables
  ld (yint2),a
  ld (sin_cnt2),a
  ld (vblnr),a
  ld (sin_cnt),a
  ld (txt_cnt),a
  ld (txt_cnt2),a
  ld (scr_cnt),a
  ld (vbl_cnt),a

  ld a,33			;Set first LCDC-int
  ld (yint),a
  ldh ($45),a


;*** Setup sample stuff ***
  ld hl,1716   ;sample length
  ld a,h
  ld (samp_cnt_h),a
  ld a,l
  ld (samp_cnt_l),a
  ld hl,$4000
  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a
  ld a,2
  ld (samp_bank),a
  ld a,$84
  ldh ($26),a
  xor a
  ldh ($1A),a
  ldh ($25),a
  ld a,$77
  ldh ($24),a
  ld a,$FF
  ldh ($25),a
  ld a,$FF
  ldh ($1B),a
  ld a,$20
  ldh ($1C),a
;---- 8 Khz freq ----
  ld a,%00000000
  ldh ($1D),a
  ld a,256-16
  ld ($FF06),a                   ;divide
  ld a,4
  ld ($FF07),a                   ;set timer freq = 4096
;---------------------

  ei
  
main:
  jr main





;***********************
;*** TIMER Interrupt ***
;***********************
TIMER_int:
  push af
  push bc
  push de
  push hl
  ld a,(samp_pos_h)
  ld h,a
  ld a,(samp_pos_l)
  ld l,a                ;hl = sample position
  ld a,(samp_bank)
  ld ($2000),a  ;select bank
  ld de,$FF30
  ld b,16               ;16 bytes / sample-pack
  xor a
  ldh ($1A),a
load_samp:
  ld a,(hli)
  ld (de),a
  inc de
  dec b
  jr nz,load_samp
  ld a,1
  ld ($2000),a  ;bank1
  ld a,h
  cp $80
  jr nz,noressb
  ld a,(samp_bank)
  inc a
  ld (samp_bank),a
  ld hl,$4000
noressb:
  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a
  ld a,(samp_cnt_h)
  ld h,a
  ld a,(samp_cnt_l)
  ld l,a
  dec hl
  ld a,h
  ld (samp_cnt_h),a
  ld a,l
  ld (samp_cnt_l),a
  inc hl
  ld a,h
  cp 0
  jr nz,noressamp
  ld a,l
  cp 0
  jr nz,noressamp
;*** Reset sample ***
  ld hl,1716
  ld a,l
  ld (samp_cnt_l),a
  ld a,h
  ld (samp_cnt_h),a
  ld hl,$4000
  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a
  ld a,2
  ld (samp_bank),a
noressamp:
  ld a,$84
  ldh ($26),a
  ld a,$80
  ldh ($1A),a
  ld a,%10000111
  ldh ($1E),a
  pop hl
  pop de
  pop bc
  pop af
  reti





;**********************
;*** LCDC Interrupt ***
;**********************
lcd_interrupt:
  push af
  push bc
  push de
  push hl

  ld a,(vblnr)
  cp 0
  jp nz,dowindowpart
;*** SCROLLTEXTPART ***
  ld a,(yint)
  inc a
  cp 33				;Is y<33?
  jr c,do_logodist		;yes, dist logo
  cp 35				;Is y>34?
  jr nc,lc1a			;Yes, do text-mirror
  ld a,(sin_cnt)		;scroll the text
  inc a
  inc a
  ld (sin_cnt),a
  ld hl,sin1
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  ldh ($42),a			;scroll text up/down
  ld (curyscr),a
  ld a,(scroll)
  ld b,4
  add a,b
  ld (scroll),a
  ldh ($43),a			;scroll text right->left
  ld a,123
  ld (yint),a
  ldh ($45),a

  pop hl
  pop de
  pop bc
  pop af
  reti
lc1a:			;Do the mirror of scrolltext
  cp 144
  jr nz,noreslc1a
  ld a,7
  ld (yint),a
  ldh ($45),a
  ld a,%11100100
  ldh ($47),a
  pop hl
  pop de
  pop bc
  pop af
  reti
noreslc1a:

  ld (yint),a
  ldh ($45),a

  ld hl,scrtab
  ld d,0
  ld e,a
  add hl,de
  ld a,(hl)
  neg
  ld b,a
  ld a,(curyscr)
  srl a
  add a,b
  ldh ($42),a
  ld a,(yint)
  ld hl,coltab
  ld e,a
  add hl,de
  ld a,(hl)
  ldh ($47),a
  pop hl
  pop de
  pop bc
  pop af
  reti
do_logodist:
  ld (yint),a
  ldh ($45),a
  ld b,a
  ld a,(sin_cnt2)
  add a,b
  ld hl,sin4
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  neg
  ldh ($43),a
  pop hl
  pop de
  pop bc
  pop af
  reti


;*** DISTING BACKGROUND PART ***
dowindowpart:
  ld a,(yint2)
  inc a
  cp 144
  jr nz,yi2
  xor a
yi2:
  ld (yint2),a
  ldh ($45),a
  ld b,a
  ld a,(sin_cnt2)
  add a,b
  ld e,a
  ld d,0
  ld hl,sin3
  add hl,de
  ld a,(hl)
  ldh ($43),a
  ld a,(sin_cnt2)
  ld b,a
  ld a,(yint2)
  add a,b
  ld e,a
  ld d,0
  ld hl,sin3
  add hl,de
  ld a,(hl)
  srl a
  srl a
  ldh ($42),a 
  pop hl
  pop de
  pop bc
  pop af
  reti


;************************
;*** Vblank Interrupt ***
;************************
Vblank_interrupt:
  ld a,(vblnr)
  inc a
  cp 2
  jr nz,vbnrr
  xor a
vbnrr:
  ld (vblnr),a			;Set new VBL-NR (0 / 1)
  cp 0
  jr z,morevbl			;VBL-NR 0 = scroller
drawwindow:
  ld a,%11011001
  ldh ($40),a			;mapdata = $9C00 (disting background)
  xor a
  ldh ($43),a			;scrollX=0
  ldh ($42),a			;scrollY=0
  ld (yint2),a			;next LCDC-int at Y=0
  ldh ($45),a
  ld a,(sin_cnt2)
  inc a
  inc a
  cp 144
  jr c,sin2notres
  xor a
sin2notres:
  ld (sin_cnt2),a
  reti				;end of disting-VBL
morevbl:
  ld a,%11010001
  ldh ($40),a			;Set mapdata=$9800 (scroller)
  ld a,7
  ld (yint),a			;Next lcdc-int=116
  ldh ($45),a

  xor a
  ldh ($43),a			;Don't scroll screen
  ld a,-3			;Go down 3 pixels
  ldh ($42),a

  ld a,(vbl_cnt)
  inc a
  cp 16
  jp nz,dontputnew
  ld a,(scr_cnt)
  inc a
  cp 4
  jr nz,vba
  xor a
vba:
  ld (scr_cnt),a
  xor a
  ld (vbl_cnt),a		;next vbl is for dist-bg
  ld a,(txt_cnt)
  ld e,a
  ld a,(txt_cnt2)
  ld d,a
  inc de
  ld a,d
  ld (txt_cnt2),a
  ld a,e
  ld (txt_cnt),a

  ld hl,text
  add hl,de
  ld a,(hl)			;a=text to write
  ld hl,$9800+(32*10)		;pos. on screen
  push af
  ld a,(scr_cnt)
  cp 0
  jr z,vb2
vbl1:
  push de
  ld de,8
  add hl,de
  pop de

  dec a
  cp 0
  jr nz,vbl1
vb2:
  pop af
;*** Put character on screen ***
writechar:			;a=character
  push hl
  cp 1
  jp z,resetscroller
  cp 33
  jp z,docUT
  cp 39
  jp z,docKOMMA2
  cp 44
  jp z,docKOMMA
  cp 46
  jp z,docDOT
  CP 48
  JP Z,doc0
  CP 49
  JP Z,doc1
  CP 50
  JP Z,doc2
  CP 51
  JP Z,doc3
  CP 52
  JP Z,doc4
  CP 53
  JP Z,doc5
  CP 54
  JP Z,doc6
  CP 55
  JP Z,doc7
  CP 56
  JP Z,doc8
  CP 57
  JP Z,doc9
  cp 65
  jp z,doca
  cp 66
  jp z,docb
  cp 67
  jp z,docc
  cp 68
  jp z,docd
  cp 69
  jp z,doce
  cp 70
  jp z,docf
  cp 71
  jp z,docg
  cp 72
  jp z,doch
  cp 73
  jp z,doci
  cp 74
  jp z,docj
  cp 75
  jp z,dock
  cp 76
  jp z,docl
  cp 77
  jp z,docm
  cp 78
  jp z,docn
  cp 79
  jp z,doco
  cp 80
  jp z,docp
  cp 81
  jp z,docq
  cp 82
  jp z,docr
  cp 83
  jp z,docs
  cp 84
  jp z,doct
  cp 85
  jp z,docu
  cp 86
  jp z,docv
  cp 87
  jp z,docw
  cp 88
  jp z,docx
  cp 89
  jp z,docy
  cp 90
  jp z,docz
  ld hl,cUNKNOWN
  jp putcharonscreen
docDOT:
  ld hl,cDOT
  jp putcharonscreen
docKOMMA:
  ld hl,cKOMMA
  jp putcharonscreen
docKOMMA2
  ld hl,cKOMMA2
  jp putcharonscreen
docUT:
  ld hl,cUT
  jp putcharonscreen
resetscroller:
  xor a
  ld (txt_cnt),a
  ld hl,cUNKNOWN
  jp putcharonscreen
doca:
  ld hl,cA
  jp putcharonscreen
docb:
  ld hl,cB
  jp putcharonscreen
docc:
  ld hl,cC
  jp putcharonscreen
docd:
  ld hl,cD
  jp putcharonscreen
doce:
  ld hl,cE
  jp putcharonscreen
docf:
  ld hl,cF
  jp putcharonscreen
docg:
  ld hl,cG
  jp putcharonscreen
doch:
  ld hl,cH
  jp putcharonscreen
doci:
  ld hl,cI
  jp putcharonscreen
docj:
  ld hl,cJ
  jp putcharonscreen
dock:
  ld hl,cK
  jp putcharonscreen
docl:
  ld hl,cL
  jp putcharonscreen
docm:
  ld hl,cM
  jp putcharonscreen
docn:
  ld hl,cN
  jp putcharonscreen
doco:
  ld hl,cO
  jp putcharonscreen
docp:
  ld hl,cP
  jp putcharonscreen
docq:
  ld hl,cQ
  jp putcharonscreen
docr:
  ld hl,cR
  jp putcharonscreen
docs:
  ld hl,cS
  jp putcharonscreen
doct:
  ld hl,cT
  jp putcharonscreen
docu
  ld hl,cU
  jp putcharonscreen
docv
  ld hl,cV
  jp putcharonscreen
docw:
  ld hl,cW
  jp putcharonscreen
docx:
  ld hl,cX
  jp putcharonscreen
docy:
  ld hl,cY
  jp putcharonscreen
docz:
  ld hl,cZ
  jp putcharonscreen
doc0:
  ld hl,c0
  jp putcharonscreen
doc1:
  ld hl,c1
  jp putcharonscreen
doc2:
  ld hl,c2
  jp putcharonscreen
doc3:
  ld hl,c3
  jp putcharonscreen
doc4:
  ld hl,c4
  jp putcharonscreen
doc5:
  ld hl,c5
  jp putcharonscreen
doc6:
  ld hl,c6
  jp putcharonscreen
doc7:
  ld hl,c7
  jp putcharonscreen
doc8:
  ld hl,c8
  jp putcharonscreen
doc9:
  ld hl,c9
  jp putcharonscreen
putcharonscreen:
  ld de,char
  ld b,30			;size=5*6 = 30
cpych:
  ldi a,(hl)
  ldi (de),a
  dec b
  jp nz,cpych
  pop hl
  ld de,char
  ld c,5		;height=5
putch1
  ld b,6		;width=6
putch2:
  ldh a,($41)
  and 2
  jp nz,putch2		;wait until ok to write to Vram
  ldi a,(de)
  ldi (hl),a		;write tile to screen
  dec b
  jp nz,putch2
  push de
  ld d,0
  ld e,26
  add hl,de
  pop de
  dec c
  jp nz,putch1
  nop
  nop
  reti
dontputnew
  ld (vbl_cnt),a
  reti




;*****************************************************************
;**			GENERAL SUB-ROUTINES 			**
;*****************************************************************



wait30:					;Wait 0.5 sec
  ld b,30
wt30:
  call waitvbl
  dec b
  jp nz,wt30
  ret

wait45:					;Wait 0.75 sec
  ld b,45
wt45:
  call waitvbl
  dec b
  jp nz,wt45
  ret

wait60:					;Wait 1 sec
  ld b,60
wt60:
  call waitvbl
  dec b
  jp nz,wt60
  ret


waitvbl:
  push af
  ldh a,($40)
  add a,a
  jp nc,vbl_done
vbl_notyet:
  ldh a,($44)			; $ff44=LCDC Y-Pos
  cp $98			; $98 and bigger = in VBL
  jp nz,vbl_notyet
vbl_done:
  pop af
  ret


load_map:		;** LOAD A MAP AT HL **
  ld de,$9800			;Mapmem location
  ld c,32			;Height=32
ldmap1:
  ld b,32			;Width=32
ldmap2:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jp nz,ldmap2
  dec c
  jp nz,ldmap1
  ret

load_tiles:		;** LOAD TILESET FROM HL **
  ld de,$8000			;BG-tiles position
  ld c,255			;Nr. of tiles
loadtiles:
  ld b,16			;16 bytes per tile 
loadonetile:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jp nz,loadonetile
  dec c
  jp nz,loadtiles
  ret


load_windowmap:			;** LOAD WINDOW MAP **
  ld de,$9C00
  ld c,32
loadwintiles:
  ld b,32
loadwintile:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jp nz,loadwintile
  dec c
  jp nz,loadwintiles
  ret



wrAtohl:	;** Writes A to HL at the right time **
  push af		;Save reg A and flags
wral1:
  ldh a,($41)
  and 2
  jp nz,wral1
  pop af		;Restore reg A and flags
  ld (hl),a		;write a to hl
  ret

wrAtode:	;** Writes A to DE at the right time **
  push af		;Save reg A and flags
wral2:
  ldh a,($41)
  and 2
  jp nz,wral2
  pop af		;Restore reg A and flags
  ld (de),a		;write a to de
  ret




VblankFirst
  di
  push af
  ld a,$c0
  ldh ($46),a
  ld a,$28
VblankW
  dec a
  jp nz,VblankW
  pop af
  ei
  ret
VblankLast


clear_spritedata:
  xor a
  ld hl,$C000
  ld c,40			;40 sprites
  xor a
clroamdata:
  ld (hli),a
  ld (hli),a
  ld a,255
  ld (hli),a
  xor a
  ld (hli),a
  dec c
  jp nz,clroamdata
  ret

clear_bgdata:
  ld a,255			;tile 255 = blank
  ld hl,$9800
  ld c,32			;Height=32
cleartiles:
  ld b,32			;width=32
cleartile:
  ld (hli),a
  dec b
  jp nz,cleartile
  dec c
  jp nz,cleartiles
  ret








;**********
;** DATA **
;**********
text:
.DB " HERE IT IS, "
.DB " THE 'BIG SCROLLER'"
.DB " DEMO... CODED"
.DB " BY ANDERS GRANLUND"
.DB " FOR THE GAMEBOY '98"
.DB " DEMO COMPETITION.."
.DB "    THIS"
.DB " DEMO WAS FINISHED"
.DB " SOMETIME AROUND"
.DB " JANUARY '98 BUT"
.DB " THE TEXT YOU ARE"
.DB " NOW READING"
.DB " WAS ADDED IN MARCH"
.DB " OF THIS YEAR..."
.DB "   "
.DB " GREETINGS GOES"
.DB " TO EVERYONE AT THE"
.DB " GAMEBOY MAILING LIST"
.DB " AND DEVELOPEMENT RING,"
.DB " KEEP IT UP EVERYONE"
.DB " YOU ARE DOING GREAT"
.DB " WORK!!"
.DB "   WELL, WRITING"
.DB " SCROLLTEXT'S ISN'T"
.DB " EXACTLY MY STRONG SIDE"
.DB " SO I SUGGEST WE START"
.DB " IT ALL OVER AGAIN...."
.DB "    "
.DB 1



map_bg:
#include "bcmap.map"
tiles_chars:
#include "bigchar.tle"
sin1:
#include "bcsin.dta"
#include "bcsin.dta"
sin2:
#include "bcsin2.dta"
#include "bcsin2.dta"
sin3:
#include "bcsin3.dta"
#include "bcsin3.dta"
sin4:
#include "bcsin4.dta"
#include "bcsin4.dta"



chars:
cUNKNOWN:
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
cA:
.db 2,1,1,1,1,3
.db 1,1,1,1,1,1
.db 1,1,0,0,1,1
.db 1,1,1,1,1,1
.db 1,1,0,0,1,1
cB:
.db 1,1,1,1,1,3
.db 1,1,0,0,1,1
.db 1,1,1,1,1,6
.db 1,1,0,0,1,1
.db 1,1,1,1,1,5
cC:
.db 2,1,1,1,1,1
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
.db 4,1,1,1,1,1
cD:
.db 1,1,1,1,1,3
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,1,1,1,5
cE:
.db 2,1,1,1,1,1
.db 1,1,0,0,0,0
.db 1,1,1,1,0,0
.db 1,1,0,0,0,0
.db 4,1,1,1,1,1
cF:
.db 2,1,1,1,1,1
.db 1,1,0,0,0,0
.db 1,1,1,1,0,0
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
cG:
.db 2,1,1,1,1,1
.db 1,1,0,0,0,0
.db 1,1,0,1,1,3
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
cH:
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,1,1,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
cI:
.db 0,1,1,1,1,0
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
.db 0,1,1,1,1,0
cJ:
.db 1,1,1,1,1,1
.db 0,0,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
cK:
.db 1,1,0,0,1,1
.db 1,1,0,2,1,5
.db 1,1,1,1,6,0
.db 1,1,0,4,1,3
.db 1,1,0,0,1,1
cL:
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
.db 1,1,1,1,1,1
cM:
.db 1,1,3,2,1,1
.db 1,1,1,1,1,1
.db 1,1,4,5,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
cN:
.db 1,1,3,0,1,1
.db 1,1,4,3,1,1
.db 1,1,0,4,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
cO:
.db 2,1,1,1,1,3
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
cP:
.db 1,1,1,1,1,3
.db 1,1,0,0,0,1
.db 1,1,1,1,1,5
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
cQ:
.db 2,1,1,1,1,3
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,0,2,1,1
.db 4,1,1,1,1,1
cR:
.db 1,1,1,1,1,3
.db 1,1,0,0,0,1
.db 1,1,1,3,2,5
.db 1,1,0,1,0,0
.db 1,1,0,4,1,1
cS:
.db 2,1,1,1,1,1
.db 1,0,0,0,0,0
.db 4,1,1,1,1,3
.db 0,0,0,0,0,1
.db 1,1,1,1,1,5
cT:
.db 2,1,1,1,1,3
.db 1,0,1,1,0,1
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
cU:
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
cV:
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 0,1,1,1,1,0
.db 0,0,1,1,0,0
cW:
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 1,1,2,3,1,1
.db 1,1,1,1,1,1
.db 1,1,5,4,1,1
cX:
.db 1,1,0,0,1,1
.db 0,1,1,1,1,0
.db 0,0,1,1,0,0
.db 0,1,1,1,1,0
.db 1,1,0,0,1,1
cY:
.db 1,1,0,0,1,1
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
cZ:
.db 1,1,1,1,1,1
.db 0,0,0,1,1,0
.db 0,1,1,0,0,0
.db 1,1,0,0,0,0
.db 1,1,1,1,1,1
cKOMMA:
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,2,1,0,0
.db 0,0,1,5,0,0
cKOMMA2
.db 0,0,0,0,2,1
.db 0,0,0,0,1,5
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
cDOT:
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,0,0,0,0
.db 0,0,2,3,0,0
.db 0,0,4,5,0,0
cUT:
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
.db 0,0,0,0,0,0
.db 0,0,2,5,0,0
c0:
.db 2,1,1,1,1,3
.db 1,1,0,2,1,1
.db 1,1,2,5,1,1
.db 1,1,5,0,1,1
.db 4,1,1,1,1,5
c1:
.db 0,2,1,1,0,0
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
.db 0,0,1,1,0,0
.db 0,1,1,1,1,0
c2:
.db 1,1,1,1,1,3
.db 0,0,0,0,1,1
.db 2,1,1,1,1,5
.db 1,1,0,0,0,0
.db 1,1,1,1,1,1
c3:
.db 2,1,1,1,1,3
.db 1,1,0,0,1,1
.db 0,0,0,1,1,6
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
c4:
.db 1,1,0,0,0,0
.db 1,1,0,1,1,0
.db 4,1,1,1,1,1
.db 0,0,0,1,1,0
.db 0,0,0,1,1,0
c5:
.db 1,1,1,1,1,1
.db 1,1,0,0,0,0
.db 1,1,1,1,1,3
.db 0,0,0,0,1,1
.db 1,1,1,1,1,5
c6:
.db 1,1,0,0,0,0
.db 1,1,0,0,0,0
.db 1,1,1,1,1,3
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
c7:
.db 1,1,1,1,1,1
.db 0,0,0,2,1,5
.db 0,0,2,1,5,0
.db 0,2,1,5,0,0
.db 2,1,5,0,0,0
c8:
.db 2,1,1,1,1,3
.db 1,1,0,0,1,1
.db 7,1,1,1,1,6
.db 1,1,0,0,1,1
.db 4,1,1,1,1,5
c9:
.db 2,1,1,1,1,3
.db 1,1,0,0,1,1
.db 4,1,1,1,1,1
.db 0,0,0,0,1,1
.db 0,0,0,0,1,1


scrtab:
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 5,8,11,14,17,20,23,26,29,32
.db 35,38,41,44,47,50,53,56,59
.db 62,65,68,71,74,77,81
coltab:
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0

.db %11100100
.db %11100100
.db %11100100
.db %11100100
.db %11100100
.db %11100100
.db %11100100
.db %11100100
.db %11100100

.db %11100100
.db %11100100

.db %10010000
.db %10010000
.db %10010000
.db %10010000
.db %10010000
.db %10010000

.db %10010000
.db %10010000


.db %01000000
.db %01000000
.db %01000000
.db %01000000
.db %01000000
.db %01000000
.db %01000000

;*** binary sample-data starts here  ***
.org $8000
.end
