//--------------------------------------------------------------------------//
// iq . 2007 . kindernoiser 4k intro demo by RGBA                           //
//--------------------------------------------------------------------------//

#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "main.h"
#include "ext.h"
#include "fsh_ssao.inl"
#include "fsh_glow.inl"
#include "fsh_sprite.inl"
#include "vsh_2d.inl"
#include "vsh_sprite.inl"
#include "fp.h"
#include "fft.h"

//=================================================================================================================
//=================================================================================================================
#define NUMPASSES   5
#define NUMSHADERS  5
#define NUMTEXTURES 5
#define NUMSPHERES  24576

#define TX0ID  2
#define TX1ID  3
#define TX2ID  4
#define TX3ID  5
#define TX4ID  6

#define ZBUID  7
#define FBOID  8

/*static*/ const float freq = 16.0f*0.1153741f;//4.0f*6.0f*5.0f/(2.0f*130.0f);
/*static*/ const char *vshaders[NUMSHADERS] = { vsh_sprite, vsh_2d,   vsh_2d,    vsh_2d,    vsh_2d   };
/*static*/ const char *fshaders[NUMSHADERS] = { fsh_sprite, fsh_ssao, fsh_hblur, fsh_vblur, fsh_copy };
/*static*/ unsigned char pass_t0id[] = { 0,     TX0ID, TX1ID, 0,      0 };
/*static*/ unsigned char pass_t1id[] = { 0,     0,     TX0ID, TX2ID,  0 };
/*static*/ unsigned char pass_targ[] = { TX0ID, TX1ID, TX2ID, 0    ,  0 };
//                                      0      1       2       3        4       5       6       7       8        9      10      11        12        13       14        15       16       17      18       19      20     21       22     23     24
/*static*/ const short tiempos[] = {  0,   70, 293,  438,   514,  551,  588,  604,  610,  640,  646,   678,   714,    720,   735,   812,   870,   873,   879,   882,  884,  921,  960, 995, 1030,  1040 };
/*static*/ const short camvel[]  = {  2,   10,  25,   10,    10,   10,   10,   10,   10,   10,   10,    10,    80,     10,    10,    10,     0,     0,   320,    10,   20,   10,   10,  10,   40,     0 };
/*static*/ const short camoff[]  = { 559, 358, 29, 708,  664, 570, 195, 265, 428, 265, 540, 3620,   10,    22,  298, 8590,  886,  875,  330,   22,  100,  9, 233,100, 350,    0 };

//=================================================================================================================
//=================================================================================================================

/*static*/ int   pid[NUMPASSES];
/*static*/ float fkernef[32*4];
/*static*/ float esferas[NUMSPHERES*4];

//=================================================================================================================

static __forceinline float mfmodf( float x, float y )
{
    float r;
    _asm fld y
    _asm fld x
    _asm fprem
    _asm fstp st(1)
    _asm fstp r
    return r;
}

static __forceinline float m2powf( float f )
{
    _asm fld   dword ptr [f]
    _asm fld1
    _asm fld   st(1)
    _asm fprem
    _asm f2xm1
    _asm faddp st(1), st
    _asm fscale
    _asm fstp  st(1)
    _asm fstp  dword ptr [f]
    return f;
}

//=================================================================================================================

/*static*/ float sfrand( int *mirand ) { mirand[0] = mirand[0]*0x343fd+0x269ec3; int a = (mirand[0]>>16)&32767; return  -1.0f + (2.0f/32768.0f)*(float)a; }

static __forceinline void generate1( const float *fft, float time, float rtime, float *sph, /*int numspheres,*/ int escena )
{
    int sems[2] = { 2, 1 };

	const float rithm = mfmodf( rtime, freq )/freq;

    const float h = rithm;
    
    float s = 1.0f;
    if( escena==7 || escena==9 || escena==24 ) s = sqrtf(sqrtf( rtime ));

    const bool israro = (escena==13) || (escena==14) || (escena==21);

    for( int i=0; i<NUMSPHERES; i++ )
    {
        float pos[3];
        float inc[3];

        const int k = i & 2047;

        if( k==0 )
        {
            pos[0] = 0.0f;
            pos[1] = 0.0f;
            pos[2] = 0.0f;
        }

        const float incs[6] = { sfrand(sems+0), sfrand(sems+0), sfrand(sems+0),
                                sfrand(sems+1), sfrand(sems+1), sfrand(sems+1) };
        inc[0] = incs[0];
        inc[1] = incs[1];
        inc[2] = incs[2];
        if( israro )
        {
            inc[0] += (incs[3]-incs[0])*h;
            inc[1] += (incs[4]-incs[1])*h;
            inc[2] += (incs[5]-incs[2])*h;
        }

        // update position
        pos[0] += inc[0];
        pos[1] += inc[1];
        pos[2] += inc[2];

        // give shape
        if( israro )
        {
            sph[4*i+0] = s*pos[0]*pos[1]*(0.01f*0.01f*8.0f);
            sph[4*i+1] = s*pos[1]*pos[2]*(0.01f*0.01f*8.0f);
            sph[4*i+2] = s*pos[2]*pos[0]*(0.01f*0.01f*8.0f);
        }
        else
        {
            sph[4*i+0] = p0d01*s*pos[0];
            sph[4*i+1] = p0d01*s*pos[1];
            sph[4*i+2] = p0d01*s*pos[2];
        }

        // fft dancing
        float ffr = fft[k>>4] * (((float)k/2047.0f)*p0d90+p0d10);
        if( escena==0 ) ffr=0.5f+ffr*0.25f;
        sph[4*i+3] = s*0.006f*(1.0f + ffr);
    }
}

int intro_init( void )
{
    // extensions
    if( !EXT_Init() )
        return( 0 );

    // kernel
    int mirand = 1; 
    for( int i=0; i<(32*4); i++ ) 
		fkernef[i] = sfrand(&mirand);

    // textures
    for( int i=0; i<NUMTEXTURES; i++ )
    {
        glBindTexture( GL_TEXTURE_2D, TX0ID+i );
        glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA16F_ARB, XRES, YRES, 0, GL_RGBA, GL_FLOAT, 0 );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,     GL_CLAMP_TO_EDGE );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,     GL_CLAMP_TO_EDGE );
        glBindTexture( GL_TEXTURE_2D, 0 );
    }

    // depth renderbuffer
    oglBindRenderbufferEXT(GL_RENDERBUFFER_EXT, ZBUID );
    oglRenderbufferStorageEXT(GL_RENDERBUFFER_EXT, GL_DEPTH_COMPONENT24, XRES, YRES );
    oglBindRenderbufferEXT(GL_RENDERBUFFER_EXT, 0 );

    // shaders
    for( int i=0; i<NUMSHADERS; i++ )
    {
        pid[i] = oglCreateProgram();                           
	    const int vsId = oglCreateShader( GL_VERTEX_SHADER );  
	    const int fsId = oglCreateShader( GL_FRAGMENT_SHADER );
	    oglShaderSource( vsId, 1, vshaders+i, 0 );
	    oglShaderSource( fsId, 1, fshaders+i, 0 );
        oglCompileShader( vsId );
        oglCompileShader( fsId );
	    oglAttachShader( pid[i], fsId );
	    oglAttachShader( pid[i], vsId );
	    oglLinkProgram( pid[i] );
        #ifdef DEBUG
        int		result;
        char    info[2048];
        oglGetObjectParameteriv( vsId,   GL_OBJECT_COMPILE_STATUS_ARB, &result ); oglGetInfoLog( vsId,   1024, NULL, (char*)info ); if( !result ) DebugBreak();
        oglGetObjectParameteriv( fsId,   GL_OBJECT_COMPILE_STATUS_ARB, &result ); oglGetInfoLog( fsId,   1024, NULL, (char*)info ); if( !result ) DebugBreak();
        oglGetObjectParameteriv( pid[i], GL_OBJECT_LINK_STATUS_ARB,    &result ); oglGetInfoLog( pid[i], 1024, NULL, (char*)info ); if( !result ) DebugBreak();
        #endif
    }
    return 1;
}

//=================================================================================================================

void intro_do( const float *fft, float t, int frame )
{
    //--- update parameters -----------------------------------------
    const float ot = t;

	// select scene
    int escena;
    for( escena=0; 0.1f*tiempos[escena]<t; escena++ ); escena--;
    const float rt = t - 0.1f*tiempos[escena];

    // move camera
    t = rt*0.1f*camvel[escena] + (float)camoff[escena];

    // create/move spheres
    generate1( fft, t, rt, esferas, /*numspheres,*/ escena );

    // set camera
    const float cam[6] = { 
        p0d30*cosf( t*p0d05+p0d00 ),
        p0d30*cosf( t*p0d06+p0d90 ),
        p0d30*cosf( t*p0d11*0.5f+p1d57 ),
        p0d10*cosf( t*p0d17+p2d00 ),
        p0d10*cosf( t*p0d18+p1d60 ),
        p0d10*cosf( t*p0d19+p0d00 ) };

    // scren shaking and distortions
    float to = -100.0f;
	if( ot>36.6f ) to = 36.6f;
    if( ot>51.5f ) to = 51.5f;
    if( ot>73.5f ) to = 73.5f;
	if( ot>88.2f ) to = 88.2f;

	const float dt = ot-to;
    const float f2 = -1.0f+2.0f*fabsf(-1.0f+mfmodf(dt,1.0f/12.0f)*(2.0f*12.0f));

    fkernef[4*1+2] = p0d25*f2*m2powf(-16.0f*dt);
  	fkernef[4*1+3] = 0.0f;
	fkernef[4*0+3] = (frame<4)?0.0f:1.0f;

    //--- render -----------------------------------------

    oglBindFramebufferEXT(GL_FRAMEBUFFER_EXT, FBOID );
    oglFramebufferRenderbufferEXT( GL_FRAMEBUFFER_EXT, GL_DEPTH_ATTACHMENT_EXT, GL_RENDERBUFFER_EXT, ZBUID );

    const unsigned int st = frame&1;    // ping-pong textures for mblur
    pass_t0id[3] = TX3ID+st;
    pass_targ[3] = TX3ID+1-st;
    pass_t0id[4] = TX3ID+1-st;

    for( int i=0; i<NUMPASSES; i++ )
    {
        oglUseProgram( pid[i] );
        oglUniform4fv( oglGetUniformLocation( pid[i], "fpa" ), 32, fkernef );
		oglUniform1i( oglGetUniformLocation( pid[i], "tex0" ),  0 );
		oglUniform1i( oglGetUniformLocation( pid[i], "tex1" ),  1 );
        oglActiveTextureARB( GL_TEXTURE0_ARB ); glBindTexture( GL_TEXTURE_2D, pass_t0id[i] );
        oglActiveTextureARB( GL_TEXTURE1_ARB ); glBindTexture( GL_TEXTURE_2D, pass_t1id[i] );

		oglFramebufferTexture2DEXT( GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_2D, pass_targ[i], 0);
        if( i==(NUMPASSES-1) )  
            oglBindFramebufferEXT( GL_FRAMEBUFFER_EXT, 0 );  // last frame, render to color buffer

        if( i==0 )
        {
            glMatrixMode( GL_MODELVIEW );   // QUITABLE?
            glLoadIdentity();
            gluLookAt( cam[0], cam[1], cam[2], cam[3], cam[4], cam[5], 0.0f, 1.0f, 0.0f );
            glClearColor( 1.0f, 1.0f, 1.0f, 1.0f );
            glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT );
            glEnable( GL_DEPTH_TEST );
            for( int j=0; j<NUMSPHERES; j++ ) 
			{ 
				glTexCoord4fv( esferas+4*j ); 
				glRects( -1, -1, 1, 1 ); 
			}
            glDisable( GL_DEPTH_TEST );
        }
        else
        {
            glRects( -1, -1, 1, 1 );
        }
    }
}