;************************************************
;* Base System for the Intro - by Orion_ [2003] *
;************************************************

	INCLUDE	"inc\os.h"

;******************************

;old_ams	equ	1	; ben vous avez qu'a avoir un AMS recent #gni#

call macro
	ifd	old_ams
	move.l	$c8,a0
	move.l	\1*4(a0),a0
	jsr	(a0)
	endc
	ifnd	old_ams
	dc.w	$f800+\1
	endc
	endm

;******************************

	XDEF	_nostub
	XDEF	_ti89

__main:	xdef __main			; TIGCC v0.95 pawa :|

	XDEF	myscreen		; u si on oublis a
	XDEF	CosT			; on ce demande apres p koi a compile pas
	XDEF	SinT			; #lolpaf#
	XDEF	SinTab
	XDEF	objdata
	XDEF	objdata1
	XDEF	objdata2

BUFSIZE	equ	(2*3840)+300+(512*2*2)+256+(1296*3)	; comment sa ch'ui gourmant ?? #trifus#

	movem.l	d0-d7/a0-a6,-(a7)	; Push Regs

					; Save Screen
	pea.l	BUFSIZE			; malloc(BUFFER)
	call	HeapAllocPtr		; on fait tout en une seule allocation a va plus vite ;)
	addq.l	#4,a7
	move.l	a0,d0			; put the pointer in D0
	tst.l	d0			; Test if it return an error
	beq	nomem			; not enough memory :(

	move.l	#3840,d1
	move.l	#1296,d2
	move.l	#512*2,d3

				; Attribution des pointeurs
	lea.l	oscreen(pc),a0		; Optimisation en taille pour la suite
	move.l	d0,(a0)+		; screen save
	add.l	d1,d0
	move.l	d0,(a0)+		; vscreen
	add.l	d1,d0
	move.l	d0,(a0)+		; scrollbuffer
	addi.w	#300,d0
	move.l	d0,(a0)+		; CosT
	add.w	d3,d0
	move.l	d0,(a0)+		; SinT
	add.w	d3,d0
	move.l	d0,(a0)+		; SinTab
	addi.w	#256,d0
	move.l	d0,(a0)+		; objdata
	add.l	d2,d0
	move.l	d0,(a0)+		; objdata1
	add.l	d2,d0
	move.l	d0,(a0)			; objdata2

	pea.l	BUFSIZE			; Size
	clr.w	-(a7)			; Clear
	move.l	oscreen(pc),-(a7)	; Buffer
	call	memset			; :)
	lea.l	10(a7),a7

	pea.l	3840			; memcpy(oscreen,LCD_MEM,LCD_SIZE)
	pea.l	LCD_MEM
	move.l	oscreen(pc),-(a7)
	call	memcpy			; save the screen
	lea.l	12(a7),a7

	lea.l	txtpresent(pc),a0
	moveq	#90,d0			; Y
	moveq	#2,d1			; Pixels Scrolled Per Frame
	bsr	InitScroll

	bsr	Loading			; a fait toujours bien un Loading :) sauf que la il sert  quelque chose :D
	bsr	MakeStarField		; Fast Init (pas besoin de faire une barre de chargement)
	bsr	MakeCube
	bsr	MakeTube

	bsr	Init3D

;**************************************************************	

	bsr	GetContrast
	bsr	CompleteFadeOutClear

;**************************************************************	

;**************************************************************	

IntroL:	bsr	FadeIn
	bsr	Clear

	move.w	#1,k			; Empeche le morphing 3D

	bsr	do3D
	bsr	doTunnel
	bsr	doScroll

	bsr	Flip

	tst.w	scrollend		; end of the scroll ?
	beq.s	outI
	bsr	CheckESC
	beq.s	IntroL

outI:	bsr	CompleteFadeOutClear
	bsr	doTitle
	bsr	CompleteFadeOutClear

	lea.l	txtplasma(pc),a0
	moveq	#90,d0			; Y
	moveq	#4,d1			; Pixels Scrolled Per Frame
	bsr	InitScroll

PlasmL:	bsr	FadeIn
	bsr	Clear

	bsr	doPlasma
	bsr	doScroll

	bsr	Flip

	tst.w	scrollend		; end of the scroll ?
	beq.s	outP
	bsr	CheckESC
	beq.s	PlasmL

outP:	bsr	CompleteFadeOutClear

	lea.l	txtthanks(pc),a0
	moveq	#10,d0			; Y
	moveq	#2,d1			; Pixels Scrolled Per Frame
	bsr	InitScroll
	bsr	Init3D

d3DL:	bsr	FadeIn
	bsr	Clear

	bsr	do3D
	bsr	doScroll

	bsr	Flip

	tst.w	scrollend		; end of the scroll ?
	beq.s	out3
	bsr	CheckESC
	beq.s	d3DL

out3:	bsr	CompleteFadeOutClear

;**************************************************************	

	pea.l	3840			; memcpy(LCD_MEM,oscreen,LCD_SIZE)
	move.l	oscreen(pc),-(a7)
	pea.l	LCD_MEM
	call	memcpy
	lea.l	12(a7),a7
	move.l	oscreen(pc),-(a7)	; free(oscreen)
	call	HeapFreePtr
	addq.l	#4,a7
	pea.l	byebyemsg(pc)
	bra.s	dixit
nomem:	pea.l	nomemmsg(pc)
dixit:	call	ST_helpMsg
	addq.l	#4,a7

FinalFI	bsr.s	Tempo
	bsr.s	FadeIn
	cmp.w	CurrentContrast,d3
	bne.s	FinalFI

	movem.l	(a7)+,d0-d7/a0-a6	; Pop Regs

	rts

;******************************
;* Utils
;******************************

Tempo:	moveq	#-1,d4
Twait:	dbra	d4,Twait
	rts

FadeIn:
	move.w	ValeurContrast(pc),d3
	cmp.w	CurrentContrast,d3
	beq.s	adiosFI
	addq.w	#1,CurrentContrast
	call	OSContrastUp
adiosFI	rts

GetContrast:
	moveq	#4,d0
	trap	#9
	move.w	d0,ValeurContrast
	move.w	d0,CurrentContrast
	rts

FadeOut:
	move.w	CurrentContrast(pc),d3
	tst.w	d3
	beq.s	adiosFO
	subq.w	#1,CurrentContrast
	call	OSContrastDn
adiosFO	rts

CompleteFadeOutClear:
	bsr	Tempo
	bsr	FadeOut
	tst.w	d3
	bne.s	CompleteFadeOutClear
	call	ScreenClear
	rts

CheckESC:
	move.w	#-65,-(a7)		; while(!_keytest(RR_ESC))
	bsr	_rowread
	addq.l	#2,a7
	andi.w	#1,d0
	rts

Flip:	pea.l	3840			; memcpy(LCD_MEM,myscreen,LCD_SIZE);
	move.l	myscreen(pc),-(a7)
	move.l	#LCD_MEM,-(a7)
	call	memcpy
	lea.l	12(a7),a7
	rts

Clear:	pea.l	3840			; Size
	clr.w	-(a7)			; Clear
	move.l	myscreen(pc),-(a7)	; Buffer
	call	memset
	lea.l	10(a7),a7
	rts

;******************************

	include	"Scroll.asm"
	include	"Plasma.asm"
	include	"MyPix.asm"
	include	"Mini3D.asm"
	include	"Init.asm"
	include	"wormcirc.asm"
	include	"title.asm"

;*****************

		even
txtplasma	dc.b	"First PLASMA Effect ever made on TI :)                    ",0
		even
txtthanks	dc.b	"Thanks goes to: sBibi, Liquid, Vertyos, Vark, Kevin Kofler, PpHd, yAro and Sasume..."
		dc.b	"                    ",0
		even
txtpresent	dc.b	"Orion_ is proud to present a >3,2Ko< Intro for TI89, called...                    ",0
		even
let:	dc.b	"EGNEVER",0		; et ben quoi ? verlan pawa =)
		even

;******************************

nomemmsg:	dc.b	"Not enough memory :(",0
		even
byebyemsg:	dc.b	"Revenge by Orion_ [2003]",0
		even

;****************************** On regroupe toutes les vars ici pour optimiser en place lors de la compression :)
; ** System Vars **
		even
oscreen:	dc.l	0		; Original Screen Save Pointer
myscreen:	dc.l	0
scrollbuffer:	dc.l	0
CosT:		dc.l	0
SinT:		dc.l	0
SinTab:		dc.l	0
objdata:	dc.l	0
objdata1:	dc.l	0
objdata2:	dc.l	0
ValeurContrast	dc.w	0
CurrentContrast	dc.w	0

; ** Scroll Vars **

scrolly:	dc.l	0	; 0
nofpix:		dc.l	0	; 4
currenttext:	dc.l	0	; 8
posintext:	dc.w	0	; 12
eightcnt:	dc.b	0	; 14
cntmax:		dc.b	0	; 15
scrollend:	dc.w	0	; 16

; ** Tunnel/Intro Name Vars **
dtc:		dc.w	0
f:		dc.l	0
SRECT:		dc.b	0, 0, 159, 99

; ** Plasma Vars **

sty:	dc.w	0
sins:	dc.w	0

; ** 3DEngine Vars **

rX:		dc.w	0	; 0
rY:		dc.w	0	; 2
rZ:		dc.w	0	; 4
dX:		dc.w	0	; 6
dY:		dc.w	0	; 8
dZ:		dc.w	0	; 10
nvertex:	dc.w	0	; 12
nvertex1:	dc.w	216	; 14
nvertex2:	dc.w	192	; 16
k:		dc.w	0	; 18
mode:		dc.w	0	; 20
cosX:		dc.l	0
sinX:		dc.l	0
cosY:		dc.l	0
sinY:		dc.l	0
cosZ:		dc.l	0
sinZ:		dc.l	0
sinYcosX:	dc.l	0
sinYsinX:	dc.l	0
m11:		dc.l	0
m12:		dc.l	0
m13:		dc.l	0
m21:		dc.l	0
m22:		dc.l	0
m23:		dc.l	0
m31:		dc.l	0
m32:		dc.l	0
m33:		dc.l	0
x:		dc.l	0
y:		dc.l	0
xe:		dc.l	0
ye:		dc.l	0
ze:		dc.l	0
