
#ifndef _VDP_H_
#define _VDP_H_

/* VDP1 memory and registers */
#define VDP1_VRAM   0x25C00000
#define VDP1_FB     0x25C80000
#define TVMR        (*(vuint16 *)0x25D00000)
#define FBCR        (*(vuint16 *)0x25D00002)
#define PTMR        (*(vuint16 *)0x25D00004)
#define EWDR        (*(vuint16 *)0x25D00006)
#define EWLR        (*(vuint16 *)0x25D00008)
#define EWRR        (*(vuint16 *)0x25D0000A)
#define ENDR        (*(vuint16 *)0x25D0000C)
//

#define EDSR        (*(vuint16 *)0x25D00010)
#define LOPR        (*(vuint16 *)0x25D00012)
#define COPR        (*(vuint16 *)0x25D00014)
#define MODR        (*(vuint16 *)0x25D00016)
//
//
//
//

/* VDP2 memory and registers */
#define VDP2_VRAM   0x25E00000
#define VDP2_CRAM   0x25F00000
#define VDP2_REG    0x25F80000

#define TVMD        (*(vuint16 *)0x25F80000)
#define EXTEN       (*(vuint16 *)0x25F80002)
#define TVSTAT      (*(vuint16 *)0x25F80004)
#define VRSIZE      (*(vuint16 *)0x25F80006)
#define HCNT        (*(vuint16 *)0x25F80008)
#define VCNT        (*(vuint16 *)0x25F8000A)
//
#define RAMCTL      (*(vuint16 *)0x25F8000E)

#define CYCA0L      (*(vuint16 *)0x25F80010)
#define CYCA0U      (*(vuint16 *)0x25F80012)
#define CYCA1L      (*(vuint16 *)0x25F80014)
#define CYCA1U      (*(vuint16 *)0x25F80016)
#define CYCB0L      (*(vuint16 *)0x25F80018)
#define CYCB0U      (*(vuint16 *)0x25F8001A)
#define CYCB1L      (*(vuint16 *)0x25F8001C)
#define CYCB1U      (*(vuint16 *)0x25F8001E)

#define BGON        (*(vuint16 *)0x25F80020)
#define MZCTL       (*(vuint16 *)0x25F80022)
#define SFSEL       (*(vuint16 *)0x25F80024)
#define SFCODE      (*(vuint16 *)0x25F80026)
#define CHCTLA      (*(vuint16 *)0x25F80028)
#define CHCTLB      (*(vuint16 *)0x25F8002A)
#define BMPNA       (*(vuint16 *)0x25F8002C)
#define BMPNB       (*(vuint16 *)0x25F8002E)

#define PNCN0       (*(vuint16 *)0x25F80030)
#define PNCN1       (*(vuint16 *)0x25F80032)
#define PNCN2       (*(vuint16 *)0x25F80034)
#define PNCN3       (*(vuint16 *)0x25F80036)
#define PNCR        (*(vuint16 *)0x25F80038)
#define PLSZ        (*(vuint16 *)0x25F8003A)
#define MPOFN       (*(vuint16 *)0x25F8003C)
#define MPOFR       (*(vuint16 *)0x25F8003E)

#define MPABN0      (*(vuint16 *)0x25F80040)
#define MPCDN0      (*(vuint16 *)0x25F80042)
#define MPABN1      (*(vuint16 *)0x25F80044)
#define MPCDN1      (*(vuint16 *)0x25F80046)
#define MPABN2      (*(vuint16 *)0x25F80048)
#define MPCDN2      (*(vuint16 *)0x25F8004A)
#define MPABN3      (*(vuint16 *)0x25F8004C)
#define MPCDN3      (*(vuint16 *)0x25F8004E)

#define MPABRA      (*(vuint16 *)0x25F80050)
#define MPCDRA      (*(vuint16 *)0x25F80052)
#define MPEFRA      (*(vuint16 *)0x25F80054)
#define MPGHRA      (*(vuint16 *)0x25F80056)
#define MPIJRA      (*(vuint16 *)0x25F80058)
#define MPKLRA      (*(vuint16 *)0x25F8005A)
#define MPMNRA      (*(vuint16 *)0x25F8005C)
#define MPOPRA      (*(vuint16 *)0x25F8005E)

#define MPABRB      (*(vuint16 *)0x25F80060)
#define MPCDRB      (*(vuint16 *)0x25F80062)
#define MPEFRB      (*(vuint16 *)0x25F80064)
#define MPGHRB      (*(vuint16 *)0x25F80066)
#define MPIJRB      (*(vuint16 *)0x25F80068)
#define MPKLRB      (*(vuint16 *)0x25F8006A)
#define MPMNRB      (*(vuint16 *)0x25F8006C)
#define MPOPRB      (*(vuint16 *)0x25F8006E)

#define SCXIN0      (*(vuint16 *)0x25F80070)
#define SCXDN0      (*(vuint16 *)0x25F80072)
#define SCYIN0      (*(vuint16 *)0x25F80074)
#define SCYDN0      (*(vuint16 *)0x25F80076)
#define ZMXIN0      (*(vuint16 *)0x25F80078)
#define ZMXDN0      (*(vuint16 *)0x25F8007A)
#define ZMYIN0      (*(vuint16 *)0x25F8007C)
#define ZMYDN0      (*(vuint16 *)0x25F8007E)

#define SCXIN1      (*(vuint16 *)0x25F80080)
#define SCXDN1      (*(vuint16 *)0x25F80082)
#define SCYIN1      (*(vuint16 *)0x25F80084)
#define SCYDN1      (*(vuint16 *)0x25F80086)
#define ZMXIN1      (*(vuint16 *)0x25F80088)
#define ZMXDN1      (*(vuint16 *)0x25F8008A)
#define ZMYIN1      (*(vuint16 *)0x25F8008C)
#define ZMYDN1      (*(vuint16 *)0x25F8008E)

#define SCXN2       (*(vuint16 *)0x25F80090)
#define SCYN2       (*(vuint16 *)0x25F80092)
#define SCXN3       (*(vuint16 *)0x25F80094)
#define SCYN3       (*(vuint16 *)0x25F80096)
#define ZMCTL       (*(vuint16 *)0x25F80098)
#define SCRCTL      (*(vuint16 *)0x25F8009A)
#define VCSTAU      (*(vuint16 *)0x25F8009C)
#define VCSTAL      (*(vuint16 *)0x25F8009E)

#define LSTA0U      (*(vuint16 *)0x25F800A0)
#define LSTA0L      (*(vuint16 *)0x25F800A2)
#define LSTA1U      (*(vuint16 *)0x25F800A4)
#define LSTA1L      (*(vuint16 *)0x25F800A6)
#define LCTAU       (*(vuint16 *)0x25F800A8)
#define LCTAL       (*(vuint16 *)0x25F800AA)
#define BKTAU       (*(vuint16 *)0x25F800AC)
#define BKTAL       (*(vuint16 *)0x25F800AE)

#define RPMD        (*(vuint16 *)0x25F800B0)
#define RPRCTL      (*(vuint16 *)0x25F800B2)
#define KTCTL       (*(vuint16 *)0x25F800B4)
#define KTAOF       (*(vuint16 *)0x25F800B6)
#define OVPNRA      (*(vuint16 *)0x25F800B8)
#define OVPNRB      (*(vuint16 *)0x25F800BA)
#define RPTAU       (*(vuint16 *)0x25F800BC)
#define RPTAL       (*(vuint16 *)0x25F800BE)

#define WPSX0       (*(vuint16 *)0x25F800C0)
#define WPSY0       (*(vuint16 *)0x25F800C2)
#define WPEX0       (*(vuint16 *)0x25F800C4)
#define WPEY0       (*(vuint16 *)0x25F800C6)
#define WPSX1       (*(vuint16 *)0x25F800C8)
#define WPSY1       (*(vuint16 *)0x25F800CA)
#define WPEX1       (*(vuint16 *)0x25F800CC)
#define WPEY1       (*(vuint16 *)0x25F800CE)

#define WCTLA       (*(vuint16 *)0x25F800D0)
#define WCTLB       (*(vuint16 *)0x25F800D2)
#define WCTLC       (*(vuint16 *)0x25F800D4)
#define WCTLD       (*(vuint16 *)0x25F800D6)
#define LWTA0U      (*(vuint16 *)0x25F800D8)
#define LWTA0L      (*(vuint16 *)0x25F800DA)
#define LWTA1U      (*(vuint16 *)0x25F800DC)
#define LWTA1L      (*(vuint16 *)0x25F800DE)

#define SPCTL       (*(vuint16 *)0x25F800E0)
#define SDCTL       (*(vuint16 *)0x25F800E2)
#define CRAOFA      (*(vuint16 *)0x25F800E4)
#define CRAOFB      (*(vuint16 *)0x25F800E6)
#define LNCLEN      (*(vuint16 *)0x25F800E8)
#define SFPRMD      (*(vuint16 *)0x25F800EA)
#define CCCTL       (*(vuint16 *)0x25F800EC)
#define SFCCMD      (*(vuint16 *)0x25F800EE)

#define PRISA       (*(vuint16 *)0x25F800F0)
#define PRISB       (*(vuint16 *)0x25F800F2)
#define PRISC       (*(vuint16 *)0x25F800F4)
#define PRISD       (*(vuint16 *)0x25F800F6)
#define PRINA       (*(vuint16 *)0x25F800F8)
#define PRINB       (*(vuint16 *)0x25F800FA)
#define PRIR        (*(vuint16 *)0x25F800FC)
#define RESERVE     (*(vuint16 *)0x25F800FE)

#define CCRSA       (*(vuint16 *)0x25F80100)
#define CCRSB       (*(vuint16 *)0x25F80102)
#define CCRSC       (*(vuint16 *)0x25F80104)
#define CCRSD       (*(vuint16 *)0x25F80106)
#define CCRNA       (*(vuint16 *)0x25F80108)
#define CCRNB       (*(vuint16 *)0x25F8010A)
#define CCRR        (*(vuint16 *)0x25F8010C)
#define CCRLB       (*(vuint16 *)0x25F8010E)

#define CLOFEN      (*(vuint16 *)0x25F80110)
#define CLOFSL      (*(vuint16 *)0x25F80112)
#define COAR        (*(vuint16 *)0x25F80114)
#define COAG        (*(vuint16 *)0x25F80116)
#define COAB        (*(vuint16 *)0x25F80118)
#define COBR        (*(vuint16 *)0x25F8011A)
#define COBG        (*(vuint16 *)0x25F8011C)
#define COBB        (*(vuint16 *)0x25F8011E)

/* Global data */
extern vuint16 *vdp1_vram;
extern vuint16 *vdp1_fb;
extern vuint16 *vdp2_vram;
extern vuint16 *vdp2_cram;

/* Function prototypes */
void vdp_init(void);
void vdp_shutdown();
void wait_hblank(void);
void wait_hblank_in(void);
void wait_hblank_out(void);
void wait_vblank_in(void);
void wait_vblank_out(void);
void wait_vblank(void);

#endif /* _VDP_H_ */

