
#include "shared.h"
#include "vga_font.h"
#include "vga_pal.h"

static char hextable[16] = {"0123456789ABCDEF"};

void conio_init(void)
{
    int i;
    for(i = 0; i < 256; i++)
        vdp2_cram[i] = vga_pal[i];

    vdp2_cram[0] = vdp2_cram[1];
    vdp2_cram[1] = 0x10 << 10;
}

void _printchar(int x, int y, uint8 color, char v)
{
    int r, c;
    vuint8 *bmp = (vuint8 *)VDP2_VRAM;
    uint8 fg = (color >> 4) & 0x0F;
    uint8 bg = (color >> 0) & 0x0F;

    for(r = 0; r < 8; r++)
    {
        uint8 b = font[v<<3|r];
        for(c = 0; c < 8; c++)
        {
            uint8 d = (b & (0x80 >> c)) ? fg : bg;
            bmp[((y<<3|r)<<10)+(x<<3|c)] = d;
        }            
    }
}

void _printf(int x, int y, uint8 color, char *s)
{
    int i;
    for(i = 0; s[i] != 0; i++)
        _printchar(x+i,y,color,s[i]);
}

void _printhexd(int x, int y, uint8 color,uint8 v)
{
    _printchar(x,y,color,hextable[v&0x0F]);
}

void _printhexb(int x, int y, uint8 color,uint8 v)
{
    _printchar(x+0,y,color,hextable[(v>>4)&0x0F]);
    _printchar(x+1,y,color,hextable[v & 0x0F]);
}

void _printhexw(int x, int y, uint8 color,uint16 v)
{
    _printchar(x+0,y,color,hextable[(v>>12)&0x0F]);
    _printchar(x+1,y,color,hextable[(v>>8)&0x0F]);
    _printchar(x+2,y,color,hextable[(v>>4)&0x0F]);
    _printchar(x+3,y,color,hextable[v & 0x0F]);
}

void _printhexl(int x, int y, uint8 color,uint32 v)
{
    _printchar(x+0,y,color,hextable[(v>>28)&0x0F]);
    _printchar(x+1,y,color,hextable[(v>>24)&0x0F]);
    _printchar(x+2,y,color,hextable[(v>>20)&0x0F]);
    _printchar(x+3,y,color,hextable[(v>>16)&0x0F]);
    _printchar(x+4,y,color,hextable[(v>>12)&0x0F]);
    _printchar(x+5,y,color,hextable[(v>>8)&0x0F]);
    _printchar(x+6,y,color,hextable[(v>>4)&0x0F]);
    _printchar(x+7,y,color,hextable[v & 0x0F]);
}

