; VGM (SN76489) player for the HuC6280
; /Mic, 2010
; 
; Assemble with wla-dx


.memorymap
        defaultslot 0
        slotsize $2000
        slot 0 $0000
        slot 1 $2000
        slot 2 $4000
        slot 3 $6000
        slot 4 $8000
        slot 5 $A000
        slot 6 $C000
        slot 7 $E000
.endme

.rombankmap
        bankstotal 8
        banksize $2000
        banks 8
.endro


.DEFINE VDC_CTRL			$0000
.DEFINE VDC_DATA_L			$0002
.DEFINE VDC_DATA_H			$0003

.DEFINE VCE_INDEX_L			$0402
.DEFINE VCE_INDEX_H			$0403
.DEFINE VCE_DATA_L			$0404
.DEFINE VCE_DATA_H			$0405

.DEFINE PSG_CHANNEL_SELECT	$0800
.DEFINE PSG_GLOBAL_BALANCE	$0801
.DEFINE PSG_FREQ_FINE		$0802
.DEFINE PSG_FREQ_COARSE		$0803
.DEFINE PSG_CHANNEL_CTRL	$0804
.DEFINE PSG_CHANNEL_BALANCE $0805
.DEFINE PSG_CHANNEL_WAVE	$0806
.DEFINE PSG_NOISE_CTRL		$0807
.DEFINE PSG_LFO_FREQ		$0808
.DEFINE PSG_LFO_CTRL		$0809

.DEFINE TIMER_COUNTER		$0C00
.DEFINE TIMER_CTRL			$0C01

.DEFINE INTERRUPT_CTRL		$1402
.DEFINE INTERRUPT_STATUS	$1403


.DEFINE SONG_LOCATION		$6000


.enum $2000
VGM_PTR		ds 2
TONE0_LATCH	ds 2
TONE1_LATCH	ds 2
TONE2_LATCH	ds 2
NOISE_LATCH	ds 2
VOL0_LATCH	ds 2
VOL1_LATCH	ds 2
VOL2_LATCH	ds 2

VOL3_LATCH	ds 2	; $10
LATCHED_REG	ds 1	; $12
TEMP		ds 1	; $13
TEMP2		ds 1	; $14
DELAY		ds 2	; $20
TEMP3		ds 1	; $17
TEMP4		ds 1	; $18
TEMP5		ds 1	; $19
WAIT_TIMER	ds 1
SONG_BANK	ds 1
.ende


.macro INCW
	inc	<\1
	bne	+
	inc	<\1+1
	+:
.endm


.macro PUTSXY
	lda	#<++
	sta	<TEMP
	lda	#>++
	sta	<TEMP+1
	lda	#<(\3 * 32 + \2)
	sta	<TEMP3
	lda	#>(\3 * 32 + \2)
	sta	<TEMP3+1
 	bra +++
 	++:
 	.db \1,0
 	+++:
 	jsr	puts
 .endm


.org $0000
.dw 0


; Interrupt vectors
.org $1FF6

 .dw vdc_irq                    
 .dw vdc_irq                   
 .dw timer_irq               
 .dw vdc_irq               
 .dw start     


 
.bank 0 slot 7
.org $0000
.section "text"

.include "aplib_decrunch_huc6280.asm"

start:
    sei                               
    csh  							; switch the CPU to high speed mode                             
    cld                               
    ldx    	#$FF                       
    txs
    
    lda		#$FF
    tam		#$01
    lda		#$F8
    tam		#$02
    lda		#$01
    tam		#$04
    lda		#$02
    tam		#$08
    lda		#$03
    tam		#$10
    lda		#$04
    tam		#$20
    lda		#$05
    tam		#$40
    lda		#$00
    tam		#$80
    
    stz    	$2000                	; clear all the RAM
    tii    	$2000,$2001,$1FFF
    
	lda		#$FF
	sta		PSG_GLOBAL_BALANCE
	lda		#$80
	sta		PSG_LFO_CTRL			; LFO off
	
	lda		#<square_wave_50
	sta		<TEMP
	lda		#>square_wave_50
	sta		<TEMP+1

	; Setup channel 0 (Tone0)
	lda		#0
	sta		PSG_CHANNEL_SELECT
	jsr		load_waveform
	lda		#$FF
	sta		PSG_CHANNEL_BALANCE
	
	; Disable channel 1
	lda		#1
	sta		PSG_CHANNEL_SELECT
	stz		PSG_CHANNEL_CTRL
	
	; Setup channel 2 (Tone1)
	lda		#2
	sta		PSG_CHANNEL_SELECT
	jsr		load_waveform
	lda		#$FF
	sta		PSG_CHANNEL_BALANCE	

	; Setup channel 3 (Tone2)
	lda		#3
	sta		PSG_CHANNEL_SELECT
	jsr		load_waveform
	lda		#$FF
	sta		PSG_CHANNEL_BALANCE	

	; Setup channel 4 (Noise)
	lda		#<square_wave_12_5
	sta		<TEMP
	lda		#>square_wave_12_5
	sta		<TEMP+1
	lda		#4
	sta		PSG_CHANNEL_SELECT
	jsr		load_waveform
	lda		#$FF
	sta		PSG_CHANNEL_BALANCE	

	; Disable channel 5
	lda		#5
	sta		PSG_CHANNEL_SELECT
	stz		PSG_CHANNEL_CTRL
	
	; Setup VDC registers	
	clx
-:
	lda.w	vdc_reg_values,x
	cmp		#$FF
	beq		+
	sta.w	VDC_CTRL
	inx
	lda.w	vdc_reg_values,x
	sta.w	VDC_DATA_L
	inx
	lda.w	vdc_reg_values,x
	sta.w	VDC_DATA_H
	inx
	bra		-
+:

	; Load font tiles
	lda		#<font
	sta		<APLIB_SRC
	lda		#>font
	sta		<APLIB_SRC+1
	lda		#$00
	sta		<APLIB_DEST
	lda		#$24
	sta		<APLIB_DEST+1
	jsr		aplib_decrunch
	st0		#0
	st1		#0
	st2		#4
	st0		#2
	tia		$2400,VDC_DATA_L,112*32

	; Set colors
	cla	
	sta		VCE_INDEX_L
	sta		VCE_INDEX_H
	sta		VCE_DATA_L
	sta		VCE_DATA_H
	lda		#$FC
	sta		VCE_DATA_L
	lda		#$01
	sta		VCE_DATA_H
	
	; Clear the screen
	st0		#0
	st1		#0
	st2		#0
	st0		#2
	ldy		#4
-:
	clx
--:
	st1		#0
	st2		#0
	dex
	bne		--
	dey
	bne		-


	lda		#<(SONG_LOCATION+64)
	sta		<VGM_PTR
	lda		#>(SONG_LOCATION+64)
	sta		<VGM_PTR+1
	
	lda		#2
	sta		<SONG_BANK

	PUTSXY	"HuVGM",13,2
	PUTSXY 	"By Mic, 2010",10,3
	
	; These strings are modified by VGM2HES; hence the padding.
	PUTSXY	"Title Screen                ",2,6
	PUTSXY	"Chuck Rock                  ",2,7
	PUTSXY	"Matt Furniss/Matt Simmonds  ",2,8

	; Enable the background
	st0		#5
	st1		#$80
	st2		#0
	
	cli
	
play:
	lda		(<VGM_PTR)
	INCW	VGM_PTR

	sta		<TEMP			; save the command byte
	and		#$F0
	cmp		#$70			; first check if it's a short wait command since we want the lowest latency in processing them
	beq		short_wait
	
	lda		<TEMP	
	cmp		#$50			
	bne		+
	jsr		psg_param
	bra		play
+:
	cmp		#$4B			; bank switch
	bne		+
	jmp		bank_switch
+:
	cmp		#$66			; loop
	bne		+
	jmp		loop_song
+:
	cmp		#$4F			; set gamegear stereo parameter
	beq		gg_stereo_param
	cmp		#$62			; wait one ntsc frame (1/60 s)
	beq		wait_frame_ntsc
	cmp		#$63			; wait one pal frame (1/50 s)
	bne		+
	jmp		wait_frame_pal
+:
	cmp		#$67
	bne		+
+:
	cmp		#$61			; wait xxyy samples
	bne		+
	jmp		long_wait
+:
	; All other commands are unhandled and assumed to be 3 bytes long
	INCW	VGM_PTR
	INCW	VGM_PTR
	bra		play


; Wait n/44100 s  (n = [1..16])
; For n==1 this routine takes 162 cycles (~1/44192 s with the CPU running at ~7209090 Hz)
; For n==2 this routine takes 336 cycles (~2/42613 s)
; For n==16 this routine takes 2590 cycles (~16/44226 s)
short_wait:
	lda		<TEMP	; 4 
	and		#$F		; 2
short_wait_2:
	tax				; 2 
	bne		+		; 3|2
-:
	ldy		#29		; 2 
--:
	dey				; 2 
	bne		--		; 3|2 
	dex				; 2 
	bpl		-		; 3|2 
	bra		play	; 2 
+:
-:
	ldy		#31		; 2 
--:
	dey				; 2 
	bne		--		; 3|2 
	dex				; 2 
	bpl		-		; 3|2 
	jmp		play	; 4 
	


; Wait 1/60 s
wait_frame_ntsc:
	lda		#118 				; 6992 / 60
	sta		TIMER_COUNTER
	lda		#1
	sta		TIMER_CTRL
	lda		#$F9
	sta		INTERRUPT_CTRL		; disable all interrupts except TIMER and VDC
	lda		#1
	sta		<WAIT_TIMER
-:
	lda		<WAIT_TIMER			; the timer_irq routine clears this variable when the timer underflows
	bne		-
	jmp		play
	

; GG stereo is currently ignored
gg_stereo_param:
	INCW	VGM_PTR
	jmp		play
	
	
; Wait 1/50 s
wait_frame_pal:
	lda		#127				
	sta		TIMER_COUNTER
	lda		#1
	sta		TIMER_CTRL
	lda		#$F9
	sta		INTERRUPT_CTRL		; disable all interrupts except TIMER and VDC
	lda		#1
	sta		<WAIT_TIMER
-:
	lda		<WAIT_TIMER
	bne		-
	lda		#12					; 127 + 12 = 139 = 6992 / 50				
	sta		TIMER_COUNTER
	lda		#1
	sta		TIMER_CTRL
	lda		#$F9
	sta		INTERRUPT_CTRL		; disable all interrupts except TIMER and VDC
	lda		#1
	sta		<WAIT_TIMER
-:
	lda		<WAIT_TIMER
	bne		-
	jmp		play
	

; Wait 256 VGM frames (256/44100 s)
wait_256_frames:
	lda		#40 	 ;40			
	sta		TIMER_COUNTER
	lda		#1
	sta		TIMER_CTRL
	lda		#$F9
	sta		INTERRUPT_CTRL		; disable all interrupts except TIMER and VDC
	lda		#1
	sta		<WAIT_TIMER
-:
	lda		<WAIT_TIMER
	bne		-
	rts


long_wait:
	lda		(<VGM_PTR)
	sta		<DELAY
	INCW	VGM_PTR
	lda		(<VGM_PTR)
	sta		<DELAY+1
	INCW	VGM_PTR
long_wait_loop:
	lda		<DELAY+1
	beq		long_wait_loop_2
	jsr		wait_256_frames
	dec		<DELAY+1
	bra		long_wait_loop
long_wait_loop_2:
	lda		<DELAY
	cmp		#$10
	bcs		+
	and		#$0F
	beq		long_wait_done
	dea
	jmp		short_wait_2
+:
	lda		<DELAY
	sec
	sbc		#$10
	sta		<DELAY
	ldx		#$0F
-:
	ldy		#31		; 2 
--:
	dey				; 2 
	bne		--		; 3|2 
	dex				; 2 
	bpl		-		; 3|2 
	bra		long_wait_loop_2
long_wait_done:
	jmp		play
	
	
; A value is being written to the PSG	
psg_param:
	lda		(<VGM_PTR)		; read the parameter byte
	INCW	VGM_PTR
	sta		<TEMP
	bbs7	<TEMP,latch_data
	lda		<LATCHED_REG
	cmp		#6
	bcs		+
	; Set high 6 bits of tone register
	tax
	lda		<TEMP
	asl		a
	asl		a
	asl		a
	asl		a
	and		#$F0
	sta		<TEMP2
	lda		<TONE0_LATCH,x
	and		#$F					; save bits 0-3
	ora		<TEMP2				; replace bits 4-7 of the tone period with bits 0-3 of the parameter byte
	sta		<TONE0_LATCH,x
	lda		<TEMP
	lsr		a
	lsr		a
	lsr		a
	lsr		a
	and		#3
	sta		<TONE0_LATCH+1,x	; set bits 8-9 of the tone period to bits 4-5 of the parameter byte
	jmp		tone_reg_updated	; the tone register has been updated, so we should update the channels frequency on the S-DSP
+:
	tax
	lda		<TEMP
	and		#$F
	sta		<TONE0_LATCH,x
check_vol_noise:
	bbs3	<LATCHED_REG,volume_reg_updated
	jmp		noise_reg_updated
latch_data:
	lda		<TEMP
	lsr		a
	lsr		a
	lsr		a
	lsr		a
	and		#$7
	sta		<TEMP2
	lsr		a
	tax
	lda		<TEMP2
	and		#1
	asl		a
	asl		a
	stx		<TEMP2
	ora		<TEMP2
	asl		a
	sta		<LATCHED_REG
	tax
	lda		<TEMP
	and		#$F
	sta		<TEMP
	lda		<TONE0_LATCH,x
	and		#$F0
	ora		<TEMP
	sta		<TONE0_LATCH,x
	lda		<LATCHED_REG
	cmp		#6
	bcs		check_vol_noise
	bra		tone_reg_updated
	

volume_reg_updated:
	ldx		<LATCHED_REG
	lda		<TONE0_LATCH,x
	eor		#$0F
	ora		#$90
	tay
	lda		<LATCHED_REG
	lsr		a
	and		#3
	beq		+
	ina
+:
	sta		PSG_CHANNEL_SELECT
	sty		PSG_CHANNEL_CTRL
	rts	
	
	
; TODO: Handle constant output (psgPeriod <= 1)
tone_reg_updated:
	lda		<LATCHED_REG
	lsr		a
	and		#3
	beq		+
	ina
+:
	sta		PSG_CHANNEL_SELECT

	ldx		<LATCHED_REG
	lda		<TONE0_LATCH,x
	sta		<TEMP
	lda		<TONE0_LATCH+1,x
	sta		<TEMP+1
	; Multiply period by 4
	asl		<TEMP
	rol		<TEMP+1
	asl		<TEMP
	rol		<TEMP+1
	lda		<TEMP
	sta		PSG_FREQ_FINE
	lda		<TEMP+1
	sta		PSG_FREQ_COARSE

	; If tone2 was updated and the noise channel is set to "periodic noise" with tone2 as the driving signal, then we
	; need to update channel 3 as well.
	lda		<LATCHED_REG
	cmp		#4
	bne		+
	lda		<NOISE_LATCH
	cmp		#3
	bne		+
	jmp		periodic_noise
+:
	rts


noise_reg_updated:
	lda		#4
	sta		PSG_CHANNEL_SELECT

	bbr2	<NOISE_LATCH,periodic_noise

	lda		<NOISE_LATCH
	and		#3
	cmp		#3
	beq		+
	eor		#3
	asl		a
	asl		a
	asl		a
	ora		#$80
	sta		PSG_NOISE_CTRL
	rts
+:
	lda		<TONE2_LATCH
	sta		<TEMP
	lda		<TONE2_LATCH+1
	rol		<TEMP
	rol		a
	rol		<TEMP
	rol		a
	rol		<TEMP
	rol		a
	and		#$1F
	ora		#$80
	sta		PSG_NOISE_CTRL
	rts

; "Periodic noise" with tone2's period as the counter reload value
-:
	lda		<TONE2_LATCH
	sta		<TEMP
	lda		<TONE2_LATCH+1
	sta		<TEMP+1
	; Multiply period by 16
	asl		<TEMP
	rol		<TEMP+1
	asl		<TEMP
	rol		<TEMP+1
	asl		<TEMP
	rol		<TEMP+1
	lda		<TEMP
	rol		<TEMP+1
	lda		<TEMP
	sta		PSG_FREQ_FINE
	lda		<TEMP+1
	sta		PSG_FREQ_COARSE
	rts	
periodic_noise:
	stz		PSG_NOISE_CTRL
	lda		<NOISE_LATCH
	and		#3
	cmp		#3
	beq		-
	asl		a
	tax
	lda.w	per_noise_table,x
	sta		PSG_FREQ_FINE
	lda.w	per_noise_table+1,x
	sta		PSG_FREQ_COARSE
	rts	
	

; Restart from the song's loop point	
loop_song:
	; Reset banks 3,4,5,6
	lda		#2
	sta		<SONG_BANK
    tam    	#$08
    ina
    tam    	#$10
    ina
    tam    	#$20
    ina
    tam    	#$40
	lda		#<(SONG_LOCATION+28)
	clc
	adc.w	SONG_LOCATION+28
	sta		<VGM_PTR
	lda		#>(SONG_LOCATION+28)
	adc.w	SONG_LOCATION+29
	sta		<VGM_PTR+1
	jmp		play
	

; Switch in the next 32kB of the song
bank_switch:
	lda		<SONG_BANK
	clc
	adc		#4
	sta		<SONG_BANK
    tam    	#$08
    ina
    tam    	#$10
    ina
    tam    	#$20
    ina
    tam    	#$40
	lda		#<SONG_LOCATION
	sta		<VGM_PTR
	lda		#>SONG_LOCATION
	sta		<VGM_PTR+1
	jmp		play
	

; TEMP points to the 32-byte waveform
load_waveform:
	lda		#$40
	sta		PSG_CHANNEL_CTRL	; reset waveform position
	stz		PSG_CHANNEL_CTRL	; set waveform write mode
	cly
-:
	lda		(<TEMP),y
	sta		PSG_CHANNEL_WAVE
	iny
	cpy		#32
	bne		-
	rts



timer_irq:
	stz		INTERRUPT_STATUS	; acknowledge interrupt
	stz		TIMER_CTRL
	stz		<WAIT_TIMER
	rti


vdc_irq:
	rti



puts:
	st0		#0
	lda		<TEMP3
	sta.w	VDC_DATA_L
	lda		<TEMP3+1
	sta.w	VDC_DATA_H
	st0		#2
	cly
-:
	lda		(<TEMP),y
	beq		+
	clc
	adc		#32
	sta.w	VDC_DATA_L
	st2		#0
	iny
	bra		-
+:
	rts
	

; 12.5% square wave
square_wave_12_5:
.db 20,20,20,20,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0

; 50% square wave
square_wave_50:
.db 20,20,20,20,0,0,0,0, 20,20,20,20,0,0,0,0, 20,20,20,20,0,0,0,0, 20,20,20,20,0,0,0,0

per_noise_table:
.dw 136, 273, 546

font:
.incbin "adore.apx"



vdc_reg_values:
.db $00
.dw $0400
.db $05
.db $0000
.db $07
.dw $0000
.db $08
.dw $0000
.db $09
.dw $0000
.db $0A
.dw $0202
.db $0B
.dw $031F
.db $0C
.dw $0F02
.db $0D
.dw $00EF
.db $0E
.dw $0003
.db $FF

 .ends


    

