INCLUDE "COUNTER.INC"

SIZE EQU 256

ORG 256
 DW     127             ; constant 127 -> amplitude for sinus table
;DW     3C00H           ; constant 1/128 -> calculating PI/128 for sinus table

 CALL SINUS128

 CWD
;MOV BP,320

main:
 MOV    SI,0A000H       ; segment of video memory
 MOV    ES,SI
 MOV    CL,5
 PUSHA
 XCHG   AX,DI
 DIV    BP
 MOV    AH,DL
 SHR    DX,CL
 ADD    BL,DL
 MOV    DL,AL
 SHR    DL,CL
 ADD    BL,DL
 ADD    BL,DL
 AND    AX,257*31
 SUB    AL,16
 SUB    AH,16
 XCHG   DX,AX

.2:
 MOV    AL,[BX]
 IMUL   DL
 ADD    BL,64
 XCHG   BP,AX
 MOV    AL,[BX]
 IMUL   DH
 ADD    AX,BP
 CMP    AX,1500;1800;1125
 SALC
 JG     .3
 SUB    BL,BH;64+64;51;85
 LOOP   .2
 XCHG   AX,BX
 CBW
 XOR    AL,AH
 ADD    AL,120-16
.3:
 MOV    [SI],AL
 POPA

logo:
 PUSHA
 MOV    AX,0CCCDH       ; screen coordinates from pixel offset
 MUL    DI              ; DL = sX = 0..255, DH = sY = 0..199
 ADD    DL,[BX]
 SUB    DL,BL
 CMP    DL,BH           ; Y coordinate correction
 SBB    DH,100          ; center Y coordinate, dY = sY-112 (or -113)
 MOV    CL,67+72+72
.2:
 MOV    AX,DrawBar
 SUB    BL,4
 JS     .3
 TEST   CL,CL
 JS     .3
 MOV    BL,128
.3:
 MOV    CH,SIZE/256*3*10
 MOV    BP,-SIZE*3*2
 MOV    DI,SIZE*2*4
 CALL   AX
 MOV    CH,SIZE/256*3*8
 SUB    BP,BP
 MOV    DI,SIZE*2*14
 CALL   AX
 MOV    CH,SIZE/256*3*1
 MOV    BP,-SIZE*3*7
 CALL   AX
 NEG    BP
 CALL   AX
 SUB    CL,72
 JNC    .2

 POPA

 MOVSB
 TEST   DI,DI
back:
 JNZ    main

 PUSHA
 MOV    AX,1300H
 MOV    BX,67
;INC    CX              ; If you could find one more byte
 MOV    DX,1822H;-1     ; then print char ! as a bonus :)
 PUSH   CS
 POP    ES
 MOV    BP,text
 INT    10H
 POPA

 CALL ESCAPE

 NEG AL
 MOV BL,AL
 JMP back

DrawBar:
; BX:angle, DL:dX, DH:dY, CL:color, CH:width1
; BP:offset1, SI:offset2

.0:
 PUSHA
.1:
 MOV    AL,[BX]
 IMUL   DL
 ADD    BP,AX
 ADD    BL,64
 MOV    AL,[BX]
 IMUL   DH
 ADD    AX,BP
 JNS    .2
 NEG    AX
.2:
 CMP    AH,CH
 JA     .3
 ADD    BL,-64+64-10
 MOV    BP,DI
 CMP    CH,SIZE/256*2*3
 MOV    CH,SIZE/256*2*3
 JNE    .1
 MOV    [SI],CL
.3:
 POPA
 XOR    BL,BH
 NEG    AX
 JS     .0
 SUB    DI,SIZE*2*2
RETN                    ; return to DOS prompt

text:
 DB 'Rulez';!
