;----------------------------------------------------------------------------;
; Some sound blasters procedures used to detect and initialize sound card,   ;
; and to set the frequency of the sample replay routine. This piece of code  ;
; only plays samples on your little sound blaster fucking card. If you don't ;
; have one, sorry for this, but you have certainly right...                  ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;



;----------------------------------------------------------------------------;
; DetectSB - This procedure detect the sound blaster card.                   ;
; INPUT : Nothing
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
DetectSB    proc near
    mov     cs:SBPort,210h
dsb_j000:
    mov     dx,cs:SBPort
    add     dx,06h
    mov     al,1
    out     dx,al           ; Initialise DSP in 2x6h
    mov     al,0
    out     dx,al           ; Write 0 in port 2x6h

    mov     bx,50           ; This piece of code wait for the card's reaction
dsb_j001:
    cmp     bx,0
    jng     dsb_j002
    mov     dx,cs:SBPort
    add     dx,0Eh
    in      al,dx
    cmp     al,128
    jge     dsb_j002
    dec     bx
    jmp     dsb_j001

dsb_j002:
    
    mov     dx,cs:SBPort    ; Test DSP, must find AAh in port 2xAh
    add     dx,0Ah
    in      al,dx
    cmp     al,0AAh
    je      dsp_ok

    add     cs:SBPort,10h
    cmp     cs:SBPort,260h
    jna     dsb_j000

    mov     cs:SBPort,0     ; SBPort=0 if card not found

dsp_ok:
    ret
DetectSB    endp




;----------------------------------------------------------------------------;
; SBPowerOn - Initialize Sound card to receive datas.
; INPUT : Nothing
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
SBPowerOn   proc near
    mov     dx,cs:SBPort
    add     dx,0Ch
SBon_j0:
    in      al,dx
    cmp     al,80h
    jae     SBon_j0

    mov     al,0D1h
    out     dx,al
    ret
SBPowerOn   endp




;----------------------------------------------------------------------------;
; SBPowerOff - Turn the sound card off after its use.
; INPUT : Nothing
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
SBPowerOff  proc near
    mov     dx,cs:SBPort
    add     dx,0Ch
SBoff_j0:
    in      al,dx
    cmp     al,80h
    jae     Sboff_j0

    mov     al,0D3h
    out     dx,al
    ret
SBPowerOff  endp




;----------------------------------------------------------------------------;
; PlayOnSB - The new timer interrupt which plays the sample on sound blaster ;
; INPUT : Nothing
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
PlayOnSB    Proc far
    pusha
    cli
    cmp     cs:EndSound,1       ; No sound playing ? skip routine...
    je      EndPlaySB

    mov     bx,cs:PlayIndex
    cmp     bx,cs:DataSize      ; CoMPare data pointer and data size
    ja      StopThisNow

    mov     es,cs:SndDataSeg
    mov     di,cs:SndDataOfs
    mov     cl,es:[di+bx]       ; Get data from SndDataSeg:SndDataOfs to CL

    mov     dx,cs:SBPort        ; Prepare sound card...
    add     dx,0ch
    mov     al,10h
    out     dx,al
PlaySBj:
    in      al,dx
    cmp     al,80h
    jae     PlaySBj

    mov     al,cl               
    out     dx,al               ; Give data (stored in CL) to sound card.
    inc     cs:PlayIndex
    jmp     EndPlaySB

StopThisNow:
    mov     cs:EndSound,1
    mov     cs:PlayIndex,0

EndPlaySB:
    mov     al,20h
    out     20h,al
    sti
    popa
    iret
PlayOnSB    endp




;----------------------------------------------------------------------------;
; Work8253 - Initialize 8253 canals values
; INPUT : AL=Canal   CX=Value
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
Work8253    proc near
    mov     bx,0
    mov     bl,al

    shl     al,6
    or      al,54
    out     43h,al

    shl     bx,1
    mov     dx,cs:Puce8253[bx]
    mov     al,cl
    out     dx,al
    mov     al,ch
    out     dx,al
    ret
Work8253    endp




;----------------------------------------------------------------------------;
; PFrequency - Set the frequency for replay routine
; INPUT : CX=Frequency
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
PFrequency  proc near
    mov     ax,34DCh
    mov     dx,12h
    mov     cx,cs:frequency
    div     cx                  
    mov     cx,ax               ; Calcul: 1193180/frequency in CX
    mov     al,0
    call    Work8253
    ret
PFrequency  endp




;----------------------------------------------------------------------------;
; InitFreq - Reset initial frequency after restoring timer interrupt.        ;
; INPUT : Nothing
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
InitFreq    proc near
    mov     cx,0
    mov     al,0
    call    Work8253
    ret
InitFreq    endp




;----------------------------------------------------------------------------;
; InitPlay - Detect and initialize Sound Blaster card & playing routine.     ;
; INPUT : Nothing
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
InitPlay    proc near
    cli
    
    mov     cs:PlayIndex,0
    mov     cs:EndSound,1           ; Forbid playing...

    mov     ax,3508h
    int     21h
    mov     edx,0
    mov     dx,es
    shl     edx,16
    mov     dx,bx
    mov     cs:oldint,edx           ; Preserve old int 08h
    
    call    DetectSB
    cmp     cs:SBPort,0
    je      EndInitPlay
    
    mov     ax,2508h
    push    ds
    mov     bx,cs
    mov     ds,bx
    mov     dx,offset PlayOnSB      ; New interrupt in DS:DX...
    int     21h                     ; Put the new timer interrupt.
    pop     ds

    call    SBPowerOn               ; Set sound card on

EndInitPlay:
    sti
    ret
InitPlay    endp




;----------------------------------------------------------------------------;
; RestoreInt - Restore old timer interrupt & Reset sound card/speaker.       ;
; INPUT : Nothing
; OUTPUT: Nothing
;----------------------------------------------------------------------------;
RestoreInt  proc near
    call    InitFreq
    cli
    push    ds
    lds     dx,cs:oldint
    mov     ax,2508h
    int     21h
    pop     ds
    sti
    cmp     cs:SBPort,0
    je      EndRestore
    call    SBPowerOff
EndRestore:
    ret
RestoreInt  endp




;----------------------------------------------------------------------------;
; StartPlay - Allow SB routine to play the sample.                           ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: Nothing                    ;
;----------------------------------------------------------------------------;
StartPlay   proc near
    mov     cs:EndSound,0
    ret
StartPlay   endp




;----------------------------------------------------------------------------;
; StopPlay - Make a pause in the sample replay routine.                      ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: Nothing                    ;
;----------------------------------------------------------------------------;
StopPlay    proc near
    mov     cs:EndSound,1
    ret
StopPlay    endp



;--------------------------------------------------------------------variables



EndSound        db 0            ; Is sound playing ? =0 yes, =1 no !
Frequency       dw 0            ; Frequency of replay routine.

SndDataSeg      dw 0            ; Segement register of the datas.
SndDataOfs      dw 0            ; Offset register of the datas.

DataSize        dw 0            ; Length of sample datas.

PlayIndex       dw 0            ; Where i am in the sample datas ?

Puce8253        dw 40h,41h,42h  ; three canals...for three samples if u want.

SBPort          dw ?            ; huhu, what can it be ? =0 -> No sound card

oldint          dd 0            ; To store old timer interrupt.

                
                db 'Samples on SB - (c)opyright, may 1996 by Trantor of Zen',0



;----------------------------------------------------------------------------;
; NOTES:                                                                     ;
; To use these routines you have to :                                        ;
;   - Put in CS:SndDataSeg the segment register of the sample datas.         ;
;   - Put in CS:SndDataOfs the offset register of the sample datas.          ;
;   - Put in CS:DataSize the length of sample datas.                         ;
;   - Put in CS:Frequency the replay frequency and call PFREQUENCY routine.  ;
;   - call INITSB to initialize sound card & timer interrupt.                ;
;   - call STARTPLAY or STOPPLAY as many as you want to play sample.         ;
;   - DON'T FORGET to call RESTOREINT after the use of these routines.       ;
; Don't take care of the others routines, they are called by mains routines. ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;
