;----------------------------------------------------------------------------;
; Hardware detection... Need AFFICHE.INC to run...                                                      ;
;----------------------------------------------------------------------------;

; variables & constants...

p_i486      equ 8
p_i386      equ 7
p_80286     equ 6

co_i387     equ 3
co_80287    equ 2
co_8087     equ 1
co_aucun    equ 0


skiptxtline     db 13,10,'$'
pleindet        db '-----------------------',13,10,'$'
cputype         db 'cpu  : ','$'
coprotype       db 'fpu  : ','$'
vesacard        db 'vesa : ','$'
dosversion      db 'dos  : ','$'
xmsdrv          db 'XMS  : ','$'
emsdrv          db 'EMS  : ','$'
SoundType       db 'Sound: ','$'
SoundSpeaker    db 'Speaker',13,10,'$'
SoundSB         db 'Sound Blaster',13,10,'$'
SoundSB15       db 'Sound Blaster 1.5',13,10,'$'
SoundSB2        db 'Sound Blaster 2',13,10,'$'
SoundSBPro      db 'Sound Blaster Pro I/II',13,10,'$'
SoundSB16       db 'Sound Blaster 16/AWE32',13,10,'$'
sizeSt          db '       size','$'
freeSTR         db '       free','$'
cardport        db '       port','$'
cardirq         db '       irq','$'
carddma8        db '       dma8','$'
carddma16       db '       dma16','$'
carddsp         db '       dsp','$'
kilo            db 'Ko',13,10,'$'
no              db 'no',13,10,'$'

less386         db '80286 or less',10,13,'$'
Detect386       db 'i386',10,13,'$'
Detect486D      db 'i486DX or better',13,10,'$'
Detect486S      db 'i486SX or better',13,10,'$'

co_none         db 'not found',10,13,'$'
co_287          db '80287 or less',13,10,'$'
co_387          db 'i387',13,10,'$'
co_487          db 'i487 or better',13,10,'$'

vesainfo        db 256 dup (?)
WhichCPU        dw ?
WhichFPU        dw ?
IsXMS           dw ?
XMSPtr          dd ?
IsEMS           dw ?

SoundIRQ        dw ?
SoundPort       dw ?
SoundDMA8       dw ?
SoundDMA16      dw ?
SoundVersion    dw ?

; procedures...

GetProc     proc near
    pushf
    xor     ax,ax
    push    ax
    popf
    pushf
    pop     ax
    and     ax,0f000h
    cmp     ax,0f000h
    je      pfin
    mov     dl,p_80286
    mov     ax,07000h
    push    ax
    popf
    pushf
    pop     ax
    and     ax,07000h
    je      pfin
    inc     dl
    cli
    mov     ebx,esp
    and     esp,0FFFCh
    pushfd
    pop     eax
    mov     ecx,eax
    xor     eax,1 shl 18
    push    eax
    popfd
    pushfd
    pop     eax
    push    ecx
    popfd
    xor     eax,ecx
    shr     eax,18
    and     eax,1h
    mov     esp,ebx
    sti
    and     al,dl
pfin label near
    popf
    xor     dh,dh
    mov     ax,dx
    mov     WhichCPU,ax
    ret
GetProc     endp




GetCopro    proc near
    mov     dx,co_aucun
    mov     byte ptr cs:wait1,90h
    mov     byte ptr cs:wait2,90h
wait1:
    finit
    mov     byte ptr isems+1,0
wait2:
    fstcw   isems
    cmp     byte ptr isems+1,3
    jne     gcfin
    inc     dx
    and     isems,0FF7Fh
    fldcw   isems
    fdisi
    fstcw   isems
    test    isems,80h
    jne     gcfin
    inc     dx
    finit
    fld1
    fldz
    fdiv
    fld st
    fchs
    fcompp
    fstsw   isems
    mov     ah,byte ptr isems+1
    sahf
    je      gcfin
    inc     dx
gcfin:
    mov     WhichFPU,dx
    ret
GetCopro    endp



CPUFPUInfos proc near
    call    GetProc
    mov     dx,offset cputype
    call    AffString
    cmp     WhichCPU,7
    jae     least386
    mov     dx,offset Less386
    call    AffString
    jmp     Copro_now
Least386:
    cmp     WhichCPU,8
    je      Least486
    mov     dx,offset Detect386
    call    AffString
    jmp     Copro_now
Least486:
    cmp     WhichFPU,0
    jne     Its486DX
    mov     dx,offset Detect486S
    call    AffString
    jmp     Copro_now
Its486DX:
    mov     dx,offset Detect486D
    call    AffString
Copro_now:    
    call    GetCopro
    mov     dx,offset coprotype
    call    AffString
    cmp     WhichFPU,0
    jne     ThereisCopro
    mov     dx,offset co_none
    call    AffString
    jmp     EndCPUFPU
ThereisCopro:
    cmp     WhichFPU,3
    je      Its387487
    mov     dx,offset co_287
    call    AffString
    jmp     EndCPUFPU
Its387487:
    cmp     WhichCPU,8
    je      Its487
    mov     dx,offset co_387
    call    AffString
    jmp     EndCPUFPU
Its487:
    mov     dx,offset co_487
    call    AffString
EndCPUFPU:
    ret
CPUFPUInfos endp



TestVesa    proc near
    mov     ah,4fh
    xor     al,al
    push    cs
    pop     es
    mov     di,offset vesainfo
    int     10h
    cmp     al,4fh
    jne     NotSupportV
    cmp     ah,0
    jne     NotSupportV
    mov     al,'v'
    call    affascii
    mov     di,offset vesainfo
    mov     al,cs:[di+4]
    call    affchiffre
    mov     al,'.'
    call    affascii
    mov     al,cs:[di+5]
    call    affchiffre
    mov     dx,offset skiptxtline
    call    AffString
    jmp     endVESAt
NotSupportV:
    mov     dx,offset no
    call    AffString
endVESAt:
    ret
TestVesa    endp



WhichDOS    proc near
    mov     al,'v'
    call    affascii
    mov     ah,30h
    int     21h
    call    affchiffre
    mov     al,'.'
    call    affascii
    mov     al,ah
    call    affchiffre
    mov     dx,offset skiptxtline
    call    AffString
    ret
WhichDOS    endp




XMSInfos    proc near
    mov     dx,offset xmsdrv
    call    affstring
    
    mov     IsXMS,0             ; init XMS
    mov     ax,4300h
    int     2fh
    cmp     al,80h
    jne     EndXMSInit
    mov     ax,4310h
    int     2fh
    mov     IsXMS,1 
    mov     word ptr XMSptr+2,es
    mov     word ptr XMSptr+0,bx
EndXMSInit:
    cmp     IsXMS,1             ; =1 -> no XMS driver
    je      VersionXMS
    mov     dx,offset no
    call    affstring
    jmp     EndXMSinf
VersionXMS:
    mov     al,'v'
    call    affascii
    xor     ax,ax
    call    dword ptr [XMSptr]  ; find XMS version
    mov     dx,ax               ; Version in AX and Revision in BX
    
    shr     ax,8                ; Version=Ver/256
    call    affchiffre
    mov     al,'.'
    call    affascii
    mov     ax,bx               ; revision=(Rev-Ver)/16
    sub     ax,dx
    shr     ax,4
    call    affChiffre
    mov     dx,offset SkipTxtLine
    call    affstring

    mov     ah,8h
    call    dword ptr [XMSptr]
    push    dx
    push    ax
    mov     dx,offset SizeSt
    call    affstring
    pop     ax
    call    affdecimal
    mov     dx,offset kilo
    call    affstring
    mov     dx,offset FreeSTR
    call    Affstring
    pop     ax
    call    affdecimal
    mov     dx,offset kilo
    call    affstring
EndXMSinf:
    ret
XMSInfos    endp



EMSInfos    proc near
    mov     dx,offset emsdrv
    call    affstring
    mov     eax,cr0
    test    al,1
    jnz     V86Mode
    mov     dx,offset no
    call    affstring
    jmp     EndEMSInfos
V86Mode:
    mov     al,'v'
    call    affascii
    mov     IsEMS,1
    mov     ah,46h
    int     67h             ; version in AX
    xor     ah,ah
    mov     dx,ax
    shr     ax,4
    call    affchiffre
    mov     al,'.'
    call    affascii
    mov     al,dl
    and     al,15
    call    affchiffre
    mov     dx,offset skiptxtline
    call    affstring
    mov     dx,offset sizeSt
    call    affstring
    mov     ah,42h
    int     67h
    mov     ax,dx
    shl     ax,4
    call    affdecimal
    mov     dx,offset kilo
    call    affstring
    mov     dx,offset freeSTR
    call    affstring
    mov     ax,bx
    shl     ax,4
    call    affdecimal
    mov     dx,offset kilo
    call    affstring
EndEMSInfos:
    ret
EMSInfos    endp



SoundInfos  proc near
    LOCAL   ver:byte,rev:byte 
    call    DetectSB
    mov     dx,offset SoundType
    call    Affstring
    cmp     [SoundPort],255
    jne     SoundDetectionOk
    mov     dx,offset SoundSpeaker
    call    affstring
    jmp     SkipCardAff
SoundDetectionOk:
    mov     ax,[SoundVersion]
    mov     Ver,ah
    mov     Rev,al
    cmp     Ver,1
    jne     NotSBOrigine
    mov     dx,offset SoundSB
    call    Affstring
    jmp     EndSoundInfos
NotSBOrigine:
    cmp     Rev,0
    jne     NotSB15
    cmp     Ver,2
    jne     NotSB2
    mov     dx,offset SoundSB15
    call    affstring
    jmp     EndSoundInfos
NotSB15:
    cmp     Ver,2
    jne     NotSB2
    mov     dx,offset SoundSB2
    call    affstring
    jmp     EndSoundInfos
NotSB2:
    cmp     Ver,3
    jne     NotSBPro
    mov     dx,offset SoundSBPro
    call    affstring
    jmp     EndSoundInfos
NotSBPro:
    cmp     Ver,4
    jne     UnkownCard
    mov     dx,offset SoundSB16
    call    affstring
    jmp     EndSoundInfos
UnkownCard:
    mov     dx,offset no
    call    affstring
    mov     [SoundPort],255
    mov     [SoundIrq],255
    mov     [SoundDma8],255
    mov     [SoundVersion],255
    jmp     SkipCardAff
EndSoundInfos:
    mov     dx,offset cardport
    call    affstring
    mov     ax,[SoundPort]
    call    AffHexa
    mov     al,'h'
    call    affascii
    mov     dx,offset skiptxtline
    call    AffString
    
    mov     dx,offset cardirq
    call    affstring
    mov     ax,[SoundIRQ]
    call    AffDecimal
    mov     dx,offset skiptxtline
    call    AffString
    
    cmp     [sounddma16],255
    jne     SkipAffDMA8
    mov     dx,offset carddma8
    call    affstring
    mov     ax,[Sounddma8]
    call    AffDecimal
    mov     dx,offset skiptxtline
    call    AffString
    jmp     SkipAffDMA16
SkipAffDMA8:
    mov     dx,offset carddma16
    call    affstring
    mov     ax,[Sounddma16]
    call    AffDecimal
    mov     dx,offset skiptxtline
    call    AffString
SkipAffDMA16:
    mov     dx,offset carddsp
    call    affstring
    mov     ax,[SoundVersion]
    mov     al,ah
    call    affchiffre
    mov     al,'.'
    call    affascii
    mov     al,'0'
    call    affascii
    mov     ax,[SoundVersion]
    call    affchiffre
    mov     dx,offset skiptxtline
    call    affstring
SkipCardAff:
    ret
SoundInfos  endp



DetectSb    proc near
    LOCAL  dma1:byte,dma2:byte,dma1r:byte,dma2r:byte
    pusha
    push    es
@@ScanSBPort:
    mov     bx,210h                 ; start scanning ports..
@@ResetDSP:
    mov     dx,bx                   ; try to reset the DSP.
    add     dx,06h
    mov     al,1
    out     dx,al
    in      al,dx
    in      al,dx
    in      al,dx
    in      al,dx
    xor     al,al
    out     dx,al
    add     dx,08h
    mov     cx,100
@@WaitSBID:
    in      al,dx
    or      al,al
    js      @@GetSBID
    loop    @@WaitSBID
    jmp     @@NextSBPort
@@GetSBID:
    sub     dx,04h
    in      al,dx
    cmp     al,0AAh
    je      @@FoundSB
    add     dx,04h
    loop    @@WaitSBID
@@NextSBPort:
    add     bx,10h                  ; if not response,
    cmp     bx,260h                 ; try the next port.
    jbe     @@ResetDSP
    jmp     FailDetectSB
@@FoundSB:
    mov     [SoundPort],bx          ; SB Port Address Found!
@@ScanSBIRQ:
    cli
    in      al,21h                  ; save the IMR.
    mov     bl,al
    mov     al,11111111b            ; disable all the IRQs.
    out     21h,al
    xor     ax,ax                   ; trap the IRQs 2,3,5,7.
    mov     es,ax
@@SaveSBIrqs:
    mov     ax,es:[28h]             ; irq2
    mov     dx,es:[2Ah]
    push    ax
    push    dx
    mov     ax,es:[2Ch]             ; irq3
    mov     dx,es:[2Eh]
    push    ax
    push    dx
    mov     ax,es:[34h]             ; irq5
    mov     dx,es:[36h]
    push    ax
    push    dx
    mov     ax,es:[3Ch]             ; irq7
    mov     dx,es:[3Eh]
    push    ax
    push    dx
@@SetSBIrqs:
    mov     ax,offset TrapIrq2      ; irq2
    mov     es:[28h],ax
    mov     es:[2Ah],cs
    mov     ax,offset TrapIrq3      ; irq3
    mov     es:[2Ch],ax
    mov     es:[2Eh],cs
    mov     ax,offset TrapIrq5      ; irq5
    mov     es:[34h],ax
    mov     es:[36h],cs
    mov     ax,offset TrapIrq7      ; irq7
    mov     es:[3Ch],ax
    mov     es:[3Eh],cs
@@EnableSBIrqs:
    mov     al,bl                   ; enable IRQs 2,3,5,7.
    and     al,01010011b
    out     21h,al
    sti
    mov     [SoundIRQ],0            ; clear the IRQ level.
    mov     dx,[SoundPort]          ; tells to the SB to
    add     dx,0Ch                  ; generate an IRQ!
@@WaitSbSB:
    in      al,dx
    or      al,al
    js      @@WaitSbSB
    mov     al,0F2h
    out     dx,al
    xor     cx,cx                   ; wait until IRQ level
@@WaitSBIRQ:
    cmp     [SoundIrq],0            ; is changed or timeout.
    jne     @@IrqSBOk
    loop    @@WaitSBIRQ
@@IrqSBOk:
    mov     al,bl                   ; restore IMR.
    out     21h,al
@@RestoreSBIrqs:
    cli                             ; restore IRQ vectors.
    xor     ax,ax
    mov     es,ax
    pop     dx                      ; irq7
    pop     ax
    mov     es:[3Ch],ax
    mov     es:[3Eh],dx
    pop     dx                      ; irq5
    pop     ax
    mov     es:[34h],ax
    mov     es:[36h],dx
    pop     dx                      ; irq3
    pop     ax
    mov     es:[2Ch],ax
    mov     es:[2Eh],dx
    pop     dx                      ; irq2
    pop     ax
    mov     es:[28h],ax
    mov     es:[2Ah],dx
    cli                   
    cmp     [SoundIrq],0            ; IRQ level was changed?
    je      FailDetectSB            ; no, fail.
    
@@DetectSBDMAs:
    mov     [SoundDMA8],255
    mov     al,0d3h                 ;Turn off speaker
    call    SBwrite
    mov     al,040h                 ;Set sample rate to 22000Hz
    call    SBwrite                 ;Value = 256 - (1000000/Hz)
    mov     al,0D3H
    call    SBwrite
    mov     al,014h                 ;Set 8bit DMA transfer mode
    call    SBwrite
    mov     al,0FFh ;010h           ;8bit DAC mode or is it length?
    call    SBwrite
    cli
    xor     al,al                   ;Clear Flip-Flop
    out     0ch,al
    in      al,8                    ;Get original status of DMA chip 1
    and     al,0f0h ;e0h
    mov     [dma1],al
    xor     al,al                   ;Reset DSP...
    call    SBwrite
    mov     cx,0                    ;Wait for a DMA to be requested.
@@WaitFlag8:                        ;When it's requested, DMA registers
    in      al,8                    ;are modified. Don't ask me how.
    and     al,0f0h ;e0h
    mov     [dma1r],al
    cmp     al,[dma1]
    jne     @@DMArequested8
    loop    @@WaitFlag8
@@DMArequested8:
    sti
    call    _SBreset                ;DSP confused already. Heh heh.
                                    ;---Now, determine which DMA occured.
    mov     al,[dma1]
    not     al
    and     al,[dma1r]
    shr     al,4
    mov     cl,4-1                  ;Test 4 channels.
    xor     ah,ah                   ;Start from DMA0
@@CheckDMAbit8:
    test    al,1
    jnz     short @@DMAfound8
    shr     al,1
    inc     ah
    loop    @@CheckDMAbit8
    mov     ah,1                    ;No 8-bit DMA. Force to 1 ?
    jmp     short @@DetectDMA16     ;No 8-bit DMA. Try detect 16-bit one.
@@DMAfound8:
    mov     al,ah
    xor     ah,ah                  
    mov     [SoundDMA8],ax          ;Store DMA channel number.

@@DetectDMA16:
    mov     al,0e1h                 ;Get AH:AL=Maj:Min DSP version
    call    SBwrite
    call    SBread
    mov     ah,al
    call    SBread
    cmp     ax,0400h
    jb      @@Not16BitSoundCard
    mov     al,0d3h                 ;Turn off speaker
    call    SBwrite
    mov     al,041h                 ;Set sample rate to 20000Hz
    call    SBwrite                 ;Set rate hi-lo
    mov     al,20000/256
    call    SBwrite
    mov     al,20000 AND 255
    call    SBwrite
    mov     al,0b6h
    call    SBwrite
    mov     al,010h                 ;16-bit mono signed PCM
    call    SBwrite
;    mov     al,014h                ;Set 8bit DMA transfer mode
;    call    SBwrite
    mov     al,0FFh                 ;Just like what I did with 8-BIT Detect
    call    SBwrite
    cli
    xor     al,al                   ;Clear Flip-Flop
    out     0d8h,al
    in      al,0d0h                 ;Get original status of DMA chip 2
    and     al,0f0h
    mov     [dma2],al
    xor     al,al                   ;Reset DSP...
    call    SBwrite
    mov     cx,0 ;60000             ;Wait for a DMA to be requested.
@@WaitFlag16:                       ;When it's requested, DMA registers
    in      al,0d0h                 ;are modified. Don't ask me how.
    and     al,0f0h
    mov     [dma2r],al
    cmp     al,[dma2]
    jne     @@DMArequested16
    loop    @@WaitFlag16

@@DMArequested16:
    sti
    call    _SBreset                ;DSP confused already. Heh heh.
    mov     al,[dma2]
    not     al
    and     al,[dma2r]
    shr     al,4
    mov     cl,4-1                  ;Test 4 channels.
    mov     ah,4                    ;Start from DMA4
@@CheckDMAbit16:
    test    al,1
    jnz     short @@DMAfound16
    shr     al,1
    inc     ah
    loop    @@CheckDMAbit16
    jmp     short @@Not16BitSoundCard
@@DMAfound16:
    mov     al,ah
    xor     ah,ah
    mov     [SoundDMA16],ax         ;Store DMA channel number.
    jmp     short @@FoundDMA16
@@Not16BitSoundCard:
    mov     [SoundDMA16],255
    cmp     [SoundDMA8],255
    je      FailDetectSB
@@FoundDMA16:
    call    _SBreset                ;DSP confused already. Heh heh.

@@FindSBVer:
    mov     al,0e1h
    call    SBwrite
    call    SBread
    mov     ah,al
    call    SBread
    mov     [SoundVersion],ax
@@SBVerFound:

    pop     es
    popa                            ; Return to caller.
    ret
FailDetectSB:
    mov     [SoundPort],255
    mov     [SoundIRQ],255
    mov     [SoundDMA8],255
    mov     [SoundDMA16],255
    mov     [SoundVersion],255
    pop     es
    popa
    ret
DetectSb    EndP


TrapIrq     proc far
    push    dx                      ; General IRQ trapper
    push    ds                      ; used for IRQ autodetect.
    mov     dx,@Data
    mov     ds,dx
    mov     [SoundIrq],ax              ; save IRQ level.
    mov     dx,[SoundPort]
    add     dx,0Eh
    in      al,dx                   ; SB acknowledge.
    mov     al,20h
    out     20h,al                  ; Hardware acknowledge.
    pop     ds
    pop     dx
    pop     ax
    iret                            ; bye!
    IRP Level,<2,3,5,7>
TrapIrq&Level:
    push    ax
    mov     ax,Level
    jmp     TrapIrq
    EndM
TrapIrq     endp


SBwrite     proc near               ; Write to DSP. Not timed.
    mov     DX,[SoundPort]
    add     DL,0Ch
    mov     AH,AL
@@WaitingSBWrite:
    in      AL,DX
    or      AL,AL
    js      short @@WaitingSBWrite
    mov     AL,AH
    out     DX,AL
    ret
SBwrite     endp


SBread      proc near               ; Read from DSP. Not timed.
    mov     dx,[SoundPort]         
    add     dl,0eh
    mov     ah,al
@WaitingSBread:
    in      al,dx
    or      al,al
    jns     short @WaitingSBread
    sub     dl,04h
    in      al,dx
    ret
SBread      endp


_SBreset    proc near           ; Reset the DSP by sending 1, (delay), then 0
    mov     dx,[SoundPort]
    add     dx,6
    mov     al,1
    out     dx,al
    in      al,dx               ; Wait at least 3 microseconds
    in      al,dx
    in      al,dx
    in      al,dx
    xor     al,al
    out     dx,al
                                ; Wait for SB signature (0AAh)
    mov     cx,064h             ; Up to 100 times retry...
@@WaitForSignature:
    mov     dx,[SoundPort]      ; POLLING - WAIT FOR SIGNATURE
    add     dx,0Eh              ;          TO BE AVAILABLE.
    in      al,dx
    test    al,080h
    jnz     short @@DataAvailable
    loop    @@WaitForSignature
    jmp     @@SBnotFoundAtPort
@@DataAvailable:
    mov     dx,[SoundPort]      ; GET THE SIGNATURE
    add     dx,0ah
    in      al,dx
    cmp     al,0AAh
    je      short @@SBfoundAtPort
    loop    @@WaitForSignature
@@SBnotFoundAtPort:
    stc
    ret
@@SBfoundAtPort:                ;SB found at port.
    clc
    ret
_SBreset    endp 



RestoreText proc near
    mov     ax,03h
    int     10h
    xor     bl,bl
    mov     ah,11h
    mov     al,12h
ActiveTXTfnt:
    int     10h
    ret
RestoreText endp



Hardware    proc near
    mov     dx,offset skiptxtline
    call    affstring
    mov     dx,offset pleindet
    call    AffString

    call    CPUFPUInfos

    mov     dx,offset dosversion
    call    AffString
    call    WhichDOS

    call    XMSInfos
    call    EMSInfos
    
    mov     dx,offset vesacard
    call    AffString
    call    TestVesa

    call    SoundInfos

    mov     dx,offset pleindet
    call    AffString
    ret
Hardware    endp
