;compile with sjasmplus:sjasmplus dith256.asm

	device zxspectrum128
        ORG $F0
begin
		;Define EXOS call macro (not needed in Enterprise assemblers)
                MACRO EXOS n
                  RST 30H
                  DB  n
                ENDM

		DB 0,5		;type 5 = machine code application program
		DW VEGE-100H	;16 bit lenght
		DB 0,0,0,0,0,0,0,0,0,0,0,0 ;not used bytes

		;start of program, loaded at 100h
                LD SP,100H	;set the User Stack, 164 bytes free
	di

;Then LPT address + 4,5 gives the video memory (character map address) and LPT address + 6,7 gives the font memory/char mode.
;Snake uses CHAR128 mode therefor LPT address +6,7 should be multiplied by 128, it will give the font memory, I use the normal EXOS font memory.
;
;LPT 1 st char row used by the game:
;F7 08 0B 73 28 C0 E9 01 00 92 00 49 FF 24 2D 36 
;Character map address: c028h
;font address: 01e9h*80h= f480h

;for the 256b:
;$C000 - character map
;$C000+40*24= $C3C0, or $C400, for ch128 $C400/$80=$188
	ld      hl,($bff4);LPT address

	ld a,$FF
	out ($B3),a

;how LPT looks in BASIC
;  B900  F7 08 0B 73 B8 FE E9 01 :w..s8~i.
;  B908  00 36 00 49 FF 24 2D 36 :.6.I.$-6
;  B910  F7 08 3F 74 B8 FE E9 01 :w.?t8~i.
;  B918  00 92 00 49 FF 24 2D 36 :...I.$-6
;  B920  F7 08 3F 74 B8 FE E9 01 :w.?t8~i.

; let build LPT
	ld de,$C000; $C000 for Nick, page $FF

	ld a,24
pp:
	exa
	inc hl,hl ; skip SC,MB

	ld      (hl),$0b ; LM
	inc hl
    ld      (hl),$73;RM
    inc hl

	ld (hl),e; LD1L/LD1H - character map
	inc hl
	ld (hl),d
	inc hl
	
	ld a,e ; charmap+40
	add a,40
	ld e,a
	jr nc,no_inc_d
	inc d
no_inc_d:

;$C400/128=$188
	ld      (hl),$88;LD2L,LD2H - font data, $C400/128=$188
	inc hl
	ld      (hl),$01
	inc hl

; here is color values:
;http://ep.lgb.hu/colors.html
	ld b,4
zz:
	ld (hl),4
	inc hl

	ld (hl),$FB
	inc hl

	djnz zz

	exa
	dec a
	jr nz,pp


	ld hl,$C400
	exx
;Written by Max/CBX/BDA, 27.10.98.
;      XAS Assembler v7.447.
;---------------------------------
; it may differ since i need alter dithered pattern
DIT_GEN LD    E,64*2

DIT_GN1:
	exx
	push hl
	exx

 		LD    HL,MATRIX
        LD    B,8
DIT_GN2 LD    C,1

 		LD    A,E
        bit 6,a
        jr nz,noneg
        cpl
noneg:
		and 63

DIT_GN3 CP    (HL)
        INC   HL
        RL    C
        JP    NC,DIT_GN3
        LD    A,C
        exx
        ld (hl),a
        ld de,64*2
        add hl,de
        exx
        DJNZ  DIT_GN2
        exx
        ld (val9+1),hl
        pop hl
		ld a,(hl)
val9: ld (0),a

        inc hl
        exx
        DEC   E
        JP    P,DIT_GN1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;draw pattern;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
buf equ 0C000h
		ld	hl, buf
		ld	de, 101h
		ld	c, 18h

gpat1:
		ld	a, e
		ld	b, 40;20h
gpat2:
		ld	(hl), a
		inc	hl
		add	a, d
		djnz	gpat2
		inc	d
		inc	e
		dec	c
		jr	nz, gpat1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;draw one
lp0:
	ld bc,40*24
      LD            HL ,buf
      LD            DE ,$027F
lp1:
      LD            A ,(HL)
      ADD           A ,D
      CP            E
      JR            C ,mm;$+3

      SUB           E
mm:
      LD            (HL)  ,A
      INC           HL

      dec bc
      ld a,b
      or c
      jr nz,lp1

      jr lp0

MATRIX  DB    1,33,9,41,3,35,11,43
        DB    49,17,57,25,51,19,59,27
        DB    13,45,5,37,15,47,7,39
        DB    61,29,53,21,63,31,55,23
        DB    4,36,12,44,2,34,10,42
        DB    52,20,60,28,50,18,58,26
        DB    16,48,8,40,14,46,6,38
        DB    64,32,56,24,62,30,54,22

VEGE:
end

	display /d,end-begin
	savebin "dith256.com",begin,end-begin

