read "CoreDefs.asm"




limit &E00	
org &50


;
;Rastercolor buffer - 80 bytes (&50
RasterColors_ColorArray1:
	defb 1
	defb 1
	defb 64+20,64+24,64+29,64+11	 :IlluminatedPaletteA_Plus2
RasterColors_ColorArray2:
	defb 1
	defb 1

	defb 64+20,64+12,64+13,64+11	:IlluminatedPaletteB_Plus2
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 12
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray3:
	defb 1
	defb 1
	defb 64+20,64+12,64+13,64+11 :IlluminatedPaletteC_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray4:
	defb 1
	defb 1 
	defb 64+20,64+31,64+14,64+11 :IlluminatedPaletteD_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11



align 256,&00
StarArraySize equ 255
StarArrayPointer: 	
defs StarArraySize*3,&00


ObjectArraySize equ 60
PlayerStarArraySize equ 36

align 256,&00
PlayerStarArrayPointer: 
defs 64,&00
ObjectArrayPointer:
defs 64,&00
align 256,&00
defs 255*5,&00

;defs ObjectArraySize*6,&00
;defs PlayerStarArraySize*3,&00

;align 256,&00

	

Event_SavedSettings:
defs 4*16,&00

CustomRam:
defs 64 ;  Pos-Tick-Pos-Tick ; enough memory for 16 enemies!




org &1000
;incbin "Sprites\PLAYER.SPR"
limit &4000

org &2500
LevelSprites:
;incbin "Sprites\LEVEL1A2.SPR"
incbin "Sprites\LEVEL6.SPR"





limit &3ff0
org &3800


evtSettingsBank_Save equ %10010000+15
evtSettingsBank_Load equ %10010000+0
evtMultipleCommands equ %01110000


evtSetMoveLife     equ 128
evtSetProg	   equ 129
evtSetLife	   equ 130
evtSetMove	   equ 131
evtSetProgMoveLife equ 132
evtSetSprite	   equ 133
evtAddToForeground equ 135
evtAddToBackground equ 134
evtJumpToNewTime   equ 136
evtCallAddress	   equ 137
evtSaveLstObjToAdd equ 138
evtResetPowerup    equ 139
evtSetLevelSpeed   equ 140

evtReprogramPalette 	equ %11110000
evtReprogramBackground 	equ %11110001	
evtReprogramHitHandler 	equ %11110010		
evtReprogramParalax	equ %11110011		

evtReprogramCustomMove1 equ %11110100
evtReprogramCustomMove2 equ %11110101
evtReprogramCustomMove3 equ %11110111
evtReprogramCustomMove4 equ %11111000

evtReprogramCustomProg1 equ %11111001
evtReprogramCustomProg2 equ %11111010
evtReprogramCustomProg3 equ %11111011
evtReprogramCustomProg4 equ %11111100

evtReprogram_PowerupSprites equ %11110110



evtSingleSprite equ 0
evtTileSprite equ 48 ;     0011xxxx X Y S = (48) add  xxxx objects all on column X, Ypos Spaced S apart vertically

prgSpecial	equ 2
prgBonus 	equ 3
prgMovePlayer	equ 4
prgFireSnail	equ %10000000
prgFireSlow	equ %01100000
prgFireMid	equ %01000000
prgFireMid2	equ %11000000
prgFireFast	equ %00100000
prgFireHyper	equ %10100000
prgCustom1 	equ %11111100			;Custom 1
prgCustom2 	equ %11111101			;Custom 2
prgCustom3 	equ %11111110			;Custom 3
prgCustom4 	equ %11111111			;Custom 4


mveStatic 	equ &24
mveSeaker	equ %10000100
mveWave		equ %10100000
mveWaveSmall	equ %10010000
mveCustom1	equ %11110000
mveCustom2	equ %11100000
mveCustom3	equ %11010000
mveCustom4	equ %10110000

lifCustom       equ 255		; We use 63 as a marker for custom code's INIT - a real life will be set by the custom code
lifEnemy	equ %11000000	;HurtByBullets,Hurts Player
lifTimed	equ %00000000	;Doesnt hurt, dies automatically
lifDeadly	equ %01000000	;Deadly and cant be shot
TwoFrameSprite  equ 128




EventStreamArray:

;defb 1,128,&24,128+64+60		; Move Static




defb 0,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		



; Define the background


; Define the background

defb 0,240+1,0,17*2+1				; (Time,Cmd,Off,Bytes) Load 41 bytes into the background - 41 bytes is the limit
defb &F0,&F0	;1; first line
defb 196,&D0	;2; line num, New byte
defb 190,&70	;3
defb 186,&A0	;4
defb 180,&50	;5
defb 176,&80	;6
defb 170,&20	;7
defb 166,&00	;8
defb 160,&00	;9
defb 36,&20	;10
defb 30,&80	;11
defb 26,&50	;12
defb 20,&A0	;13
defb 16,&70	;14
defb 10,&D0	;15
defb 06,&F0	;16
defb 02,&F0	;17
defb 255

;We will use 4 Paralax layers
; ---------()- (sky)		%11001000
; ------------ (Far)		%11000100
; -----X---X-- (mid)		%11000010	Bank 1
; []=====[]=== (foreground) 	%11000001	Bank 0

defb 0,evtAddToBackground

defb 0,evtReprogramHitHandler				;Install a custom hit handler
defw CustomObjectHitHandler


defb 0,evtReprogram_PowerupSprites,128+88,128+88,128+88,128+1	; sprites drone,speed,power,coin

; Background L
defb 0,128+4,1,%11000001,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,0				; Save Object settings to Bank 0

defb 0,128+4,1,%11000010,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,1				; Save Object settings to Bank 1



;  Boss Body
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,0,mveCustom2+5,0			; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+17		
defb 	evtSettingsBank_Save,2		

; Boss Saw
defb 0,evtMultipleCommands+5			; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,0,mveCustom3+6,lifDeadly+63
defb 	evtSetSprite,TwoFrameSprite+18
defb 	evtSettingsBank_Save,3	
defb    evtSetLife,0
defb 	evtSettingsBank_Save,5	;Saw Arm


; Boss Drone
defb 0,evtMultipleCommands+3			; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgCustom1,mveCustom1,lifCustom	
defb 	evtSetSprite,TwoFrameSprite+1
defb 	evtSettingsBank_Save,4	


; Drone Move
defb 0,evtReprogramCustomMove1
defw CustomMove1
defb 0,evtReprogramCustomMove2
defw CustomMove2
defb 0,evtReprogramCustomMove3
defw CustomMove3


defb 0,evtReprogramCustomProg1
defw CustomProgram1

; start of level
StartOfLevel:


;Palette Change
defb 1,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40			












; Load Palette

	defb 2,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0				
	defb &44,&57,&59,&4B			

	;defb 0,240,6,6			; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 5
	;defb 1				
	;defb &54,&55,&43,&4B		

	defb 240,26*0+6,5*1+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1	; Switches
	defb 0	;delay			
	defb &44,&57,&59,&4B			

	defb 240,26*1+6,1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0

	defb 240,26*2+6,5*1+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1 ; no of switches
	defb 0	;delays			
	defb &44,&57,&59,&4B			
		
	

;defb 5,%01110000+2			; 3 commands at the same timepoint
;defb evtSetProgMoveLife,0,&24,10
;defb 	0,128+	0,140+24,170+24	; 	; Single Object sprite 11 (animated)



	;defb 1				
	;defb &54,&4C,&56,&4B


AttackLoop:
;Saw Blade

SawBlade equ 26


defb 10,evtMultipleCommands+6
defb 	evtSettingsBank_Load+3
defb 	evtSetLife,lifCustom
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+6,160+24-36,1
defb 	evtSettingsBank_Load+3
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+7,160+24-24,1
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+8,160+24-12,1


defb 13,evtMultipleCommands+7
defb 	evtSettingsBank_Load+5
defb 	evtSetProg,prgFireMid+13
defb 	evtSingleSprite ,TwoFrameSprite +36,160+24-24,1
defb 	evtSettingsBank_Load+3
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+3,160+24-36,1
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+4,160+24-24,1
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+5,160+24-12,1


defb 16,evtMultipleCommands+6
defb 	evtSettingsBank_Load+5
;defb evtSetProg,prgFireMid+13
defb 	evtSingleSprite ,TwoFrameSprite+7 :SawArmA
		defb 160+24-24,1
defb 	evtSettingsBank_Load+3
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+0,160+24-36,1
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+1,160+24-24,1
defb 	evtSingleSprite ,TwoFrameSprite +SawBlade+2,160+24-12,1

defb 19,evtMultipleCommands+2
defb 	evtSettingsBank_Load+5
defb 	evtSingleSprite ,TwoFrameSprite +7 :SawArmB
	defb 160+24-24,1


defb 22,evtMultipleCommands+2
defb 	evtSettingsBank_Load+5
defb 	evtSingleSprite ,TwoFrameSprite +7 :SawArmC
	defb 160+24-24,1

defb 25,evtMultipleCommands+2
defb 	evtSettingsBank_Load+5
defb 	evtSingleSprite ,TwoFrameSprite +7 :SawArmD
	defb 160+24-24,1

defb 28,evtMultipleCommands+2
defb 	evtSettingsBank_Load+5
defb 	evtSingleSprite ,TwoFrameSprite +7 :SawArmE
	defb 160+24-24,1




Drones
defb 70,evtMultipleCommands+9
defb 	evtSettingsBank_Load+4
defb 	evtSetMove,mveCustom1+0
defb 	evtSingleSprite ,TwoFrameSprite +0,24,24
defb 	evtSetMove,mveCustom1+1
defb 	evtSingleSprite ,TwoFrameSprite +0,160,24
defb 	evtSetMove,mveCustom1+2
defb 	evtSingleSprite ,TwoFrameSprite +0,24,200
defb 	evtSetMove,mveCustom1+3
defb 	evtSingleSprite ,TwoFrameSprite +0,160,200






;Big Fish

defb 73,evtMultipleCommands+3
defb 	evtSettingsBank_Load+2
defb 	evtSetLife,lifCustom
defb 	evtSingleSprite ,TwoFrameSprite +5 :BossSpr5A
	defb 160+24,24*7+24+8	


defb 76,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtSingleSprite ,TwoFrameSprite +6	:BossSpr6A
	defb 160+24,24*7+24+8

defb 79,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+2 ,160+24,24*6+24+7  ,24
	defb	TwoFrameSprite +5 :BossSpr5B
	defb 	TwoFrameSprite +4 :BossSpr4A


defb 82,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+2 ,160+24,24*6+24+7  ,24
	defb	TwoFrameSprite +6 :BossSpr6B
	defb 	TwoFrameSprite +4 :BossSpr4B

defb 85,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24
	defb	TwoFrameSprite +5 :BossSpr5C
	defb 	TwoFrameSprite +4 :BossSpr4C
	defb 	TwoFrameSprite +2 :BossSpr2

defb 88,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24
	defb	TwoFrameSprite +6 :BossSpr6C
	defb	TwoFrameSprite +4 :BossSpr4D
	defb	TwoFrameSprite +4 :BossSpr4E

defb 91,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24
	defb	TwoFrameSprite +4 :BossSpr4F
	defb	TwoFrameSprite +3 :BossSpr3A
	defb	TwoFrameSprite +4:BossSpr4G

defb 94,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24
	defb	TwoFrameSprite +4 :BossSpr4H
	defb	TwoFrameSprite +4 :BossSpr4I
	defb	TwoFrameSprite +3 :BossSpr3B

defb 97,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24
	defb	TwoFrameSprite +3 :BossSpr3C
	defb	TwoFrameSprite +4 :BossSpr4J
	defb	TwoFrameSprite +4:BossSpr4K

defb 100,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24
	defb	TwoFrameSprite +4 :BossSpr4L
	defb	TwoFrameSprite +4 :BossSpr4M
	defb	TwoFrameSprite +3:BossSpr3D

defb 103,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24
	defb	TwoFrameSprite +3 :BossSpr3E
	defb	TwoFrameSprite +4 :BossSpr4N
	defb	TwoFrameSprite +4:BossSpr4O

defb 103,evtMultipleCommands+4
defb 	evtSettingsBank_Load+2
defb evtSetProg,prgSpecial
defb evtSetLife,%11000000+40
defb 	evtSingleSprite,TwoFrameSprite +8 :BossSpr8
	defb	160+24,24*4+24+7

defb 106,evtMultipleCommands+2
defb 	evtSettingsBank_Load+2
defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24,	TwoFrameSprite +3 ,TwoFrameSprite +4 ,TwoFrameSprite +4

;defb 59,evtMultipleCommands+2
;defb 	evtSettingsBank_Load+2
;defb 	evtTileSprite+3 ,160+24,24*5+24+7  ,24,	TwoFrameSprite +4 ,TwoFrameSprite +4 ,TwoFrameSprite +3






defb 110	
defb 	evtJumpToNewTime			; Jump to a different level point
defw 	AttackLoop				; pointer
defb	 0					; new time







LevelEndAnim:

defb 250,%10001001			;Call a memory location
defw	ClearBadguys

defb 253,%01110000+2			; 3 commands at the same timepoint
defb evtSetProgMoveLife,prgMovePlayer,&24,10
defb 	0,128+37,140+24,100+24	; 	; Single Object sprite 11 (animated)

;Palette Change
defb 254,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40			




defb 255,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

defb 0,evtCallAddress			;Call a memory location
defw	EndLevel

ClearBadguys:
	ld a,2
	ld i,a
	push hl
	call Akuyou_DoSmartBombCall
	pop hl
ret
EndLevel:
	pop hl	;
	ld hl,	&0107 				;load level 2
	jp	Akuyou_ExecuteBootStrap	; Start the game, no return



LevelInit:

	; wipe our memory, to clear out any junk from old levels
	ld de,&51
	ld hl,&50
	ld bc,&5FF
	ld (hl),0
	ldir 


	ld a, StarArraySize
	ld hl,StarArrayPointer
	call AkuYou_StarArrayInit_Enemy 

	ld a, PlayerStarArraySize
	ld hl,PlayerStarArrayPointer
	call AkuYou_StarArrayInit_Player 

	ld a,ObjectArraySize
	ld hl,ObjectArrayPointer
	call AkuYou_ObjectArray_Init



	ld a,1
	ld bc,RasterColors_ColorArray1
	ld de,RasterColors_ColorArray2
	ld hl,RasterColors_ColorArray3
	ld ix,RasterColors_ColorArray4
	ld iy,null
	call Akuyou_RasterColors_SetPointers


	ld hl,EventStreamArray		;Event Stream
	ld de,Event_SavedSettings	;Saved Settings
	call AkuYou_Event_StreamInit

	ld hl,LevelSprites		
	ld de,&1000
	call AkuYou_SpritePointerInit

	call Akuyou_Music_Restart

	;Make sure you Init the event stream first, else the rastercolor data will be zero! 
	call Akuyou_ScreenBuffer_Init
	call Akuyou_RasterColors_Init

	;call RasterColors_Reset
LevelLoop:

	;ld a,128+0
	;ld hl,(BossObject1)
	;call SetSprite

	call Akuyou_Background_Clear
	;ld l,&08
	;call Timer_Stop
	;ld l,&09
	;call Timer_Stop
	;ld a,"B"
	;call &bb5a 


	call Akuyou_EventStream_Process
	;ld l,&0a
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 


	call Akuyou_ObjectArray_Redraw
	;ld l,&0b
	;call Timer_Stop
	;ld a,"O"
	;call &bb5a 

	call Akuyou_Player_Handler
	;ld l,&0c
	;call Timer_Stop
	;ld a,"P"
	;call &bb5a 



	call Akuyou_StarArray_Redraw
	;ld l,&0d
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 


	call AkuYou_Player_StarArray_Redraw
	;ld l,&0e
	;call Timer_Stop
	;ld a,"F"
	;call &bb5a 


	call AkuYou_Player_DrawUI

	call Akuyou_PlaySfx


	;ld a,"U"
	;call &bb5a 

	call ShowBossText

	ifdef debug
		call ShowLevelTime
	endif

	call Akuyou_ScreenBuffer_Flip
	jp LevelLoop

LevelShutdown:

ret


ShowLevelTime:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font

	ld hl,&1001
	call Akuyou_DrawText_LocateSprite

	call Akuyou_GetLevelTime
	push bc	
	call ShowHex
	pop bc
	ld a,b
	call ShowHex
ret


ShowHex:

	push af         ;store original byte value
	rrca            
	rrca
	rrca
	rrca
	call ShowHexDigit
	pop af          ;retrieve original byte value

ShowHexDigit:
;	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
;	add a,"0"       ;add ASCII for 0. Digits 0...9 become "0"..."9", digits 10..15
;	cp "9"+1        
;	jr c,ShowHexDigitNum     ;if number is in digit range 0...9, display digit
;	add a,"A"-"9"-1 ;modify ASCII value so that digits in the range 10...15
and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
cp &a           ;Less than 10?  Set carry if so
sbc a,&69
daa             ;Because previous instruction was a subtract operation this
                ;is known as 'das' in x86
ShowHexDigitNum:
	jp Akuyou_DrawText_CharSprite   ;display digit

BossObject1: defw &6969
BossObject2: defw &6969
BossObject3: defw &6969
;HandObject1 defw &6969
;HandObject2 defw &6969
;HandObject3 defw &6969
;HandObject4 defw &6969
;HandObject5 defw &6969
;HandObject6 defw &6969
BossTarget: defw &6969
BossLife: defb 50
FireTarget1: defw &6969
FireTarget2: defw &6969
FireTarget3: defw &6969
SetSprite:; YYYYYXXXXMMMMSSSLLLLPPP
	ld i,a
	ld a,h
	cp &69
	ret z		;not on screen yet


	ld d,0
	ld e,objectarraysize
	;y
	add hl,de 	
	;x
	add hl,de 	
	;move
	add hl,de 	
	ld a,i
	ld (hl),a
	add hl,de 	;spr
	add hl,de 	;Life

	;program
ret

SetProgram:; YYYYYXXXXMMMMSSSLLLLPPP
	ld i,a
	ld a,h
	cp &69
	ret z		;not on screen yet


	ld d,0
	ld e,objectarraysize
	;y
	add hl,de 	
	;x
	add hl,de 	
	;move
	add hl,de 	

	add hl,de 	;spr
	add hl,de 	;Life
	ld a,i
	ld (hl),a
	;program
ret
ObjectArraySwapSprite:
	; swap sprite D with Sprite E

	ld hl,ObjectArrayPointer
	ld b,0
	ld c,ObjectArraySize
	add hl,bc ;Y
	add hl,bc ;X
	add hl,bc ;M
	ld b,c
	;ld c,0

ObjectArraySwapSprite_Next:
	
	ld a,(hl);S
	cp D
	jp nz,ObjectArraySwapSprite_NoMatch
	ld a,E
	ld (hl),a
ObjectArraySwapSprite_NoMatch:
	inc hl
	
	djnz ObjectArraySwapSprite_Next	
ret
CustomObjectHitHandler:

ld a,iyl
cp prgSpecial
jp nz,Akuyou_Object_DecreaseLifeShot	; if this object isn't the boss target, just run the normal routine

ld a,2
ld (TargetSpritecountdown_Plus1-1),a

	;iyl ; Program Code
	;ixl ;Life
	;iyh  ;spr
	;ixh ;Move
	;b ;X
	;c ;Y
	ld ixl,%11000000+40	; Make object immortal
	di
	exx



	ld a,(BossLife)
	dec a
	ld (BossLife),a
	cp 30
	jp z,BossLife3
	cp 10
	jp z,BossLife4
	cp 1
	jp z,BossLife5		;5 means boss is dead
	jp UpdateBossLife
BossLife5:
		; boss is dead

	ld D,128+2
	LD e,128+2+16
	call ObjectArraySwapSprite
	ld a,e
	ld (BossSpr2-1),a


		ld ixl,0	; Make object immortal

	ld D,128+8
	LD e,128+8+16
	call ObjectArraySwapSprite
	ld a,e
	ld (BossSpr8-1),a
	
	ld a,128+9+16
	ld (HitTargetSprite_Plus1-1),a
	ld a,128+8+16
	ld (ResetTargetSprite_Plus1-1),a
;		ld a,2
;		call Akuyou_DoSmartBombCall

		ld hl,LevelEndAnim
		ld a,249
		call Akuyou_SetLevelTime

	jp UpdateBossLife
BossLife4:





	ld D,128+3+8
	LD e,128+3+16
	call ObjectArraySwapSprite
	call doBossSpr3

	ld D,128+4+8
	LD e,128+4+16
	call ObjectArraySwapSprite
	call doBossSpr4

	ld D,128+5+8
	LD e,128+5+16
	call ObjectArraySwapSprite
	call doBossSpr5

	ld D,128+6+8
	LD e,128+6+16
	call ObjectArraySwapSprite
	call doBossSpr6

	ld D,128+7+8
	LD e,128+7+16
	call ObjectArraySwapSprite
	call DoSawArmSprites


	
	jp UpdateBossLife

BossLife3:
	ld D,128+2
	LD e,128+2+8
	call ObjectArraySwapSprite
	ld a,e
	ld (BossSpr2-1),a

	ld D,128+3
	LD e,128+3+8
	call ObjectArraySwapSprite
	call doBossSpr3

	ld D,128+4
	LD e,128+4+8
	call ObjectArraySwapSprite
	call doBossSpr4

	ld D,128+5
	LD e,128+5+8
	call ObjectArraySwapSprite
	call doBossSpr5

	ld D,128+6
	LD e,128+6+8
	call ObjectArraySwapSprite
	call doBossSpr6

	ld D,128+7
	LD e,128+7+8
	call ObjectArraySwapSprite
	call DoSawArmSprites
	ld D,128+8
	LD e,128+8+8
	call ObjectArraySwapSprite
	ld a,e
	ld (BossSpr8-1),a

	ld a,128+9+8
	ld (HitTargetSprite_Plus1-1),a
	ld a,128+8+8
	ld (ResetTargetSprite_Plus1-1),a

	jp UpdateBossLife
BossLife2:
	
BossLife1:



UpdateBossLife:

	exx
	ei
ret

doBossSpr3:
	ld a,e
	ld (BossSpr3A-1),a
	ld (BossSpr3B-1),a
	ld (BossSpr3C-1),a
	ld (BossSpr3D-1),a
	ld (BossSpr3E-1),a
	ret
doBossSpr5:
	ld a,e
	ld (BossSpr5A-1),a
	ld (BossSpr5B-1),a
	ld (BossSpr5C-1),a
	ret
doBossSpr6:
	ld a,e
	ld (BossSpr6A-1),a
	ld (BossSpr6B-1),a
	ld (BossSpr6C-1),a
;	ld (BossSpr6D-1),a
;	ld (BossSpr6E-1),a
	ret
doBossSpr4:
	ld a,e
	ld (BossSpr4A-1),a
	ld (BossSpr4B-1),a
	ld (BossSpr4C-1),a
	ld (BossSpr4D-1),a
	ld (BossSpr4E-1),a
	ld (BossSpr4F-1),a
	ld (BossSpr4G-1),a
	ld (BossSpr4H-1),a
	ld (BossSpr4I-1),a
	ld (BossSpr4J-1),a
	ld (BossSpr4K-1),a
	ld (BossSpr4L-1),a
	ld (BossSpr4M-1),a
	ld (BossSpr4N-1),a
	ld (BossSpr4O-1),a
	ret
DoSawArmSprites:
	ld a,e
	ld (SawArmA-1),a
	ld (SawArmB-1),a
	ld (SawArmC-1),a
	ld (SawArmD-1),a
	ld (SawArmE-1),a
ret
;jp Akuyou_Object_DecreaseLifeShot
ShowBossText2:


	or a
	ret z

	ld a,(BossCharNum_Plus1-1)
	inc a
	ld (BossCharNum_Plus1-1),a

	ld bc,BossText2
	jp ShowBossText_StartText


ShowBossText:
	ld a,15 :OnscreenTimer_Plus1
	cp 10
	jp C,ShowBossText2
	ld bc,BossText
ShowBossText_StartText:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font
	ld l,4
	ld a,1:BossCharNum_Plus1
	ld i,a	; show up to 255 chars
	
ShowBossText_MoreText:
	ld a,(bc)

	or a
	jp z,ShowBossText_AllOnscreen ; See if we have reached the end of the string

	ld h,a
	inc bc

	push hl
		call Akuyou_DrawText_LocateSprite

		call Akuyou_DrawText_PrintString
	pop hl
	inc l
	inc l
	inc l
	ld a,i
	dec a
	inc bc
	jp nz,ShowBossText_MoreText

	ld a,(bc)
	or a
	jp z,ShowBossText_AllOnscreen ; See if we have reached the end of the string
	ld a,(BossCharNum_Plus1-1)
	inc a
	cp 20
	jp c,ShowBossTextNoSpeedup
	inc a
ShowBossTextNoSpeedup:
	ld (BossCharNum_Plus1-1),a

ret
ShowBossText_AllOnscreen:
	ld a,(OnscreenTimer_Plus1-1)
	dec a
	ld (OnscreenTimer_Plus1-1),a

	cp 10
	ret nz
	ld a,9 ; 0 for only 1 page 
	ld (OnscreenTimer_Plus1-1),a
	ld a,BossText2End-BossText2-20
	ld a,1
	ld (BossCharNum_Plus1-1),a
ret

BossText: 
db  11,"W A R N I N G ! ! ","!"+&80
db  05,"A Unnessasarily Large Enem","y"+&80
db  04,"is approaching: Angler Grinder","!"+&80
db  05,""," "+&80
db  05,""," "+&80
db  05,"Hang on? Was there somethin","g"+&80
db  08,"like this in mega man?!","?"+&80
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;b  "12345678901234567890123456789","0"+&80
db &0



BossText2: 
db  05,""," "+&80
db  05,""," "+&80
db  05,""," "+&80
db  03,""," "+&80
db  06,""," "+&80
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db  04,"Er.. I kind of think there WAS","!"+&80
db  06,"Oh well, who gives a smeg","!"+&80
;we are using a speedup, so must be divisible by 3
BossText2End:db &0,&0,&0







CustomMove1:
	di
	exx
	ld hl,CustomMovePattern1
	ld de,null
	ld bc,CustomMovePattern_Init

jr CustomMovePattern

CustomMove2:
	di
	exx
	ld hl,CustomMovePattern2
	ld de,CustomMovePattern2b
	ld bc,CustomMovePattern_InitImmortal;CustomMovePattern_Init
jr CustomMovePattern
CustomMove3:
	di
	exx
	ld hl,CustomMovePattern3
	ld de,CustomMovePattern3b
	ld bc,CustomMovePattern_InitInvincible

jr CustomMovePattern



CustomMovePattern:		; B=X C=Y D=Move
	ld (CustomPatternJump_Plus2-2),hl
	ld (CustomPatternbJump_Plus2-2),de
	ld (CustomMovePattern_Init_Plus2-2),bc
	exx



;		ld a,iyl ; Program Code
;		ld a,ixl ;Life  - MOVED INTO af'
;		ld a,iyh ;spr
;		ld (hl),ixh ;Move
;		ld (hl),b ;X
;		ld (hl),c ;Y

		

	ld a,ixl	;lifCustom 
	ex af,af'

	ld a,d
	exx
	push ix


		and %00001111
		ld hl,CustomRam
			
			ld d,0
			ld e,a
			add hl,de
			add hl,de
			add hl,de
			add hl,de
		push hl
		pop ix

		call Akuyou_Timer_GetTimer
		ld d,a
		ld a,i	; Level time
		ld e,a


		;dont update more than once per tick! 
		ld a,(ix+1)
		cp e
		jr z,CustomMovePattern_NoTick	
		ld a,e
		ld (ix+1),e

		;see if this is our first run
		ex af,af'
			cp 250
			call nc,CustomMovePattern_Init :CustomMovePattern_Init_Plus2
		ex af,af'


		; here is where we make some moves!
		exx
		call CustomMovePattern1 :CustomPatternJump_Plus2
		exx
		;increment the pos
	

CustomMovePattern_NoTick:
		
		; here is where we make some moves!
		exx
		call null :CustomPatternbJump_Plus2
		exx
		;increment the pos
	


		jp CustomMovePattern_Done

CustomMovePattern_Done:
	ld a,iyl
	cp prgSpecial
	jp nz,CustomMovePattern_NotBossTarget
	ld a,0:TargetSpritecountdown_Plus1
	or a
	jp z,CustomMovePattern_TargetReset
	dec a
	ld (TargetSpritecountdown_Plus1-1),a
CustomMovePattern_TargetSet:
	ld a,128+9	:HitTargetSprite_Plus1
	ld iyh,a
	jr CustomMovePattern_NotBossTarget
CustomMovePattern_TargetReset:
	ld a,128+8 	:ResetTargetSprite_Plus1
	ld iyh,a
CustomMovePattern_NotBossTarget:
	pop ix
	exx

	ex af,af'

	ld ixl,a	;lifCustom 


ei
ret
CustomMovePattern_InitImmortal:
	call CustomMovePattern_Init
	ld a,0		;New Life
ret
CustomMovePattern_InitInvincible:
	call CustomMovePattern_Init
	ld a,lifDeadly+63		;New Life
;there seems to be a bug in the code where an object hurts the player, but cannot be shot

ret
CustomMovePattern_Init:

	xor a
	;exx
	;B=X
	;C=Y
	;exx

	ld (ix+0),a
	ld (ix+1),a

	ld a,r

	rrca
	rrca
	and %01111111
	add 24+36
	ld (ix+3),a
	

	ld a,r

	rrca
	rrca
	rrca
	and %01111111
	add 24+16
	ld (ix+2),a

	ld a,lifEnemy+6			;New Life

ret




CustomMovePattern1:
	push ix
	push iy

		;call AkuYou_Player_GetPlayerVars


		ld a,(ix+2)	;Y
		sub 8
		cp C
		jr NC,DoMoves_Seeker_Ylower
		ld a,C
		sub 2
		jp DoMoves_Seeker_CheckX
	DoMoves_Seeker_Ylower:
		ld a,C
		add 2
	DoMoves_Seeker_CheckX:
		ld C,a
		ld a,(ix+3)	;X
		sub 3
		cp B
		jr NC,DoMoves_Seeker_Xlower
		ld a,B
		sub 2
		ld ixh,0+128
		jp DoMoves_Seeker_Done
	DoMoves_Seeker_Xlower:
		ld a,B
		ld ixh,35+128
		add 2
	DoMoves_Seeker_Done:
		ld B,a

	pop iy
		ld a,ixh
		ld iyh,a
	pop ix

	call Akuyou_Timer_GetTimer

		bit 5,a	
		ret z
	exx
	ex af,af'
		call CustomMovePattern_Init
	ex af,af'
	exx

ret
CustomMovePatternKill:
	;ex af,af'
	;xor a
	
	ld b,0
	ld c,b
	ld D,b
	;ex af,af'
ret

CustomMovePattern2: ; big fish

	ld a,(ix+0)
	inc a
	ld (ix+0),a	
ret
CustomMovePattern2b:
	ld a,(ix+0)


	cp 134
	jr C,CustomMovePattern2Left
	
	inc c	;move down
	inc c	;move down
	inc c	;move down
	inc c	;move down

	cp 142
	jr NC,CustomMovePattern2Done


CustomMovePattern2Left:	
	dec b	;move left
	;dec c	;m


CustomMovePattern2Done:
	ld a,c
	cp 199+24
	jp nc,CustomMovePatternKill	;off the bottom of the screen


ret




CustomMovePattern3: ; saw

	ld a,(ix+0)
	inc a
	ld (ix+0),a	
ret
CustomMovePattern3b:
	ld a,(ix+0)
	cp 253
	jp nc,CustomMovePatternKill	;off the bottom of the screen

	cp 72-8 ;>72
	jr NC,CustomMovePattern3Left
	inc c	
	inc c	
	jr CustomMovePattern3Done

CustomMovePattern3Left:
	cp 72+60-8
	jr NC,CustomMovePattern3Up
	dec b
	dec b
	
	bit 3,a
	jr z,CustomMovePattern3WaveUp
	inc c
	inc c
	jr CustomMovePattern3Done
CustomMovePattern3WaveUp:
	dec c
	dec c
	jr CustomMovePattern3Done

CustomMovePattern3Up:	
	dec c
	dec c


CustomMovePattern3Done:
	ld a,c
	cp 199+24
	jp nc,CustomMovePatternKill	;off the bottom of the screen


ret



CustomProgram1:
	call Akuyou_Timer_GetTimer
	ld a,i	; Level time
	and %00000011
	;rrca
	add 16
	ld iyl,a		; Program Fire
	push bc
	push de
	push iy
	call Akuyou_FireStar
	pop iy
	pop de
	pop bc


	ld a,iyl
	add 4
	ld iyl,a
	jp Akuyou_FireStar


CustomProgram2:
	call Akuyou_Timer_GetTimer
	ld a,i	; Level time
	bit 0,a
	jr z,CustomProgram2_Fire2

	ld a,17
	ld iyl,a
	jp Akuyou_FireStar

CustomProgram2_Fire2:
	ld a,23
	ld iyl,a
	jp Akuyou_FireStar




null:ret

limit &3fff
org &3ff0
jp LevelInit; - Level Start &3ff0
jp LevelLoop; - Level loop &3ff3
jp null     ; - Level resume &3ff6
jp null     ; - Level Shutdown &3ff9






save direct "T14-SC1.D02",&2500,&1B00	;address,size...}[,exec_address]



